/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan;

import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.SignalHelperWrapper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.SignalHelperWrapperFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.VlanScanProxy;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHCancelVlanScanInd;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHInitiateServiceCfm;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHInitiateServiceReq;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHPerformVlanScan2Req;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHPerformVlanScanCfm;
import se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHPerformVlanScanReq;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.common.proxy.OseSenderReceiverImpl;

public class VlanScanProxyImpl
extends OseSenderReceiverImpl
implements VlanScanProxy {
    private static final Class THIS_CLASS = VlanScanProxyImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String SLOGAN = "VlanScan";
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private static final int TWO_SECONDS = 2000;
    private static final int ONE_MINUTE = 60000;
    private OseProcess vlanScanProcess = null;
    private boolean cancelled = false;
    static /* synthetic */ Class class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHInitiateServiceCfm;
    static /* synthetic */ Class class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHInitiateServiceRej;
    static /* synthetic */ Class class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHPerformVlanScanCfm;

    public void huntForVlanScanProcess() throws RbsConfigurationFailedException {
        this.vlanScanProcess = OseProcess.hunt((String)"Ipet_dhcpvlansrv_proc");
        if (this.vlanScanProcess == null) {
            throw new RbsConfigurationFailedException(SLOGAN, "Failed to hunt down PID for process: Ipet_dhcpvlansrv_proc");
        }
    }

    private int initiateService(long initStartedAt, SignalHelperWrapper signalHelperWrapper, int timeout) throws RbsConfigurationFailedException {
        signalHelperWrapper.send(this.vlanScanProcess, (Signal)new IpetDhcpVlanSRHInitiateServiceReq());
        Signal initiateServiceCfm = null;
        Signal initiateServiceRej = null;
        int selectedPV = 0;
        while (!this.cancelled && initiateServiceCfm == null && initiateServiceRej == null && System.currentTimeMillis() - initStartedAt < (long)timeout) {
            initiateServiceCfm = signalHelperWrapper.receive(class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHInitiateServiceCfm == null ? VlanScanProxyImpl.class$("se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHInitiateServiceCfm") : class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHInitiateServiceCfm, 1000);
            initiateServiceRej = signalHelperWrapper.receive(class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHInitiateServiceRej == null ? VlanScanProxyImpl.class$("se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHInitiateServiceRej") : class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHInitiateServiceRej, 1000);
        }
        if (!this.cancelled && initiateServiceRej != null) {
            throw new RbsConfigurationFailedException(SLOGAN, "Reject received for initiate service request");
        }
        if (!this.cancelled && initiateServiceCfm == null) {
            throw new RbsConfigurationFailedException(SLOGAN, "No confirm received for initiate service request");
        }
        if (!this.cancelled && initiateServiceCfm != null) {
            selectedPV = ((IpetDhcpVlanSRHInitiateServiceCfm)initiateServiceCfm).getSelectedPV();
            logger.traceDebug(THIS_CLASS, "Protocol version is: " + selectedPV);
        }
        return selectedPV;
    }

    public int[] performVlanScan(int[] macAddress, int[] clientId, int timeout) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "performVlanScan()");
        if (this.vlanScanProcess == null) {
            throw new RbsConfigurationFailedException(SLOGAN, "No vlan scan process, must call huntForVlanScanProcess() before performVlanScan()");
        }
        long initStartedAt = System.currentTimeMillis();
        SignalHelperWrapper signalHelperWrapper = SignalHelperWrapperFactory.getSignalHelperWrapper();
        int selectedPV = this.initiateService(initStartedAt, signalHelperWrapper, timeout);
        if (!this.cancelled && selectedPV == 1) {
            logger.traceError(THIS_CLASS, "Wrong protocol version, using VLAN scan without dhcpClientIdentifier");
            signalHelperWrapper.send(this.vlanScanProcess, (Signal)new IpetDhcpVlanSRHPerformVlanScanReq(macAddress));
        } else if (!this.cancelled && selectedPV == 2) {
            signalHelperWrapper.send(this.vlanScanProcess, (Signal)new IpetDhcpVlanSRHPerformVlanScan2Req(macAddress, clientId.length, clientId));
        }
        long waitTimeForStartReceive = Math.min(((long)timeout - (System.currentTimeMillis() - initStartedAt)) / 2L, 60000L);
        if (waitTimeForStartReceive < 60000L) {
            waitTimeForStartReceive = 0L;
        }
        logger.traceDebug(THIS_CLASS, "timeout: " + timeout + ", waitTimeForStartReceive: " + waitTimeForStartReceive);
        if (waitTimeForStartReceive >= 60000L) {
            long waitStartedAt = System.currentTimeMillis();
            while (!this.cancelled && System.currentTimeMillis() - waitStartedAt < waitTimeForStartReceive) {
                try {
                    Thread.sleep(waitTimeForStartReceive / 60L);
                }
                catch (InterruptedException shouldNotHappen) {
                    logger.traceAbnormal(THIS_CLASS, "Interrupted while waiting for it's time to do a receive");
                }
            }
        }
        long timeoutForReceive = (long)timeout - (System.currentTimeMillis() - initStartedAt);
        logger.traceDebug(THIS_CLASS, "timeout: " + timeout + ", timeoutForReceive: " + timeoutForReceive);
        long scanStartedAt = System.currentTimeMillis();
        int[] result2 = new int[]{};
        Signal vlanScanCfm = null;
        while (!this.cancelled && vlanScanCfm == null && System.currentTimeMillis() - scanStartedAt < timeoutForReceive) {
            logger.traceDebug(THIS_CLASS, "signalHelperWrapper.receive()");
            vlanScanCfm = signalHelperWrapper.receive(class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHPerformVlanScanCfm == null ? VlanScanProxyImpl.class$("se.ericsson.crbs.cat.mao.rbsconfiguration.state.vlanscan.signals.IpetDhcpVlanSRHPerformVlanScanCfm") : class$se$ericsson$crbs$cat$mao$rbsconfiguration$state$vlanscan$signals$IpetDhcpVlanSRHPerformVlanScanCfm, 2000);
        }
        if (!this.cancelled) {
            if (vlanScanCfm == null) {
                throw new RbsConfigurationFailedException(SLOGAN, "No confirm received for perform vlan scan request");
            }
            result2 = ((IpetDhcpVlanSRHPerformVlanScanCfm)vlanScanCfm).getVlanIds();
        }
        logger.traceReturn(THIS_CLASS, "performVlanScan() " + result2.length + " vlanId's");
        return result2;
    }

    public void cancelVlanScan() throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "cancelVlanScan()");
        if (this.vlanScanProcess == null) {
            throw new RbsConfigurationFailedException(SLOGAN, "No vlan scan process, must call huntForVlanScanProcess() before cancelVlanScan()");
        }
        this.cancelled = true;
        SignalHelperWrapper signalHelperWrapper = SignalHelperWrapperFactory.getSignalHelperWrapper();
        signalHelperWrapper.send(this.vlanScanProcess, (Signal)new IpetDhcpVlanSRHCancelVlanScanInd());
        logger.traceReturn(THIS_CLASS, "cancelVlanScan()");
    }
}

