/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class AddStaticRouteTp
implements TransactionPackage {
    private static final String IP_ADDRESS_STATIC = "ipAddress";
    private static final Class THIS_CLASS = AddStaticRouteTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfigurationMao;
    private final MoRepositoryWrapper aMoRepository;
    private final String destination;
    private final String subnetOrPrefixLength;
    private final String nextHop;
    private final int routeMetric;
    private final boolean redistribute;

    public AddStaticRouteTp(RbsConfigurationMao inRbsConfigurationMao, GenericMaoContext aGenericMaoContext, String inDestination, String inSubnetOrPrefixLength, String inNextHop, int inRouteMetric, boolean inRedistribute) {
        this.rbsConfigurationMao = inRbsConfigurationMao;
        this.aMoRepository = aGenericMaoContext.getMoRepositoryWrapper();
        this.destination = inDestination;
        this.subnetOrPrefixLength = inSubnetOrPrefixLength;
        this.nextHop = inNextHop;
        this.routeMetric = inRouteMetric;
        this.redistribute = inRedistribute;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (IpParameters.instance(this.rbsConfigurationMao).getCorbaOnSiteLan()) {
            logger.info(THIS_CLASS, "Skipped to add static route as CorbaOnSiteLan was set");
        } else {
            IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
            ipRoutingTableMo.actionAddStaticRoute(this.destination, this.subnetOrPrefixLength, this.nextHop, this.routeMetric, this.redistribute, coordinator);
            ConfigurationReportLoggerFactory.getLogger().logAction("IpRoutingTable", "actionAddStaticRoute", new String[]{IP_ADDRESS_STATIC, "networkMask", "nextHopIpAddr", "routeMetric", "redistribute"}, (Object[])new String[]{this.destination, this.subnetOrPrefixLength, this.nextHop, Integer.toString(this.routeMetric), Boolean.toString(this.redistribute)});
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) {
        String reason = "";
        if (exception != null) {
            reason = " Unable to create Static Route: " + exception.getMessage();
        }
        ConfigurationReportLoggerFactory.getLogger().logInformation("IpRoutingTable", "Unable to add a static route. Destination: " + this.destination + " Subnet: " + this.subnetOrPrefixLength + "  nextHopIpAddr: " + this.nextHop + " routeMetric: " + Integer.toString(this.routeMetric) + " redistribute" + this.redistribute);
        logger.traceError(THIS_CLASS, reason);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

