/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.EthernetLinkMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.AddStaticRouteTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class AssignAllEthernetLinkIpAddressesTp
implements TransactionPackage {
    private static final Class THIS_CLASS = AddStaticRouteTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepositoryWrapper;
    private final String ipAddress;
    private final String subnetMask;
    private final String broadcastAddress;

    public AssignAllEthernetLinkIpAddressesTp(GenericMaoContext inGenericMaoContext, String inIpAddress, String inSubnetMask, String inBroadcastAddress) {
        this.moRepositoryWrapper = inGenericMaoContext.getMoRepositoryWrapper();
        this.ipAddress = inIpAddress;
        this.subnetMask = inSubnetMask;
        this.broadcastAddress = inBroadcastAddress;
    }

    public void execute(Coordinator coordinator) throws MoAccessException, InactiveTransactionException {
        logger.traceEnter(THIS_CLASS, "execute()");
        EthernetLinkMo ethernetLinkMo = (EthernetLinkMo)this.moRepositoryWrapper.lookup("ManagedElement=1,IpOam=1,Ip=1,EthernetLink=1");
        ethernetLinkMo.actionAssignAllIpAddresses(this.ipAddress, this.subnetMask, this.broadcastAddress, coordinator);
        ConfigurationReportLoggerFactory.getLogger().logAction("EthernetLink", "actionAssignAllIpAddresses", new String[]{"ipAddress", "subnetMask", "broadcastAddress"}, (Object[])new String[]{this.ipAddress, this.subnetMask, this.broadcastAddress});
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) {
        logger.traceError(THIS_CLASS, "Unable to create assign all ip addresses: " + exception.getMessage());
        ConfigurationReportLoggerFactory.getLogger().logInformation("EthernetLink", "Unable to assign all ip addresses. ipAddress: " + this.ipAddress + " subnetMask: " + this.subnetMask + "  broadcastAddress: " + this.broadcastAddress);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

