/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpMo;
import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CleanIpConfigurationTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CleanIpConfigurationTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final boolean deleteGigabitEthernet;
    private final boolean unsetInterfaceName;

    public CleanIpConfigurationTp(GenericMaoContext aGenericMaoContextIn, boolean inDeleteGigabitEthernet) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.deleteGigabitEthernet = inDeleteGigabitEthernet;
        this.unsetInterfaceName = false;
    }

    public CleanIpConfigurationTp(GenericMaoContext aGenericMaoContextIn, boolean inDeleteGigabitEthernet, boolean inUnsetInterfaceName) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.deleteGigabitEthernet = inDeleteGigabitEthernet;
        this.unsetInterfaceName = inUnsetInterfaceName;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        if (this.unsetInterfaceName) {
            IpMo ipMo = (IpMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
            IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
            if (ipMo != null && ipHostLinkMo != null) {
                String interfaceName = ipHostLinkMo.getInterfaceName(coordinator);
                String ipv4InterfaceName = (String)ipMo.getAttribute("nodeInterfaceName", coordinator);
                if (interfaceName != null && interfaceName.compareTo(ipv4InterfaceName) == 0) {
                    ipMo.setAttribute("nodeInterfaceName", (Object)"le0", coordinator);
                } else {
                    String ipv6InterfaceName = (String)ipMo.getAttribute("nodeIpv6InterfaceName", coordinator);
                    if (interfaceName != null && interfaceName.compareTo(ipv6InterfaceName) == 0) {
                        ipMo.setAttribute("nodeIpv6InterfaceName", (Object)"", coordinator);
                    }
                }
            }
        }
        this.deleteMos("IpHostLink", coordinator);
        this.deleteMos("IpInterface", coordinator);
        this.deleteMos("Ipv6Interface", coordinator);
        this.deleteMos("VpnInterface", coordinator);
        this.deleteMos("AccessControlList", coordinator);
        if (this.deleteGigabitEthernet) {
            this.deleteMos("GigaBitEthernet", coordinator);
        }
        this.cleanSoip(coordinator);
        this.removeInactiveRoutes(coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void deleteMos(String moType, Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "deleteMos() " + moType);
        MoIterator moIter = this.aMoRepository.lookupType(moType);
        if (moIter != null) {
            while (moIter.hasMoreElements()) {
                ManagedObject mo = moIter.nextMo();
                mo.delete(coordinator);
            }
        }
        logger.traceReturn(THIS_CLASS, "deleteMos()");
    }

    private void removeInactiveRoutes(Coordinator coordinator) {
        logger.traceEnter(THIS_CLASS, "removeInactiveRoutes()");
        IpRoutingTableMo ipRoutingTable = (IpRoutingTableMo)this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
        if (ipRoutingTable != null) {
            try {
                int[] deletableStaticRoutes = ipRoutingTable.getIndexOfDeletableStaticRoutes(coordinator);
                if (deletableStaticRoutes != null && deletableStaticRoutes.length != 0) {
                    int i;
                    Struct[] entries = new Struct[deletableStaticRoutes.length];
                    for (i = 0; i < deletableStaticRoutes.length; ++i) {
                        entries[i] = ipRoutingTable.actionGetRoutingTableEntry(deletableStaticRoutes[i], coordinator);
                    }
                    for (i = 0; i < deletableStaticRoutes.length; ++i) {
                        if (!entries[i].getValue("active").equals(Boolean.FALSE)) continue;
                        ipRoutingTable.actionDeleteStaticRoute(entries[i], coordinator);
                        ConfigurationReportLoggerFactory.getLogger().logAction("IpRoutingTable", "actionDeleteStaticRoute", entries[i].getNames(), entries[i].getValues());
                    }
                }
            }
            catch (MoAccessException mae) {
                logger.traceDebug(THIS_CLASS, "Caught exception when trying to filter inactive routes: " + mae.getVariablesAsString());
                ConfigurationReportLoggerFactory.getLogger().logInformation("IpRoutingTable", "Unable to remove inactive static routes. " + mae.getVariablesAsString());
            }
        }
        logger.traceReturn(THIS_CLASS, "removeInactiveRoutes()");
    }

    private void cleanSoip(Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException {
        ManagedObject eNodeBFunction = this.aMoRepository.lookup("ManagedElement=1,ENodeBFunction=1");
        if (eNodeBFunction != null) {
            eNodeBFunction.setAttribute("sctpRef", null, coordinator);
        }
        this.deleteMos("Sctp", coordinator);
        this.deleteMos("IpAccessSctp", coordinator);
        this.removeIpSyncRef(coordinator);
        this.deleteMos("IpAccessHostEt", coordinator);
    }

    private void removeIpSyncRef(Coordinator coordinator) throws RbsConfigurationFailedException, MoAccessException {
        MoIterator ipSyncRefIter = this.aMoRepository.lookupType("IpSyncRef");
        if (ipSyncRefIter != null) {
            SynchronizationMo syncMo = (SynchronizationMo)this.aMoRepository.lookup("ManagedElement=1,TransportNetwork=1,Synchronization=1");
            if (syncMo == null) {
                throw new RbsConfigurationFailedException("Can not find Synchronization MO!");
            }
            ManagedObject[] registeredSyncReferenses = syncMo.getSyncReference(coordinator);
            ManagedObject currentIpSyncRef = null;
            while (ipSyncRefIter.hasMoreElements()) {
                currentIpSyncRef = ipSyncRefIter.nextMo();
                for (int index = 0; index < registeredSyncReferenses.length; ++index) {
                    if (!currentIpSyncRef.equals(registeredSyncReferenses[index])) continue;
                    syncMo.actionRemoveSyncRefResource(currentIpSyncRef, coordinator);
                }
                currentIpSyncRef.delete(coordinator);
            }
        }
    }

    public void handleExecutionException(Exception exception) {
        logger.traceAbnormal(THIS_CLASS, "Unexpected exception during removal of old ip configuration! " + exception);
    }

    public void handleTransactionException(Exception exception) {
        logger.traceAbnormal(THIS_CLASS, "Unexpected transactional failure! " + exception);
    }
}

