/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.FileParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.NodeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.UpgradeParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class ConvertParameterNames
implements TransactionPackage {
    private static final Class THIS_CLASS = ConvertParameterNames.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfiguration;

    public ConvertParameterNames(RbsConfigurationMao rbsConfigurationIn) {
        this.rbsConfiguration = rbsConfigurationIn;
    }

    public void execute(Coordinator coordinator) {
        this.updateParameters(coordinator);
    }

    private void updateParameters(Coordinator coordinator) {
        String upgradeParams = UpgradeParameters.instance(this.rbsConfiguration).correctParameterNames(coordinator);
        String nodeParams = NodeParameters.instance(this.rbsConfiguration).correctParameterNames(coordinator);
        String ipParams = IpParameters.instance(this.rbsConfiguration).correctParameterNames(coordinator);
        String fileParams = FileParameters.instance(this.rbsConfiguration).correctParameterNames(coordinator);
        logger.traceDebug(THIS_CLASS, "Conversion of old Parameters names in AI");
        logger.traceDebug(THIS_CLASS, "UpgradeParameters:" + upgradeParams);
        logger.traceDebug(THIS_CLASS, "NodeParameters:" + nodeParams);
        logger.traceDebug(THIS_CLASS, "IpParameters:" + ipParams);
        logger.traceDebug(THIS_CLASS, "FileParameters:" + fileParams);
    }

    public void handleExecutionException(Exception exception) {
    }

    public void handleTransactionException(Exception exception) {
    }
}

