/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateGigabitMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateGigabitMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;
    private final int portNo;
    private final boolean autoNegotiation;

    public CreateGigabitMoTp(GenericMaoContext aGenericMaoContextIn, int portNoIn, boolean autoNegotiationIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.portNo = portNoIn;
        this.autoNegotiation = autoNegotiationIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        ManagedObject exchangeTerminalIp = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1");
        MoFactory gbeFactory = this.aMoFactoryMgr.lookup("GigaBitEthernet");
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement("linkType", (Object)new Integer(0));
        attrList.addElement("portNo", (Object)new Integer(this.portNo));
        attrList.addElement("protectiveMode", (Object)Boolean.FALSE);
        if (!this.autoNegotiation) {
            attrList.addElement("autoNegotiation", (Object)Boolean.FALSE);
        }
        gbeFactory.createMo(exchangeTerminalIp, (AttrList)attrList, "1", null, coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create GigaBitEthernet MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

