/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIpv6InterfaceMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpv6InterfaceMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;

    public CreateIpv6InterfaceMoTp(GenericMaoContext aGenericMaoContextIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        ManagedObject ipSystemMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1");
        MoFactory ipv6InterfaceFactory = this.aMoFactoryMgr.lookup("Ipv6Interface");
        AttrListImpl attrList = new AttrListImpl();
        ManagedObject gigabitMo = this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1");
        attrList.addElement("ethernetRef", (Object)gigabitMo);
        ipv6InterfaceFactory.createMo(ipSystemMo, (AttrList)attrList, "1", null, coordinator);
        ConfigurationReportLoggerFactory.getLogger().logAction("Ipv6Interface", "create", "", "");
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create Ipv6Interface MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

