/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpv6InterfaceMoTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateIpv6MoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpv6InterfaceMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;

    public CreateIpv6MoTp(GenericMaoContext aGenericMaoContextIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        ManagedObject ipSystemMo = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1");
        MoFactory ipv6Factory = this.aMoFactoryMgr.lookup("Ipv6");
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement("featureState", (Object)RbsConfigurationDefinitions.ACTIVATED);
        ipv6Factory.createMo(ipSystemMo, (AttrList)attrList, "1", null, coordinator);
        ConfigurationReportLoggerFactory.getLogger().logAction("Ipv6", "create", "", "");
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create Ipv6 MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception in IPv6 MO creation", exception);
    }
}

