/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class CreateVpnInterfaceMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateVpnInterfaceMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final MoFactoryMgrWrapper aMoFactoryMgr;
    private final Integer configurationMode;
    private final Integer ipVersion;

    public CreateVpnInterfaceMoTp(GenericMaoContext aGenericMaoContextIn, Integer confMode, Integer ipVer) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.aMoFactoryMgr = aGenericMaoContextIn.getMoFactoryMgrWrapper();
        this.configurationMode = confMode;
        this.ipVersion = ipVer;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        ManagedObject ipSystem = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1");
        ManagedObject referencedIpAccessHostEt = this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpAccessHostEt=1");
        AttrListImpl attrList = new AttrListImpl();
        attrList.addElement("ipAccessHostEtRef", (Object)referencedIpAccessHostEt);
        attrList.addElement("configurationMode", (Object)this.configurationMode);
        attrList.addElement("ipVersion", (Object)this.ipVersion);
        MoFactory vpnInterfaceFactory = this.aMoFactoryMgr.lookup("VpnInterface");
        vpnInterfaceFactory.createMo(ipSystem, (AttrList)attrList, "1", null, coordinator);
        ConfigurationReportLoggerFactory.getLogger().logAction("VpnInterface", "create", new String[]{"ipAccessHostEtRef", "configurationMode", "ipVersion"}, (Object[])new String[]{referencedIpAccessHostEt.toString(), this.configurationMode.toString(), this.ipVersion.toString()});
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO create failed", "Unable to create VpnInterface MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

