/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class DisableTuOutTp
implements TransactionPackage {
    private final MoRepositoryWrapper moRepository;
    private final String attr;

    public DisableTuOutTp(MoRepositoryWrapper inMoRepository, String attribute) {
        this.moRepository = inMoRepository;
        this.attr = attribute;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        MoIterator timingUnits = this.moRepository.lookupType("TimingUnit");
        while (timingUnits != null && timingUnits.hasMoreElements()) {
            ManagedObject timingUnit = timingUnits.nextMo();
            timingUnit.setAttribute(this.attr, (Object)Boolean.FALSE, coordinator);
            ConfigurationReportLoggerFactory.getLogger().logAttribute(timingUnit.getRelativeDistinguishedName(), this.attr, (Object)Boolean.FALSE);
        }
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Site Basic fault", "Unable to disable 'gpsOut' on TimingUnit, which is needed to create TuSyncRef instances.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Site Basic fault", "Unable to disable 'gpsOut' on TimingUnit, which is needed to create TuSyncRef instances.", exception);
    }
}

