/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.iptransport.AccessControlListMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class ModifyInitialAccessControlListTp
implements TransactionPackage {
    private static final Class THIS_CLASS = ModifyInitialAccessControlListTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moReopsitory;
    private final String oldSmrs;
    private final String newSmrs;

    public ModifyInitialAccessControlListTp(MoRepositoryWrapper moRepositoryIn, String oldSmrsIn, String newSmrsIn) {
        this.moReopsitory = moRepositoryIn;
        this.oldSmrs = oldSmrsIn;
        this.newSmrs = newSmrsIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        Struct[] aclEntries;
        logger.traceEnter(THIS_CLASS, "execute()");
        AccessControlListMo initAclMo = (AccessControlListMo)this.moReopsitory.lookup("ManagedElement=1,IpSystem=1,AccessControlList=initAcl");
        if (initAclMo != null && (aclEntries = initAclMo.getAclEntries(coordinator)) != null && aclEntries.length > 0) {
            this.filterAclEntries(aclEntries);
            initAclMo.setAclEntries(aclEntries, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void filterAclEntries(Struct[] aclEntries) throws MoAccessException {
        for (int listIndex = 0; listIndex < aclEntries.length; ++listIndex) {
            String[] names = aclEntries[listIndex].getNames();
            Object[] values = aclEntries[listIndex].getValues();
            for (int memberIndex = 0; memberIndex < names.length; ++memberIndex) {
                if (!"remoteIpAddress".equalsIgnoreCase(names[memberIndex]) || !((String)values[memberIndex]).equalsIgnoreCase(this.oldSmrs)) continue;
                values[memberIndex] = this.newSmrs;
            }
        }
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Adjust ACL rules for SMRS", "Unable to switch to new SMRS IP-Address in AccessControlList.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Adjust ACL rules for SMRS", "Unable to switch to new SMRS IP-Address in AccessControlList.", exception);
    }
}

