/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipoam.IpRoutingTableMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpAccessHostEtData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpHostLinkData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.IpInterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.Ipv6InterfaceData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.sitebasic.datastructure.SiteBasicData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class RemoveOriginalIpConfigurationTp
implements TransactionPackage {
    private static final Class THIS_CLASS = RemoveOriginalIpConfigurationTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper moRepository;
    private SiteBasicData siteBasicData = null;

    public RemoveOriginalIpConfigurationTp(GenericMaoContext aGenericMaoContextIn) {
        this.moRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
    }

    public RemoveOriginalIpConfigurationTp(SiteBasicData inSiteBasicData, GenericMaoContext aGenericMaoContextIn) {
        this.moRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.siteBasicData = inSiteBasicData;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        this.setNodeInterfaceName(coordinator);
        this.removeOriginalIpHostLinkMo(coordinator);
        this.removeOriginalStaticRoute(coordinator);
        this.removeIpv6OriginalStaticRoute(coordinator);
        this.removeOriginalIpInterfaceMo(coordinator);
        this.removeOriginalIpv6InterfaceMo(coordinator);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void setNodeInterfaceName(Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            ManagedObject ipMo = this.moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
            String nodeInterfaceName = "le0";
            ipMo.setAttribute("nodeInterfaceName", (Object)"le0", coordinator);
            ConfigurationReportLoggerFactory.getLogger().logAttribute(ipMo.getRelativeDistinguishedName(), "nodeInterfaceName", (Object)"le0");
            String nodeIpv6InterfaceName = "";
            ipMo.setAttribute("nodeIpv6InterfaceName", (Object)"", coordinator);
            ConfigurationReportLoggerFactory.getLogger().logAttribute(ipMo.getRelativeDistinguishedName(), "nodeIpv6InterfaceName", (Object)"");
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("SiteBasic failure", "Unable to set NodeInterface and NodeIpv6Interface name when removing original ip config.", (Exception)((Object)mae));
        }
    }

    private void removeOriginalIpHostLinkMo(Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            IpHostLinkMo originalIpHostLink = (IpHostLinkMo)this.moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
            if (originalIpHostLink == null) {
                return;
            }
            ConfigurationReportLoggerFactory.getLogger().logAction(originalIpHostLink.getType(), "Delete", "LDN", "ManagedElement=1,IpOam=1,Ip=1,IpHostLink=1");
            originalIpHostLink.delete(coordinator);
        }
        catch (MoAccessException mae) {
            throw new RbsConfigurationFailedException("Site Basic", "Unable to delete temporary IpHostLink MO.", (Exception)((Object)mae));
        }
    }

    private void removeOriginalStaticRoute(Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            IpInterfaceMo ipInterfaceMo = (IpInterfaceMo)this.moRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
            if (ipInterfaceMo == null) {
                return;
            }
            String defaultRoute0 = ipInterfaceMo.getDefaultRouter0(coordinator);
            IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)this.moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
            int numberOfRoutes = ipRoutingTableMo.actionNumberOfRoutes(coordinator);
            for (int index = 0; index < numberOfRoutes; ++index) {
                Struct routingTableEntry = ipRoutingTableMo.actionGetRoutingTableEntry(index, coordinator);
                String nextHopIpAddress = (String)routingTableEntry.getValue("nextHopIpAddr");
                String destinationIpAddr = (String)routingTableEntry.getValue("destinationIpAddr");
                String destinationNetworkMask = (String)routingTableEntry.getValue("destinationNetworkMask");
                if (!defaultRoute0.equalsIgnoreCase(nextHopIpAddress) || !"0.0.0.0".equalsIgnoreCase(destinationIpAddr) || !"0.0.0.0".equalsIgnoreCase(destinationNetworkMask)) continue;
                ipRoutingTableMo.actionDeleteStaticRoute(routingTableEntry, coordinator);
                ConfigurationReportLoggerFactory.getLogger().logAction("IpRoutingTable", "actionDeleteStaticRoute", new String[]{"destinationIpAddr", "destinationNetworkMask", "nextHopIpAddr"}, (Object[])new String[]{"0.0.0.0", "0.0.0.0", defaultRoute0});
                break;
            }
        }
        catch (MoAccessException mae) {
            if (mae instanceof RbsConfigurationFailedException) {
                throw (RbsConfigurationFailedException)mae;
            }
            throw new RbsConfigurationFailedException("SiteBasic failure", "Unable to remove temporary static route", (Exception)((Object)mae));
        }
    }

    private void removeIpv6OriginalStaticRoute(Coordinator coordinator) throws RbsConfigurationFailedException {
        try {
            IpParameters ip = IpParameters.instance();
            Ipv6InterfaceMo originalIpv6InterfaceMo = (Ipv6InterfaceMo)this.moRepository.lookup("ManagedElement=1,IpSystem=1,Ipv6Interface=1");
            if (ip == null || originalIpv6InterfaceMo == null) {
                return;
            }
            String defaultRoute0 = ip.getDefaultRouter();
            IpRoutingTableMo ipRoutingTableMo = (IpRoutingTableMo)this.moRepository.lookup("ManagedElement=1,IpOam=1,Ip=1,IpRoutingTable=1");
            int numberOfRoutes = ipRoutingTableMo.actionNumberOfRoutes(coordinator);
            for (int index = 0; index < numberOfRoutes; ++index) {
                Struct routingTableEntry = ipRoutingTableMo.actionGetRoutingTableEntry(index, coordinator);
                String destinationIpAddr = (String)routingTableEntry.getValue("destinationIpAddr");
                String destinationNetworkMask = (String)routingTableEntry.getValue("destinationNetworkMask");
                if (!"::".equalsIgnoreCase(destinationIpAddr) || !"0".equalsIgnoreCase(destinationNetworkMask)) continue;
                ipRoutingTableMo.actionDeleteStaticRoute(routingTableEntry, coordinator);
                ConfigurationReportLoggerFactory.getLogger().logAction("IpRoutingTable", "actionDeleteStaticRoute", new String[]{"destinationIpAddr", "destinationNetworkMask", "nextHopIpAddr"}, (Object[])new String[]{"::", "0", defaultRoute0});
                break;
            }
        }
        catch (MoAccessException mae) {
            if (mae instanceof RbsConfigurationFailedException) {
                throw (RbsConfigurationFailedException)mae;
            }
            throw new RbsConfigurationFailedException("SiteBasic failure", "Unable to remove temporary static route", (Exception)((Object)mae));
        }
    }

    private void removeOriginalIpInterfaceMo(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeOriginalIpInterfaceMo");
        boolean isReferenced = false;
        IpAccessHostEtData[] ipAccessHostEtData = null;
        IpInterfaceData[] ipInterfaceData = null;
        IpHostLinkData ipHostLinkData = null;
        try {
            IpInterfaceMo originalIpInterfaceMo = (IpInterfaceMo)this.moRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
            if (originalIpInterfaceMo != null) {
                String relativeName;
                int i;
                if (this.siteBasicData != null) {
                    ipAccessHostEtData = this.siteBasicData.getIpSystemData().getIpAccessHostEtData();
                    ipInterfaceData = this.siteBasicData.getIpInterfaceData();
                    ipHostLinkData = this.siteBasicData.getIpData().getIpHostLinkData();
                }
                if (ipAccessHostEtData != null) {
                    for (i = 0; i < ipAccessHostEtData.length; ++i) {
                        IpInterfaceMo ipInterfaceRefMo = (IpInterfaceMo)this.moRepository.lookup(ipAccessHostEtData[i].getIpInterfaceMoRefLdn());
                        if (ipInterfaceRefMo == null || !ipInterfaceRefMo.equals(originalIpInterfaceMo)) continue;
                        isReferenced = true;
                        break;
                    }
                }
                if (isReferenced && ipInterfaceData != null && ipHostLinkData != null && ipHostLinkData.getIpInterfaceLdn().toLowerCase().indexOf("ManagedElement=1,IpSystem=1,VpnInterface=".toLowerCase()) != -1) {
                    for (i = 0; i < ipInterfaceData.length; ++i) {
                        relativeName = "IpInterface=" + ipInterfaceData[i].getIpInterfaceId();
                        if (!relativeName.equalsIgnoreCase(originalIpInterfaceMo.getRelativeDistinguishedName())) continue;
                        isReferenced = false;
                        break;
                    }
                }
                if (isReferenced && ipInterfaceData != null && ipHostLinkData != null && ipHostLinkData.getIpInterfaceLdn().toLowerCase().indexOf("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1".toLowerCase()) != -1) {
                    for (i = 0; i < ipInterfaceData.length; ++i) {
                        relativeName = "IpInterface=" + ipInterfaceData[i].getIpInterfaceId();
                        if (!relativeName.equalsIgnoreCase(originalIpInterfaceMo.getRelativeDistinguishedName()) || !ipInterfaceData[i].configurationMode.equals("DHCP")) continue;
                        isReferenced = false;
                        break;
                    }
                }
                if (!isReferenced) {
                    ConfigurationReportLoggerFactory.getLogger().logAction(originalIpInterfaceMo.getType(), "Delete", "LDN", "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
                    originalIpInterfaceMo.delete(coordinator);
                } else {
                    logger.traceDebug(THIS_CLASS, "Original IpInterface MO should not be deleted due to referenced by IpAccessHostEt");
                }
            }
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Site Basic", "Unable to delete temporary IpInterface MO.", (Exception)((Object)e));
        }
        logger.traceReturn(THIS_CLASS, "removeOriginalIpInterfaceMo");
    }

    private void removeOriginalIpv6InterfaceMo(Coordinator coordinator) throws RbsConfigurationFailedException {
        logger.traceEnter(THIS_CLASS, "removeOriginalIpV6InterfaceMo");
        boolean isReferenced = false;
        IpAccessHostEtData[] ipAccessHostEtData = null;
        Ipv6InterfaceData[] ipv6InterfaceData = null;
        IpHostLinkData ipHostLinkData = null;
        try {
            Ipv6InterfaceMo originalIpv6InterfaceMo = (Ipv6InterfaceMo)this.moRepository.lookup("ManagedElement=1,IpSystem=1,Ipv6Interface=1");
            if (originalIpv6InterfaceMo != null) {
                int i;
                if (this.siteBasicData != null) {
                    ipAccessHostEtData = this.siteBasicData.getIpSystemData().getIpAccessHostEtData();
                    ipv6InterfaceData = this.siteBasicData.getIpSystemData().getIpv6InterfaceData();
                    ipHostLinkData = this.siteBasicData.getIpData().getIpHostLinkData();
                }
                if (ipAccessHostEtData != null) {
                    for (i = 0; i < ipAccessHostEtData.length; ++i) {
                        Ipv6InterfaceMo ipv6InterfaceRefMo = (Ipv6InterfaceMo)this.moRepository.lookup(ipAccessHostEtData[i].getIpInterfaceMoRefLdn());
                        if (ipv6InterfaceRefMo == null || !ipv6InterfaceRefMo.equals(originalIpv6InterfaceMo)) continue;
                        isReferenced = true;
                        break;
                    }
                }
                if (isReferenced && ipv6InterfaceData != null && ipHostLinkData != null && ipHostLinkData.getIpInterfaceLdn().toLowerCase().indexOf("ManagedElement=1,IpSystem=1,VpnInterface=".toLowerCase()) != -1) {
                    for (i = 0; i < ipv6InterfaceData.length; ++i) {
                        String relativeName = "Ipv6Interface=" + ipv6InterfaceData[i].getIpv6InterfaceId();
                        if (!relativeName.equalsIgnoreCase(originalIpv6InterfaceMo.getRelativeDistinguishedName())) continue;
                        isReferenced = false;
                        break;
                    }
                }
                if (!isReferenced) {
                    ConfigurationReportLoggerFactory.getLogger().logAction(originalIpv6InterfaceMo.getType(), "Delete", "LDN", "ManagedElement=1,IpSystem=1,Ipv6Interface=1");
                    originalIpv6InterfaceMo.delete(coordinator);
                } else {
                    logger.traceDebug(THIS_CLASS, "Original Ipv6Interface MO should not be deleted due to referenced by IpAccessHostEt");
                }
            }
        }
        catch (MoAccessException e) {
            throw new RbsConfigurationFailedException("Site Basic", "Unable to delete temporary IpInterface MO.", (Exception)((Object)e));
        }
        logger.traceReturn(THIS_CLASS, "removeOriginalIpV6InterfaceMo");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO delete failed", "Unable to delete original OaM IP configuration.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

