/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.managedelement.ManagedElementDataMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetAutoConfigurationAllowedTp
implements TransactionPackage {
    private static final Class THIS_CLASS = SetAutoConfigurationAllowedTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private boolean autoConfigurationAllowed;

    public SetAutoConfigurationAllowedTp(GenericMaoContext aGenericMaoContextIn, boolean inAutoConfigurationAllowed) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.autoConfigurationAllowed = inAutoConfigurationAllowed;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        ManagedElementDataMo managedElementData = (ManagedElementDataMo)this.aMoRepository.lookup("ManagedElement=1,ManagedElementData=1");
        boolean currentValue = managedElementData.getAutoConfigurationAllowed(coordinator);
        if (this.autoConfigurationAllowed != currentValue) {
            managedElementData.setAutoConfigurationAllowed(this.autoConfigurationAllowed, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO set failed", "Unable to set autoConfigurationAllowed attributes on ManagedElementData MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

