/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.managedelement.NtpServerMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetDefaultNtpServerTp
implements TransactionPackage {
    private static final Class THIS_CLASS = SetDefaultNtpServerTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final String ntpIpAddress;
    private final String ntpFallbackFqdn;
    private String usedNtpAddress = "169.254.0.10";

    public SetDefaultNtpServerTp(GenericMaoContext genericMaoContextIn, String fqdn, String option42) {
        this.aMoRepository = genericMaoContextIn.getMoRepositoryWrapper();
        this.ntpIpAddress = option42;
        this.ntpFallbackFqdn = fqdn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        String actualValue = this.ntpIpAddress;
        NtpServerMo ntpServerMo = (NtpServerMo)this.aMoRepository.lookup("ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=1");
        String ipv4address = this.getIpv4Address(this.ntpFallbackFqdn);
        if (actualValue != null && !actualValue.trim().equals("")) {
            ntpServerMo.setServerAddress(actualValue, coordinator);
            this.usedNtpAddress = actualValue;
            logger.traceDebug(THIS_CLASS, "Using DHCP option 42 as NTP server address: " + this.usedNtpAddress + ".");
        } else if (ipv4address != null) {
            this.usedNtpAddress = actualValue = ipv4address;
            ntpServerMo.setServerAddress(actualValue, coordinator);
            logger.traceDebug(THIS_CLASS, "Using " + this.ntpFallbackFqdn + " resolved to " + this.usedNtpAddress + " as NTP server address.");
        } else {
            this.usedNtpAddress = "169.254.0.10";
            ntpServerMo.setServerAddress(this.usedNtpAddress, coordinator);
            logger.traceAbnormal(THIS_CLASS, "No Ntp Server IP address found. Check that option 42 or DNS has been configured. ");
        }
        if (!this.usedNtpAddress.equals("169.254.0.10")) {
            if (!ntpServerMo.getServiceActive(coordinator)) {
                ntpServerMo.setServiceActive(true, coordinator);
            }
        } else if (ntpServerMo.getServiceActive(coordinator)) {
            ntpServerMo.setServiceActive(false, coordinator);
            logger.traceDebug(THIS_CLASS, "Deactivating NTP server MO due to invalid or reset NTP server IP address.");
        }
        ConfigurationReportLoggerFactory.getLogger().logAttribute(ntpServerMo.getType(), "NTP server address set to", (Object)this.usedNtpAddress);
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("NtpServerMo", "Unable to set " + this.usedNtpAddress + " to active " + "ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=1" + ".", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }

    private String getIpv4Address(String fqdn) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(fqdn.trim());
            for (int i = 0; i < addresses.length; ++i) {
                if (!(addresses[i] instanceof Inet4Address)) continue;
                return addresses[i].getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            logger.traceAbnormal(THIS_CLASS, "server can't find " + fqdn + " -> " + e.getMessage());
        }
        return null;
    }
}

