/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationMao;
import se.ericsson.crbs.cat.mao.rbsconfiguration.parameters.IpParameters;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.rollback.RollbackStack;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetNodeInterfaceNameTp
implements TransactionPackage {
    private static final Class THIS_CLASS = SetNodeInterfaceNameTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final RbsConfigurationMao rbsConfigurationMao;
    private final MoRepositoryWrapper aMoRepository;
    private final String ipHostLinkLdn;
    private final RollbackStack rollbackStack;
    private boolean isIpv4 = true;

    public SetNodeInterfaceNameTp(RbsConfigurationMao rbsConfigurationMaoIn, GenericMaoContext genericMaoContextIn, String ipHostLinkRdnValueIn, RollbackStack rollbackStackIn, boolean isIpv4In) {
        this.rbsConfigurationMao = rbsConfigurationMaoIn;
        this.aMoRepository = genericMaoContextIn.getMoRepositoryWrapper();
        this.ipHostLinkLdn = "ManagedElement=1,IpOam=1,Ip=1,IpHostLink=" + ipHostLinkRdnValueIn;
        this.rollbackStack = rollbackStackIn;
        this.isIpv4 = isIpv4In;
    }

    private void checkIpHostLinkVersion(Coordinator coordinator) throws MoAccessException {
        IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.aMoRepository.lookup(this.ipHostLinkLdn);
        ManagedObject ipHostLinkRef = ipHostLinkMo.getIpInterfaceMoRef(coordinator);
        VpnInterfaceMo vpnInterfaceMo = null;
        if (ipHostLinkRef instanceof VpnInterfaceMo) {
            vpnInterfaceMo = (VpnInterfaceMo)ipHostLinkRef;
        }
        if (ipHostLinkMo != null) {
            String[] ipv4Addresses = ipHostLinkMo.getIpv4Addresses(coordinator);
            if (ipv4Addresses != null && ipv4Addresses.length > 0 || vpnInterfaceMo != null && vpnInterfaceMo.getConfigurationMode(coordinator) != RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE.intValue() && vpnInterfaceMo.getIpVersion(coordinator) == RbsConfigurationDefinitions.VPN_INTERFACE_IP_VERSION_V4.intValue()) {
                this.isIpv4 = true;
            } else {
                Struct[] ipv6Addresses = ipHostLinkMo.getIpv6Addresses(coordinator);
                if (ipv6Addresses != null && ipv6Addresses.length > 0 && this.isIpv4 || vpnInterfaceMo != null && vpnInterfaceMo.getConfigurationMode(coordinator) != RbsConfigurationDefinitions.VPN_INTERFACE_CONF_MODE_IKE.intValue() && vpnInterfaceMo.getIpVersion(coordinator) == RbsConfigurationDefinitions.VPN_INTERFACE_IP_VERSION_V6.intValue()) {
                    this.isIpv4 = false;
                }
            }
        }
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        boolean corbaOnSiteLan = IpParameters.instance(this.rbsConfigurationMao).getCorbaOnSiteLan();
        if (corbaOnSiteLan) {
            logger.info(THIS_CLASS, "Skipped to set node interface name as CorbaOnSiteLan was set");
        } else {
            IpHostLinkMo ipHostLinkMo = (IpHostLinkMo)this.aMoRepository.lookup(this.ipHostLinkLdn);
            this.waitForIpHostLinkEnabled(coordinator, ipHostLinkMo);
            ManagedObject ipMo = this.aMoRepository.lookup("ManagedElement=1,IpOam=1,Ip=1");
            String nodeInterfaceName = ipHostLinkMo.getInterfaceName(coordinator);
            this.checkIpHostLinkVersion(coordinator);
            if (this.isIpv4) {
                if (this.rollbackStack != null) {
                    String[] attributeNames = new String[]{"nodeInterfaceName"};
                    this.rollbackStack.pushSet("ManagedElement=1,IpOam=1,Ip=1", attributeNames, ipMo.getAttributes(attributeNames, coordinator), coordinator);
                }
                ipMo.setAttribute("nodeInterfaceName", (Object)nodeInterfaceName, coordinator);
                logger.traceDebug(THIS_CLASS, "nodeInterfaceName for IPV4 is set to " + nodeInterfaceName);
                ConfigurationReportLoggerFactory.getLogger().logAttribute(ipMo.getRelativeDistinguishedName(), "nodeInterfaceName", (Object)nodeInterfaceName);
            } else {
                if (this.rollbackStack != null) {
                    String[] attributeNames = new String[]{"nodeIpv6InterfaceName"};
                    this.rollbackStack.pushSet("ManagedElement=1,IpOam=1,Ip=1", attributeNames, ipMo.getAttributes(attributeNames, coordinator), coordinator);
                }
                ipMo.setAttribute("nodeIpv6InterfaceName", (Object)nodeInterfaceName, coordinator);
                logger.traceDebug(THIS_CLASS, "nodeIpv6InterfaceName for IPV6 is set to " + nodeInterfaceName);
                ConfigurationReportLoggerFactory.getLogger().logAttribute(ipMo.getRelativeDistinguishedName(), "nodeIpv6InterfaceName", (Object)nodeInterfaceName);
            }
        }
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    private void waitForIpHostLinkEnabled(Coordinator coordinator, IpHostLinkMo ipHostLinkMo) throws MoAccessException, NoSuchAttributeException {
        boolean ipHostLinkIsEnabled = false;
        while (!ipHostLinkIsEnabled) {
            Integer operationalState = (Integer)ipHostLinkMo.getAttribute("operationalState", coordinator);
            if (operationalState != null && operationalState.intValue() == RbsConfigurationDefinitions.ENABLED.intValue()) {
                ipHostLinkIsEnabled = true;
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.traceDebug(THIS_CLASS, "Interrupted while sleeping: " + e.getMessage());
            }
        }
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("IpHostLink", "Unable to set nodeInterfaceName on IpMo for IpHostLink" + this.ipHostLinkLdn + ".", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

