/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetVendorCredentialsOnIpSecMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = SetVendorCredentialsOnIpSecMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final int vendorCredentialState;

    public SetVendorCredentialsOnIpSecMoTp(int vendorCredentialStateIn, GenericMaoContext aGenericMaoContextIn) {
        this.vendorCredentialState = vendorCredentialStateIn;
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute");
        IpSecMo ipSecMo = (IpSecMo)this.aMoRepository.lookup("ManagedElement=1,IpSystem=1,IpSec=1");
        ipSecMo.setVendorCredentials((long)this.vendorCredentialState, coordinator);
        logger.traceReturn(THIS_CLASS, "execute");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO set failed", "Unable to set vendor credentials on IpSec MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

