/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages.CreateIpInterfaceMoTp;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class SetVlanOnIpInterfaceMoTp
implements TransactionPackage {
    private static final Class THIS_CLASS = CreateIpInterfaceMoTp.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final MoRepositoryWrapper aMoRepository;
    private final int vlanId;

    public SetVlanOnIpInterfaceMoTp(GenericMaoContext aGenericMaoContextIn, int vlanIdIn) {
        this.aMoRepository = aGenericMaoContextIn.getMoRepositoryWrapper();
        this.vlanId = vlanIdIn;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "execute()");
        IpInterfaceMo ipInterface = (IpInterfaceMo)this.aMoRepository.lookup("ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1,GigaBitEthernet=1,IpInterface=1");
        if (ipInterface == null) {
            throw new MoNotFoundException("Correct IpInterface MO was not found!");
        }
        if (this.vlanId == -1) {
            ipInterface.setVid(1, coordinator);
            ipInterface.setVLan(false, coordinator);
        } else if (this.vlanId > -1) {
            ipInterface.setVid(this.vlanId, coordinator);
            ipInterface.setVLan(true, coordinator);
        } else {
            throw new RbsConfigurationFailedException("Invalid vlanId: " + this.vlanId);
        }
        ConfigurationReportLoggerFactory.getLogger().logAction("IpInterface", "set", new String[]{"vid", "VLan"}, (Object[])new String[]{Integer.toString(ipInterface.getVid(coordinator)), ipInterface.getVLan(coordinator) ? "true" : "false"});
        logger.traceReturn(THIS_CLASS, "execute()");
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("MO set failed", "Unable to set vlan attributes on IpInterface MO.", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Transaction exception", "Caught a transaction exception", exception);
    }
}

