/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.transactionpackages;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationDefinitions;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationFailedException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.transactionhandling.TransactionPackage;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class UnlockHptsiTp
implements TransactionPackage {
    private final MoRepositoryWrapper moRepository;
    private final String attr;

    public UnlockHptsiTp(MoRepositoryWrapper inMoRepository, String attribute) {
        this.moRepository = inMoRepository;
        this.attr = attribute;
    }

    public void execute(Coordinator coordinator) throws MoAccessException {
        MoIterator hptsis = this.moRepository.lookupType("HptsiSyncRef");
        while (hptsis != null && hptsis.hasMoreElements()) {
            ManagedObject hptsiMo = hptsis.nextMo();
            hptsiMo.setAttribute(this.attr, (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED, coordinator);
            ConfigurationReportLoggerFactory.getLogger().logAttribute(hptsiMo.getRelativeDistinguishedName(), this.attr, (Object)RbsConfigurationDefinitions.ADMINISTRATIVE_STATE_UNLOCKED);
        }
    }

    public void handleExecutionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Site Basic fault", "Unable to unlock hptsi", exception);
    }

    public void handleTransactionException(Exception exception) throws RbsConfigurationFailedException {
        throw new RbsConfigurationFailedException("Site Basic fault", "Unable to unlock hptsi", exception);
    }
}

