/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade;

import java.util.Locale;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.common.StringHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.RbsConfigurationContext;
import se.ericsson.crbs.cat.mao.rbsconfiguration.progressreport.ProgressReportHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.ActionResultData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.InstallInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.Installer;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpInfo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpStatus;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeHelper;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.InstallSubscriber;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpState;
import se.ericsson.crbs.common.DateTimeHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public class InstallerImpl
implements Installer {
    private static final Class THIS_CLASS = InstallerImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String userLabelPrefix = "RBS_configuration_";
    private final RbsConfigurationContext rbsConfigurationContext;

    public InstallerImpl(RbsConfigurationContext rbsConfigurationContextIn) {
        logger.traceEnter(THIS_CLASS, "InstallerImpl()");
        this.rbsConfigurationContext = rbsConfigurationContextIn;
        logger.traceReturn(THIS_CLASS, "InstallerImpl()");
    }

    public InstallInfo prepare(UpInfo upInfo, MoRepositoryWrapper moRepositoryWrapper, MoFactoryMgrWrapper moFactoryWrapper, String ftpService, String ucfFilePath, Coordinator coordinator) throws UpgradeException {
        InstallInfo installInfo;
        try {
            logger.traceEnter(THIS_CLASS, "prepare(" + upInfo + ")");
            this.updateProgressReportInformation(600, 3, "Preparing upgrade package: " + StringHelper.doubleQuote((String)ucfFilePath) + " for installation", true);
            InstallInfo installInfo2 = this.getUpgradePackageMo(upInfo, moRepositoryWrapper, moFactoryWrapper, ftpService, ucfFilePath, coordinator);
            UpStatus upStatus = UpgradeHelper.getUpgradePackageStatus(coordinator, installInfo2.upgradePackageMo);
            if (this.isUpInInstallExecutingState(upStatus)) {
                ConfigurationReportLoggerFactory.getLogger().logInformation("UpgradePackage:continueInstall", "UpgradePackage installation is ongoing.");
                installInfo2.upgradePackageMo.actionUpdateFTPServerData(installInfo2.upInfo.ftpService, installInfo2.upInfo.upgradeControlFile, installInfo2.upInfo.userName, installInfo2.upInfo.password, coordinator);
            } else {
                if (this.isUpInWrongState(upStatus)) {
                    throw new UpgradeException("Upgrade package not ready for installation: " + upStatus.state.getStateDescription());
                }
                if (this.isUpInFinishedState(upStatus)) {
                    ConfigurationReportLoggerFactory.getLogger().logInformation("UpgradePackage:updateFtpServerData", "UpgradePackage already installed, updating FTP information.");
                    installInfo2.upgradePackageMo.actionUpdateFTPServerData(installInfo2.upInfo.ftpService, installInfo2.upInfo.upgradeControlFile, installInfo2.upInfo.userName, installInfo2.upInfo.password, coordinator);
                }
            }
            installInfo = installInfo2;
            Object var11_12 = null;
        }
        catch (Exception e) {
            try {
                String errorMsg = "Could not prepare the upgrade package with number, " + upInfo.productNumber + ", and revision, " + upInfo.productRevision;
                this.updateProgressReportInformation(600, 4, errorMsg, true);
                throw new UpgradeException(errorMsg, e);
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                logger.traceReturn(THIS_CLASS, "prepare(" + upInfo + ")");
                throw throwable;
            }
        }
        logger.traceReturn(THIS_CLASS, "prepare(" + upInfo + ")");
        return installInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void install(InstallInfo installInfo, Coordinator coordinator) throws UpgradeException {
        UpStatus upStatus;
        try {
            upStatus = UpgradeHelper.getUpgradePackageStatus(null, installInfo.upgradePackageMo);
            int upState = upStatus.state.getStateValue();
            ConfigurationReportLoggerFactory.getLogger().logInformation("Upgrade", "Upgrade package " + installInfo.upgradePackageMo.getLocalDistinguishedName() + " UP in state: " + upState);
            if (upState == UpState.STATE_INSTALL_EXECUTING.getStateValue()) return;
            if (upState == UpState.STATE_INSTALL_COMPLETED.getStateValue()) return;
            if (upState == UpState.STATE_UPGRADE_COMPLETED.getStateValue()) {
                return;
            }
        }
        catch (MoAccessException e1) {
            throw new UpgradeException("Upgrade problem in install phase. UpgradePackage with number, " + installInfo.upInfo.productNumber + ", and revision, " + installInfo.upInfo.productRevision, e1);
        }
        InstallSubscriber subscriber = null;
        try {
            try {
                int actionId;
                block14: {
                    String upLdn = "ManagedElement=1,SwManagement=1,UpgradePackage=" + installInfo.upInfo.getUpId();
                    subscriber = new InstallSubscriber(upLdn, this.rbsConfigurationContext);
                    subscriber.subscribe();
                    ConfigurationReportLoggerFactory.getLogger().logAction("UpgradePackage", "install", "", "");
                    actionId = -1;
                    try {
                        actionId = installInfo.upgradePackageMo.actionInstall(coordinator);
                    }
                    catch (MoAccessException e) {
                        upStatus = UpgradeHelper.getUpgradePackageStatus(coordinator, installInfo.upgradePackageMo);
                        if (upStatus.state.getStateValue() == UpState.STATE_INSTALL_EXECUTING.getStateValue() || upStatus.state.getStateValue() == UpState.STATE_INSTALL_COMPLETED.getStateValue() || upStatus.state.getStateValue() == UpState.STATE_UPGRADE_COMPLETED.getStateValue()) break block14;
                        throw new UpgradeException("Could not install the upgrade package with number, " + installInfo.upInfo.productNumber + ", and revision, " + installInfo.upInfo.productRevision, e);
                    }
                }
                upStatus = UpgradeHelper.getUpgradePackageStatus(coordinator, installInfo.upgradePackageMo);
                if (upStatus.state.getStateValue() == UpState.STATE_INSTALL_EXECUTING.getStateValue()) {
                    throw new UpgradeException("INSTALL_EXECUTING");
                }
                if (upStatus.state.getStateValue() == UpState.STATE_INSTALL_COMPLETED.getStateValue()) {
                    ConfigurationReportLoggerFactory.getLogger().logInformation("Upgrade", "Upgrade package " + installInfo.upgradePackageMo.getLocalDistinguishedName() + " installed.");
                } else {
                    if (upStatus.state.getStateValue() != UpState.STATE_UPGRADE_COMPLETED.getStateValue()) {
                        ActionResultData actionResultData = UpgradeHelper.getActionResultData(actionId, coordinator, installInfo.upgradePackageMo);
                        String errorMsg = "Failed to install upgrade package: " + installInfo.upgradePackageMo.getFullDistinguishedName() + ". Reason: \"" + actionResultData.info + "\", \"" + actionResultData.additionalInfo + "\"";
                        throw new UpgradeException(errorMsg);
                    }
                    logger.traceGeneral(THIS_CLASS, "Upgrade with " + installInfo.upgradePackageMo.getLocalDistinguishedName() + " complete.");
                }
                Object var10_13 = null;
                if (subscriber == null) return;
                subscriber.unsubscribe();
            }
            catch (Exception e) {
                if (e.getMessage().compareTo("INSTALL_EXECUTING") != 0) throw new UpgradeException("Could not install the upgrade package with number, " + installInfo.upInfo.productNumber + ", and revision, " + installInfo.upInfo.productRevision, e);
                throw new UpgradeException("INSTALL_EXECUTING");
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (subscriber == null) throw throwable;
            subscriber.unsubscribe();
            logger.traceAbnormal(THIS_CLASS, "Stopped installation subscription.");
            throw throwable;
        }
        logger.traceAbnormal(THIS_CLASS, "Stopped installation subscription.");
    }

    private InstallInfo getUpgradePackageMo(UpInfo upInfo, MoRepositoryWrapper moRepositoryWrapper, MoFactoryMgrWrapper moFactoryWrapper, String ftpService, String ucfFilePath, Coordinator coordinator) throws MoAccessException, UpgradeException {
        InstallInfo installInfo;
        boolean createdUpgradePackage = false;
        UpgradePackageMo upgradePackageMo = null;
        String upId = UpgradeHelper.getUpgradePackageId(coordinator, moRepositoryWrapper, upInfo.productNumber, upInfo.productRevision);
        if (upId == null) {
            upId = upInfo.getUpId();
            String userLabel = userLabelPrefix + DateTimeHelper.dateToString((long)System.currentTimeMillis(), (String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.getDefault());
            logger.traceGeneral(THIS_CLASS, "Creating UpgradePackage MO with id " + upId);
            ManagedObject swManagementMo = moRepositoryWrapper.lookup("ManagedElement=1,SwManagement=1");
            upgradePackageMo = UpgradeHelper.createUpgradePackageMo(moRepositoryWrapper, moFactoryWrapper, swManagementMo, upId, userLabel, ftpService, upInfo.userName, upInfo.password, ucfFilePath, coordinator);
            createdUpgradePackage = true;
            installInfo = new InstallInfo(createdUpgradePackage, upInfo, upgradePackageMo);
        } else {
            upgradePackageMo = UpgradeHelper.getUpgradePackageMo(coordinator, moRepositoryWrapper, upId);
            if (UpState.STATE_ONLY_DELETEABLE.getStateValue() == upgradePackageMo.getState(coordinator)) {
                upgradePackageMo.delete(coordinator);
                installInfo = this.getUpgradePackageMo(upInfo, moRepositoryWrapper, moFactoryWrapper, ftpService, ucfFilePath, coordinator);
            } else {
                installInfo = new InstallInfo(createdUpgradePackage, upInfo, upgradePackageMo);
            }
        }
        return installInfo;
    }

    private boolean isUpInInstallExecutingState(UpStatus upStatus) {
        return upStatus.state.getStateValue() == UpState.STATE_INSTALL_EXECUTING.getStateValue();
    }

    private boolean isUpInWrongState(UpStatus upStatus) {
        return upStatus.state.getStateValue() == UpState.STATE_UPGRADE_EXECUTING.getStateValue() || upStatus.state.getStateValue() == UpState.STATE_AWAITING_CONFIRMATION.getStateValue() || upStatus.state.getStateValue() == UpState.STATE_ONLY_DELETEABLE.getStateValue();
    }

    private boolean isUpInFinishedState(UpStatus upStatus) {
        return upStatus.state.getStateValue() == UpState.STATE_INSTALL_COMPLETED.getStateValue() || upStatus.state.getStateValue() == UpState.STATE_UPGRADE_COMPLETED.getStateValue();
    }

    private void updateProgressReportInformation(int integrationStepNumber, int status, String detailedInformation, boolean updateProgressReport) {
        ProgressReportHandler.getInstance().updateProgressReportInformation(integrationStepNumber, status, detailedInformation, updateProgressReport);
    }
}

