/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade;

import java.io.FileReader;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpInfo;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;

public class UpgradeControlFileParser
extends DefaultHandler {
    private static final Class THIS_CLASS = UpgradeControlFileParser.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final transient Stack elementStack = new Stack();
    private transient String productNumber = null;
    private transient String productRevision = null;

    protected UpgradeControlFileParser() {
    }

    public UpInfo getUpInfo() {
        return new UpInfo(this.productNumber, this.productRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String fileName) throws SAXException, IOException, ParserConfigurationException {
        try {
            logger.traceEnter(THIS_CLASS, "parse(" + fileName + ")");
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            FileReader fileReader = new FileReader(fileName);
            InputSource input = new InputSource(fileReader);
            saxParser.parse(input, (DefaultHandler)this);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            logger.traceReturn(THIS_CLASS, "parse(" + fileName + ")");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "parse(" + fileName + ")");
    }

    public void endElement(String namespaceURI, String simpleName, String qualifiedName) throws SAXException {
        if (!this.elementStack.empty()) {
            this.elementStack.pop();
        }
    }

    public void startElement(String namespaceURI, String simpleName, String qualifiedName, Attributes attrs) throws SAXException {
        String parentElement = null;
        if (!this.elementStack.empty()) {
            parentElement = (String)this.elementStack.peek();
        }
        if (parentElement != null && parentElement.equals("UpgradePackage") && qualifiedName.equals("ProductData")) {
            this.productNumber = attrs.getValue("number");
            this.productRevision = attrs.getValue("revision");
        }
        this.elementStack.push(qualifiedName);
    }
}

