/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactory;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.cat.mao.rbsconfiguration.reportlogger.ConfigurationReportLoggerFactory;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.ActionResultData;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpStatus;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.UpgradeException;
import se.ericsson.crbs.cat.mao.rbsconfiguration.upgrade.notification.UpState;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.wrappers.MoFactoryMgrWrapper;
import se.ericsson.crbs.omf.mao.wrappers.MoRepositoryWrapper;

public abstract class UpgradeHelper {
    private static final Class THIS_CLASS = UpgradeHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUpgradePackageId(Coordinator coordinator, MoRepositoryWrapper moRepositoryWrapper, String productNumber, String productRevision) throws MoAccessException {
        String string;
        String upId = null;
        try {
            logger.traceEnter(THIS_CLASS, "getUpgradePackageId(" + productNumber + ", " + productRevision + ")");
            UpgradePackageMo[] upgradePackageMos = UpgradeHelper.getUpgradePackageMos(moRepositoryWrapper);
            String[] attrNames = new String[]{"UpgradePackageId", "administrativeData"};
            for (int index = 0; index < upgradePackageMos.length; ++index) {
                Object[] attrValues = upgradePackageMos[index].getAttributes(attrNames, coordinator);
                AdminData adminData = new AdminData(attrValues[1]);
                if (attrValues[0] == null || !adminData.productNumber.equals(productNumber) || !adminData.productRevision.equals(productRevision)) continue;
                upId = (String)attrValues[0];
                logger.traceGeneral(THIS_CLASS, "getUpgradePackageId(): Matching UP MO found: " + upId);
                break;
            }
            string = upId;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logger.traceReturn(THIS_CLASS, "getUpgradePackageId(" + productNumber + ", " + productRevision + ")");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "getUpgradePackageId(" + productNumber + ", " + productRevision + ")");
        return string;
    }

    public static UpgradePackageMo createUpgradePackageMo(MoRepositoryWrapper moRepositoryWrapper, MoFactoryMgrWrapper moFactoryWrapper, ManagedObject swManagementMo, String upId, String userLabel, String ftpServerAddress, String userName, String password, String upgradePackagePath, Coordinator coordinator) throws UpgradeException {
        UpgradePackageMo upgradePackageMo;
        try {
            UpgradePackageMo upgradePackageMo2;
            logger.traceEnter(THIS_CLASS, "createUpgradePackageMo(" + upId + ", ...)");
            MoFactory upgradePackageMoFactory = moFactoryWrapper.lookup("UpgradePackage");
            ManagedObject source = null;
            AttrListImpl attrList = new AttrListImpl(moRepositoryWrapper);
            attrList.addAttribute("userLabel", (Object)userLabel);
            attrList.addAttribute("ftpServerIpAddress", (Object)ftpServerAddress);
            attrList.addAttribute("upFilePathOnFtpServer", (Object)upgradePackagePath);
            attrList.addAttribute("password", (Object)password);
            attrList.addAttribute("user", (Object)userName);
            ConfigurationReportLoggerFactory.getLogger().logAction("UpgradePackage", "create", new String[]{"userLabel", "ftpServerIpAddress", "upFilePathOnFtpServer", "id", "user", "password"}, (Object[])new String[]{userLabel, ftpServerAddress, upgradePackagePath, upId, "***", "***"});
            upgradePackageMo = upgradePackageMo2 = (UpgradePackageMo)upgradePackageMoFactory.createMo(swManagementMo, (AttrList)attrList, upId, source, coordinator);
            Object var16_16 = null;
        }
        catch (Exception e) {
            try {
                ConfigurationReportLoggerFactory.getLogger().logFailure("Upgrade failure", "Failed to create the up");
                throw new UpgradeException("Failed to create an UpgradePackage MO.", e);
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                logger.traceReturn(THIS_CLASS, "createUpgradePackageMo(" + upId + ", ...)");
                throw throwable;
            }
        }
        logger.traceReturn(THIS_CLASS, "createUpgradePackageMo(" + upId + ", ...)");
        return upgradePackageMo;
    }

    public static UpgradePackageMo getUpgradePackageMo(Coordinator coordinator, MoRepositoryWrapper moRepositoryWrapper, String upId) throws UpgradeException {
        UpgradePackageMo upgradePackageMo;
        UpgradePackageMo upgradePackageMo2 = null;
        UpgradePackageMo result2 = null;
        try {
            logger.traceEnter(THIS_CLASS, "getUpgradePackageMo(" + upId + ")");
            UpgradePackageMo[] upgradePackageMos = UpgradeHelper.getUpgradePackageMos(moRepositoryWrapper);
            for (int index = 0; index < upgradePackageMos.length; ++index) {
                upgradePackageMo2 = upgradePackageMos[index];
                if (((String)upgradePackageMo2.getAttribute("UpgradePackageId", coordinator)).equals(upId)) {
                    result2 = upgradePackageMo2;
                    break;
                }
                if (!((String)upgradePackageMo2.getAttribute("UpgradePackageId", coordinator)).endsWith(upId)) continue;
                upgradePackageMo2.delete(coordinator);
            }
            upgradePackageMo = result2;
            Object var8_9 = null;
        }
        catch (Exception e) {
            try {
                throw new UpgradeException("Failed to find the UpgradePackage MO, with id: \"" + upId + "\"", e);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                logger.traceReturn(THIS_CLASS, "getUpgradePackageMo(" + upId + ")");
                throw throwable;
            }
        }
        logger.traceReturn(THIS_CLASS, "getUpgradePackageMo(" + upId + ")");
        return upgradePackageMo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpgradePackageMo[] getUpgradePackageMos(MoRepositoryWrapper moRepositoryWrapper) {
        UpgradePackageMo[] upgradePackageMoArray;
        UpgradePackageMo[] upgradePackageMos = new UpgradePackageMo[]{};
        try {
            logger.traceEnter(THIS_CLASS, "getUpgradePackageMos()");
            MoIterator moIterator = moRepositoryWrapper.lookupType("UpgradePackage");
            upgradePackageMos = new UpgradePackageMo[moIterator.size()];
            int index = 0;
            while (moIterator.hasMoreElements()) {
                upgradePackageMos[index++] = (UpgradePackageMo)moIterator.nextMo();
            }
            upgradePackageMoArray = upgradePackageMos;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            logger.traceReturn(THIS_CLASS, "getUpgradePackageMos()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "getUpgradePackageMos()");
        return upgradePackageMoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpStatus getUpgradePackageStatus(Coordinator coordinator, UpgradePackageMo upgradePackageMo) throws MoAccessException {
        UpStatus upStatus;
        try {
            logger.traceEnter(THIS_CLASS, "getUpgradePackageStatus()");
            String[] attrNames = new String[]{"state", "progressHeader", "progressCount", "progressTotal"};
            Object[] attrValues = upgradePackageMo.getAttributes(attrNames, coordinator);
            upStatus = new UpStatus(UpState.toUpState((Integer)attrValues[0]), (Integer)attrValues[1], (Integer)attrValues[2], (Integer)attrValues[3]);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            logger.traceReturn(THIS_CLASS, "getUpgradePackageStatus()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "getUpgradePackageStatus()");
        return upStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionResultData getActionResultData(int actionId, Coordinator coordinator, UpgradePackageMo upgradePackageMo) throws MoAccessException {
        ActionResultData actionResultData;
        try {
            logger.traceEnter(THIS_CLASS, "getActionResultData()");
            Object[] attrValues = (Object[])upgradePackageMo.getAttribute("actionResult", coordinator);
            actionResultData = new ActionResultData(actionId, attrValues);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            logger.traceReturn(THIS_CLASS, "getActionResultData()");
            throw throwable;
        }
        logger.traceReturn(THIS_CLASS, "getActionResultData()");
        return actionResultData;
    }

    public static class AdminData {
        public final String productInfo;
        public final String productionDate;
        public final String productName;
        public final String productNumber;
        public final String productRevision;

        public AdminData(Object adminObj) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException {
            Struct struct = (Struct)adminObj;
            this.productInfo = (String)struct.getValue("productInfo");
            this.productionDate = (String)struct.getValue("productionDate");
            this.productName = (String)struct.getValue("productName");
            this.productNumber = (String)struct.getValue("productNumber");
            this.productRevision = (String)struct.getValue("productRevision");
        }
    }
}

