/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.TransactionWrapper;
import se.ericsson.cello.aueframework.converter.ChangeSet;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.CoreConverterContext;
import se.ericsson.cello.aueframework.converter.DataReader;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.managedelement.ManagedElementAueConstants;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class NtpServerChanges
implements ChangeSet,
ManagedElementAueConstants {
    static final String NTP1 = "NTP1";
    static final String NTP2 = "NTP2";
    static final String NTP3 = "NTP3";
    static final String NULL_ADDRESS = "0.0.0.0";
    static final String TIMESETTING_LDN = "ManagedElement=1,SystemFunctions=1,TimeSetting=1";
    static final String NTPSERVER = "NtpServer";
    static final String TIMESETTING = "TimeSetting";
    static final String NTPSERVER_FRO_ID = "froId";
    static final int NTPSERVER_REVISION = 14000;
    static final int TIMESETTING_REVISION = 9000;
    static final String USER_LABEL = "userLabel";

    public void apply(ConverterContext converterContext) throws AueException {
        StringAttribute stringAttribute;
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        TransactionWrapper transactionWrapper = null;
        transactionWrapper = converterContext.getTransactionWrapperFactory().create();
        Coordinator coordinator = transactionWrapper.getCoordinator();
        DataReader dataReader = converterContext.getDataReader();
        if (this.numberOfNtpServers(moDataAccessor) > 0) {
            return;
        }
        if (!this.isNtpParentExisting(TIMESETTING_LDN, moDataAccessor)) {
            this.createNtpParent(1, TIMESETTING, moDataAccessor, coordinator);
        }
        if (!(stringAttribute = (StringAttribute)dataReader.getData(NTP1, (CoreConverterContext)converterContext, coordinator)).getValue(coordinator).equals(NULL_ADDRESS)) {
            this.createNtp(1, NTP1, moDataAccessor, coordinator);
        }
        if (!(stringAttribute = (StringAttribute)dataReader.getData(NTP2, (CoreConverterContext)converterContext, coordinator)).getValue(coordinator).equals(NULL_ADDRESS)) {
            this.createNtp(2, NTP2, moDataAccessor, coordinator);
        }
        if (!(stringAttribute = (StringAttribute)dataReader.getData(NTP3, (CoreConverterContext)converterContext, coordinator)).getValue(coordinator).equals(NULL_ADDRESS)) {
            this.createNtp(3, NTP3, moDataAccessor, coordinator);
        }
        transactionWrapper.commit();
    }

    private void createNtp(int n, String string, MoDataAccessor moDataAccessor, Coordinator coordinator) throws AueException {
        String string2 = "ManagedElement=1,SystemFunctions=1,TimeSetting=1,NtpServer=" + n;
        if (this.isNtpExisting(string2, moDataAccessor)) {
            return;
        }
        MoDataWrapper moDataWrapper = moDataAccessor.create(string2, coordinator);
        moDataWrapper.registerPersistentAttr((Attribute)new IntegerAttribute(NTPSERVER_FRO_ID, false, n - 1));
        StringAttribute stringAttribute = new StringAttribute(USER_LABEL, true, string);
        moDataWrapper.registerPersistentAttr((Attribute)stringAttribute);
        moDataWrapper.setRevision(14000);
        moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private void createNtpParent(int n, String string, MoDataAccessor moDataAccessor, Coordinator coordinator) throws AueException {
        String string2 = TIMESETTING_LDN;
        MoDataWrapper moDataWrapper = moDataAccessor.create(string2, coordinator);
        StringAttribute stringAttribute = new StringAttribute(USER_LABEL, true, string);
        moDataWrapper.registerPersistentAttr((Attribute)stringAttribute);
        moDataWrapper.setRevision(9000);
        moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private boolean isNtpExisting(String string, MoDataAccessor moDataAccessor) {
        Collection collection = moDataAccessor.getByType(NTPSERVER);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MoDataWrapper moDataWrapper = (MoDataWrapper)iterator.next();
            if (!moDataWrapper.getLocalDistinguishedName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isNtpParentExisting(String string, MoDataAccessor moDataAccessor) {
        Collection collection = moDataAccessor.getByType(TIMESETTING);
        return collection.size() > 0;
    }

    private int numberOfNtpServers(MoDataAccessor moDataAccessor) {
        Collection collection = moDataAccessor.getByType(NTPSERVER);
        return collection.size();
    }
}

