/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.cmaaue.from;

import se.ericsson.cello.aueframework.common.AueRuntimeException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.Struct;

public class JvmProgramFilter
implements MoFilter {
    public static final String PROGRAM_LOADMODULE = "loadModule";
    public static final String LM_PDATA = "productData";
    public static final String ADMDATA_PRODUCTNO = "productNumber";
    public static final String PROD_NO_JVM = "CXC1320784";

    public boolean accept(ManagedObject managedObject) throws AueRuntimeException {
        String string;
        return managedObject.getType().equals("Program") && PROD_NO_JVM.equals(string = this.getRelatedProductNumber(managedObject));
    }

    private String getRelatedProductNumber(ManagedObject managedObject) throws AueRuntimeException {
        ManagedObject managedObject2 = this.getRelatedLoadModule(managedObject);
        Struct struct = null;
        String string = null;
        try {
            struct = (Struct)managedObject2.getAttribute(LM_PDATA, null);
            string = (String)struct.getValue(ADMDATA_PRODUCTNO);
        }
        catch (MoAccessException moAccessException) {
            throw new AueRuntimeException("Problem determining the product number for (" + managedObject2.getLocalDistinguishedName() + ") referenced by (" + managedObject.getLocalDistinguishedName() + ")", (Throwable)moAccessException);
        }
        return string;
    }

    private ManagedObject getRelatedLoadModule(ManagedObject managedObject) throws AueRuntimeException {
        ManagedObject managedObject2 = null;
        try {
            managedObject2 = (ManagedObject)managedObject.getAttribute(PROGRAM_LOADMODULE, null);
        }
        catch (MoAccessException moAccessException) {
            throw new AueRuntimeException("Unable to get associated LoadModule for Program '" + managedObject.getLocalDistinguishedName() + "'", (Throwable)moAccessException);
        }
        if (managedObject2 == null) {
            throw new AueRuntimeException("LoadModule attribute for Program '" + managedObject.getLocalDistinguishedName() + "' is NULL");
        }
        return managedObject2;
    }
}

