/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.managedelement;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import se.ericsson.cello.managedelement.InvalidTimeFormatException;
import se.ericsson.cello.managedelement.WeekdayOutOfRangeException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.support.scheduler.ScheduleTime;

public class ScheduleEntry {
    private Struct entry;
    private StructAttribute attr;
    private ScheduleTime scheduleTime;
    public static final String TIME = "time";
    public static final String WEEKDAY = "weekday";
    private static final String[] FIELDS = new String[]{"time", "weekday"};

    public ScheduleEntry(Struct struct) throws MoAccessException, InvalidTimeFormatException, WeekdayOutOfRangeException {
        this.entry = struct;
        String string = (String)struct.getValue(TIME);
        int n = (Integer)struct.getValue(WEEKDAY);
        this.attr = new StructAttribute("", false);
        this.attr.addElement((Attribute)new StringAttribute(TIME, false, string));
        this.attr.addElement((Attribute)new IntegerAttribute(WEEKDAY, false, n));
        this.initScheduleTime(string, n);
    }

    public ScheduleEntry(StructAttribute structAttribute) throws InvalidTimeFormatException, WeekdayOutOfRangeException {
        this.attr = structAttribute;
        String string = ((StringAttribute)structAttribute.getElement(TIME, null)).getValue(null);
        int n = ((IntegerAttribute)structAttribute.getElement(WEEKDAY, null)).getValue(null);
        this.entry = new StructImpl(FIELDS, new Object[]{string, new Integer(n)});
        this.initScheduleTime(string, n);
    }

    private void initScheduleTime(String string, int n) throws InvalidTimeFormatException, WeekdayOutOfRangeException {
        Calendar calendar = this.parseTimeString(string);
        this.validateWeekday(n);
        this.scheduleTime = new ScheduleTime();
        this.scheduleTime.setTimeOfDay(calendar.get(11), calendar.get(12));
        this.scheduleTime.setDayOfWeek(n);
    }

    private Calendar parseTimeString(String string) throws InvalidTimeFormatException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
        Date date = null;
        simpleDateFormat.setLenient(false);
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new InvalidTimeFormatException(string);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar;
    }

    private void validateWeekday(int n) throws WeekdayOutOfRangeException {
        if (n < 1 || n > 7) {
            throw new WeekdayOutOfRangeException(n);
        }
    }

    public Struct toStruct() {
        return this.entry;
    }

    public StructAttribute toAttribute() {
        return this.attr;
    }

    public ScheduleTime toScheduleTime() {
        return this.scheduleTime;
    }
}

