/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.create;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import se.ericsson.cello.configurationversion.create.CV_ProgramInformation;
import se.ericsson.cello.configurationversion.create.event.CollectRequestEvent;
import se.ericsson.cello.configurationversion.create.event.UpdateRequestEvent;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeHandler;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.froproxy.cv.interfaces.RepertoirePositionData;
import se.ericsson.cello.su.util.thread.BlockingQueue;
import se.ericsson.cello.swmanagement.suaccess.RepertoireMoSU_Access;
import se.ericsson.cello.swmanagement.swmaccess.SwAllocationPropertyChangeEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.programhandler.FTC_OaM_PiuTypeLoadModuleRefInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.LoadModuleRefInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.PiuTypeInformation;
import se.ericsson.cello.upgradepackage.util.programhandler.PiuTypeInformations;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramCollector;
import se.ericsson.cello.upgradepackage.util.programhandler.ProgramConfigurationException;

public class CV_ProgramConfigurationCollector
implements PropertyChangeListener,
Runnable {
    private long myHighestLoadClassToBeIncluded = 0xFFFFFFFFL;
    private boolean myIsActive = false;
    private boolean myKeepWaiting = false;
    private static CV_ProgramConfigurationCollector myInstance = new CV_ProgramConfigurationCollector();
    private BlockingQueue myQueue = new BlockingQueue();
    private CV_ProgramInformation myCV_ProgramInformation = null;
    private ProgramConfigurationException myProgramConfigurationException = null;
    private Collection myPIU_MosFtc = new LinkedList();
    private Collection myPIU_MosOaM = new LinkedList();

    private CV_ProgramConfigurationCollector() {
        this.initiateThread();
    }

    private void initiateThread() {
        new Thread((Runnable)this, "CV_ProgramConfigurationCollector").start();
    }

    public static synchronized CV_ProgramConfigurationCollector instance() {
        return myInstance;
    }

    public synchronized void activate() {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "activate()", "myIsActive: " + this.myIsActive);
        }
        if (!this.myIsActive) {
            PropertyChangeHandler.instance().addPropertyChangeListener("SwAllocationConfigurationChange", (PropertyChangeListener)this);
            this.myCV_ProgramInformation = null;
            this.myIsActive = true;
        }
    }

    public synchronized void deactivate() {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "deactivate()", "myIsActive: " + this.myIsActive);
        }
        if (this.myIsActive) {
            PropertyChangeHandler.instance().removePropertyChangeListener("SwAllocationConfigurationChange", (PropertyChangeListener)this);
            this.myCV_ProgramInformation = null;
            this.myIsActive = false;
        }
    }

    public synchronized void update() {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "update()");
        }
        this.myQueue.enqueue(new UpdateRequestEvent(this));
    }

    public synchronized boolean isUpToDate() {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "isUpToDate()");
        }
        return this.myIsActive && this.myCV_ProgramInformation != null;
    }

    public synchronized CV_ProgramInformation getProgramConfiguration(long l) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProgramConfiguration(long aHighestLoadClassToBeIncluded)", "aHighestLoadClassToBeIncluded: " + l);
        }
        this.myQueue.enqueue(new CollectRequestEvent(this, l));
        this.waitForProgramInformation();
        if (Trace.valid(this.getClass(), 40)) {
            this.printProgramInformationFor(this.myCV_ProgramInformation.getFTC_OaM_PiuTypeLoadModuleRefInformations());
        }
        if (this.myCV_ProgramInformation != null) {
            return new CV_ProgramInformation(new LinkedList(this.myCV_ProgramInformation.getFTC_OaM_PiuTypeLoadModuleRefInformations()), new LinkedList(this.myCV_ProgramInformation.getRepertoirePositionDatas()));
        }
        throw this.myProgramConfigurationException;
    }

    public void printInfo() {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "printInfo()", "myCV_ProgramInformation: " + this.myCV_ProgramInformation);
        }
    }

    public synchronized void waitForProgramInformation() throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForProgramInformation()");
        }
        this.myKeepWaiting = true;
        try {
            while (this.myKeepWaiting) {
                this.wait();
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "waitForProgramInformation()", "After wait() statement");
            }
        }
        catch (InterruptedException interruptedException) {
            Trace.error(this.getClass(), "waitForProgramInformation()", "InterruptedException caught when invoking wait() method...", interruptedException);
            throw new ProgramConfigurationException(interruptedException.toString());
        }
    }

    private synchronized void reportProgramInformationResult() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "reportProgramInformationResult()");
        }
        this.myKeepWaiting = false;
        this.notify();
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 22, "reportProgramInformationResult()", "After notify() statement");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent.getNewValue() + "\n\tEvent name: " + propertyChangeEvent.getNewValue().getClass().getName());
        }
        if (propertyChangeEvent.getNewValue() instanceof SwAllocationPropertyChangeEvent) {
            if (!this.myQueue.contains(propertyChangeEvent.getNewValue())) {
                this.myQueue.enqueue(propertyChangeEvent.getNewValue());
            } else if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "SwAllocation event not added to queue since an event of that type already existsaPropertyChangeEvent.getNewValue(): " + propertyChangeEvent.getNewValue());
            }
        } else {
            Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of object received in a PropertyChangeEvent (ignored),\n\tReceived object: " + propertyChangeEvent.getNewValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        Object object = null;
        try {
            try {
                while (true) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "run()", "Waiting for an event object to be received");
                    }
                    object = this.myQueue.dequeue();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "run()", "Name of eventObject received: " + object.getClass().getName() + "\n\tData of eventObject received: " + object);
                    }
                    if (object instanceof CollectRequestEvent) {
                        this.handleCollectRequest(((CollectRequestEvent)object).getHighestLoadClassToBeIncluded());
                        continue;
                    }
                    if (object instanceof UpdateRequestEvent) {
                        this.handleUpdateRequest();
                        continue;
                    }
                    if (!(object instanceof SwAllocationPropertyChangeEvent)) continue;
                    this.handleUpdateRequest();
                }
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "run()", "Throwable caught (ignored).\n\ttheEventObject: " + object, throwable);
                Object var4_3 = null;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run()", "Thread is stoped!");
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run()", "Thread is stoped!");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCollectRequest(long l) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleCollectRequest(long aHighestLoadClassToBeIncluded)", "aHighestLoadClassToBeIncluded: " + l + "\n\tmyIsActive: " + this.myIsActive + "\n\tmyHighestLoadClassToBeIncluded: " + this.myHighestLoadClassToBeIncluded);
        }
        try {
            if (!this.myIsActive || this.myCV_ProgramInformation == null || this.myHighestLoadClassToBeIncluded != l || this.isFtcOaM_MPsChanged()) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "handleCollectRequest(long aHighestLoadClassToBeIncluded)", "Starts to collect program information.\n\tmyIsActive: " + this.myIsActive + "\n\taHighestLoadClassToBeIncluded: " + l + "\n\tmyHighestLoadClassToBeIncluded: " + this.myHighestLoadClassToBeIncluded);
                }
                this.myCV_ProgramInformation = this.collectProgramInformations(l);
                this.myHighestLoadClassToBeIncluded = l;
                ProgramCollector programCollector = new ProgramCollector();
                this.myPIU_MosFtc = programCollector.getFtcPiuMos();
                this.myPIU_MosOaM = programCollector.getOaM_PiuMos();
            } else if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "handleCollectRequest(long aHighestLoadClassToBeIncluded)", "Don't need to collect program information since it already has been collected.\n\tmyIsActive: " + this.myIsActive + "\n\tmyHighestLoadClassToBeIncluded: " + this.myHighestLoadClassToBeIncluded);
            }
        }
        catch (ProgramConfigurationException programConfigurationException) {
            this.myCV_ProgramInformation = null;
            this.myProgramConfigurationException = programConfigurationException;
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "handleCollectRequest()", "Throwable caught: " + throwable);
            this.myCV_ProgramInformation = null;
            this.myProgramConfigurationException = new ProgramConfigurationException(throwable.toString());
        }
        finally {
            this.reportProgramInformationResult();
        }
    }

    private void handleUpdateRequest() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUpdateRequest()");
        }
        try {
            if (this.myIsActive) {
                this.myCV_ProgramInformation = this.collectProgramInformations(this.myHighestLoadClassToBeIncluded);
                ProgramCollector programCollector = new ProgramCollector();
                this.myPIU_MosFtc = programCollector.getFtcPiuMos();
                this.myPIU_MosOaM = programCollector.getOaM_PiuMos();
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "handleUpdateRequest()", "A refresh is requested for the program information\n\tmyHighestLoadClassToBeIncluded: " + this.myHighestLoadClassToBeIncluded);
                    this.printProgramInformationFor(this.myCV_ProgramInformation.getFTC_OaM_PiuTypeLoadModuleRefInformations());
                }
            }
        }
        catch (ProgramConfigurationException programConfigurationException) {
            this.myCV_ProgramInformation = null;
            this.myProgramConfigurationException = programConfigurationException;
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "handleUpdateRequest()", "Throwable caught: " + throwable);
            this.myCV_ProgramInformation = null;
            this.myProgramConfigurationException = new ProgramConfigurationException(throwable.toString());
        }
    }

    public boolean isActive() {
        return this.myIsActive;
    }

    private boolean isFtcOaM_MPsChanged() throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isFtcOaM_MPsChanged()");
        }
        ProgramCollector programCollector = new ProgramCollector();
        Collection collection = programCollector.getFtcPiuMos();
        Collection collection2 = programCollector.getOaM_PiuMos();
        if (collection.size() != this.myPIU_MosFtc.size()) {
            return true;
        }
        if (collection2.size() != this.myPIU_MosOaM.size()) {
            return true;
        }
        Iterator iterator = collection.iterator();
        PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
        while (iterator.hasNext()) {
            plugInUnitMoSU_Access = (PlugInUnitMoSU_Access)iterator.next();
            if (this.myPIU_MosFtc.contains(plugInUnitMoSU_Access)) continue;
            return true;
        }
        Iterator iterator2 = collection2.iterator();
        while (iterator2.hasNext()) {
            plugInUnitMoSU_Access = (PlugInUnitMoSU_Access)iterator2.next();
            if (this.myPIU_MosOaM.contains(plugInUnitMoSU_Access)) continue;
            return true;
        }
        return false;
    }

    private CV_ProgramInformation collectProgramInformations(long l) throws ProgramConfigurationException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectProgramInformations(long aHighestLoadClassToBeIncluded)", "aHighestLoadClassToBeIncluded: " + l);
        }
        CV_ProgramInformation cV_ProgramInformation = null;
        if (l > 0L) {
            ProgramCollector programCollector = new ProgramCollector();
            LinkedList linkedList = programCollector.collectFTC_OaM_PiuTypeLoadModuleRefInformatios();
            Thread.yield();
            linkedList = programCollector.filterLMsWithHigherLoadClassThan(linkedList, l);
            Thread.yield();
            linkedList = programCollector.sortLoadLists(linkedList);
            Thread.yield();
            linkedList = this.filterPositionsWithNoLoadLists(linkedList);
            Thread.yield();
            Iterator iterator = linkedList.iterator();
            FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation = null;
            HashMap hashMap = null;
            LinkedList<RepertoirePositionData> linkedList2 = new LinkedList<RepertoirePositionData>();
            while (iterator.hasNext()) {
                fTC_OaM_PiuTypeLoadModuleRefInformation = (FTC_OaM_PiuTypeLoadModuleRefInformation)iterator.next();
                hashMap = fTC_OaM_PiuTypeLoadModuleRefInformation.getPiuTypesAndLmRefs();
                linkedList2.add(new RepertoirePositionData(fTC_OaM_PiuTypeLoadModuleRefInformation.getSmn(), fTC_OaM_PiuTypeLoadModuleRefInformation.getApn(), hashMap.size()));
            }
            cV_ProgramInformation = new CV_ProgramInformation(linkedList, linkedList2);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "collectProgramInformations(long aHighestLoadClassToBeIncluded)", "RETURNS - CV_ProgramInformation: " + cV_ProgramInformation);
            }
        }
        return cV_ProgramInformation;
    }

    private LinkedList filterPositionsWithNoLoadLists(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterPositionsWithNoLoadLists(Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "aFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection);
        }
        Iterator iterator = collection.iterator();
        LinkedList<FTC_OaM_PiuTypeLoadModuleRefInformation> linkedList = new LinkedList<FTC_OaM_PiuTypeLoadModuleRefInformation>();
        FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation = null;
        while (iterator.hasNext()) {
            fTC_OaM_PiuTypeLoadModuleRefInformation = (FTC_OaM_PiuTypeLoadModuleRefInformation)iterator.next();
            if (fTC_OaM_PiuTypeLoadModuleRefInformation.getPiuTypesAndLmRefs().size() <= 0) continue;
            linkedList.add(fTC_OaM_PiuTypeLoadModuleRefInformation);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "filterPositionsWithNoLoadLists(Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "RETURNS - aFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection);
        }
        return linkedList;
    }

    private void printProgramInformationFor(Collection collection) {
        try {
            Iterator iterator = collection.iterator();
            FTC_OaM_PiuTypeLoadModuleRefInformation fTC_OaM_PiuTypeLoadModuleRefInformation = null;
            Collection collection2 = null;
            Collection collection3 = null;
            Collection collection4 = null;
            while (iterator.hasNext()) {
                fTC_OaM_PiuTypeLoadModuleRefInformation = (FTC_OaM_PiuTypeLoadModuleRefInformation)iterator.next();
                collection2 = this.getRepertoireNames(fTC_OaM_PiuTypeLoadModuleRefInformation.getRepertoireMos());
                collection3 = this.getPiuTypesProdNoRevs(fTC_OaM_PiuTypeLoadModuleRefInformation.getPiuTypeInformations());
                collection4 = this.getLoadModulesProdNoRevs(fTC_OaM_PiuTypeLoadModuleRefInformation.getLoadModuleRefs());
                if (!Trace.valid(this.getClass(), 40)) continue;
                Trace.debug(this.getClass(), 40, "printProgramInformationFor(Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "SMN: " + fTC_OaM_PiuTypeLoadModuleRefInformation.getSmn() + " APN: " + fTC_OaM_PiuTypeLoadModuleRefInformation.getApn() + " Repertoire names: " + new TreeSet(collection2) + " Piu types prod no revs: " + new TreeSet(collection3) + " Load modules prod no revs: " + new TreeSet(collection4));
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "printProgramInformationFor(Collection aFTC_OaM_PiuTypeLoadModuleRefInformations)", "Throwable caughtaFTC_OaM_PiuTypeLoadModuleRefInformations: " + collection, throwable);
        }
    }

    public Collection getRepertoireNames(Collection collection) throws ProgramConfigurationException {
        try {
            Iterator iterator = collection.iterator();
            RepertoireMoSU_Access repertoireMoSU_Access = null;
            LinkedList<String> linkedList = new LinkedList<String>();
            while (iterator.hasNext()) {
                repertoireMoSU_Access = (RepertoireMoSU_Access)iterator.next();
                linkedList.add(repertoireMoSU_Access.getName(null));
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            throw new ProgramConfigurationException(throwable.toString());
        }
    }

    public Collection getPiuTypesProdNoRevs(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuTypesProdNoRevs(Collection aPiuTypeInformations)", "aPiuTypeInformations: " + collection);
        }
        Iterator iterator = collection.iterator();
        PiuTypeInformations piuTypeInformations = null;
        PiuTypeInformation piuTypeInformation = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            piuTypeInformations = (PiuTypeInformations)iterator.next();
            Iterator iterator2 = piuTypeInformations.getPiuTypeInformation().iterator();
            while (iterator2.hasNext()) {
                piuTypeInformation = (PiuTypeInformation)iterator2.next();
                linkedList.add(piuTypeInformation.getProductNumber() + "_" + piuTypeInformation.getProductRevision());
            }
        }
        return linkedList;
    }

    public Collection getLoadModulesProdNoRevs(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesProdNoRevs(Collection aLoadModuleRefs)", "aLoadModuleRefs: " + collection);
        }
        Iterator iterator = collection.iterator();
        LoadModuleRefInformation loadModuleRefInformation = null;
        LinkedList linkedList = null;
        LinkedList<String> linkedList2 = new LinkedList<String>();
        while (iterator.hasNext()) {
            linkedList = (LinkedList)iterator.next();
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                loadModuleRefInformation = (LoadModuleRefInformation)iterator2.next();
                linkedList2.add(loadModuleRefInformation.getProductNumber() + "_" + loadModuleRefInformation.getProductRevision());
            }
        }
        return linkedList2;
    }
}

