/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.ipnetworkdata.create;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import se.ericsson.cello.configurationversion.file.base.CreateFileInformation;
import se.ericsson.cello.configurationversion.file.ipnetworkdata.proxy.IP_NetworkDataProxy;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.handler.NodeIP_DataHandler;
import se.ericsson.cello.configurationversion.util.handler.NodeIP_DataHandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.ethernetlink.EthernetLinkMO_handlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.ip.IpMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.ip.IpMO_HandlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.iphostlink.IpHostLinkMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.iphostlink.IpHostLinkMO_HandlerInterface;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class IP_NetworkDataFileCreator {
    public static final String defaultVersion = "3";

    public IP_NetworkDataFileCreator() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "IP_NetworkDataFileCreator()");
        }
    }

    public CreateFileInformation createFile(String string, String string2, boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createFile(String aVersion, String aDirPath, boolean anIsVersion3_Supported)", "aVersion: " + string + "\n\taDirPath:" + string2 + "\n\tanIsVersion3_Supported: " + bl);
        }
        return this.createFile(string, string2, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CreateFileInformation createFile(String string, String string2, boolean bl, boolean bl2) throws ConfigurationVersionException {
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createFile(String aVersion, String aDirPath, boolean anIsVersion3_Supported, boolean anIsFileToBeCreated)", "aVersion: " + string + "\n\taDirPath:" + string2 + "\n\tanIsVersion3_Supported: " + bl);
        }
        PrintStream printStream = null;
        try {
            try {
                IP_NetworkDataProxy iP_NetworkDataProxy = this.createDom(string);
                CreateFileInformation createFileInformation = null;
                if (bl && !bl2) {
                    object = new ByteArrayOutputStream();
                    printStream = new PrintStream((OutputStream)object);
                    iP_NetworkDataProxy.print(printStream);
                    createFileInformation = new CreateFileInformation(BackupRestoreDataHandler.instance().getCurrentFileName(), ((ByteArrayOutputStream)object).toString());
                } else {
                    object = new File(string2 + BackupRestoreDataHandler.instance().getCurrentFileName());
                    printStream = new PrintStream(new FileOutputStream((File)object));
                    iP_NetworkDataProxy.print(printStream);
                    createFileInformation = new CreateFileInformation(((File)object).getAbsolutePath());
                }
                object = createFileInformation;
                Object var10_11 = null;
                if (printStream == null) return object;
            }
            catch (ConfigurationVersionException configurationVersionException) {
                Trace.info(this.getClass(), "createFile(String aVersion, String aDirPath, boolean anIsVersion3_Supported, boolean anIsFileToBeCreated)", "aVersion: " + string + "\n\taDirPath: " + string2 + "\n\tanIsVersion3_Supported: " + bl + "\n\tFailed to create the file: " + BackupRestoreDataHandler.instance().getCurrentFileName() + "." + "\n\tIt will not be possible to use this CV for backup/restore.");
                throw configurationVersionException;
            }
            catch (Throwable throwable) {
                Trace.warning(this.getClass(), "createFile(String aVersion, String aDirPath, boolean anIsVersion3_Supported, boolean anIsFileToBeCreated)", "aVersion: " + string + "\n\taDirPath: " + string2 + "\n\tanIsVersion3_Supported: " + bl + "\n\tThrowable caught." + "\n\tFailed to create the file: " + BackupRestoreDataHandler.instance().getCurrentFileName() + "." + "\n\tIt will not be possible to use this CV for backup/restore." + "Exception info: " + throwable);
                throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tcreateFile(String aVersion, String aDirPath, boolean anIsVersion3_Supported, boolean anIsFileToBeCreated)" + "\n\tThrowable caught." + "\n\tThrowable: " + throwable);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (printStream == null) throw throwable;
            try {
                printStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                Trace.error(this.getClass(), "createFile(String aVersion, String aDirPath, boolean anIsVersion3_Supported, boolean anIsFileToBeCreated)", "aVersion: " + string + "\n\taDirPath: " + string2 + "\n\tanIsVersion3_Supported: " + bl + "\n\tAn error occured when trying to close the handle to the IP network configuration file. " + "\n\tThrowable data: " + throwable2.toString(), throwable2);
                throw throwable;
            }
        }
        try {}
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createFile(String aVersion, String aDirPath, boolean anIsVersion3_Supported, boolean anIsFileToBeCreated)", "aVersion: " + string + "\n\taDirPath: " + string2 + "\n\tanIsVersion3_Supported: " + bl + "\n\tAn error occured when trying to close the handle to the IP network configuration file. " + "\n\tThrowable data: " + throwable.toString(), throwable);
            return object;
        }
        printStream.close();
        return object;
    }

    public IP_NetworkDataProxy createDom() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createDom( )");
        }
        return this.createDom(defaultVersion);
    }

    public IP_NetworkDataProxy createDom(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createDom(String aVersion)", "aVersion: " + string);
        }
        try {
            NodeIP_DataHandler nodeIP_DataHandler = new NodeIP_DataHandler();
            String string2 = nodeIP_DataHandler.getIP_Address();
            String string3 = nodeIP_DataHandler.getSubnetMask();
            String string4 = nodeIP_DataHandler.getNodeNextHopIP_Address();
            String string5 = nodeIP_DataHandler.getBroadcastAddress();
            String string6 = nodeIP_DataHandler.getNodeInterfaceName();
            String string7 = nodeIP_DataHandler.getNodeIpv6InterfaceName();
            String string8 = nodeIP_DataHandler.getNodeIpv6Address();
            IP_NetworkDataProxy iP_NetworkDataProxy = new IP_NetworkDataProxy(new Integer(string));
            iP_NetworkDataProxy.setIP_Address(string2);
            iP_NetworkDataProxy.setSubnetMask(string3);
            iP_NetworkDataProxy.setOaM_Cable(this.getIsOaM_CableConfigured());
            iP_NetworkDataProxy.setBroadcastAddress(string5);
            iP_NetworkDataProxy.setNextHopIP_Address(string4);
            iP_NetworkDataProxy.setNodeInterfaceName(string6);
            iP_NetworkDataProxy.setNodeIpv6Address(string8);
            iP_NetworkDataProxy.setNodeIpv6InterfaceName(string7);
            return iP_NetworkDataProxy;
        }
        catch (NodeIP_DataHandlerException nodeIP_DataHandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createDom(String aVersion)", "\n\taVersion: " + string + "\n\tFailed to build up the DOM structure." + "\n\tNodeIP_DataHandlerException: " + (Object)((Object)nodeIP_DataHandlerException));
            }
            throw new ConfigurationVersionException(nodeIP_DataHandlerException.toString());
        }
        catch (ConfigurationVersionException configurationVersionException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createDom(String aVersion)", "ConfigurationVersionException caught.\n\taVersion: " + string + "\n\tFailed to build up the DOM structure." + "\n\tConfigurationVersionException info: " + (Object)((Object)configurationVersionException));
            }
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createDom(String aVersion)", "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tcreateDom(String aVersion)" + "\n\taVersion: " + string + "\n\tFailed to build up the DOM structure." + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private boolean getIsOaM_CableConfigured() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIsOaM_CableConfigured()");
        }
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            IpHostLinkMO_HandlerInterface ipHostLinkMO_HandlerInterface = ServiceFinder.getIpHostLinkMO_HandlerInterface();
            EthernetLinkMO_handlerInterface ethernetLinkMO_handlerInterface = ServiceFinder.getEthernetLinkMO_handlerInterface();
            boolean bl = false;
            if (ethernetLinkMO_handlerInterface.existsEthernetLinkMo() && ipHostLinkMO_HandlerInterface.existsIpHostLinkMo()) {
                String string = ipMO_HandlerInterface.getNodeInterfaceName();
                String string2 = ethernetLinkMO_handlerInterface.getInterfaceName();
                String string3 = ipHostLinkMO_HandlerInterface.getInterfaceName();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getIsOaM_CableConfigured()", "theNodeInterfaceName: " + string + "\n\ttheEthernetLinkMO_InterfaceName: " + string2 + "\n\ttheIpHostLinkInterfaceName: " + string3);
                }
                if (string != null) {
                    if (string.equals(string2)) {
                        bl = true;
                    } else if (string.equals(string2)) {
                        bl = false;
                    } else if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "getIsOaM_CableConfigured()", "Unexpected.. The configured NodeInterfaceName should match any of the two values configured in\n\tthe EthernetLinkMo or IpHostLinkMo.\n\tAssuming that OaM cable is used.");
                    }
                }
            } else if (ethernetLinkMO_handlerInterface.existsEthernetLinkMo() && !ipHostLinkMO_HandlerInterface.existsIpHostLinkMo()) {
                bl = true;
            } else if (!ethernetLinkMO_handlerInterface.existsEthernetLinkMo() && ipHostLinkMO_HandlerInterface.existsIpHostLinkMo()) {
                bl = false;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getIsOaM_CableConfigured()", "RETURNS - " + bl);
            }
            return bl;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            Trace.warning(this.getClass(), "getIsOaM_CableConfigured()", "ConfigurationVersionException caught.\n\tConfigurationVersionException info: " + (Object)((Object)configurationVersionException));
            throw configurationVersionException;
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw new ConfigurationVersionException(ipMO_HandlerException.toString());
        }
        catch (IpHostLinkMO_HandlerException ipHostLinkMO_HandlerException) {
            throw new ConfigurationVersionException(ipHostLinkMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getIsOaM_CableConfigured()", "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetIsOaM_CableConfigured()" + "\n\tThrowable: " + throwable);
        }
    }
}

