/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.service;

import se.ericsson.cello.configurationversion.service.ServiceTypeInformation;
import se.ericsson.cello.equipment.eqaccess.ServiceControllerAccess;
import se.ericsson.cello.equipment.eqaccess.UpgradeBackupServiceInformation;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceStatusInformationEvent;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceType;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.piutypesupervisor.PiuTypeInstallStateSupervisor;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class ServiceController
implements ServiceControllerAccess {
    private static ServiceController myInstance = null;
    private ServiceType myExecutingServiceType = ServiceType.None;
    private ServiceSubType myExecutingServiceSubType = ServiceSubType.none;

    private ServiceController() {
        myInstance = this;
    }

    public static synchronized ServiceController instance() {
        if (myInstance == null) {
            new ServiceController();
        }
        return myInstance;
    }

    public synchronized boolean busyMark(ServiceType serviceType, ServiceSubType serviceSubType) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark(ServiceType aServiceType, ServiceSubType aServiceSubType)", "aServiceType: " + serviceType + "aServiceSubType: " + serviceSubType);
        }
        boolean bl = false;
        PiuTypeInstallStateSupervisor piuTypeInstallStateSupervisor = (PiuTypeInstallStateSupervisor)ServiceLocatorFacade.getRepository().getService(PiuTypeInstallStateSupervisor.class);
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "busyMark(ServiceType aServiceType, ServiceSubType aServiceSubType)", "thePiuTypeInstallStateSupervisor: " + piuTypeInstallStateSupervisor);
        }
        if (this.myExecutingServiceType.getValue().equals(ServiceType.None.getValue()) && piuTypeInstallStateSupervisor.isIdle()) {
            this.myExecutingServiceType = serviceType;
            this.myExecutingServiceSubType = serviceSubType;
            bl = true;
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ServiceStatus, new ServiceStatusInformationEvent(this, this.myExecutingServiceType, this.myExecutingServiceSubType, bl));
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "busyMark(ServiceType aServiceType, ServiceSubType aServiceSubType)", "A service is already in execution.\n\tmyExecutingServiceType: " + this.myExecutingServiceType + "\n\tmyExecutingServiceSubType: " + this.myExecutingServiceSubType + "\n\tthePiuTypeInstallStateSupervisor state: " + piuTypeInstallStateSupervisor.isIdle());
        }
        return bl;
    }

    public synchronized ServiceType getExecutingServiceType() {
        return this.myExecutingServiceType;
    }

    public synchronized ServiceTypeInformation getExecutingServiceTypeInformation() {
        return new ServiceTypeInformation(this.myExecutingServiceType, this.myExecutingServiceSubType);
    }

    public boolean isAnyUpgradeBackupServiceInExecution() {
        boolean bl = false;
        if (this.isBusy() && (this.myExecutingServiceSubType.getValue().equals(ServiceSubType.install.getValue()) || this.myExecutingServiceSubType.getValue().equals(ServiceSubType.restore.getValue()) || this.myExecutingServiceSubType.getValue().equals(ServiceSubType.update.getValue()) || this.myExecutingServiceSubType.getValue().equals(ServiceSubType.upgrade.getValue()) || this.myExecutingServiceSubType.getValue().equals(ServiceSubType.verifyUpgrade.getValue()))) {
            bl = true;
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "isAnyUpgradeBackupServiceInExecution()", "RETURNS - theIsBusy: " + bl);
        }
        return bl;
    }

    public UpgradeBackupServiceInformation getExecutingUpgradeBackupServiceInformation() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getExecutingUpgradeBackupServiceInformation()");
        }
        boolean bl = this.isAnyUpgradeBackupServiceInExecution();
        return new UpgradeBackupServiceInformation(bl, this.myExecutingServiceType.getValue(), this.myExecutingServiceSubType.getValue());
    }

    public synchronized boolean freeMark(ServiceType serviceType, ServiceSubType serviceSubType) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "freeMark(ServiceType aServiceType, ServiceSubType aServiceSubType)", "aServiceType: " + serviceType + "\n\taServiceSubType: " + serviceSubType);
        }
        boolean bl = true;
        if (this.myExecutingServiceType.getValue().equals(serviceType.getValue()) && this.myExecutingServiceSubType.getValue().equals(serviceSubType.getValue())) {
            ServiceType serviceType2 = this.myExecutingServiceType;
            ServiceSubType serviceSubType2 = this.myExecutingServiceSubType;
            this.myExecutingServiceType = ServiceType.None;
            this.myExecutingServiceSubType = ServiceSubType.none;
            bl = false;
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ServiceStatus, new ServiceStatusInformationEvent(this, serviceType2, serviceSubType2, bl));
        } else if (!this.myExecutingServiceType.getValue().equals(ServiceType.None.getValue())) {
            Trace.error(this.getClass(), "freeMark(ServiceType aServiceType, ServiceSubType aServiceSubType)", "The service that is requested to be free marked is not the one that is in execution!.myExecutingServiceType: " + this.myExecutingServiceType + "\n\tmyExecutingServiceSubType: " + this.myExecutingServiceSubType + "\n\taServiceType: " + serviceType + "\n\taServiceSubType: " + serviceSubType);
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "freeMark(ServiceType aServiceType, ServiceSubType aServiceSubType)", "The service that is requested to be free marked is not in execution!!! (ignoring this free mark request).\n\tExecutingServiceType: " + this.myExecutingServiceType + "\n\tExecutingServiceSubType: " + this.myExecutingServiceSubType + "\n\tService requested to be free marked: " + serviceType + "\n\tSubService requested to be free marked: " + serviceSubType);
        }
        return true;
    }

    public synchronized void swapTo(ServiceType serviceType, ServiceSubType serviceSubType) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "swapTo(ServiceType aServiceType, ServiceSubType aServiceSubType)", "aServiceType: " + serviceType + "\n\taServiceSubType: " + serviceSubType);
        }
        this.myExecutingServiceType = serviceType;
        this.myExecutingServiceSubType = serviceSubType;
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ServiceStatus, new ServiceStatusInformationEvent(this, this.myExecutingServiceType, this.myExecutingServiceSubType, true));
    }

    public synchronized void freeMarkHard() {
        if (Trace.valid(this.getClass(), 4)) {
            Trace.debug("freeMarkHard()");
        }
        this.myExecutingServiceType = ServiceType.None;
        this.myExecutingServiceSubType = ServiceSubType.none;
    }

    public synchronized boolean isBusy() {
        return this.myExecutingServiceType != ServiceType.None;
    }

    public synchronized boolean isIdle() {
        PiuTypeInstallStateSupervisor piuTypeInstallStateSupervisor = (PiuTypeInstallStateSupervisor)ServiceLocatorFacade.getRepository().getService(PiuTypeInstallStateSupervisor.class);
        return this.myExecutingServiceType.getValue().equals(ServiceType.None.getValue()) && piuTypeInstallStateSupervisor.isIdle();
    }
}

