/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.su.convert.attribute;

import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.su.convert.attribute.BooleanConverterAttribute;
import se.ericsson.cello.su.convert.attribute.ConverterAttributeType;
import se.ericsson.cello.su.convert.attribute.FloatConverterAttribute;
import se.ericsson.cello.su.convert.attribute.IntegerConverterAttribute;
import se.ericsson.cello.su.convert.attribute.LongConverterAttribute;
import se.ericsson.cello.su.convert.attribute.ReferenceConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StringConverterAttribute;
import se.ericsson.cello.su.convert.attribute.StructConverterAttribute;
import se.ericsson.cello.su.convert.base.ConverterAttributeBase;
import se.ericsson.cello.su.convert.exception.ConverterAttributeException;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class SequenceConverterAttribute
extends ConverterAttributeBase {
    private LinkedList myValues = new LinkedList();

    public SequenceConverterAttribute(String string) {
        super(ConverterAttributeType.SEQUENCE, string);
    }

    public SequenceConverterAttribute(String string, Boolean bl) {
        super(ConverterAttributeType.SEQUENCE, string, bl);
    }

    public SequenceConverterAttribute(String string, LinkedList linkedList, Boolean bl) {
        super(ConverterAttributeType.SEQUENCE, string, bl);
        this.myValues = linkedList;
    }

    public SequenceConverterAttribute(SequenceAttribute sequenceAttribute) throws ConverterAttributeException {
        super(ConverterAttributeType.SEQUENCE, sequenceAttribute.getName(), sequenceAttribute.isAVCNotifier());
        Attribute[] attributeArray = sequenceAttribute.getValue(null);
        for (int i = 0; i < attributeArray.length; ++i) {
            this.myValues.add(this.getConverterAttribute(attributeArray[i]));
        }
    }

    public LinkedList getPreviousValues(String string) throws ConverterAttributeException {
        LinkedList linkedList = this.myValues;
        if (string != null) {
            if (!this.myPreviousValues.containsKey(string)) {
                Trace.error(this.getClass(), "getPreviousValueAsString(String aMoLdn)", "Failed to get a previous value for MoLdn: " + string);
                throw new ConverterAttributeException("Failed to get a previous value for MoLdn: " + string);
            }
            linkedList = (LinkedList)this.myPreviousValues.get(string);
        }
        return linkedList;
    }

    public Attribute getPersistentAttribute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPersistentAttribute()");
        }
        SequenceAttribute sequenceAttribute = new SequenceAttribute(this.myName, this.myIsAVC_Notifier.booleanValue());
        ConverterAttributeBase converterAttributeBase = null;
        Iterator iterator = this.myValues.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            converterAttributeBase = (ConverterAttributeBase)e;
            sequenceAttribute.addElement(converterAttributeBase.getPersistentAttribute());
        }
        return sequenceAttribute;
    }

    public LinkedList getValues() {
        return this.myValues;
    }

    public String getValueAsString() {
        return "";
    }

    private ConverterAttributeBase getConverterAttribute(Attribute attribute) throws ConverterAttributeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getConverterAttribute(Attribute anAttribute)", "anAttribute: " + attribute);
        }
        ConverterAttributeBase converterAttributeBase = null;
        if (attribute instanceof BooleanAttribute) {
            converterAttributeBase = new BooleanConverterAttribute((BooleanAttribute)attribute);
        } else if (attribute instanceof FloatAttribute) {
            converterAttributeBase = new FloatConverterAttribute((FloatAttribute)attribute);
        } else if (attribute instanceof IntegerAttribute) {
            converterAttributeBase = new IntegerConverterAttribute((IntegerAttribute)attribute);
        } else if (attribute instanceof LongAttribute) {
            converterAttributeBase = new LongConverterAttribute((LongAttribute)attribute);
        } else if (attribute instanceof ReferenceAttribute) {
            converterAttributeBase = new ReferenceConverterAttribute((ReferenceAttribute)attribute);
        } else if (attribute instanceof SequenceAttribute) {
            converterAttributeBase = new SequenceConverterAttribute((SequenceAttribute)attribute);
        } else if (attribute instanceof StringAttribute) {
            converterAttributeBase = new StringConverterAttribute((StringAttribute)attribute);
        } else if (attribute instanceof StructAttribute) {
            converterAttributeBase = new StructConverterAttribute((StructAttribute)attribute);
        } else {
            Trace.error(this.getClass(), "getConverterAttribute(Attribute anAttribute)", "Unknown attribute type received in sequence.\n\tSequence attribute name: " + this.myName + "\n\ttheAttribute: " + attribute);
            throw new ConverterAttributeException("Unknown attribute type received in sequence. SequenceAttributeName: " + this.myName);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getConverterAttribute(Attribute anAttribute)", "Returning - theConverterAttribute: " + converterAttributeBase);
        }
        return converterAttributeBase;
    }

    public void addPreviousValue(String string, Attribute attribute) throws ConverterAttributeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addPreviousValue(String aMoLdn, Attribute theAttribute)", "aMoLdn: " + string + "\n\ttheAttribute: " + attribute);
        }
        this.myPreviousName = attribute.getName();
        this.myPreviousIsAVC_Notifier = attribute.isAVCNotifier();
        LinkedList<ConverterAttributeBase> linkedList = new LinkedList<ConverterAttributeBase>();
        Attribute[] attributeArray = ((SequenceAttribute)attribute).getValue(null);
        for (int i = 0; i < attributeArray.length; ++i) {
            linkedList.add(this.getConverterAttribute(attributeArray[i]));
        }
        this.myPreviousValues.put(string, linkedList);
    }

    public String getPreviousValueAsString(String string) {
        return null;
    }

    public String toString() {
        return super.toString() + "\n\tValue: " + this.myValues + "\n\tPreviousValues: " + this.myPreviousValues;
    }
}

