/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence;

import java.util.Collection;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.SupportedUpgradeTypesStatusDataName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.SequenceInformationException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SequenceInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SupportedSequenceInformation;

public class ValidSequencesInformation {
    private SupportedSequenceInformation myRebootNodeUpgradeSupportedSequenceInformation = null;
    private SupportedSequenceInformation myUpgradeSupportedSequenceInformation = null;
    private SupportedSequenceInformation myUpdateSupportedSequenceInformation = null;

    public ValidSequencesInformation() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ValidSequencesInformation()");
        }
        this.myRebootNodeUpgradeSupportedSequenceInformation = new SupportedSequenceInformation();
        this.myUpgradeSupportedSequenceInformation = new SupportedSequenceInformation();
        this.myUpdateSupportedSequenceInformation = new SupportedSequenceInformation();
    }

    public ValidSequencesInformation(SupportedSequenceInformation supportedSequenceInformation, SupportedSequenceInformation supportedSequenceInformation2, SupportedSequenceInformation supportedSequenceInformation3) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ValidSequencesInformation(SupportedSequenceInformation aRebootNodeUpgradeSupportedSequenceInformation, SupportedSequenceInformation anUpgradeSupportedSequenceInformation, SupportedSequenceInformation anUpdateSupportedSequenceInformation)", (String)("aRebootNodeUpgradeSupportedSequenceInformation: " + supportedSequenceInformation + "\n\tanUpgradeSupportedSequenceInformation: " + supportedSequenceInformation2 + "\n\tanUpdateSupportedSequenceInformation: " + supportedSequenceInformation3));
        }
        this.myRebootNodeUpgradeSupportedSequenceInformation = supportedSequenceInformation;
        this.myUpgradeSupportedSequenceInformation = supportedSequenceInformation2;
        this.myUpdateSupportedSequenceInformation = supportedSequenceInformation3;
    }

    public SupportedSequenceInformation getSupportedSequenceInformation(TypeOfUpgrade typeOfUpgrade) throws SequenceInformationException {
        if (TypeOfUpgrade.RebootNodeUpgrade.getValue().equals(typeOfUpgrade.getValue())) {
            return this.myRebootNodeUpgradeSupportedSequenceInformation;
        }
        if (TypeOfUpgrade.Upgrade.getValue().equals(typeOfUpgrade.getValue())) {
            return this.myUpgradeSupportedSequenceInformation;
        }
        if (TypeOfUpgrade.Update.getValue().equals(typeOfUpgrade.getValue())) {
            return this.myUpdateSupportedSequenceInformation;
        }
        UpgradeTrace.error(this.getClass(), (String)"getSequenceInformation(TypeOfUpgrade aTypeOfUpgrade)", (String)("Unexpected type of upgrade received (no sequence is found for this one...)\n\taTypeOfUpgrade: " + typeOfUpgrade));
        throw new SequenceInformationException("getSequenceInformation(TypeOfUpgrade aTypeOfUpgrade)Unexpected type of upgrade received (no sequence is found for this one...)\n\taTypeOfUpgrade: " + typeOfUpgrade);
    }

    public Vector getAllFirstSupportedSequenceInformationLabels() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getAllFirstSupportedSequenceInformationLabels( )");
        }
        Vector vector = new Vector();
        vector = this.addSequenceLabel(this.myRebootNodeUpgradeSupportedSequenceInformation, vector);
        vector = this.addSequenceLabel(this.myUpgradeSupportedSequenceInformation, vector);
        vector = this.addSequenceLabel(this.myUpdateSupportedSequenceInformation, vector);
        return vector;
    }

    public Collection getAllFirstSupportedSequenceInformations(boolean bl) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getAllFirstSupportedSequenceInformations(boolean anIncludeUpdate)", (String)("anIncludeUpdate: " + bl));
        }
        Vector<SequenceInformation> vector = new Vector<SequenceInformation>();
        SequenceInformation sequenceInformation = null;
        if (this.myRebootNodeUpgradeSupportedSequenceInformation != null && (sequenceInformation = this.myRebootNodeUpgradeSupportedSequenceInformation.getFirstSequenceInformation()) != null) {
            vector.add(sequenceInformation);
        }
        if (this.myUpgradeSupportedSequenceInformation != null && (sequenceInformation = this.myUpgradeSupportedSequenceInformation.getFirstSequenceInformation()) != null) {
            vector.add(sequenceInformation);
        }
        if (bl && this.myUpdateSupportedSequenceInformation != null && (sequenceInformation = this.myUpdateSupportedSequenceInformation.getFirstSequenceInformation()) != null) {
            vector.add(sequenceInformation);
        }
        return vector;
    }

    public boolean isAnyUpgradeVariantSupported() {
        return this.isSupported(TypeOfUpgrade.RebootNodeUpgrade) || this.isSupported(TypeOfUpgrade.Upgrade) || this.isSupported(TypeOfUpgrade.Update);
    }

    public boolean isSupported(TypeOfUpgrade typeOfUpgrade) {
        try {
            return this.getSupportedSequenceInformation(typeOfUpgrade).isSupported();
        }
        catch (SequenceInformationException sequenceInformationException) {
            return false;
        }
    }

    public String toString() {
        return "\n\tmyRebootNodeUpgradeSupportedSequenceInformation: " + this.myRebootNodeUpgradeSupportedSequenceInformation + "\n\tmyUpgradeSupportedSequenceInformation: " + this.myUpgradeSupportedSequenceInformation + "\n\tmyUpdateSupportedSequenceInformation: " + this.myUpdateSupportedSequenceInformation;
    }

    public Struct toStruct() {
        StructAttribute structAttribute = new StructAttribute(SupportedUpgradeTypesStatusDataName.SupportedUpgradeTypesStatus.getValue(), false);
        BooleanAttribute booleanAttribute = new BooleanAttribute(SupportedUpgradeTypesStatusDataName.RebootNodeUpgrade.getValue(), false, this.isSupported(TypeOfUpgrade.RebootNodeUpgrade));
        structAttribute.addElement((Attribute)booleanAttribute);
        BooleanAttribute booleanAttribute2 = new BooleanAttribute(SupportedUpgradeTypesStatusDataName.Update.getValue(), false, this.isSupported(TypeOfUpgrade.Update));
        structAttribute.addElement((Attribute)booleanAttribute2);
        BooleanAttribute booleanAttribute3 = new BooleanAttribute(SupportedUpgradeTypesStatusDataName.Upgrade.getValue(), false, this.isSupported(TypeOfUpgrade.Upgrade));
        structAttribute.addElement((Attribute)booleanAttribute3);
        return structAttribute.getValue(null);
    }

    private Vector addSequenceLabel(SupportedSequenceInformation supportedSequenceInformation, Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"addSequenceLabel(SupportedSequenceInformation aSupportedSequenceInformation, Vector aVector)", (String)("aSupportedSequenceInformation: " + supportedSequenceInformation + "\n\taVector: " + vector));
        }
        SequenceInformation sequenceInformation = null;
        if (supportedSequenceInformation != null && (sequenceInformation = supportedSequenceInformation.getFirstSequenceInformation()) != null) {
            vector.add(sequenceInformation.label);
        }
        return vector;
    }
}

