/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser;

import java.io.File;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.MainElementHolder;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectController;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;

public class ControlFileDocumentHandler
implements DocumentHandler {
    private File myControlFileHandle = null;
    private MainElementHolder myMainElementHolder = null;
    private boolean myValidationNeeded = false;
    private Locator myLocator = null;
    private DocumentObjectController myDocumentObjectController = null;

    public ControlFileDocumentHandler(File file, MainElementHolder mainElementHolder, boolean bl) {
        String string = null;
        if (file != null) {
            string = file.getAbsolutePath();
        }
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"ControlFileDocumentHandler(File anHandleToControlFile, MainElementHolder aNameOfMainElementsToBeParsed, boolean aValidationNeeded)", (String)("anHandleToControlFile (path): " + string));
        }
        this.myControlFileHandle = file;
        this.myMainElementHolder = mainElementHolder;
        this.myValidationNeeded = bl;
    }

    public DocumentObjectUpgradePackage getDocumentObjectForUpgradePackage() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDocumentObjectForUpgradePackage()");
        }
        if (this.myDocumentObjectController != null) {
            return this.myDocumentObjectController.getDocumentObjectForUpgradePackage();
        }
        return null;
    }

    public MainElementHolder getMainElements() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getMainElements()");
        }
        return this.myMainElementHolder;
    }

    public void setDocumentLocator(Locator locator) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDocumentLocator(Locator aLocator)", (String)("aLocator: " + LocatorProxy.getLocatorInfo(locator)));
        }
        this.myLocator = locator;
    }

    public void startDocument() throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"startDocument()");
        }
        if (this.myDocumentObjectController == null) {
            this.myDocumentObjectController = new DocumentObjectController(this, this.myValidationNeeded);
            if (UpgradeTrace.valid(this.getClass(), (int)27)) {
                UpgradeTrace.debug(this.getClass(), (int)27, (String)"startDocument()", (String)("First time the upgrade control file '" + this.myControlFileHandle.getAbsolutePath() + "' is parsed."));
            }
        } else if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"startDocument()", (String)("The upgrade control file '" + this.myControlFileHandle.getAbsolutePath() + "' is re-parsed."));
        }
        this.myDocumentObjectController.startDocument(this.myLocator);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"startElement(String anElementName, AttributeList aListOfAttributes)", (String)("anElementName: " + string + "\n\taListOfAttributes: " + attributeList));
        }
        this.myDocumentObjectController.startElement(string, attributeList, this.myLocator);
    }

    public void endElement(String string) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"endElement(String anElementName)", (String)("anElementName: " + string));
        }
        this.myDocumentObjectController.endElement(string, this.myLocator);
    }

    public void endDocument() throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"endDocument()");
        }
        this.myDocumentObjectController.endDocument(this.myLocator);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"characters(char ch[], int start, int length)", (String)("ch: " + new String(cArray) + "\n\tstart: " + n + "\n\tlength: " + n2));
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"ignorableWhitespace(char ch[], int start, int length)", (String)("ch: " + new String(cArray) + "\n\tstart: " + n + "\n\tlength: " + n2));
        }
        String string = new String(cArray);
        if (UpgradeTrace.valid(this.getClass(), (int)27)) {
            UpgradeTrace.debug(this.getClass(), (int)27, (String)"ignorableWhitespace(char ch[], int start, int length)", (String)("ch as string: " + string));
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"processingInstruction(String target, String data)", (String)("target: " + string + "\n\tdata: " + string2));
        }
    }

    public void setMainElements(MainElementHolder mainElementHolder) {
        this.myMainElementHolder = mainElementHolder;
    }

    public void cleanup() {
        this.myControlFileHandle = null;
        this.myMainElementHolder = null;
        this.myLocator = null;
        if (this.myDocumentObjectController != null) {
            this.myDocumentObjectController.cleanup();
            this.myDocumentObjectController = null;
        }
    }
}

