/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.loadmodule;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.AttributeProperty;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.UnexpectedElementReason;
import se.ericsson.cello.sudom.parser.dom.loadmodule.DynamicClass;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallLM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.InstallSM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModuleSubElementName;
import se.ericsson.cello.sudom.parser.dom.loadmodule.LoadModuleValidator;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM;
import se.ericsson.cello.sudom.parser.dom.loadmodule.Mopplet;
import se.ericsson.cello.sudom.parser.dom.productdata.ProductData;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleInformationExtended;
import se.ericsson.cello.sudom.util.datacontainer.LoadModuleInfo;

public class LoadModule
extends ParsedData
implements DocumentObjectInterface {
    private Vector myMopplet = new Vector(1);
    private MoDataLM myMoDataLM = null;
    private DynamicClass myDynamicClass = null;
    private Vector myInstallLM = new Vector(1);
    private Vector myInstallSM = new Vector(1);
    private ProductData myProductData = null;
    private static final String NO_FILESIZE = "0";
    private static final String SM_FILESIZE = "375";
    private static final String EMPTY_STRING = "";

    public LoadModule(LoadModuleInfo loadModuleInfo) {
        Iterator iterator;
        Object object;
        String string;
        if (loadModuleInfo.getProductNumber() != null) {
            this.myProductData = new ProductData(loadModuleInfo.getProductNumber(), loadModuleInfo.getRevision(), loadModuleInfo.getName(), null, null, null);
        }
        if ((string = loadModuleInfo.getLmDirectoryPath()) != null) {
            object = new InstallLM(null, loadModuleInfo.getLmDirectoryPath(), NO_FILESIZE);
            ((InstallLM)object).setDirectory("yes");
            this.myInstallLM.addElement(object);
        }
        object = null;
        String string2 = null;
        InstallLM installLM = null;
        if (!loadModuleInfo.getLmFilePaths().isEmpty() && !loadModuleInfo.getLmFileSizes().isEmpty()) {
            iterator = loadModuleInfo.getLmFilePaths().iterator();
            Iterator iterator2 = loadModuleInfo.getLmFileSizes().iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                object = (String)iterator.next();
                string2 = (String)iterator2.next();
                installLM = !((String)object).equals(EMPTY_STRING) ? new InstallLM(null, (String)object, string2) : new InstallLM(null, null, string2);
                installLM.setDirectory("no");
                this.myInstallLM.addElement(installLM);
            }
        }
        if (!loadModuleInfo.getSmFilePaths().isEmpty()) {
            iterator = loadModuleInfo.getSmFilePaths().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (string != null) {
                    this.myInstallSM.addElement(new InstallSM((String)object, SM_FILESIZE));
                    continue;
                }
                this.myInstallSM.addElement(new InstallSM(null, SM_FILESIZE));
            }
        }
    }

    public LoadModule(LoadModuleInformationExtended loadModuleInformationExtended) {
        Iterator iterator;
        Object object;
        String string;
        if (loadModuleInformationExtended.getProductNumber() != null) {
            this.myProductData = new ProductData(loadModuleInformationExtended.getProductNumber(), loadModuleInformationExtended.getProductRevision(), loadModuleInformationExtended.getProductName(), null, null, null);
        }
        if ((string = loadModuleInformationExtended.getDirectoryDestFilePath()) != null) {
            object = new InstallLM(null, string);
            ((InstallLM)object).setDirectory("yes");
            this.myInstallLM.add(object);
        }
        object = null;
        if (!loadModuleInformationExtended.getDestinationPaths().isEmpty()) {
            iterator = loadModuleInformationExtended.getDestinationPaths().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.myInstallLM.addElement(new InstallLM(null, (String)object));
            }
        }
        if (!loadModuleInformationExtended.getDestinationPathsRefs().isEmpty()) {
            iterator = loadModuleInformationExtended.getDestinationPathsRefs().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.myInstallSM.addElement(new InstallSM((String)object));
            }
        }
        if (!loadModuleInformationExtended.getEmptyDirDestFilePaths().isEmpty()) {
            iterator = loadModuleInformationExtended.getEmptyDirDestFilePaths().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                InstallLM installLM = new InstallLM(null, (String)object);
                installLM.setObsoleteEmptyDir("yes");
                this.myInstallLM.addElement(installLM);
            }
        }
    }

    public LoadModule(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"LoadModule(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = AttributeProperty.verifyNoNames(attributeList)) == null || stringArray.length > 0) {
            super.handleUnexpectedAttribute("LoadModule(AttributeList anAttributeList, Locator aLocator)", "LoadModule", stringArray, locator);
        }
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (string.equals(LoadModuleSubElementName.MoDataLM.getValue())) {
            return this.createMoDataLM(string, attributeList, locator);
        }
        if (string.equals(LoadModuleSubElementName.Mopplet.getValue())) {
            return this.createMopplet(string, attributeList, locator);
        }
        if (string.equals(LoadModuleSubElementName.ProductData.getValue())) {
            return this.createProductData(string, attributeList, locator);
        }
        if (string.equals(LoadModuleSubElementName.InstallLM.getValue())) {
            return this.createInstallLM(string, attributeList, locator);
        }
        if (string.equals(LoadModuleSubElementName.InstallSM.getValue())) {
            return this.createInstallSM(string, attributeList, locator);
        }
        if (string.equals(LoadModuleSubElementName.DynamicClass.getValue())) {
            return this.createDynamicClass(string, attributeList, locator);
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", "LoadModule", string, locator);
    }

    public void print(PrintStream printStream, String string) {
        Enumeration enumeration;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(string + "<" + "LoadModule" + ">");
        if (this.myProductData != null) {
            this.myProductData.print(printStream, "  " + string);
        }
        if (this.myInstallLM != null) {
            enumeration = this.myInstallLM.elements();
            while (enumeration.hasMoreElements()) {
                ((InstallLM)enumeration.nextElement()).print(printStream, "  " + string);
            }
        }
        if (this.myInstallSM != null) {
            enumeration = this.myInstallSM.elements();
            while (enumeration.hasMoreElements()) {
                ((InstallSM)enumeration.nextElement()).print(printStream, "  " + string);
            }
        }
        if (this.myMoDataLM != null) {
            this.myMoDataLM.print(printStream, "  " + string);
        }
        enumeration = this.myMopplet.elements();
        while (enumeration.hasMoreElements()) {
            ((Mopplet)enumeration.nextElement()).print(printStream, "  " + string);
        }
        if (this.myDynamicClass != null) {
            this.myDynamicClass.print(printStream, "  " + string);
        }
        printStream.println(string + "</" + "LoadModule" + ">");
    }

    public void validate() throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate( )");
        }
        LoadModuleSubElementName.ProductData.validate(this.myProductData, super.getLocatorData());
        LoadModuleSubElementName.InstallLM.validate(this.myInstallLM, super.getLocatorData());
        LoadModuleSubElementName.InstallSM.validate(this.myInstallSM, super.getLocatorData());
        LoadModuleSubElementName.MoDataLM.validate(this.myMoDataLM, super.getLocatorData());
        LoadModuleSubElementName.Mopplet.validate(this.myMopplet, super.getLocatorData());
        LoadModuleSubElementName.DynamicClass.validate(this.myDynamicClass, super.getLocatorData());
        Enumeration enumeration = this.myMopplet.elements();
        while (enumeration.hasMoreElements()) {
            ((Mopplet)enumeration.nextElement()).validate();
        }
        this.myMoDataLM.validate();
        Enumeration enumeration2 = this.myInstallLM.elements();
        while (enumeration2.hasMoreElements()) {
            ((InstallLM)enumeration2.nextElement()).validate();
        }
        Enumeration enumeration3 = this.myInstallSM.elements();
        while (enumeration3.hasMoreElements()) {
            ((InstallSM)enumeration3.nextElement()).validate();
        }
        if (this.myDynamicClass != null) {
            this.myDynamicClass.validate();
        }
        this.myProductData.validate();
        LoadModuleValidator.validate(this, this.getLocatorData());
    }

    public ProductData getProductData() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductData( )");
        }
        return this.myProductData;
    }

    public Vector getInstallLM() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getInstallLM( )");
        }
        return this.myInstallLM;
    }

    public Collection getInstallSM() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getInstallSM( )");
        }
        return this.myInstallSM;
    }

    public MoDataLM getMoDataLM() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getMoDataLM( )");
        }
        return this.myMoDataLM;
    }

    public Vector getMopplet() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getMopplet( )");
        }
        return this.myMopplet;
    }

    public DynamicClass getDynamicClass() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getMopplet( )");
        }
        return this.myDynamicClass;
    }

    public String getProductNumber() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumber( )");
        }
        if (this.myProductData != null) {
            return this.myProductData.getNumber();
        }
        return null;
    }

    public String getProductRevision() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductRevision( )");
        }
        if (this.myProductData != null) {
            return this.myProductData.getRevision();
        }
        return null;
    }

    public String getProductLocatorString() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductLocatorString( )");
        }
        if (this.myProductData != null) {
            return this.myProductData.getLocatorString();
        }
        return null;
    }

    public String getProductName() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductName( )");
        }
        if (this.myProductData != null) {
            return this.myProductData.getName();
        }
        return null;
    }

    public String getProductDate() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductDate( )");
        }
        if (this.myProductData != null) {
            return this.myProductData.getDate();
        }
        return null;
    }

    public String getProductType() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductType( )");
        }
        if (this.myProductData != null) {
            return this.myProductData.getType();
        }
        return null;
    }

    public String getProductInformation() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductInformation( )");
        }
        if (this.myProductData != null) {
            return this.myProductData.getInformation();
        }
        return null;
    }

    public Vector getMoppletNames() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getMoppletNames( )");
        }
        Vector<String> vector = new Vector<String>(1);
        Enumeration enumeration = this.myMopplet.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((Mopplet)enumeration.nextElement()).getName());
        }
        return vector;
    }

    public void setMoDataLM(MoDataLM moDataLM) {
        this.myMoDataLM = moDataLM;
    }

    public String toString() {
        String string = null;
        String string2 = null;
        if (this.myProductData != null) {
            string = this.myProductData.getNumber();
            string2 = this.myProductData.getRevision();
        } else {
            string = EMPTY_STRING;
            string2 = EMPTY_STRING;
        }
        return "\n\tclass LoadModule: " + string + "_" + string2 + " ...";
    }

    private DocumentObjectInterface createProductData(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createProductData(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myProductData == null) {
            this.myProductData = new ProductData(attributeList, locator);
            return this.myProductData;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createMoDataLM(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", "LoadModule", string, locator);
    }

    private DocumentObjectInterface createInstallLM(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createInstallLM(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myInstallLM.addElement(new InstallLM(attributeList, locator));
        return (InstallLM)this.myInstallLM.lastElement();
    }

    private DocumentObjectInterface createInstallSM(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createInstallSM(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myInstallSM.addElement(new InstallSM(attributeList, locator));
        return (InstallSM)this.myInstallSM.lastElement();
    }

    private DocumentObjectInterface createMoDataLM(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createMoDataLM(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myMoDataLM == null) {
            this.myMoDataLM = new MoDataLM(attributeList, locator);
            return this.myMoDataLM;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createMoDataLM(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", "LoadModule", string, locator);
    }

    private DocumentObjectInterface createDynamicClass(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createDynamicClass(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (this.myDynamicClass == null) {
            this.myDynamicClass = new DynamicClass(attributeList, locator);
            return this.myDynamicClass;
        }
        return super.errorUnexpectedElement(UnexpectedElementReason.MoreElementsThanExpected, "createDynamicClass(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", "LoadModule", string, locator);
    }

    private DocumentObjectInterface createMopplet(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createMopplet(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.myMopplet.addElement(new Mopplet(attributeList, locator));
        return (Mopplet)this.myMopplet.lastElement();
    }
}

