/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.upgradelogic;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.SuLmRef;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.UpgradeLogicAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradelogic.UpgradeLogicSubElementName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicInterface;

public class UpgradeLogic
extends ParsedData
implements DocumentObjectInterface,
UpgradeLogicInterface {
    private String myName = null;
    private String myCompatibilityIndex = null;
    private Vector mySuLmRefs = new Vector(1);

    public UpgradeLogic(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"UpgradeLogic(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = UpgradeLogicAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            super.handleUnexpectedAttribute("UpgradeLogic(AttributeList anAttributeList, Locator aLocator)", "UpgradeLogic", stringArray, locator);
        }
        this.myName = attributeList.getValue(UpgradeLogicAttributeName.Name.getValue());
        this.myCompatibilityIndex = attributeList.getValue(UpgradeLogicAttributeName.CompatibilityIndex.getValue());
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if (string.equals(UpgradeLogicSubElementName.SuLmRef.getValue())) {
            return this.createSuLmRef(attributeList, locator);
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", "UpgradeLogic", string, locator);
    }

    public String getName() {
        return this.myName;
    }

    public String getCompatibilityIndex() {
        return this.myCompatibilityIndex;
    }

    public int getCompatibilityIndexAsint() {
        return new Integer(this.myCompatibilityIndex);
    }

    public Collection getSuLmRefs() {
        return this.mySuLmRefs;
    }

    private SuLmRef createSuLmRef(AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"createSuLmRef(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        this.mySuLmRefs.addElement(new SuLmRef(attributeList, locator));
        return (SuLmRef)this.mySuLmRefs.lastElement();
    }

    public void print(PrintStream printStream, String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(string + "<" + "UpgradeLogic");
        if (this.myName != null) {
            printStream.println(string + "  " + UpgradeLogicAttributeName.Name.getValue() + " = \"" + this.myName + "\"");
        }
        if (this.myCompatibilityIndex != null) {
            printStream.println(string + "  " + UpgradeLogicAttributeName.CompatibilityIndex.getValue() + " = \"" + this.myCompatibilityIndex + "\"" + ">");
        }
        Enumeration enumeration = this.mySuLmRefs.elements();
        while (enumeration.hasMoreElements()) {
            ((SuLmRef)enumeration.nextElement()).print(printStream, string + "  ");
        }
        printStream.println(string + "</" + "UpgradeLogic" + ">");
    }

    public void validate() throws ValidateException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate()");
        }
        UpgradeLogicAttributeName.Name.validate(this.myName, super.getLocatorData());
        UpgradeLogicAttributeName.CompatibilityIndex.validate(this.myCompatibilityIndex, super.getLocatorData());
        UpgradeLogicSubElementName.SuLmRef.validate(this.mySuLmRefs, super.getLocatorData());
        Enumeration enumeration = this.mySuLmRefs.elements();
        while (enumeration.hasMoreElements()) {
            ((SuLmRef)enumeration.nextElement()).validate();
        }
    }
}

