/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install;

import java.io.File;
import java.util.Collection;
import java.util.EventObject;
import java.util.Vector;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.install.CancelInstallRequestException;
import se.ericsson.cello.upgradepackage.install.FileInstaller;
import se.ericsson.cello.upgradepackage.install.InstallCoordinator;
import se.ericsson.cello.upgradepackage.install.InstallException;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesRejectedException;
import se.ericsson.cello.upgradepackage.install.event.FTP_ServerInformation;
import se.ericsson.cello.upgradepackage.install.event.InstallCancelledEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallFailedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallFinishedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallerNotifierEvent;
import se.ericsson.cello.upgradepackage.install.event.LoadModuleInstalledEvent;
import se.ericsson.cello.upgradepackage.install.event.LoadModuleStateInformationEvent;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.enumer.LoadModuleState;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.CreateLoadModuleException;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class FileInstallerNotifier
extends Thread {
    private BlockingQueue myQueue = new BlockingQueue();
    private InstallCoordinator myInstallCoordinator = null;
    private Vector myLoadModulesToBeInstalled = null;
    private ProductDataContainer myProductDataOfUP = null;
    private DocumentObjectProxyInterface myDocumentObjectProxyInterface = null;
    private FTP_ServerInformation myFTP_ServerInformation = null;
    private boolean myIsLoadModuleInstalledOngoing = false;
    private static final String Unknown = "Unknown";

    public FileInstallerNotifier(InstallCoordinator installCoordinator, File file, Collection collection, ProductDataContainer productDataContainer, FTP_ServerInformation fTP_ServerInformation) throws InstallException {
        super("FileInstallerNotifierThread");
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "FileInstallerNotifier(InstallCoordinatorInterface anInstallCoordinator, File anUCF_Path, Collection aLoadModulesToBeInstalled, ProductDataContainer aProductDataOfUP, FTP_ServerInformation aFTP_ServerInformation)", "anInstallCoordinator: " + installCoordinator + "\n\tanUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taProductDataOfUP: " + productDataContainer + "\n\taFTP_ServerInformation: " + fTP_ServerInformation);
        }
        try {
            this.myInstallCoordinator = installCoordinator;
            this.myLoadModulesToBeInstalled = new Vector(collection);
            this.myProductDataOfUP = productDataContainer;
            String[] stringArray = new String[]{"InstallUp", "LoadModule"};
            this.myDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElements(productDataContainer.getNumber(), productDataContainer.getRevision(), file.getAbsolutePath(), stringArray);
            this.myFTP_ServerInformation = fTP_ServerInformation;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "FileInstallerNotifier(InstallCoordinator anInstallCoordinator, File anUCF_Path, Collection aLoadModulesToBeInstalled)", "Throwable caught.anInstallCoordinator: " + installCoordinator + "\n\tanUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taProductDataOfUP: " + productDataContainer, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\tmethod: FileInstallerNotifier(InstallCoordinator anInstallCoordinator, File anUCF_Path, Collection aLoadModulesToBeInstalled)" + "\n\tanInstallCoordinator: " + installCoordinator + "\n\tanUCF_Path: " + SuLib.toString(file) + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taProductDataOfUP: " + productDataContainer + "\n\tOrigin Throwable data: " + throwable);
        }
    }

    public ProductNumberAndRevision getFirstLoadModuleToBeInstalled() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFirstLoadModuleToBeInstalled ()");
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFirstLoadModuleToBeInstalled ()", "myLoadModulesToBeInstalled: " + this.myLoadModulesToBeInstalled);
        }
        if (!this.myLoadModulesToBeInstalled.isEmpty()) {
            return (ProductNumberAndRevision)this.myLoadModulesToBeInstalled.firstElement();
        }
        return new ProductNumberAndRevision(Unknown, Unknown);
    }

    public void installNotification(InstallerNotifierEvent installerNotifierEvent) throws InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installNotification(InstallerNotifierEvent aInstallerNotifierEvent)", "aInstallerNotifierEvent: " + installerNotifierEvent);
        }
        if (this.myQueue == null) {
            Trace.error(this.getClass(), "installNotification(InstallerNotifierEvent aInstallerNotifierEvent)", "Failed to insert the event into the buffert.\n\taInstallerNotifierEvent: " + installerNotifierEvent);
            throw new InstallOfLoadModulesRejectedException("Failed to insert the event into the buffert.\n\taInstallerNotifierEvent: " + installerNotifierEvent);
        }
        this.myQueue.enqueue((Object)installerNotifierEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        EventObject eventObject = null;
        block4: while (true) {
            try {
                while (true) {
                    eventObject = (EventObject)this.myQueue.dequeue();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "run ()", "Received event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
                    }
                    if (eventObject instanceof LoadModuleInstalledEvent) {
                        this.myIsLoadModuleInstalledOngoing = true;
                        this.handleInstallNotification((LoadModuleInstalledEvent)eventObject);
                        this.myIsLoadModuleInstalledOngoing = false;
                        continue;
                    }
                    if (eventObject instanceof InstallFinishedEvent) {
                        this.handleInstallNotification((InstallFinishedEvent)eventObject);
                        break block4;
                    }
                    if (eventObject instanceof InstallFailedEvent) {
                        this.handleInstallNotification((InstallFailedEvent)eventObject);
                        break block4;
                    }
                    if (eventObject instanceof InstallCancelledEvent) {
                        this.handleInstallNotification((InstallCancelledEvent)eventObject);
                        break block4;
                    }
                    Trace.error(this.getClass(), "run()", "Unexpected event received in class UpgradeController, ignoring this event and starts waiting for further events...\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
                }
            }
            catch (InterruptedException interruptedException) {
                Trace.error(this.getClass(), "run()", "Interrupted exception caught. Ignored and starts waiting for further events...\n\tReceived event: " + eventObject, interruptedException);
                this.myIsLoadModuleInstalledOngoing = false;
                continue;
            }
            catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
                this.myIsLoadModuleInstalledOngoing = false;
                if (eventObject instanceof LoadModuleInstalledEvent && this.cancelFileTransfer(eventObject)) continue;
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "run()", "Exception caught when notifying install progress during installation.\n\tRequests for cancel of the ongoing installation.\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject, exception);
                this.myIsLoadModuleInstalledOngoing = false;
                if (!(eventObject instanceof LoadModuleInstalledEvent) || !this.cancelFileTransfer(eventObject)) break;
                continue;
            }
            break;
        }
        this.myQueue = null;
        this.myInstallCoordinator = null;
        UCF_ParserFacade.removeDocumentObjectForUpgradePackage(this.myProductDataOfUP.getNumber(), this.myProductDataOfUP.getRevision());
        this.myDocumentObjectProxyInterface = null;
        this.myIsLoadModuleInstalledOngoing = false;
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ()", "The tread for this object is stopped");
        }
    }

    private boolean cancelFileTransfer(EventObject eventObject) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelFileTransfer(EventObject anEventObject)", "anEventObject: " + eventObject);
        }
        try {
            new FileInstaller(this.myInstallCoordinator).cancelInstallLoadModules();
            return true;
        }
        catch (CancelInstallRequestException cancelInstallRequestException) {
            Trace.error(this.getClass(), "cancelFileTransfer( )", "Exception caught when trying to cancel an install.\n\tAborting this installation by stopping the thread.\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject, (Throwable)((Object)cancelInstallRequestException));
            return false;
        }
    }

    private void handleInstallNotification(LoadModuleInstalledEvent loadModuleInstalledEvent) throws InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallNotification(LoadModuleInstalledEvent aLoadModuleInstalledEvent)", "aLoadModuleInstalledEvent: " + loadModuleInstalledEvent);
        }
        this.loadModuleInstalled(loadModuleInstalledEvent.completeLoadModuleInstalled);
    }

    private void handleInstallNotification(InstallFinishedEvent installFinishedEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallNotification(InstallFinishedEvent anInstallFinishedEvent)", "anInstallFinishedEvent: " + installFinishedEvent);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallNotification(InstallFinishedEvent anInstallFinishedEvent)", "Requests for update of lmFilesInstallState in all PiuType MO's");
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.LoadModuleState, new LoadModuleStateInformationEvent(this, new ProductNumberAndRevision("InstallFinsihed", "R1A"), LoadModuleState.Installed));
    }

    private void handleInstallNotification(InstallFailedEvent installFailedEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallNotification(InstallFailedEvent anInstallFailedEvent)", "anInstallFailedEvent: " + installFailedEvent);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallNotification(InstallFailedEvent anInstallFailedEvent)", "Requests for update of lmFilesInstallState in all PiuType MO's");
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.LoadModuleState, new LoadModuleStateInformationEvent(this, new ProductNumberAndRevision("InstallFailed", "R1A"), LoadModuleState.Installed));
        if (installFailedEvent.cancelOfFileTransferIsNeeded) {
            this.cancelFileTransfer(installFailedEvent);
        }
    }

    private void handleInstallNotification(InstallCancelledEvent installCancelledEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallNotification(InstallCancelledEvent anInstallCancelledEvent)", "anInstallCancelledEvent: " + installCancelledEvent);
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallNotification(InstallCancelledEvent anInstallCancelledEvent)", "Requests for update of lmFilesInstallState in all PiuType MO's");
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.LoadModuleState, new LoadModuleStateInformationEvent(this, new ProductNumberAndRevision("InstallCancelled", "R1A"), LoadModuleState.Installed));
    }

    public void waitForAllLoadModuleFilesToProperlyInstalled() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForAllLoadModuleFilesToProperlyInstalled()");
        }
        boolean bl = false;
        SystemUpgradeConstantsInterface systemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
        int n = 0;
        while (!bl) {
            if (this.myQueue == null) {
                bl = true;
            } else if (this.myQueue.isEmpty() && !this.myIsLoadModuleInstalledOngoing) {
                bl = true;
            }
            if (n > 0) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "waitForAllLoadModuleFilesToProperlyInstalled()", "Waiting " + systemUpgradeConstantsInterface.getWaitForInstallOfLoadModulesFinishedTimerValue() + " ms for all load module files to be properly installed.");
                }
                TimeHandler.sleep(systemUpgradeConstantsInterface.getWaitForInstallOfLoadModulesFinishedTimerValue());
            }
            ++n;
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForAllLoadModuleFilesToProperlyInstalled()", "Stop waiting...");
        }
    }

    public void loadModuleInstalled(boolean bl) throws InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadModuleInstalled(boolean aCompleteLoadModuleInstalled)", "aCompleteLoadModuleInstalled: " + bl);
        }
        int n = -1;
        if (this.myLoadModulesToBeInstalled != null) {
            n = this.myLoadModulesToBeInstalled.size();
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "loadModuleInstalled(boolean aCompleteLoadModuleInstalled)", "myLoadModulesToBeInstalled: " + this.myLoadModulesToBeInstalled + "\n\ttheSizeOfLoadModulesToBeInstalled: " + n);
        }
        ProductNumberAndRevision productNumberAndRevision = null;
        try {
            if (bl) {
                if (!this.myLoadModulesToBeInstalled.isEmpty()) {
                    LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface;
                    productNumberAndRevision = (ProductNumberAndRevision)this.myLoadModulesToBeInstalled.remove(0);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "loadModuleInstalled(boolean aCompleteLoadModuleInstalled)", "The load module file(s) for a load module have been installed on the node.\n\tProduct data of load module: " + productNumberAndRevision);
                    }
                    if ((loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface()).isLoadModulePresent(productNumberAndRevision)) {
                        ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
                        if (configurationVersionMO_HandlerInterface.isCurrentUP(this.myProductDataOfUP.getNumber(), this.myProductDataOfUP.getRevision())) {
                            loadModuleMO_HandlerInterface.updateLoadModuleAtInstallOfActiveUP(productNumberAndRevision, this.myDocumentObjectProxyInterface);
                        }
                        loadModuleMO_HandlerInterface.updateLoadModuleAtInstall(productNumberAndRevision, this.myDocumentObjectProxyInterface);
                    } else {
                        loadModuleMO_HandlerInterface.createLoadModule(productNumberAndRevision, this.myDocumentObjectProxyInterface, this.myFTP_ServerInformation.ftpServerUCF_Path);
                    }
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)this, 997, null));
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "loadModuleInstalled(boolean aCompleteLoadModuleInstalled)", "A load module with product number '" + productNumberAndRevision.productNumber + "' and revision '" + productNumberAndRevision.revision + "' has been installed.");
                    }
                } else {
                    Trace.info(this.getClass(), "loadModuleInstalled(boolean aCompleteLoadModuleInstalled)", "A load module has been installed. However, there is no information about which load module that has been installed i.e. \n\tIgnoring this information.");
                }
            } else {
                UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)this, 997, null));
            }
        }
        catch (CreateLoadModuleException createLoadModuleException) {
            throw new InstallOfLoadModulesRejectedException(createLoadModuleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "loadModuleInstalled(boolean aCompleteLoadModuleInstalled)", "At creation of a Load Module MO after installation of its load module file(s) a Throwable was caught.\n\ttheProductNumberAndRevision: " + productNumberAndRevision, throwable);
            throw new InstallOfLoadModulesRejectedException("Due to internal error at creation of the Load Module MO that shall represent the installed load module file(s) the installation is interrupted.\n\tProduct number and revision of latest installed load module: " + productNumberAndRevision + "\n\tOriginal exception message: " + throwable.toString());
        }
    }
}

