/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install;

import java.io.File;
import java.util.Collection;
import java.util.EventObject;
import java.util.NoSuchElementException;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.su.classloader.DynamicClassLoaderCentral;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.handler.FromVersionInformation;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ValueAVC_Property;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.ChecksumFileResultInterface;
import se.ericsson.cello.su.signedsw.CrlAndCertificateUnloader;
import se.ericsson.cello.su.uci.control.ExecutionOfSequenceFinishedInformationEvent;
import se.ericsson.cello.su.uci.control.SequenceToBeExecutedInformationEvent;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UCF_ValidationException;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.installsequence.InstallSequenceProxyInterface;
import se.ericsson.cello.sudom.proxy.installsequence.InstallStepInterface;
import se.ericsson.cello.sudom.proxy.installsequence.OperationInterface;
import se.ericsson.cello.sudom.proxy.installsequence.PreUpgradeSuInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradelogic.UpgradeLogicProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.create.UpgradePackageCreator;
import se.ericsson.cello.upgradepackage.initiate.InitiateException;
import se.ericsson.cello.upgradepackage.install.ChecksumException;
import se.ericsson.cello.upgradepackage.install.ExecuteableOperationException;
import se.ericsson.cello.upgradepackage.install.ExecuteableStepOperationInterface;
import se.ericsson.cello.upgradepackage.install.InitUP_Information;
import se.ericsson.cello.upgradepackage.install.InitiateHandler;
import se.ericsson.cello.upgradepackage.install.InstallCoordinator;
import se.ericsson.cello.upgradepackage.install.InstallException;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesRejectedException;
import se.ericsson.cello.upgradepackage.install.InstallSequenceHandler;
import se.ericsson.cello.upgradepackage.install.MaxNoOfCVsException;
import se.ericsson.cello.upgradepackage.install.NotEnoughWithDiskSpaceForRequiredNoOfCVsException;
import se.ericsson.cello.upgradepackage.install.PiuTypeInstallLMs;
import se.ericsson.cello.upgradepackage.install.UP_AndLM_Information;
import se.ericsson.cello.upgradepackage.install.UpgradePackageControlFileTransformer;
import se.ericsson.cello.upgradepackage.install.event.CancelInstallConfirmedEvent;
import se.ericsson.cello.upgradepackage.install.event.CancelInstallRejectedEvent;
import se.ericsson.cello.upgradepackage.install.event.CancelInstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.ForcedInstallLoadModulesForPiuTypeRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.ForcedInstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallConfirmedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallLoadModulesForPiuTypeRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallRejectedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.UP_InstallRequestEvent;
import se.ericsson.cello.upgradepackage.main.event.steplabel.StepLabelEvent;
import se.ericsson.cello.upgradepackage.main.exception.FtpServerNotAccessibleException;
import se.ericsson.cello.upgradepackage.main.exception.GetFileException;
import se.ericsson.cello.upgradepackage.main.exception.IpAddressException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.proxy.ProxySelectorInterface;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.CurrentStepNumberInSequence;
import se.ericsson.cello.upgradepackage.util.datacontainer.IdleProgressInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.IsForcedInstallInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.OngoingActionID_Information;
import se.ericsson.cello.upgradepackage.util.datacontainer.SequenceLabel;
import se.ericsson.cello.upgradepackage.util.datacontainer.StateValueInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.TotalNumberOfStepsInSequence;
import se.ericsson.cello.upgradepackage.util.datacontainer.UCF_ControlResultContainer;
import se.ericsson.cello.upgradepackage.util.enumer.ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.upgradepackage.util.enumer.ActivatedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.enumer.RequestedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.handler.FromVersionExtendedInformation;
import se.ericsson.cello.upgradepackage.util.handler.FromVersionHandler;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.VerifyCVsToBeCreatedResult;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandler;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandlerException;

public class UpgradePackageInstaller
extends Thread {
    private BlockingQueue myQueue = new BlockingQueue();
    private boolean myIsCancelInstallRequested = false;
    public static final String EMPTY_STRING = "";
    public static final int ZERO = 0;
    public static final int ONE_INSTALL_CV = 1;
    public static final int TWO_INSTALL_CVS = 2;

    public UpgradePackageInstaller() {
        super("UpgradePackageInstallerThread");
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradePackageInstaller()");
        }
    }

    public void cancelInstallRequest(CancelInstallRequestEvent cancelInstallRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelInstallRequest(CancelInstallRequestEvent aCancelInstallRequestEvent", "aCancelInstallRequestEvent: " + cancelInstallRequestEvent);
        }
        if (this.myQueue != null) {
            this.myQueue.enqueue((Object)cancelInstallRequestEvent);
        } else {
            Trace.error(this.getClass(), "cancelInstallRequest(CancelInstallRequestEvent aCancelInstallRequestEvent)", "Cancel install received when the thread handling the cancellation of the installation has been stopped.\n\taCancelInstallRequestEvent: " + cancelInstallRequestEvent);
            UpgradeCoordinator.instance().cancelInstallResponse(new CancelInstallRejectedEvent(this));
        }
    }

    public void installRequest(InstallRequestEvent installRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installRequest(InstallRequestEvent anInstallRequestEvent)", "anInstallRequestEvent: " + installRequestEvent);
        }
        if (this.myQueue != null) {
            this.myQueue.enqueue((Object)installRequestEvent);
        } else {
            Trace.error(this.getClass(), "installRequest(InstallRequestEvent anInstallRequestEvent)", "Install received when the thread handling the installation has been stopped.\n\tanInstallRequestEvent: " + installRequestEvent);
            UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
        }
    }

    public void setIsCancelInstallRequested(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setIsCancelInstallRequested ( boolean anIsCancelInstallRequested )", "anIsCancelInstallRequested: " + bl);
        }
        this.myIsCancelInstallRequested = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run ()");
        }
        EventObject eventObject = null;
        try {
            try {
                eventObject = (EventObject)this.myQueue.dequeue();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "run ()", "Received event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
                }
                if (eventObject instanceof ForcedInstallRequestEvent) {
                    this.handleInstallRequest((ForcedInstallRequestEvent)eventObject, true);
                }
                if (eventObject instanceof UP_InstallRequestEvent) {
                    this.handleInstallRequest((UP_InstallRequestEvent)eventObject, false);
                }
                if (eventObject instanceof CancelInstallRequestEvent) {
                    this.handleCancelInstallRequest((CancelInstallRequestEvent)eventObject);
                }
                if (eventObject instanceof ForcedInstallLoadModulesForPiuTypeRequestEvent) {
                    PiuTypeInstallLMs piuTypeInstallLMs = new PiuTypeInstallLMs();
                    piuTypeInstallLMs.handleInstallLMsForPiuTypeRequest((ForcedInstallLoadModulesForPiuTypeRequestEvent)eventObject, true);
                }
                if (eventObject instanceof InstallLoadModulesForPiuTypeRequestEvent) {
                    PiuTypeInstallLMs piuTypeInstallLMs = new PiuTypeInstallLMs();
                    piuTypeInstallLMs.handleInstallLMsForPiuTypeRequest((InstallLoadModulesForPiuTypeRequestEvent)eventObject, false);
                }
                Trace.error(this.getClass(), "run()", "Unexpected event received.\n\tThe Thread created for this object is stopped.\n\tReceived Upgrade event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
            catch (InterruptedException interruptedException) {
                Trace.error(this.getClass(), "run()", "Interrupted exception caught.\n\tThe Thread created for this object is stopped.\n\tReceived event: " + eventObject + "\n\tEventData: " + eventObject, interruptedException);
                this.handleUnexpectedFailure(eventObject, interruptedException);
                Object var4_7 = null;
                this.myQueue = null;
                if (!Trace.valid(this.getClass(), 22)) return;
                Trace.debug(this.getClass(), 22, "run ()", "The thread for this object is STOPPED.");
                return;
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "run()", "Throwable caught.\n\tThe Thread created for this object is stopped.\n\tReceived event: " + eventObject, throwable);
                this.handleUnexpectedFailure(eventObject, throwable);
                Object var4_8 = null;
                this.myQueue = null;
                if (!Trace.valid(this.getClass(), 22)) return;
                Trace.debug(this.getClass(), 22, "run ()", "The thread for this object is STOPPED.");
                return;
            }
            Object var4_6 = null;
            this.myQueue = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.myQueue = null;
            if (!Trace.valid(this.getClass(), 22)) throw throwable;
            Trace.debug(this.getClass(), 22, "run ()", "The thread for this object is STOPPED.");
            throw throwable;
        }
        if (!Trace.valid(this.getClass(), 22)) return;
        Trace.debug(this.getClass(), 22, "run ()", "The thread for this object is STOPPED.");
    }

    private void handleCancelInstallRequest(CancelInstallRequestEvent cancelInstallRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleCancelInstallRequest(CancelInstallRequestEvent aCancelInstallRequestEvent)", "aCancelInstallRequestEvent: " + cancelInstallRequestEvent);
        }
        try {
            InstallCoordinator installCoordinator = new InstallCoordinator();
            installCoordinator.cancelInstallOfLoadModules(true);
            UpgradeCoordinator.instance().cancelInstallResponse(new CancelInstallConfirmedEvent(this));
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "handleCancelInstallRequest(CancelInstallRequestEvent aCancelInstallRequestEvent)", "Exception caught. Sending a notification indicating that the cancel of install failed.", exception);
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent(null, 889, null));
            UpgradeCoordinator.instance().cancelInstallResponse(new CancelInstallRejectedEvent(this));
        }
    }

    private void handleUnexpectedFailure(EventObject eventObject, Throwable throwable) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUnexpectedFailure(EventObject aRequestEvent)", "aRequestEvent: " + eventObject + "\n\taThrowable: " + throwable);
        }
        if (eventObject instanceof InstallRequestEvent) {
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException(throwable.toString()), 993, "--"));
            UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
        } else if (eventObject instanceof CancelInstallRequestEvent) {
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException(throwable.toString()), 889, "--"));
            UpgradeCoordinator.instance().cancelInstallResponse(new CancelInstallRejectedEvent(this));
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "handleUnexpectedFailure(EventObject aRequestEvent)", "Unexpected request event received. Ignoring it...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleInstallRequest(UP_InstallRequestEvent uP_InstallRequestEvent, boolean bl) {
        block46: {
            DocumentObjectProxyInterface documentObjectProxyInterface;
            boolean bl2;
            block44: {
                Object object;
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl);
                }
                bl2 = false;
                documentObjectProxyInterface = null;
                this.handleUcfConsistency(uP_InstallRequestEvent, bl);
                String[] stringArray = new String[]{"UpgradeWindow", "UpCompatibilityIndex", "InstallSequence", "UpgradeLogic", "LoadModule", "PiuType"};
                documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, uP_InstallRequestEvent.upgradePackageOriginalUCF_Path, stringArray);
                FromVersionHandler fromVersionHandler = new FromVersionHandler();
                String string = documentObjectProxyInterface.getUP_CompatibilityIndexProxyInterface().getIndex();
                if (string == null) {
                    string = EMPTY_STRING;
                }
                FromVersionExtendedInformation fromVersionExtendedInformation = fromVersionHandler.getExtendedFromVersion(uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, string, documentObjectProxyInterface.isDeltaUP(), uP_InstallRequestEvent.getSU_LogicCompatibilityIndex(), documentObjectProxyInterface);
                InstallSequenceProxyInterface installSequenceProxyInterface = documentObjectProxyInterface.getInstallSequenceProxyInterface(fromVersionExtendedInformation, documentObjectProxyInterface.isDeltaUP());
                UpgradeLogicProxyInterface upgradeLogicProxyInterface = documentObjectProxyInterface.getUpgradeLogicProxyInterface();
                LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
                if (this.isSU_ToBePreUpgradedAtAll(installSequenceProxyInterface, upgradeLogicProxyInterface, fromVersionExtendedInformation.getFromSU_LogicCompatibilityIndex(), uP_InstallRequestEvent.getPreUpgradeState(), uP_InstallRequestEvent.getOverrideForcedPreUpgrade())) {
                    object = ServiceFinder.getUpgradePackageMO_HandlerInterface().getPreUpgradedUP();
                    if (object != null) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Pre Upgrade of SU function required when already has been performed on an other UP. The installation is rejected.");
                        }
                        throw new InstallException("Pre Upgrade of SU function required when already has been performed on an other UP. The installation is rejected.\n\tThis UP: " + uP_InstallRequestEvent.upgradePackageDocumentNumber + " " + uP_InstallRequestEvent.upgradePackageDocumentRevision + "\n\tThe already pre upgrade UP: " + object);
                    }
                    this.createInstallRollbackCV(uP_InstallRequestEvent);
                } else if (uP_InstallRequestEvent.getExecutedStepLabel().equals(EMPTY_STRING)) {
                    this.verifyThatItIsPossibleToCreateSiCV();
                }
                if (uP_InstallRequestEvent.getExecutedStepLabel().equals(EMPTY_STRING) && this.isSU_ToBePreUpgradedFirstOfAll(installSequenceProxyInterface, upgradeLogicProxyInterface, fromVersionExtendedInformation.getFromSU_LogicCompatibilityIndex(), uP_InstallRequestEvent.getOverrideForcedPreUpgrade())) {
                    this.doExecuteInstallSequence(installSequenceProxyInterface, upgradeLogicProxyInterface, loadModulesProxyInterface, new InitUP_Information(uP_InstallRequestEvent), bl, fromVersionExtendedInformation);
                    break block44;
                }
                object = this.initUP(uP_InstallRequestEvent);
                if (this.isAnyTriggerPartOfSequence(installSequenceProxyInterface)) {
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new SequenceToBeExecutedInformationEvent(this, (InitUP_Information)object, true, bl, uP_InstallRequestEvent.getInstalledTypeOfUP()));
                    bl2 = true;
                }
                this.doExecuteInstallSequence(installSequenceProxyInterface, upgradeLogicProxyInterface, loadModulesProxyInterface, (InitUP_Information)object, bl, fromVersionExtendedInformation);
            }
            Object var14_21 = null;
            try {
                DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable);
            }
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
            if (bl2) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
            }
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
            {
                break block46;
                catch (MaxNoOfCVsException maxNoOfCVsException) {
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)maxNoOfCVsException, 855, maxNoOfCVsException.toString()));
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    Object var14_22 = null;
                    try {
                        DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable);
                    }
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    if (bl2) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                    break block46;
                }
                catch (NotEnoughWithDiskSpaceForRequiredNoOfCVsException notEnoughWithDiskSpaceForRequiredNoOfCVsException) {
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)notEnoughWithDiskSpaceForRequiredNoOfCVsException, 854, notEnoughWithDiskSpaceForRequiredNoOfCVsException.toString()));
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    Object var14_23 = null;
                    try {
                        DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable);
                    }
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    if (bl2) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                    break block46;
                }
                catch (ChecksumException checksumException) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Checksum problems detected related to the upgrade control files.\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl + "\n\tChecksumException: " + (Object)((Object)checksumException));
                    }
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)checksumException, 852, EMPTY_STRING));
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    Object var14_24 = null;
                    try {
                        DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable);
                    }
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    if (bl2) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                    break block46;
                }
                catch (UCF_ValidationException uCF_ValidationException) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The UCF validation control detected problems\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl + "\n\tUCF_ValidationException: " + (Object)((Object)uCF_ValidationException));
                    }
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)uCF_ValidationException, 860, EMPTY_STRING));
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    Object var14_25 = null;
                    try {
                        DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable);
                    }
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    if (bl2) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                    break block46;
                }
                catch (InitiateException initiateException) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The UCF validation control detected problems\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl + "\n\tUCF_ValidationException: " + (Object)((Object)initiateException));
                    }
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)initiateException, 859, EMPTY_STRING));
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    Object var14_26 = null;
                    try {
                        DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable);
                    }
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    if (bl2) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                    break block46;
                }
                catch (UpgradeControlFileParserException upgradeControlFileParserException) {
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)upgradeControlFileParserException, 993, "UCF Parser exception"));
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    Object var14_27 = null;
                    try {
                        DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable);
                    }
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    if (bl2) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                    break block46;
                }
                catch (InstallException installException) {
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException(installException.toString()), 993, EMPTY_STRING));
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    Object var14_28 = null;
                    try {
                        DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                    }
                    catch (Throwable throwable) {
                        Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable);
                    }
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    if (bl2) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                    break block46;
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), "handleInstallRequest(InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "The installation of the load modules has failed due to a Throwable was caught.\n\tThe load modules that were requested to be installed are: \n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl + "\n\tThrowable message: " + throwable, throwable);
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException("Throwable caught: " + throwable.toString()), 993, "--"));
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    Object var14_29 = null;
                    try {
                        DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                    }
                    catch (Throwable throwable2) {
                        Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable2);
                    }
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                    if (bl2) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                }
            }
            catch (Throwable throwable) {
                Object var14_30 = null;
                try {
                    DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(uP_InstallRequestEvent.getUpgradePackageMoExtended());
                }
                catch (Throwable throwable3) {
                    Trace.error(this.getClass(), "handleInstallRequest(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Throwable caught when trying to unload any dynamic loaded classes", throwable3);
                }
                UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
                if (bl2) {
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceStatus, new ExecutionOfSequenceFinishedInformationEvent(this));
                }
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, 0));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, EMPTY_STRING, ValueAVC_Property.ValueAndAVC));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, 0));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, EMPTY_STRING));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, 0));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, false));
                throw throwable;
            }
        }
    }

    private void createInstallRollbackCV(UP_InstallRequestEvent uP_InstallRequestEvent) throws InstallException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createInstallRollbackCV(UP_InstallRequestEvent anUP_InstallRequestEvent)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            VerifyCVsToBeCreatedResult verifyCVsToBeCreatedResult = configurationVersionMO_HandlerInterface.verifyNumberOfCVsToBeCreated(2);
            if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.Confirmed)) {
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.State, new StateValueInformation(this, uP_InstallRequestEvent.getPreviousState(), ValueAVC_Property.OnlyValue));
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new IdleProgressInformation(this, ValueAVC_Property.OnlyValue));
                String string = configurationVersionMO_HandlerInterface.createInstallRollbackCV_AndSetStartable(uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision);
                configurationVersionMO_HandlerInterface.deleteCVsWithReason("Ir", uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, string);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.State, new StateValueInformation(this, 5, ValueAVC_Property.OnlyValue));
            } else {
                if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.NumberOfCVsExceeded)) {
                    throw new MaxNoOfCVsException("The number of required CVs at the installation are two i.e. an install rollback CV (Ir_) and a final CV (Si_)");
                }
                if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.NoAvailableMemoryForCVs)) {
                    throw new NotEnoughWithDiskSpaceForRequiredNoOfCVsException("The number of required CVs at the installation are two i.e. an install rollback CV (Ir_) and a final CV (Si_)");
                }
            }
        }
        catch (InstallException installException) {
            throw installException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createInstallRollbackCV(UP_InstallRequestEvent anUP_InstallRequestEvent)", "Throwable caught", throwable);
            throw new InstallException(throwable.toString());
        }
    }

    private void verifyThatItIsPossibleToCreateSiCV() throws InstallException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyThatItIsPossibleToCreateSiCV()");
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            VerifyCVsToBeCreatedResult verifyCVsToBeCreatedResult = configurationVersionMO_HandlerInterface.verifyNumberOfCVsToBeCreated(1);
            if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.NumberOfCVsExceeded)) {
                throw new MaxNoOfCVsException("The number of required CVs at the installation is one i.e. a final install CV (Si_)");
            }
            if (verifyCVsToBeCreatedResult.equals(VerifyCVsToBeCreatedResult.NoAvailableMemoryForCVs)) {
                throw new NotEnoughWithDiskSpaceForRequiredNoOfCVsException("The number of required CVs at the installation is one i.e. a final install CV (Si_)");
            }
        }
        catch (InstallException installException) {
            throw installException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyThatItIsPossibleToCreateSiCV()", "Throwable caught", throwable);
            throw new InstallException(throwable.toString());
        }
    }

    private boolean isAnyTriggerPartOfSequence(InstallSequenceProxyInterface installSequenceProxyInterface) {
        Collection collection;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isAnyTriggerPartOfSequence(InstallSequenceProxyInterface anInstallSequenceProxyInterface)", "anInstallSequenceProxyInterface: " + installSequenceProxyInterface);
        }
        boolean bl = false;
        if (installSequenceProxyInterface != null && !(collection = installSequenceProxyInterface.getAllTriggers()).isEmpty()) {
            bl = true;
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    private void doExecuteInstallSequence(InstallSequenceProxyInterface installSequenceProxyInterface, UpgradeLogicProxyInterface upgradeLogicProxyInterface, LoadModulesProxyInterface loadModulesProxyInterface, InitUP_Information initUP_Information, boolean bl, FromVersionInformation fromVersionInformation) throws InstallException {
        Object object2222;
        block18: {
            block17: {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "doExecuteInstallSequence(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterfaceanUpgradeLogicProxyInterface, LoadModulesProxyInterface aLoadModulesProxyInterface, InitUP_Information anInitUP_Information, boolean aForcedInstallRequest, FromVersionInformation aFromVersionInformation)", "anInstallSequenceProxyInterface: " + installSequenceProxyInterface + "\n\tanUpgradeLogicProxyInterface: " + upgradeLogicProxyInterface + "\n\taLoadModulesProxyInterface: " + loadModulesProxyInterface + "\n\tanInitUP_Information: " + initUP_Information + "\n\taForcedInstallRequest: " + bl + "\n\taFromVersionInformation: " + fromVersionInformation);
                }
                String string = "None (No sequence defined)";
                String string2 = "None (No sequence defined)";
                if (installSequenceProxyInterface != null) {
                    string = installSequenceProxyInterface.getLabel();
                    string2 = installSequenceProxyInterface.getAllCaseValues().toString();
                }
                Trace.log1(this.getClass(), "doExecuteInstallSequence(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterfaceanUpgradeLogicProxyInterface, InitUP_Information anInitUP_Information, boolean aForcedInstallRequest, FromVersionInformation aFromVersionInformation)", "Starts to execute the install sequence operations\n\tLabel: " + string + "\n\tAll case values: " + string2);
                InstallSequenceHandler installSequenceHandler = new InstallSequenceHandler(installSequenceProxyInterface, upgradeLogicProxyInterface, loadModulesProxyInterface, initUP_Information, bl);
                if (initUP_Information.getUP_InstallRequestEvent().getExecutedStepLabel().equals(EMPTY_STRING)) {
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.TotalNumberofStepsInSequence, new TotalNumberOfStepsInSequence((Object)this, installSequenceHandler.getTotaNumberOfStepsInSequence()));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.OngoingActionID, new OngoingActionID_Information((Object)this, initUP_Information.getUP_InstallRequestEvent().getActionID()));
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.IsForcedInstall, new IsForcedInstallInformation((Object)this, bl));
                } else {
                    DynamicClassLoaderCentral.getInstance().loadLoadModulesInDynClassPath(initUP_Information.getUP_InstallRequestEvent().getUpgradePackageMoExtended());
                }
                int n = initUP_Information.getUP_InstallRequestEvent().getCurrentStepNumberInSequence();
                ExecuteableStepOperationInterface executeableStepOperationInterface = null;
                installSequenceHandler.setExectedStepLabel(initUP_Information.getUP_InstallRequestEvent().getExecutedStepLabel());
                while (installSequenceHandler.hasNext() && !this.myIsCancelInstallRequested) {
                    this.logInstallSequenceInfo(executeableStepOperationInterface, installSequenceProxyInterface, initUP_Information.getUP_InstallRequestEvent().getExecutedStepLabel());
                    executeableStepOperationInterface = installSequenceHandler.nextExecuteableStepOperation();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "doExecuteInstallSequence(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterfaceanUpgradeLogicProxyInterface, InitUP_Information anInitUP_Information, boolean aForcedInstallRequest, FromVersionInformation aFromVersionInformation)", "Start to execute the step operation\n\ttheExecuteableStepOperation " + executeableStepOperationInterface);
                    }
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.CurrentStepNumberInSequence, new CurrentStepNumberInSequence((Object)this, ++n));
                    if (installSequenceProxyInterface != null) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, executeableStepOperationInterface.getStepLabel(), ValueAVC_Property.OnlyAVC));
                    }
                    executeableStepOperationInterface.executeOp();
                    if (installSequenceProxyInterface == null) continue;
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.StepLabel, new StepLabelEvent(this, executeableStepOperationInterface.getStepLabel(), ValueAVC_Property.OnlyValue));
                }
                DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(initUP_Information.getUP_InstallRequestEvent().getUpgradePackageMoExtended());
                if (!this.myIsCancelInstallRequested) {
                    UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)this, 992, EMPTY_STRING));
                    UpgradeCoordinator.instance().installResponse(new InstallConfirmedEvent(this));
                    break block17;
                }
                UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)this, 887, null));
                UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
            }
            Object var13_15 = null;
            try {
                DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(initUP_Information.getUP_InstallRequestEvent().getUpgradePackageMoExtended());
                break block18;
            }
            catch (Throwable object2222) {
                Trace.error(this.getClass(), "doExecuteInstallSequence(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterfaceanUpgradeLogicProxyInterface, InitUP_Information anInitUP_Information, boolean aForcedInstallRequest, FromVersionInformation aFromVersionInformation)", "Throwable caught when trying to unload any dynamic loaded classes", (Throwable)object2222);
            }
            {
                break block18;
                catch (NoSuchElementException noSuchElementException) {
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    throw new InstallException(noSuchElementException.toString());
                }
                catch (ExecuteableOperationException executeableOperationException) {
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    throw new InstallException(executeableOperationException.toString());
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), "doExecuteInstallSequence(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterface anUpgradeLogicProxyInterface, LoadModulesProxyInterface aLoadModulesProxyInterface, InitUP_Information anInitUP_Information, boolean aForcedInstallRequest, FromVersionInformation aFromVersionInformation)", "anInstallSequenceProxyInterface: " + installSequenceProxyInterface + "\n\tThrowable caught.", throwable);
                    UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
                    throw new InstallException(throwable.toString());
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    DynamicClassLoaderCentral.getInstance().unloadAllLoadModules(initUP_Information.getUP_InstallRequestEvent().getUpgradePackageMoExtended());
                }
                catch (Throwable object3) {
                    Trace.error(this.getClass(), "doExecuteInstallSequence(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterfaceanUpgradeLogicProxyInterface, InitUP_Information anInitUP_Information, boolean aForcedInstallRequest, FromVersionInformation aFromVersionInformation)", "Throwable caught when trying to unload any dynamic loaded classes", (Throwable)object3);
                }
                object3 = initUP_Information.getUP_InstallRequestEvent().upgradePackageMO;
                CrlAndCertificateUnloader crlAndCertificateUnloader = new CrlAndCertificateUnloader();
                crlAndCertificateUnloader.unloadCrlsAndCertificatesForToState((UpgradePackageMoExtended)object3);
                throw throwable;
            }
        }
        object2222 = initUP_Information.getUP_InstallRequestEvent().upgradePackageMO;
        CrlAndCertificateUnloader crlAndCertificateUnloader = new CrlAndCertificateUnloader();
        crlAndCertificateUnloader.unloadCrlsAndCertificatesForToState((UpgradePackageMoExtended)object2222);
    }

    private void logInstallSequenceInfo(ExecuteableStepOperationInterface executeableStepOperationInterface, InstallSequenceProxyInterface installSequenceProxyInterface, String string) {
        if (executeableStepOperationInterface == null) {
            if (installSequenceProxyInterface != null) {
                Trace.log1(this.getClass(), "logInstallSequenceInfo (ExecuteableStepOperationInterface anExecuteableStepOperationInterface, InstallSequenceProxyInterface anInstallSequenceProxyInterface)", "Execution of install using the specified InstallSequence with label: " + installSequenceProxyInterface.getLabel());
                if (installSequenceProxyInterface != null && string.equals(EMPTY_STRING)) {
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.SequenceLabel, new SequenceLabel((Object)this, installSequenceProxyInterface.getLabel()));
                }
            } else {
                Trace.suTestLog(this.getClass(), "logInstallSequenceInfo (ExecuteableStepOperationInterface anExecuteableStepOperationInterface, InstallSequenceProxyInterface anInstallSequenceProxyInterface)", "Execution of install when no InstallSequence has been defined for current from version.");
            }
        }
    }

    private InitUP_Information initUP(UP_InstallRequestEvent uP_InstallRequestEvent) throws UCF_ValidationException, InitiateException, ChecksumException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "initUP(UP_InstallRequestEvent anInstallRequestEvent)", "anInstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            Object object;
            if (uP_InstallRequestEvent.getRequestedTypeOfUP().getValue() == RequestedTypeOfUP.Undefined.getValue()) {
                object = new InitiateHandler();
                ((InitiateHandler)object).initiateUP(uP_InstallRequestEvent.getUpgradePackageMoExtended(), new File(uP_InstallRequestEvent.upgradePackageOriginalUCF_Path), uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, uP_InstallRequestEvent.ftpServerInformation.ftpServerUCF_Path, ActionResultDataTypeOfInvokedActionValue.Install);
                uP_InstallRequestEvent.upgradePackageType = uP_InstallRequestEvent.getUpgradePackageMoExtended().getTypeOfUpgradePackage(null);
                uP_InstallRequestEvent.setRequestedTypeOfUP(RequestedTypeOfUP.getInstance(uP_InstallRequestEvent.getUpgradePackageMoExtended().getRequestedTypeOfUP(null)));
                uP_InstallRequestEvent.setHSI_Variant(uP_InstallRequestEvent.getUpgradePackageMoExtended().getHsiVariantInternal());
                uP_InstallRequestEvent.activatedTypeOfUP = ActivatedTypeOfUP.getInstance(uP_InstallRequestEvent.getUpgradePackageMoExtended().getActivatedTypeOfUP(null));
            }
            object = this.prepareUCF(uP_InstallRequestEvent);
            InitUP_Information initUP_Information = new InitUP_Information(uP_InstallRequestEvent, (UP_AndLM_Information)object);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "initUP(UP_InstallRequestEvent anInstallRequestEvent)", "RETURNS - theInitUP_Information: " + initUP_Information);
            }
            return initUP_Information;
        }
        catch (UCF_ValidationException uCF_ValidationException) {
            throw uCF_ValidationException;
        }
        catch (InitiateException initiateException) {
            throw initiateException;
        }
        catch (ChecksumException checksumException) {
            throw new ChecksumException(checksumException.toString());
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw new ChecksumException(checksumHandlerException.toString());
        }
        catch (InstallException installException) {
            throw new InitiateException(installException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "initUP(UP_InstallRequestEvent anInstallRequestEvent)", "anInstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable caught.", throwable);
            throw new InitiateException(throwable.toString());
        }
    }

    private UP_AndLM_Information prepareUCF(UP_InstallRequestEvent uP_InstallRequestEvent) throws InstallException, ChecksumHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "prepareUCF(UP_InstallRequestEvent anUP_InstallRequestEvent)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            UpgradePackageControlFileTransformer upgradePackageControlFileTransformer = new UpgradePackageControlFileTransformer();
            UP_AndLM_Information uP_AndLM_Information = upgradePackageControlFileTransformer.prepareControlFile(uP_InstallRequestEvent.upgradePackageDocumentNumber, uP_InstallRequestEvent.upgradePackageDocumentRevision, uP_InstallRequestEvent.upgradePackageProductName, uP_InstallRequestEvent.upgradePackageProductionDate, uP_InstallRequestEvent.upgradePackageOriginalUCF_Path, uP_InstallRequestEvent.upgradePackageUCF_Path, uP_InstallRequestEvent.upgradePackageMO, uP_InstallRequestEvent.getRequestedTypeOfUP(), uP_InstallRequestEvent.ftpServerInformation.ftpServerUCF_Path);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "prepareUCF(InstallRequestEvent anUP_InstallRequestEvent)", "\n\tRETURNS (theUP_AndLM_Information): " + uP_AndLM_Information);
            }
            return uP_AndLM_Information;
        }
        catch (InstallException installException) {
            throw installException;
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw checksumHandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "prepareUCF(InstallRequestEvent anUP_InstallRequestEvent)", "At preparation of the UCF a Throwable was caught.\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable message: " + throwable, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\tMethod: prepareUCF(InstallRequestEvent anUP_InstallRequestEvent" + "\n\tAt preparation of the UCF a Throwable was caught." + "\n\tanUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\tThrowable message: " + throwable);
        }
    }

    private boolean isSU_ToBePreUpgradedFirstOfAll(InstallSequenceProxyInterface installSequenceProxyInterface, UpgradeLogicProxyInterface upgradeLogicProxyInterface, int n, boolean bl) throws InstallException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_ToBePreUpgradedFirstOfAll(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterface aToUpgradeLogicProxyInterface, int aFromSU_LogicCompatibilityIndex, boolean anIsOverrideForcedPreUpgrade)", "anInstallSequenceProxyInterface: " + installSequenceProxyInterface + "\n\taToUpgradeLogicProxyInterface: " + upgradeLogicProxyInterface + "\n\taFromSU_LogicCompatibilityIndex: " + n + "\n\tanIsOverrideForcedPreUpgrade: " + bl);
        }
        try {
            InstallStepInterface installStepInterface;
            OperationInterface operationInterface;
            boolean bl2 = false;
            if (installSequenceProxyInterface != null && n != -1 && (operationInterface = (installStepInterface = installSequenceProxyInterface.getFirstStep()).getOperation()) instanceof PreUpgradeSuInterface) {
                PreUpgradeSuInterface preUpgradeSuInterface = (PreUpgradeSuInterface)((Object)operationInterface);
                FromVersionHandler fromVersionHandler = new FromVersionHandler();
                bl2 = fromVersionHandler.isPreUpgradeSuRequired(n, 1, upgradeLogicProxyInterface.getCompatibilityIndex(), preUpgradeSuInterface.getPhase(), preUpgradeSuInterface.isForcedPreUpgrade(), bl);
                if (bl2) {
                    LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray;
                    Collection collection = upgradeLogicProxyInterface.getLoadModules();
                    LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
                    if (loadModuleMO_HandlerInterface.contains(loadModuleMoSU_AccessArray = ServiceFinder.getJvmMO_HandlerInterface().getAdmClassPath(), collection)) {
                        bl2 = false;
                    }
                }
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "isSU_ToBePreUpgradedFirstOfAll(FromVersionInformation aFromversionInformation, boolean anIsOverrideForcedPreUpgrade)", "RETURNS - theIsPreUpgradeOfSU_Required: " + bl2);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSU_ToBePreUpgradedFirstOfAll(FromVersionInformation aFromversionInformation, boolean anIsOverrideForcedPreUpgrade)", "anInstallSequenceProxyInterface: " + installSequenceProxyInterface + "\n\taFromSU_LogicCompatibilityIndex: " + n + "\n\tanIsOverrideForcedPreUpgrade: " + bl + "\n\tThrowable caught", throwable);
            throw new InstallException(throwable.toString());
        }
    }

    private boolean isSU_ToBePreUpgradedAtAll(InstallSequenceProxyInterface installSequenceProxyInterface, UpgradeLogicProxyInterface upgradeLogicProxyInterface, int n, int n2, boolean bl) throws InstallException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_ToBePreUpgradedAtAll(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterface aToUpgradeLogicProxyInterface, int aFromSU_LogicCompatibilityIndex, int aPreUpgradeState, boolean anIsOverrideForcedPreUpgrade)", "anInstallSequenceProxyInterface: " + installSequenceProxyInterface + "\n\taToUpgradeLogicProxyInterface: " + upgradeLogicProxyInterface + "\n\taFromSU_LogicCompatibilityIndex: " + n + "\n\taPreUpgradeState: " + n2 + "\n\tanIsOverrideForcedPreUpgrade: " + bl);
        }
        try {
            boolean bl2 = false;
            if (installSequenceProxyInterface != null && n2 != 2 && n != -1) {
                InstallStepInterface installStepInterface = installSequenceProxyInterface.getFirstStep();
                OperationInterface operationInterface = installStepInterface.getOperation();
                FromVersionHandler fromVersionHandler = new FromVersionHandler();
                PreUpgradeSuInterface preUpgradeSuInterface = null;
                if (operationInterface instanceof PreUpgradeSuInterface) {
                    preUpgradeSuInterface = (PreUpgradeSuInterface)((Object)operationInterface);
                    bl2 = fromVersionHandler.isPreUpgradeSuRequired(n, 1, upgradeLogicProxyInterface.getCompatibilityIndex(), preUpgradeSuInterface.getPhase(), preUpgradeSuInterface.isForcedPreUpgrade(), bl);
                    if (bl2) {
                        bl2 = this.isSU_LMsInClassPath(upgradeLogicProxyInterface);
                    }
                }
                if (!bl2) {
                    for (int i = 1; i < installSequenceProxyInterface.getNumberOfSteps(); ++i) {
                        if ((installStepInterface = installSequenceProxyInterface.getNextStep(installStepInterface.getLabel())) == null || !((operationInterface = installStepInterface.getOperation()) instanceof PreUpgradeSuInterface)) continue;
                        preUpgradeSuInterface = (PreUpgradeSuInterface)((Object)operationInterface);
                        bl2 = fromVersionHandler.isPreUpgradeSuRequired(n, 1, upgradeLogicProxyInterface.getCompatibilityIndex(), preUpgradeSuInterface.getPhase(), preUpgradeSuInterface.isForcedPreUpgrade(), bl);
                        if (!bl2) break;
                        bl2 = this.isSU_LMsInClassPath(upgradeLogicProxyInterface);
                        break;
                    }
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "isSU_ToBePreUpgradedAtAll(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterface aToUpgradeLogicProxyInterface, int aFromSU_LogicCompatibilityIndex, int aPreUpgradeState, boolean anIsOverrideForcedPreUpgrade)", "RETURNS - theIsPreUpgradeOfSU_Required: " + bl2);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSU_ToBePreUpgradedAtAll(InstallSequenceProxyInterface anInstallSequenceProxyInterface, UpgradeLogicProxyInterface aToUpgradeLogicProxyInterface, int aFromSU_LogicCompatibilityIndex, int aPreUpgradeState, boolean anIsOverrideForcedPreUpgrade)", "anInstallSequenceProxyInterface: " + installSequenceProxyInterface + "\n\taToUpgradeLogicProxyInterface: " + upgradeLogicProxyInterface + "\n\taFromSU_LogicCompatibilityIndex: " + n + "\n\taPreUpgradeState: " + n2 + "\n\tanIsOverrideForcedPreUpgrade: " + bl + "\n\tThrowable caught", throwable);
            throw new InstallException(throwable.toString());
        }
    }

    private boolean isSU_LMsInClassPath(UpgradeLogicProxyInterface upgradeLogicProxyInterface) throws InstallException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSU_LMsInClassPath(UpgradeLogicProxyInterface aToUpgradeLogicProxyInterface)", "aToUpgradeLogicProxyInterface: " + upgradeLogicProxyInterface);
        }
        try {
            Collection collection = upgradeLogicProxyInterface.getLoadModules();
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = ServiceFinder.getJvmMO_HandlerInterface().getAdmClassPath();
            return !loadModuleMO_HandlerInterface.contains(loadModuleMoSU_AccessArray, collection);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isSU_ToBePreUpgradedAtAll(UpgradeLogicProxyInterface aToUpgradeLogicProxyInterface)", "aToUpgradeLogicProxyInterface: " + upgradeLogicProxyInterface + "\n\tThrowable caught", throwable);
            throw new InstallException(throwable.toString());
        }
    }

    private void handleUcfConsistency(UP_InstallRequestEvent uP_InstallRequestEvent, boolean bl) throws ChecksumException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUcfConsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl);
        }
        UCF_ControlResultContainer uCF_ControlResultContainer = null;
        ChecksumHandler checksumHandler = new ChecksumHandler();
        try {
            uCF_ControlResultContainer = checksumHandler.checksumUCF(uP_InstallRequestEvent.getUpgradePackageMoExtended());
            if (!uCF_ControlResultContainer.isChecksumOK()) {
                this.handleUcfInconsistency(uP_InstallRequestEvent, bl, uCF_ControlResultContainer);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleUcfConsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Both UCF files are consistent for UP MO: " + uP_InstallRequestEvent.getUpgradePackageMoExtended().getLocalDistinguishedName());
            }
        }
        catch (ChecksumException checksumException) {
            throw checksumException;
        }
        catch (ChecksumHandlerException checksumHandlerException) {
            throw new ChecksumException("Failed to check the UCF consistency, ChecksumHandlerException caught. Exception info: " + checksumHandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleUcfConsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest)", "Failed to check the UCF consistency during install, Throwable caught.", throwable);
            throw new ChecksumException("Failed to check the UCF consistency, Throwable caught. Exception info: " + throwable.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleUcfInconsistency(UP_InstallRequestEvent uP_InstallRequestEvent, boolean bl, UCF_ControlResultContainer uCF_ControlResultContainer) throws ChecksumException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleUcfInconsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest, UCF_ControlResultContainer anUCF_ControlResultContainer)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent + "\n\taForcedInstallRequest: " + bl + "\n\tanUCF_ControlResultContainer: " + uCF_ControlResultContainer);
        }
        if (!uCF_ControlResultContainer.isUcfOrigFileChecksumOK()) {
            if (bl) {
                Trace.info(this.getClass(), "handleUcfInconsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest, UCF_ControlResultContainer anUCF_ControlResultContainer)", "The checksum of upgrade control file does not match the original at forced install. The file will be downloaded again from the ftp server. \n\tCorrupt UCF file: " + uCF_ControlResultContainer.getCalculatedChecksumUCF_OrigResultInformation().getFilePath());
                this.downloadOriginalUcfFromFtpServer(uP_InstallRequestEvent);
                return;
            }
            if (!Trace.valid(this.getClass(), 22)) throw new ChecksumException("The current checksum of the original upgrade control file does not match the stored checksum at install. \n\tFilepath: " + uCF_ControlResultContainer.getCalculatedChecksumUCF_OrigResultInformation().getFilePath() + "\n\tChecksum in DB: " + uCF_ControlResultContainer.getUCF_StoredOrigChecksum() + "\n\tCalculated checksum: " + uCF_ControlResultContainer.getUCF_CalculatedOrigChecksum());
            Trace.debug(this.getClass(), 22, "handleUcfInconsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest, UCF_ControlResultContainer anUCF_ControlResultContainer)", "The current checksum of the original upgrade control file does not match the stored checksum at forced install.\n\tanUCF_ControlResultContainer: " + uCF_ControlResultContainer);
            throw new ChecksumException("The current checksum of the original upgrade control file does not match the stored checksum at install. \n\tFilepath: " + uCF_ControlResultContainer.getCalculatedChecksumUCF_OrigResultInformation().getFilePath() + "\n\tChecksum in DB: " + uCF_ControlResultContainer.getUCF_StoredOrigChecksum() + "\n\tCalculated checksum: " + uCF_ControlResultContainer.getUCF_CalculatedOrigChecksum());
        }
        if (uCF_ControlResultContainer.isUcfFileChecksumOK()) {
            Trace.error(this.getClass(), "handleUcfInconsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest, UCF_ControlResultContainer anUCF_ControlResultContainer)", "The checksum of both UCF files are ok when the UCF_ControlResultContainer indicates that they are faulty (ignored)\n\tanUCF_ControlResultContainer: " + uCF_ControlResultContainer);
            return;
        }
        if (!uP_InstallRequestEvent.getRequestedTypeOfUP().isDelta()) {
            if (!bl) throw new ChecksumException("The current checksum of the upgrade control file does not match the stored checksum at install. Filepath: " + uCF_ControlResultContainer.getCalculatedChecksumUCFResultInformation().getFilePath() + "\n\tChecksum in DB: " + uCF_ControlResultContainer.getUCF_StoredChecksum() + "\n\tCalculated checksum: " + uCF_ControlResultContainer.getUCF_CalculatedChecksum());
            Trace.info(this.getClass(), "handleUcfInconsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest, UCF_ControlResultContainer anUCF_ControlResultContainer)", "The checksum of upgrade control file does not match the stored checksum at forced install. Replacing the file with a copy of the UCF original file. \n\tCorrupt UCF file: " + uCF_ControlResultContainer.getCalculatedChecksumUCFResultInformation().getFilePath());
            this.copyOriginalUcfToUcf(uP_InstallRequestEvent);
            return;
        }
        if (!Trace.valid(this.getClass(), 40)) return;
        Trace.debug(this.getClass(), 40, "handleUcfInconsistency(UP_InstallRequestEvent anUP_InstallRequestEvent, boolean aForcedInstallRequest, UCF_ControlResultContainer anUCF_ControlResultContainer)", "UcfOriginal consistent but UCF is not during install. Since UP is delta, the ucf will be recreated during merge, ignored.\n\tanUCF_ControlResultContainer: " + uCF_ControlResultContainer);
    }

    private void downloadOriginalUcfFromFtpServer(UP_InstallRequestEvent uP_InstallRequestEvent) throws ChecksumException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "downloadOriginalUcfFromFtpServer(UP_InstallRequestEvent anUP_InstallRequestEvent)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            File file = this.downloadTempUcfFileFromFtpServer(uP_InstallRequestEvent);
            if (!this.doesOriginalUcfChecksumMatch(file, uP_InstallRequestEvent.getUpgradePackageMoExtended())) {
                Trace.info(this.getClass(), "downloadOriginalUcfFromFtpServer(UP_InstallRequestEvent anUP_InstallRequestEvent)", "The checksum of the Upgrade Control File both on node and on the ftp server does not match the stored checksum.The UpgradePackage MO: " + uP_InstallRequestEvent.getUpgradePackageMoExtended());
                throw new ChecksumException("The checksum of the Upgrade Control File both on node and on the ftp server does not match the stored checksum.");
            }
            String string = uP_InstallRequestEvent.getUpgradePackageMoExtended().getOriginalUpgradeControlFilePath(null);
            this.copyFile(file, string);
            this.reOpenSuDomIfActiveUP(uP_InstallRequestEvent);
            Trace.info(this.getClass(), "downloadOriginalUcfFromFtpServer(UP_InstallRequestEvent anUP_InstallRequestEvent)", "A correct UCF file has been successfully downloaded from FTP server. UCF file: " + string);
        }
        catch (ChecksumException checksumException) {
            throw checksumException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "downloadOriginalUcfFromFtpServer(UP_InstallRequestEvent anUP_InstallRequestEvent)", "Throwable caught when trying to download ucf file from ftp server.", throwable);
            throw new ChecksumException("Throwable caught when trying to download ucf file from ftp server. Throwable: " + throwable.toString());
        }
    }

    private void reOpenSuDomIfActiveUP(UP_InstallRequestEvent uP_InstallRequestEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "reOpenSuDomIfActiveUP(UP_InstallRequestEvent anUP_InstallRequestEvent)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            UpgradePackageMoExtended upgradePackageMoExtended = ServiceFinder.getConfigurationVersionMO_HandlerInterface().getCurrentUpgradePackage(null);
            if (upgradePackageMoExtended != null && uP_InstallRequestEvent.getUpgradePackageMoExtended().getDocumentNumber(null).equals(upgradePackageMoExtended.getDocumentNumber(null)) && uP_InstallRequestEvent.getUpgradePackageMoExtended().getDocumentRevision(null).equals(upgradePackageMoExtended.getDocumentRevision(null))) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "reOpenSuDomIfActiveUP(UP_InstallRequestEvent anUP_InstallRequestEvent)", "Re-opening SU DOM for active UP: " + uP_InstallRequestEvent.getUpgradePackageMoExtended().getLocalDistinguishedName());
                }
                ProxySelectorInterface proxySelectorInterface = (ProxySelectorInterface)ServiceLocatorFacade.getRepository().getService(ProxySelectorInterface.class);
                proxySelectorInterface.reopenSUDOM();
            } else if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "reOpenSuDomIfActiveUP(UP_InstallRequestEvent anUP_InstallRequestEvent)", "Will not re-open SU DOM for non active UP: " + uP_InstallRequestEvent.getUpgradePackageMoExtended().getLocalDistinguishedName());
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "reOpenSuDomIfActiveUP(UP_InstallRequestEvent anUP_InstallRequestEvent)", "Failed to re-open SU DOM after attempt to correct corrupt Upgrade Control File, throwable caught. (Ignored for now)", throwable);
        }
    }

    private File downloadTempUcfFileFromFtpServer(UP_InstallRequestEvent uP_InstallRequestEvent) throws ChecksumException {
        SystemUpgradeConstantsInterface systemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);
        String string = systemUpgradeConstantsInterface.getNodeDefaultUCF_Path();
        try {
            File file = UpgradePackageCreator.getUpgradeControlFileFromFTP_Server(string, uP_InstallRequestEvent.getUpgradePackageMoExtended().getUpFilePathOnFtpServer(null), uP_InstallRequestEvent.getUpgradePackageMoExtended().getFtpServerIpAddress(null), uP_InstallRequestEvent.getUpgradePackageMoExtended().getUser(null), uP_InstallRequestEvent.getUpgradePackageMoExtended().getPwd());
            return file;
        }
        catch (FtpServerNotAccessibleException ftpServerNotAccessibleException) {
            throw new ChecksumException("Corrupt UCF original detected during install. Attempt to re-download the UCF file from FTP server failed. \n\tFtpServerNotAccessibleException caught when trying to download ucf file to temporary location from ftp server.\n\tException info: " + ftpServerNotAccessibleException.toString());
        }
        catch (GetFileException getFileException) {
            throw new ChecksumException("Corrupt UCF original detected during install. Attempt to re-download the UCF file from FTP server failed. \n\tGetFileException caught when trying to download ucf file to temporary location from ftp server.\n\tException info: " + getFileException.toString());
        }
        catch (IpAddressException ipAddressException) {
            throw new ChecksumException("Corrupt UCF original detected during install. Attempt to re-download the UCF file from FTP server failed. \n\tIpAddressException caught when trying to download ucf file to temporary location from ftp server.\n\tException info: " + ipAddressException.toString());
        }
        catch (FroRequestFailedException froRequestFailedException) {
            throw new ChecksumException("Corrupt UCF original detected during install. Attempt to re-download the UCF file from FTP server failed. \n\tFroRequestFailedException caught when trying to download ucf file to temporary location from ftp server.\n\tException info: " + froRequestFailedException.toString());
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            throw new ChecksumException("Corrupt UCF original detected during install. Attempt to re-download the UCF file from FTP server failed. \n\tFroNotAccessibleException caught when trying to download ucf file to temporary location from ftp server.\n\tException info: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "downloadTempUcfFileFromFtpServer(UP_InstallRequestEvent anUP_InstallRequestEvent)", "Throwable caught when trying to download ucf file to temporary location from ftp server.", throwable);
            throw new ChecksumException("Corrupt UCF original detected during install. Attempt to re-download the UCF file from FTP server failed. \n\tThrowable caught when trying to download ucf file to temporary location from ftp server.\n\tThrowable info: " + throwable.toString());
        }
    }

    private void copyOriginalUcfToUcf(UP_InstallRequestEvent uP_InstallRequestEvent) throws ChecksumException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyOriginalUcfToUcf(UP_InstallRequestEvent anUP_InstallRequestEvent)", "anUP_InstallRequestEvent: " + uP_InstallRequestEvent);
        }
        try {
            File file = new File(uP_InstallRequestEvent.getUpgradePackageMoExtended().getOriginalUpgradeControlFilePath(null));
            this.copyFile(file, uP_InstallRequestEvent.getUpgradePackageMoExtended().getUpgradeControlFilePath(null));
            this.reOpenSuDomIfActiveUP(uP_InstallRequestEvent);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyOriginalUcfToUcf(UP_InstallRequestEvent anUP_InstallRequestEvent)", "Throwable caught when trying to copy UcfOriginal to Ucf file.", throwable);
            throw new ChecksumException("Throwable caught when trying to copy UcfOriginal to Ucf file.Throwable: " + throwable.toString());
        }
    }

    private void copyFile(File file, String string) throws ChecksumException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyFile(File aFileToCopy, String aDestinationFilePath)", "aFileToCopy: " + file + "\n\taDestinationFilePath: " + string);
        }
        try {
            SuLib.copyUCF(file, new File(string));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyFile(File aFileToCopy, String aDestinationFilePath)", "Throwable caught when copying file.\n\taFileToCopy: " + file + "\n\taDestinationFilePath: " + string, throwable);
            throw new ChecksumException("Throwable caught when copying file. Throwable: " + throwable.toString());
        }
    }

    private boolean doesOriginalUcfChecksumMatch(File file, UpgradePackageMoExtended upgradePackageMoExtended) throws ChecksumException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "doesOriginalUcfChecksumMatch(File aTempUcfOriginalFile, UpgradePackageMoExtended anUpgradePackageMoExtended)", "aTempUcfOriginalFile: " + file + "\n\tanUpgradePackageMoExtended: " + upgradePackageMoExtended);
        }
        boolean bl = false;
        ChecksumHandler checksumHandler = new ChecksumHandler();
        try {
            ChecksumFileResultInterface checksumFileResultInterface = checksumHandler.checksumUCF(file.getAbsolutePath());
            bl = checksumFileResultInterface.getChecksum().equals(upgradePackageMoExtended.getOrigUcfChecksum(null));
            return bl;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "doesOriginalUcfChecksumMatch(File aTempUcfOriginalFile, UpgradePackageMoExtended anUpgradePackageMoExtended)", "Throwable caught when checking if checksum of downloaded file is ok.\n\taTempUcfOriginalFile: " + file + "\n\tanUpgradePackageMoExtended: " + upgradePackageMoExtended, throwable);
            throw new ChecksumException("Throwable caught when checking if checksum of downloaded file is ok. Throwable: " + throwable.toString());
        }
    }
}

