/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.main.info;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import se.ericsson.cello.configurationversion.util.mohandler.upgradepackage.UpgradePackageMO_HandlerException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUCF;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.parser.ParserFactoryException;
import se.ericsson.cello.sudom.parser.UpgradeControlFileNotFoundException;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.loadmodule.InstallLMInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.InstallSMInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.nodetypespecificpiutypelist.NodeTypeSpecificPiuTypeListsProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.BasedOnContainer;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.create.UpgradePackageCreator;
import se.ericsson.cello.upgradepackage.create.UpgradePackageShadowCreator;
import se.ericsson.cello.upgradepackage.create.UpgradePackageShadowData;
import se.ericsson.cello.upgradepackage.main.handler.file.LoadModuleFilePathHandler;
import se.ericsson.cello.upgradepackage.main.info.UpgradePackagesInfoContainer;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.enumer.RequestedTypeOfUP;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class UpgradePackagesInfoCollector {
    private UpgradePackagesInfoContainer myUpgradePackagesInfoContainer = null;
    private SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);

    public UpgradePackagesInfoContainer collectInfo() {
        this.myUpgradePackagesInfoContainer = new UpgradePackagesInfoContainer();
        this.checkIfAnyUPsExist();
        this.collectLoadModulesInfoAndShadowDatasFromControlFiles();
        this.collectLoadModulesFromJvm();
        this.collectLoadModulesFromDynClassPath();
        this.collectNotUsedLoadModuleMOs();
        return this.myUpgradePackagesInfoContainer;
    }

    private void checkIfAnyUPsExist() {
        MoIterator moIterator;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkIfAnyUPsExist()");
        }
        if ((moIterator = MoRepository.instance().lookupType("UpgradePackage")) != null && moIterator.hasMoreElements()) {
            this.myUpgradePackagesInfoContainer.setAnyUpMO_Exist(true);
        }
    }

    private void collectLoadModulesInfoAndShadowDatasFromControlFiles() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLoadModuleAndShadowDataFromControlFiles( )");
        }
        Collection collection = this.getAllUpgradePackagesOnDisk();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.collectLoadModuleInfoAndShadowDataFromControlFiles((String)iterator.next());
        }
    }

    private void collectLoadModulesFromJvm() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLoadModulesFromJvm()");
        }
        try {
            LoadModuleMoSU_Access[] loadModuleMoSU_AccessArray = ServiceFinder.getJvmMO_HandlerInterface().getAdmClassPath();
            String string = null;
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            for (int i = 0; i < loadModuleMoSU_AccessArray.length; ++i) {
                loadModuleMoSU_Access = loadModuleMoSU_AccessArray[i];
                string = ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5") ? this.createProductNumberRevisionString(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null)) : this.createProductNumberRevisionString(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)));
                this.myUpgradePackagesInfoContainer.addInfoForLoadModuleInClassPath(string, loadModuleMoSU_Access.getLoadModuleFilePath(null));
            }
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "collectLoadModulesFromJvm()", "Throwable caught: " + throwable);
        }
    }

    private void collectLoadModulesFromDynClassPath() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLoadModulesFromDynClassPath()");
        }
        try {
            Collection collection = ServiceFinder.getUpgradePackageMO_HandlerInterface().getLoadModulesInDynClassPath();
            String string = null;
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                string = ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5") ? this.createProductNumberRevisionString(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null)) : this.createProductNumberRevisionString(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)));
                this.myUpgradePackagesInfoContainer.addInfoForLoadModulesInDynClassPath(string, loadModuleMoSU_Access.getLoadModuleFilePath(null));
            }
        }
        catch (UpgradePackageMO_HandlerException upgradePackageMO_HandlerException) {
        }
        catch (Throwable throwable) {
            Trace.info(this.getClass(), "setLoadModuleFromDynClassPath()", "Throwable caught: " + throwable);
        }
    }

    private void collectNotUsedLoadModuleMOs() {
        MoIterator moIterator;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectNotUsedLoadModuleMOs()");
        }
        if ((moIterator = MoRepository.instance().lookupType("LoadModule")) != null) {
            try {
                while (moIterator.hasMoreElements()) {
                    this.addNotUsedLoadModuleMO((LoadModuleMoSU_Access)moIterator.nextElement());
                }
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "removeLoadModuleMOsIfNotNeeded()", "Exception caught when trying to delete LoadModules MOs that are not needed.\n\t(LoadModule MOs with fileState not installed and not included in any UCF.)", exception);
            }
        }
    }

    private void addNotUsedLoadModuleMO(LoadModuleMoSU_Access loadModuleMoSU_Access) {
        block10: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "addNotUsedLoadModuleMO(LoadModuleMoSU_Access aLoadModuleMo)", "aLoadModuleMo: " + loadModuleMoSU_Access.getLocalDistinguishedName());
            }
            try {
                String string = this.createLM_ProductNumberRevisionString(loadModuleMoSU_Access);
                string = ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5") ? this.createProductNumberRevisionString(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null)) : this.createProductNumberRevisionString(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)));
                if (!this.myUpgradePackagesInfoContainer.isIncludedInAnyLoadModuleList(string)) {
                    if (loadModuleMoSU_Access.getFileState(null) == 0) {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "addNotUsedLoadModuleMO(LoadModuleMoSU_Access aLoadModuleMo)", "LoadModules in UCFs, class path or dynamic class path does not contain this not installed LM: " + string + "\n\tAdding LoadModule MO to list of not used and not installed LoadModules : " + loadModuleMoSU_Access.getLocalDistinguishedName());
                        }
                        this.myUpgradePackagesInfoContainer.addNotInstalledLoadModuleMosNotUsed(loadModuleMoSU_Access);
                    } else {
                        if (Trace.valid(this.getClass(), 22)) {
                            Trace.debug(this.getClass(), 22, "addNotUsedLoadModuleMO(LoadModuleMoSU_Access aLoadModuleMo)", "LoadModules in UCFs, class path or dynamic class path does not contain this installed LM: " + string + "\n\tAdding LoadModule MO to list of not used but installed LoadModules : " + loadModuleMoSU_Access.getLocalDistinguishedName());
                        }
                        this.myUpgradePackagesInfoContainer.addInstalledLoadModuleMoNotUsed(loadModuleMoSU_Access);
                    }
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "addNotUsedLoadModuleMO(LoadModuleMoSU_Access aLoadModuleMo)", "LoadModules in UCFs, class path or dynamic class path contains installed LM: " + string + "\n\tIgnoring LoadModule : " + loadModuleMoSU_Access.getLocalDistinguishedName());
                }
            }
            catch (MoAccessException moAccessException) {
                if (!Trace.valid(this.getClass(), 20)) break block10;
                Trace.debug(this.getClass(), 20, "removeLoadModuleMO_IfNotNeeded(Coordinator context, LoadModuleMoSU_Access aLoadModuleMo)", "MoAccessException caught when checking if the LoadModule MO can be deleted.\n\taLoadModuleMo: " + loadModuleMoSU_Access.getLocalDistinguishedName() + "\n\tMoAccessException: " + (Object)((Object)moAccessException));
            }
        }
    }

    private void collectLoadModuleInfoAndShadowDataFromControlFiles(String string) {
        File file;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLoadModuleInfoAndShadowDataFromControlFiles(String anUpgradePackageDirectoryName)", "anUpgradePackageDirectoryName: " + string);
        }
        String string2 = this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + string + "/" + string + ".xml";
        File file2 = new File(string2);
        boolean bl = file2.exists();
        String string3 = string2 + "Original";
        File file3 = file = new File(string3);
        if (!bl && !file.exists()) {
            this.myUpgradePackagesInfoContainer.addDirWithoutUCFs(this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + string + "/");
            return;
        }
        if (!bl) {
            Trace.warning(this.getClass(), "collectLoadModuleInfoAndShadowDataFromControlFiles(String anUpgradePackageDirectoryName)", "The Upgrade Package does not have the UCF: " + string2);
        } else if (!file.exists()) {
            file3 = file2;
            Trace.warning(this.getClass(), "collectLoadModuleInfoAndShadowDataFromControlFiles(String anUpgradePackageDirectoryName)", "The Upgrade Package does not have the UCF: " + string3);
        }
        boolean bl2 = false;
        DocumentObjectProxyInterface documentObjectProxyInterface = null;
        try {
            Object object;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectLoadModuleInfoAndShadowDataFromControlFiles(String anUpgradePackageDirectoryName)", "before parse Upgrade Control File '" + this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + string + "/" + string + ".xml'");
            }
            ProductDataContainer productDataContainer = null;
            RequestedTypeOfUP requestedTypeOfUP = null;
            BasedOnContainer[] basedOnContainerArray = null;
            Object var13_15 = null;
            documentObjectProxyInterface = this.parseControlFile(file3);
            String string4 = this.getTypeOfUpgradePackage(documentObjectProxyInterface);
            if (string4.equals("Delta")) {
                if (bl) {
                    UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface.getProductDataProxyInterface().getNumberRaw(), documentObjectProxyInterface.getProductDataProxyInterface().getRevisionRaw());
                    documentObjectProxyInterface = this.parseControlFile(file2);
                }
                basedOnContainerArray = documentObjectProxyInterface.getBasedOnsProxyInterface().getBasedOns();
            } else {
                basedOnContainerArray = new BasedOnContainer[]{};
            }
            productDataContainer = documentObjectProxyInterface.getProductDataProxyInterface().getProductDataRaw();
            requestedTypeOfUP = this.getRequestedTypeOfUP(documentObjectProxyInterface);
            boolean bl3 = this.isNSI_ElementsPresent(documentObjectProxyInterface);
            if (!documentObjectProxyInterface.isObsoleteLmUP()) {
                if (this.myUpgradePackagesInfoContainer.isAllLM_InfoProperlyCollected()) {
                    object = documentObjectProxyInterface.getLoadModulesProxyInterface();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "collectLoadModuleInfoAndShadowDataFromControlFiles(String anUpgradePackageDirectoryName)", "myAllLM_InfoProperlyCollected = true. Appending: \n\ttheLMsDefinedInUCF: " + var13_15);
                    }
                    this.addToListOfLoadModulesInUCFs((LoadModulesProxyInterface)object);
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collectLoadModuleInfoAndShadowDataFromControlFiles(String anUpgradePackageDirectoryName)", "myAllLM_InfoProperlyCollected = false. NOT appending: \n\ttheLMsDefinedInUCF: " + var13_15);
                }
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collectLoadModuleInfoAndShadowDataFromControlFiles(String anUpgradePackageDirectoryName)", "The UCF " + file3 + " belongs to an ObsoleteLmUP (ignored when collecting LoadModule and shadow data)." + "\n\tUpdating ObsoleteLm UP prodData.");
                }
                this.myUpgradePackagesInfoContainer.setProductDataContainerForObsoleteUP(documentObjectProxyInterface.getProductDataProxyInterface().getProductDataRaw());
                bl2 = true;
            }
            object = new UpgradePackageShadowData(productDataContainer, basedOnContainerArray, file2, string4, requestedTypeOfUP, bl3, bl2);
            this.myUpgradePackagesInfoContainer.addUpgradePackageShadowData((UpgradePackageShadowData)object);
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "collectLoadModuleInfoAndShadowDataFromControlFiles(String anUpgradePackageDirectoryName)", "UpgradeControlFileParserException caught, setting myAllLM_InfoProperlyCollected to false.\n\tUpgradeControlFileParserException: " + upgradeControlFileParserException);
            }
            this.myUpgradePackagesInfoContainer.setAllLM_InfoNotProperlyCollected();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setLoadModuleAndShadowDataFromControlFile(String anUpgradePackageDirectoryName)", "Throwable caught when parsing the UCF file.\n\tanUpgradePackageDirectoryName: " + string + "\n\tThrowable: " + throwable);
            this.myUpgradePackagesInfoContainer.setAllLM_InfoNotProperlyCollected();
        }
    }

    private boolean isNSI_ElementsPresent(DocumentObjectProxyInterface documentObjectProxyInterface) throws UpgradeControlFileParserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isNSI_ElementsPresent(DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        try {
            NodeTypeSpecificPiuTypeListsProxyInterface nodeTypeSpecificPiuTypeListsProxyInterface = documentObjectProxyInterface.getNodeTypeSpecificPiuTypeListsProxyInterface();
            return !nodeTypeSpecificPiuTypeListsProxyInterface.getNodeTypeSpecificPiuTypeLists().isEmpty();
        }
        catch (Exception exception) {
            Trace.error(UpgradePackageShadowCreator.class, "isNSI_ElementsPresent(ParserKeyInformation aKey1)", "aDocumentObjectProxyInterface" + documentObjectProxyInterface + "\n\ttheException: " + exception, exception);
            throw new UpgradeControlFileParserException("The upgrade control file is probably faulty i.e. parsing of the file resulted in error.\n\ttheException: " + exception + "\n\tThe creation of the Upgrade Package MO is aborted.");
        }
    }

    private RequestedTypeOfUP getRequestedTypeOfUP(DocumentObjectProxyInterface documentObjectProxyInterface) throws UpgradeControlFileParserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRequestedTypeOfUP(DocumentObjectProxyInterface aDocumentObjectProxyInterface1)", "aDocumentObjectProxyInterface1: " + documentObjectProxyInterface);
        }
        try {
            TypeOfUCF typeOfUCF = documentObjectProxyInterface.getTypeOfUCF();
            RequestedTypeOfUP requestedTypeOfUP = UpgradePackageCreator.defineRequestedTypeOfUP(typeOfUCF);
            return requestedTypeOfUP;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getRequestedTypeOfUP(DocumentObjectProxyInterface aDocumentObjectProxyInterface1)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\ttheException: " + exception, exception);
            throw new UpgradeControlFileParserException("The upgrade control file is probably faulty i.e. parsing of the file resulted in error.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\ttheException: " + exception + "\n\tThe creation of the Upgrade Package MO is aborted.");
        }
    }

    public String getTypeOfUpgradePackage(DocumentObjectProxyInterface documentObjectProxyInterface) throws ParserFactoryException {
        String string;
        if (Trace.valid(UpgradePackageCreator.class, 20)) {
            Trace.debug(UpgradePackageCreator.class, 20, "getTypeOfUpgradePackage(DocumentObjectProxyInterface aDocumentObjectProxyInterface)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface);
        }
        string = (string = documentObjectProxyInterface.getType()) != null ? (string.equals("delta") ? "Delta" : (string.equals("selective") ? "Selective" : "Standard")) : "Standard";
        return string;
    }

    private void addToListOfLoadModulesInUCFs(LoadModulesProxyInterface loadModulesProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addToListOfLoadModulesInUCFs(LoadModulesProxyInterface theLoadModulesProxy)", "theLoadModulesProxy: " + loadModulesProxyInterface);
        }
        String string = null;
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        Iterator iterator = loadModulesProxyInterface.getLoadModuleProxyInterfaces().iterator();
        while (iterator.hasNext()) {
            loadModuleProxyInterface = (LoadModuleProxyInterface)iterator.next();
            string = this.createProductNumberRevisionString(loadModuleProxyInterface.getProductNumberRaw(), loadModuleProxyInterface.getProductRevisionRaw());
            this.myUpgradePackagesInfoContainer.addInfoForLoadModuleInUCF(string, this.collectAllFilePathsForLM_InUCF(loadModuleProxyInterface));
        }
    }

    private Collection collectAllFilePathsForLM_InUCF(LoadModuleProxyInterface loadModuleProxyInterface) {
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectAllFilePathsForLM_InUCF(LoadModuleProxyInterface aLoadModuleProxy)", "aLoadModuleProxy: " + loadModuleProxyInterface);
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        String string2 = loadModuleProxyInterface.getProductNumberRaw();
        String string3 = loadModuleProxyInterface.getProductRevisionRaw();
        InstallLMInterface installLMInterface = null;
        Iterator iterator = loadModuleProxyInterface.getInstallLMs().iterator();
        while (iterator.hasNext()) {
            installLMInterface = (InstallLMInterface)iterator.next();
            int n = -1;
            if (!installLMInterface.isDirectory() && installLMInterface.getDestFilePathName() != null && (n = installLMInterface.getDestFilePathName().lastIndexOf("/")) != -1) {
                object = installLMInterface.getDestFilePathName().substring(0, n + 1);
                hashSet.addAll(this.getSubDirectories((String)object));
            }
            string = LoadModuleFilePathHandler.getLoadModuleDestinationAbsolutePath(installLMInterface.getDestFilePathName(), string2, string3);
            hashSet.add(string);
        }
        InstallSMInterface installSMInterface = null;
        object = loadModuleProxyInterface.getInstallSMs().iterator();
        while (object.hasNext()) {
            installSMInterface = (InstallSMInterface)object.next();
            string = installSMInterface.getDestFilePathNameRef();
            if (string == null || string.length() == 0) {
                string = installLMInterface.getDestFilePathName();
            }
            string = LoadModuleFilePathHandler.getLoadModuleDestinationAbsolutePath(string, string2, string3);
            hashSet.add(string + "." + installSMInterface.getExtension());
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "collectAllFilePathsForLM_InUCF(LoadModuleProxyInterface aLoadModuleProxy)", "Returns - theAllFilePathsForLM_InUCF: " + hashSet);
        }
        return hashSet;
    }

    private Collection getSubDirectories(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        while (n != -1) {
            n = string.lastIndexOf("/");
            if (n == -1) continue;
            string = string.substring(0, n);
            hashSet.add(LoadModuleFilePathHandler.getLoadModuleDestinationAbsolutePath(string + "/", "", ""));
        }
        return hashSet;
    }

    public String createLM_ProductNumberRevisionString(LoadModuleMoSU_Access loadModuleMoSU_Access) throws MoAccessException {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "createLM_ProductNumberRevisionString(LoadModuleMoSU_Access aLoadModuleMo)", "aLoadModuleMo: " + loadModuleMoSU_Access);
        }
        String string = null;
        string = ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5") ? this.createProductNumberRevisionString(loadModuleMoSU_Access.getProductNumberOpt(null), loadModuleMoSU_Access.getProductRevisionOpt(null)) : this.createProductNumberRevisionString(StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)), StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)));
        return string;
    }

    private String createProductNumberRevisionString(String string, String string2) {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "createProductNumberRevisionString(String aProductNumber, String aRevision)", "aProductNumber: " + string + "\n\taRevision: " + string2);
        }
        return this.setToLowerCaseAndRemoveWhiteSpaces(string) + "_" + this.setToLowerCaseAndRemoveWhiteSpaces(string2);
    }

    private String setToLowerCaseAndRemoveWhiteSpaces(String string) {
        if (Trace.valid(this.getClass(), 23)) {
            Trace.debug(this.getClass(), 23, "setToLowerCaseAndRemoveWhiteSpaces(String aString)", "aString: " + string);
        }
        String string2 = "";
        if (string == null || string.length() == 0) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken();
        }
        return string2.toLowerCase();
    }

    private DocumentObjectProxyInterface parseControlFile(File file) throws UpgradeControlFileNotFoundException, UpgradeControlFileParserException {
        String string = "parseControlFileForShadow(File anUpgradeControlFile)";
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "parseControlFile(File anUpgradeControlFile)", "anUpgradeControlFile: " + file);
        }
        if (file == null) {
            Trace.error(this.getClass(), string, "The upgrade control file is not found.\n\tanUpgradeControlFile: null ");
            throw new UpgradeControlFileNotFoundException("The path to the UCF file is null");
        }
        try {
            String[] stringArray = new String[]{"BasedOn", "ProductData", "NodeTypeSpecificPiuTypeList", "LoadModule"};
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElementsNoSave(file.getAbsolutePath(), stringArray, false);
            return documentObjectProxyInterface;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            Trace.error(this.getClass(), string, "The upgrade control file parsing resulted in error.\n\tanUpgradeControlFile: " + SuLib.toString(file) + "\n\ttheUpgradeControlFileParserException: " + upgradeControlFileParserException.getMessage(), (Throwable)((Object)upgradeControlFileParserException));
            throw upgradeControlFileParserException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), string, "The upgrade control file is probably faulty i.e. parsing of the file resulted in error.\n\tanUpgradeControlFile: " + SuLib.toString(file) + "\n\ttheException: " + exception.getMessage(), exception);
            throw new UpgradeControlFileParserException("The upgrade control file is probably faulty i.e. parsing of the file resulted in error.\n\tanUpgradeControlFile: " + SuLib.toString(file) + "\n\ttheException: " + exception.getMessage() + "\n\tThe creation of the Upgrade Package MO is aborted.");
        }
    }

    private Collection getAllUpgradePackagesOnDisk() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllUpgradePackagesOnDisk()");
        }
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = this.getListOfUpgradePackageDirectory();
        if (stringArray == null) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getAllUpgradePackagesOnDisk()", "No files found in the upgrade package directory.");
            }
            this.myUpgradePackagesInfoContainer.setAllLM_InfoNotProperlyCollected();
        } else {
            File file = null;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    file = new File(this.mySystemUpgradeConstantsInterface.getNodeUpRootPath() + stringArray[i]);
                    if (!file.isDirectory()) continue;
                    hashSet.add(stringArray[i]);
                    continue;
                }
                catch (Throwable throwable) {
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "getAllUpgradePackagesOnDisk()", "Throwable caught when checking if the file is a directory.\n\tThe directory: " + stringArray[i] + "\n\tThrowable: " + throwable);
                    }
                    this.myUpgradePackagesInfoContainer.setAllLM_InfoNotProperlyCollected();
                }
            }
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllUpgradePackagesOnDisk()", "theUpgradePackageDirectoriesVector: " + hashSet);
        }
        return hashSet;
    }

    private String[] getListOfUpgradePackageDirectory() {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getListOfUpgradePackageDirectory()");
        }
        String[] stringArray = null;
        try {
            File file = new File(this.mySystemUpgradeConstantsInterface.getNodeUpRootPath());
            if (file.isDirectory()) {
                stringArray = file.list();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }
}

