/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.pmaue;

import se.ericsson.cello.pms.generic.PmsPortalImpl;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.upgradepackage.main.interfaces.TriggerCentral;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeParticipator;

public class PmAue
implements UpgradeParticipator,
Runnable {
    public static final String PARTICIPATOR_NAME = "CMA PmAue";
    public static final String TRIGGER_SUSPEND_PM = "SUSPEND_PM";
    public static final String TRIGGER_RESUME_PM = "RESUME_PM";
    private String trigger = null;
    private UpgradeMaster master = null;

    public void register() {
        TriggerCentral.instance().addUpgradeParticipator(this);
    }

    public String participatorName() {
        return PARTICIPATOR_NAME;
    }

    public void triggerIndicated(UpgradeMaster upgradeMaster, String string) {
        this.master = upgradeMaster;
        this.trigger = string;
        new Thread((Runnable)this, PARTICIPATOR_NAME).start();
    }

    public void run() {
        boolean bl = true;
        if (TRIGGER_SUSPEND_PM.equals(this.trigger)) {
            bl = this.suspendPm();
        } else if (TRIGGER_RESUME_PM.equals(this.trigger)) {
            bl = this.resumePm();
        }
        this.master.triggerConfirmed(this, this.trigger, bl);
    }

    private boolean suspendPm() {
        boolean bl = false;
        try {
            PmsPortalImpl.getPortal().suspendPerformanceMonitorings();
            bl = true;
            MessageLog.info(this.getClass(), (String)"PM is now System Suspended.");
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Unable to suspend PM", (Throwable)exception);
        }
        return bl;
    }

    private boolean resumePm() {
        boolean bl = false;
        try {
            PmsPortalImpl.getPortal().resumePerformanceMonitorings();
            bl = true;
            MessageLog.info(this.getClass(), (String)"PM is no longer System Suspended.");
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), (String)"Unable to resume PM", (Throwable)exception);
        }
        return bl;
    }
}

