/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace.datacontainer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.property.PropertyChangeSupport;
import se.ericsson.cello.upgradepackage.trace.TraceConstants;
import se.ericsson.cello.upgradepackage.trace.validate.TraceAttributeValidator;
import se.ericsson.cello.upgradepackage.trace.writers.TraceTE_LogWriter;
import se.ericsson.cello.upgradepackage.util.enumer.NotifyingTracePropertyName;

public class TraceInfoDataContainer {
    private PropertyChangeSupport myPropertyChangeSupport = null;
    private String mySU_VersionString = "SU_SW: 1..35:stable-185:1..1-2 C16.2-LSV185-2 MPServicesOnDP - INIT";
    private HashSet myActiveClasses = new HashSet();
    private HashSet myActiveFunctions = new HashSet();
    private Collection myActiveFunctionClasses = new HashSet();
    private int myLevel = 2;
    private int myTypeOfStorage = 0;
    private int mySendLogsAsNotifications = 0;
    private int myOutputMode = 0;
    private String myFileName = "Trace.log";
    private int myFileSize = 2000;
    private int myFlushInterval = 3;
    private HashSet myLevelsSU = new HashSet();
    private TreeMap myActiveMethodsSU = new TreeMap();
    private boolean myDisableInfoAndLog = false;
    private int myBufferSize = 40000;
    private int myInactivityTimeout = 2000;
    private Boolean myUpgradeTraceMoLoaded = Boolean.FALSE;
    private boolean myIsOneClickUpgrade = false;

    public TraceInfoDataContainer() {
        this.myPropertyChangeSupport = new PropertyChangeSupport((Object)this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        try {
            this.myPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(TraceInfoDataContainer.class, "addPropertyChangeListener(PropertyChangeListener aPropertyChangeListener)", "\n\taPropertyChangeListener: " + propertyChangeListener + "\n\tThrowable caught.", throwable);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        try {
            this.myPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
        catch (Throwable throwable) {
            TraceTE_LogWriter.teLogError(TraceInfoDataContainer.class, "removePropertyChangeListener(PropertyChangeListener aPropertyChangeListener)", "\n\taPropertyChangeListener: " + propertyChangeListener + "\n\tThrowable caught.", throwable);
        }
    }

    private void firePropertyChange(NotifyingTracePropertyName notifyingTracePropertyName, Object object, Object object2) {
        try {
            if (this.myPropertyChangeSupport.hasListeners(notifyingTracePropertyName.getValue())) {
                this.myPropertyChangeSupport.firePropertyChange(notifyingTracePropertyName.getValue(), object, object2);
            }
        }
        catch (Exception exception) {
            TraceTE_LogWriter.teLogError(TraceInfoDataContainer.class, "firePropertyChange(NotifyingTracePropertyName aNotifyingTracePropertyName, Object anOldValue, Object aNewValue)", "aNotifyingTracePropertyName: " + notifyingTracePropertyName + "\n\tanOldValue: " + object + "\n\taNewValue: " + object2 + "\n\tException caught.", exception);
        }
    }

    public HashSet getActiveClasses() {
        return this.myActiveClasses;
    }

    public String[] getActiveClassesStringArray() {
        String[] stringArray = new String[this.myActiveClasses.size()];
        Iterator iterator = this.myActiveClasses.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public void setActiveClasses(HashSet hashSet) {
        HashSet hashSet2 = (HashSet)this.myActiveClasses.clone();
        this.myActiveClasses = (HashSet)hashSet.clone();
        this.firePropertyChange(NotifyingTracePropertyName.ActiveClasses, hashSet2, this.myActiveClasses);
    }

    public void addActiveClasses(HashSet hashSet) {
        HashSet hashSet2 = (HashSet)this.myActiveClasses.clone();
        this.myActiveClasses.addAll(hashSet);
        this.firePropertyChange(NotifyingTracePropertyName.ActiveClasses, hashSet2, this.myActiveClasses);
    }

    public void removeActiveClasses(HashSet hashSet) {
        HashSet hashSet2 = (HashSet)this.myActiveClasses.clone();
        this.myActiveClasses.removeAll(hashSet);
        this.firePropertyChange(NotifyingTracePropertyName.ActiveClasses, hashSet2, this.myActiveClasses);
    }

    public HashSet getActiveFunctions() {
        return this.myActiveFunctions;
    }

    public int[] getActiveFunctionsIntArray() {
        int[] nArray = new int[this.myActiveFunctions.size()];
        Iterator iterator = this.myActiveFunctions.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            nArray[n] = (Integer)iterator.next();
            ++n;
        }
        return nArray;
    }

    public void setActiveFunctions(HashSet hashSet) {
        HashSet hashSet2 = (HashSet)this.myActiveFunctions.clone();
        this.myActiveFunctions = (HashSet)hashSet.clone();
        this.firePropertyChange(NotifyingTracePropertyName.ActiveFunctions, hashSet2, this.myActiveFunctions);
        this.updateActiveFunctionClasses();
    }

    public void addActiveFunctions(HashSet hashSet) {
        HashSet hashSet2 = (HashSet)this.myActiveFunctions.clone();
        this.myActiveFunctions.addAll(hashSet);
        this.firePropertyChange(NotifyingTracePropertyName.ActiveFunctions, hashSet2, this.myActiveFunctions);
        this.updateActiveFunctionClasses();
    }

    private void updateActiveFunctionClasses() {
        this.myActiveFunctionClasses = new Vector(1);
        Iterator iterator = this.myActiveFunctions.iterator();
        while (iterator.hasNext()) {
            this.myActiveFunctionClasses.addAll(this.getFunctionIncludeClasses((Integer)iterator.next()));
        }
    }

    public void removeActiveFunctions(HashSet hashSet) {
        HashSet hashSet2 = (HashSet)this.myActiveFunctions.clone();
        this.myActiveFunctions.removeAll(hashSet);
        this.firePropertyChange(NotifyingTracePropertyName.ActiveFunctions, hashSet2, this.myActiveFunctions);
        this.updateActiveFunctionClasses();
    }

    public Collection getActiveFunctionClasses() {
        return this.myActiveFunctionClasses;
    }

    public int getLevel() {
        return this.myLevel;
    }

    public void setLevel(int n) {
        Integer n2 = new Integer(this.myLevel);
        this.myLevel = n;
        Integer n3 = new Integer(this.myLevel);
        this.firePropertyChange(NotifyingTracePropertyName.Level, n2, n3);
    }

    public int getTypeOfStorage() {
        return this.myTypeOfStorage;
    }

    public void setTypeOfStorage(int n) {
        Integer n2 = new Integer(this.myTypeOfStorage);
        this.myTypeOfStorage = n;
        Integer n3 = new Integer(this.myTypeOfStorage);
        this.firePropertyChange(NotifyingTracePropertyName.TypeOfStorage, n2, n3);
    }

    public int getSendLogsAsNotifications() {
        return this.mySendLogsAsNotifications;
    }

    public void setSendLogsAsNotifications(int n) {
        Integer n2 = new Integer(this.mySendLogsAsNotifications);
        this.mySendLogsAsNotifications = n;
        Integer n3 = new Integer(this.mySendLogsAsNotifications);
        this.firePropertyChange(NotifyingTracePropertyName.SendLogsAsNotifications, n2, n3);
    }

    public int getBufferSize() {
        return this.myBufferSize;
    }

    public void setBufferSize(int n) {
        this.myBufferSize = n;
    }

    public int getInactivityTimeout() {
        return this.myInactivityTimeout;
    }

    public void setInactivityTimeout(int n) {
        this.myInactivityTimeout = n;
    }

    public HashSet getLevelsSU() {
        return this.myLevelsSU;
    }

    public void setLevelsSU(HashSet hashSet) {
        HashSet hashSet2 = (HashSet)this.myLevelsSU.clone();
        this.myLevelsSU = (HashSet)hashSet.clone();
        this.firePropertyChange(NotifyingTracePropertyName.LevelsSU, hashSet2, this.myLevelsSU);
    }

    public int getOutputMode() {
        return this.myOutputMode;
    }

    public void setOutputMode(int n) {
        this.setOutputMode(n, true);
    }

    public void setOutputMode(int n, boolean bl) {
        Integer n2 = new Integer(this.myOutputMode);
        this.myOutputMode = n;
        Integer n3 = new Integer(this.myOutputMode);
        if (bl) {
            this.firePropertyChange(NotifyingTracePropertyName.OutputMode, n2, n3);
        }
    }

    public String getFileName() {
        return this.getFileName(true);
    }

    public String getFileName(boolean bl) {
        int n;
        String string = this.myFileName;
        if (bl && this.getOutputMode() == 3 && (n = this.myFileName.indexOf(".")) != -1) {
            string = this.myFileName.substring(0, n);
            string = string + ".txt";
        }
        return string;
    }

    public void setFileName(String string) {
        String string2 = this.myFileName;
        this.myFileName = string;
        this.firePropertyChange(NotifyingTracePropertyName.FileName, string2, this.myFileName);
    }

    public int getFileSize() {
        return this.myFileSize;
    }

    public void setFileSize(int n) {
        Integer n2 = new Integer(this.myFileSize);
        this.myFileSize = n;
        Integer n3 = new Integer(this.myFileSize);
        this.firePropertyChange(NotifyingTracePropertyName.FileSize, n2, n3);
    }

    public int getFlushInterval() {
        return this.myFlushInterval;
    }

    public void setFlushInterval(int n) {
        Integer n2 = new Integer(this.myFlushInterval);
        this.myFlushInterval = n;
        Integer n3 = new Integer(this.myFlushInterval);
        this.firePropertyChange(NotifyingTracePropertyName.FlushInterval, n2, n3);
    }

    public String getSU_VersionString() {
        return this.mySU_VersionString;
    }

    public void setSU_VersionString(String string) {
        this.mySU_VersionString = string;
    }

    public TreeMap getActiveMethodsSU() {
        return this.myActiveMethodsSU;
    }

    public void setActiveMethodsSU(TreeMap treeMap) {
        TreeMap treeMap2 = (TreeMap)this.myActiveMethodsSU.clone();
        this.myActiveMethodsSU = treeMap;
        this.firePropertyChange(NotifyingTracePropertyName.ActiveMethodsSU, treeMap2, this.myActiveMethodsSU);
    }

    public boolean getDisableInfoAndLogSU() {
        return this.myDisableInfoAndLog;
    }

    public void setDisableInfoAndLogSU(boolean bl) {
        this.myDisableInfoAndLog = bl;
    }

    public boolean isOneClickUpgrade() {
        return this.myIsOneClickUpgrade;
    }

    public void setOneClickUpgrade(boolean bl) {
        Boolean bl2 = this.myIsOneClickUpgrade;
        this.myIsOneClickUpgrade = bl;
        Boolean bl3 = this.myIsOneClickUpgrade;
        this.firePropertyChange(NotifyingTracePropertyName.OneClickUpgrade, bl2, bl3);
    }

    public String getTraceDirectoryPath() {
        String string = "";
        if (this.getOutputMode() == 3) {
            string = TraceConstants.DEFAULT_LOGSERVICE_TRACE_PATH_NAME + "/";
        } else if (this.getOutputMode() == 0) {
            string = TraceConstants.TRACE_FILE_PATH_NAME;
        }
        return string;
    }

    public String getLogString() {
        String string = "\n\tCurrent properties for System Upgrade trace functionality:\n\tActive classes: " + this.convertCollectionToLogString(this.getActiveClasses()) + "\n\tActive functions: " + this.convertCollectionToLogString(this.getActiveFunctions()) + "\n\tActive function classes: " + this.convertCollectionToLogString(this.getActiveFunctionClasses()) + "\n\tMaximum trace log file size: " + this.getFileSize() + " (kB)" + "\n\tNumber of trace logs before flush: " + this.getFlushInterval() + "\n\tTrace level: " + this.getLevel() + "\n\tOutput mode: " + this.getOutputModeAsString(this.getOutputMode()) + "\n\tSend Logs As Notifications: " + this.getSendLogsAsNotificationsAsString(this.getSendLogsAsNotifications()) + "\n\tTrace file name: " + this.getFileName() + "\n\tTrace file directory path: " + this.getTraceDirectoryPath() + "\n\tType of storage: " + this.getTypeOfStorageAsString(this.getTypeOfStorage());
        if (!this.getLevelsSU().isEmpty()) {
            string = string + "\n\tLevelsSU: " + TraceAttributeValidator.convertLevelsSU_Collection(this.getLevelsSU());
        }
        return string;
    }

    public void updateAllAttributes(TraceInfoDataContainer traceInfoDataContainer) {
        this.setTypeOfStorage(traceInfoDataContainer.getTypeOfStorage());
        this.setActiveClasses((HashSet)traceInfoDataContainer.getActiveClasses().clone());
        this.setActiveFunctions((HashSet)traceInfoDataContainer.getActiveFunctions().clone());
        this.setLevel(traceInfoDataContainer.getLevel());
        this.setSendLogsAsNotifications(traceInfoDataContainer.getSendLogsAsNotifications());
        this.setFileName(traceInfoDataContainer.getFileName(false));
        this.setFileSize(traceInfoDataContainer.getFileSize());
        this.setFlushInterval(traceInfoDataContainer.getFlushInterval());
        this.setOutputMode(traceInfoDataContainer.getOutputMode());
        this.setLevelsSU((HashSet)traceInfoDataContainer.getLevelsSU().clone());
        this.setActiveMethodsSU((TreeMap)traceInfoDataContainer.getActiveMethodsSU().clone());
        this.setDisableInfoAndLogSU(traceInfoDataContainer.getDisableInfoAndLogSU());
        this.setBufferSize(traceInfoDataContainer.getBufferSize());
        this.setInactivityTimeout(traceInfoDataContainer.getInactivityTimeout());
        this.setOneClickUpgrade(traceInfoDataContainer.isOneClickUpgrade());
    }

    public boolean isUpgradeTraceMoLoaded() {
        return this.myUpgradeTraceMoLoaded;
    }

    public void setUpgradeTraceMoLoaded(Boolean bl) {
        Boolean bl2 = this.myUpgradeTraceMoLoaded;
        this.myUpgradeTraceMoLoaded = bl;
        this.firePropertyChange(NotifyingTracePropertyName.UpgradeTraceMoLoaded, bl2, this.myUpgradeTraceMoLoaded);
    }

    private String convertCollectionToLogString(Collection collection) {
        String string = "";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!string.equals("")) {
                string = string + ",";
            }
            Object e = iterator.next();
            string = string + e;
        }
        return string;
    }

    public String getOutputModeAsString() {
        return this.getOutputModeAsString(this.getOutputMode());
    }

    public String getOutputModeAsString(int n) {
        if (n == 2) {
            return n + " (TE_LOG)";
        }
        if (n == 1) {
            return n + " (SERIAL_PORT)";
        }
        if (n == 0) {
            return n + " (FILE)";
        }
        if (n == 10) {
            return n + " (AVC_ONLY, unsupported)";
        }
        if (n == 3) {
            return n + " (LOG_SERVICE)";
        }
        return n + " (UNKNOWN VALUE)";
    }

    public String getSendLogsAsNotificationsAsString(int n) {
        if (n == 0) {
            return n + " (DISABLED)";
        }
        if (n == 1) {
            return n + " (ENABLED_WITH_LIMITATIONS)";
        }
        if (n == 2) {
            return n + " (FULLY_ENABLED)";
        }
        return n + " (UNKNOWN VALUE)";
    }

    private String getTypeOfStorageAsString(int n) {
        if (n == 0) {
            return n + " (NON_PERSISTENT)";
        }
        if (n == 1) {
            return n + " (DATABASE)";
        }
        if (n == 2) {
            return n + " (FILE)";
        }
        return n + " (UNKNOWN VALUE)";
    }

    private Collection getFunctionIncludeClasses(int n) {
        Collection<String> collection = Collections.synchronizedCollection(new HashSet());
        collection.add("");
        switch (n) {
            case 0: {
                collection.add("UpgradePackageCreator");
                collection.add("UpgradePackageMoImpl");
                break;
            }
            case 1: {
                collection.add("UpgradePackageShadowCreator");
                collection.add("UpgradePackageMoImpl");
                break;
            }
            case 2: {
                collection.add("FileInstaller");
                collection.add("FileInstallerNotifier");
                collection.add("InstallCoordinator");
                collection.add("InstallHandler");
                collection.add("UpgradePackageInstaller");
                collection.add("UpgradePackageMoImpl");
                break;
            }
            case 3: {
                collection.add("UpgradePackageRemover");
                collection.add("UpgradePackageMoImpl");
                break;
            }
            case 4: {
                collection.add("VerifyUpgradeHandler");
                collection.add("Verifier");
                collection.add("DocumentObjectProxy");
                break;
            }
            case 5: {
                collection.add("VerifyUpgradeHandler");
                collection.add("Verifier");
                collection.add("UpgradeSequenceProxyInterface");
                collection.add("ConfigurationVersionMO_Handler");
                break;
            }
            case 6: {
                collection.add("VerifyUpgradeHandler");
                collection.add("Verifier");
                collection.add("UpgradeablePIU_Handler");
                break;
            }
            case 7: {
                collection.add("VerifyUpgradeHandler");
                collection.add("Verifier");
                collection.add("ChecksumHandler");
                break;
            }
            case 8: {
                collection.add("VerifyUpgradeHandler");
                collection.add("Verifier");
                collection.add("UpgradeablePIU_Handler");
                break;
            }
            case 9: {
                collection.add("ReplaceConfigSupportMOsOp");
                collection.add("SwAllocationMO_Handler");
                collection.add("RepertoireMO_Handler");
                break;
            }
            case 10: {
                collection.add("ReplaceConfigSupportMOsOp");
                collection.add("PIU_MO_Handler");
                collection.add("PiuTypeMO_Handler");
                collection.add("SwAllocationMO_Handler");
                break;
            }
            case 11: {
                collection.add("ReplaceConfigSupportMOsOp");
                collection.add("ReliableProgramUniterMoImpl");
                break;
            }
            case 12: {
                collection.add("ProgramMO_Handler");
                break;
            }
            case 13: {
                collection.add("ManagedElementMO_Handler");
                collection.add("UpgradePackageUpgrader");
                collection.add("WebServerMoImpl");
                collection.add("UpgradePackageMoImpl");
                break;
            }
            case 14: {
                collection.add("ProgramMO_Handler");
                break;
            }
            case 15: {
                collection.add("UpgradeCoordinator");
                collection.add("TriggerCentralHandler");
                collection.add("TriggerFacade");
                collection.add("TriggerNotifier");
                collection.add("UpiTriggerSender");
                collection.add("TriggerCentral");
                break;
            }
            case 16: {
                collection.add("ConfigurationVersionMO_Handler");
                collection.add("ConfigurationVersionMoExtension");
                break;
            }
            case 17: {
                collection.add("RebootNodeUpgradeOp");
                break;
            }
            case 18: {
                collection.add("RebootJvmUpgradeOp");
                break;
            }
            case 19: {
                collection.add("LockRestartOp");
                collection.add("PIU_AdmStateHandler");
                collection.add("UnlockAndWaitOp");
                collection.add("WaitForActionOp");
                collection.add("WaitForLockedOp");
                break;
            }
            case 20: {
                collection.add("SoftActionSwitchOp");
                collection.add("SoftIteratListHandler");
                collection.add("SoftRpuProgramForSwitchOverHelper");
                collection.add("SoftSendAllUnswitchedProgramOp");
                collection.add("SoftStartImmediateOP");
                collection.add("SoftStopImmediateOP");
                collection.add("SoftUnreliableStartImmediateOP");
                collection.add("SoftUnreliableStopImmediateOP");
                collection.add("UpgradeCreateRealOperationSoft");
                collection.add("WaitForSoftOperationModeSwitchedOverListOp");
                collection.add("WaitForSoftOperationModeSwitchedOverOp");
                collection.add("WaitForSoftOperationStateOP");
                break;
            }
            case 21: {
                collection.add("AutoCreateMos");
                collection.add("SlotMoImpl");
                break;
            }
            case 22: {
                collection.add("AutoCreateFanMo");
                collection.add("FanMoImpl");
                break;
            }
        }
        return collection;
    }
}

