/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade;

import java.util.Iterator;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.subrackprodtype.FanConfigurationValue;
import se.ericsson.cello.sudom.proxy.subrackprodtype.SubrackProdTypeProxyInterface;
import se.ericsson.cello.sudom.proxy.subrackprodtype.SubrackProdTypesProxyInterface;
import se.ericsson.cello.sudom.proxy.subrackprodtype.TransmissionTypeValue;
import se.ericsson.cello.sudom.proxy.transform.TransformProxyInterface;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class UpdateAttributesInSubrackProdType {
    private String myUCF_Path = null;
    private String myUP_ProdNo = null;
    private String myUP_ProdRev = null;

    public UpdateAttributesInSubrackProdType(String string, String string2, String string3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpdateAttributesInSubrackProdType(String anUP_ProdNo, String anUP_ProdRev, String anUCF_Path)", "anUCF_Path: " + string3);
        }
        this.myUP_ProdNo = string;
        this.myUP_ProdRev = string2;
        this.myUCF_Path = string3;
    }

    public boolean doUpdateAttributes() {
        try {
            if (ServiceFinder.getSubrackProdTypeMO_HandlerInterface().isSU_VersionSupported("SU_4") && ServiceFinder.getSubrackProdTypeMO_HandlerInterface().isSubrackProdTypeMOsDependentOnSU_DOM()) {
                return true;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "doUpdateAttributes()", "Update SubrackProdType MO's with data from the Upgrade Control File (UCF).");
            }
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(this.myUP_ProdNo, this.myUP_ProdRev, this.myUCF_Path, "SubrackProdType");
            SubrackProdTypesProxyInterface subrackProdTypesProxyInterface = documentObjectProxyInterface.getSubrackProdTypesProxyInterface();
            ProductNumbersAndRevisions productNumbersAndRevisions = subrackProdTypesProxyInterface.getProductNumberAndRevisionOfSubrackProdTypes();
            return this.updateAttributesInAllSubrackProdTypes(productNumbersAndRevisions, subrackProdTypesProxyInterface, documentObjectProxyInterface.getTransformProxyInterface());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "doUpdateAttributes( )", "myUCF_Path: " + this.myUCF_Path, throwable);
            return false;
        }
    }

    private boolean updateAttributesInAllSubrackProdTypes(ProductNumbersAndRevisions productNumbersAndRevisions, SubrackProdTypesProxyInterface subrackProdTypesProxyInterface, TransformProxyInterface transformProxyInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateAttributesInAllSubrackProdTypes(ProductNumbersAndRevisions aProductNumbersAndRevisions, SubrackProdTypesProxyInterface aSubrackProdTypesProxyInterface,TransformProxyInterface aTransformProxyInterface)", "aProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\taaSubrackProdTypesProxyInterface: " + subrackProdTypesProxyInterface + "\n\taTransformProxyInterface: " + transformProxyInterface);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            Iterator iterator = productNumbersAndRevisions.getElements().iterator();
            SubrackProdTypeProxyInterface subrackProdTypeProxyInterface = null;
            ProductNumberAndRevision productNumberAndRevision = null;
            SubrackProdTypeMO_HandlerInterface subrackProdTypeMO_HandlerInterface = ServiceFinder.getSubrackProdTypeMO_HandlerInterface();
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                subrackProdTypeProxyInterface = subrackProdTypesProxyInterface.getSubrackProdTypeProxyInterface(productNumberAndRevision);
                FanConfigurationValue fanConfigurationValue = subrackProdTypeProxyInterface.getFanConfiguration();
                TransmissionTypeValue transmissionTypeValue = subrackProdTypeProxyInterface.getTransmissionType();
                if (fanConfigurationValue.getValue() == FanConfigurationValue.CAX_TWO.getValue() && !subrackProdTypeMO_HandlerInterface.isSU_VersionSupported("SU_3")) {
                    fanConfigurationValue = subrackProdTypeProxyInterface.getTransformedFanConfiguration(transformProxyInterface);
                }
                if (transmissionTypeValue.getValue() == TransmissionTypeValue.ETHERNET_1G_10G_40G.getValue() && !subrackProdTypeMO_HandlerInterface.isSU_VersionSupported("SU_3")) {
                    transmissionTypeValue = subrackProdTypeProxyInterface.getTransformedTransmissionType(transformProxyInterface);
                }
                AttrListImpl attrListImpl = new AttrListImpl(5);
                attrListImpl.addElement("fanConfiguration", (Object)fanConfigurationValue.getIntegerValue());
                attrListImpl.addElement("transmissionType", (Object)transmissionTypeValue.getIntegerValue());
                attrListImpl.addElement("defNumberOfSlots", (Object)subrackProdTypeProxyInterface.getDefNumberOfSlots());
                attrListImpl.addElement("maxPowerDissipation", (Object)subrackProdTypeProxyInterface.getMaxPowerDissipation());
                Struct struct = subrackProdTypeMO_HandlerInterface.getBoardPositions(subrackProdTypeProxyInterface);
                attrListImpl.addElement("boardPositions", (Object)struct);
                subrackProdTypeMO_HandlerInterface.updateAttributesInSubrackProdType(productNumberAndRevision, attrListImpl, coordinator);
            }
            Transaction.commit(control);
            return true;
        }
        catch (SubrackProdTypeMO_HandlerException subrackProdTypeMO_HandlerException) {
            if (control != null) {
                Transaction.rollback(control);
            }
            return false;
        }
        catch (Throwable throwable) {
            if (control != null) {
                Transaction.rollback(control);
            }
            Trace.error(this.getClass(), "updateAttributesInAllSubrackProdTypes(ProductNumbersAndRevisions aProductNumbersAndRevisions, SubrackProdTypesProxyInterface aSubrackProdTypesProxyInterface)", "Throwable caught.\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\taSubrackProdTypesProxyInterface: " + subrackProdTypesProxyInterface, throwable);
            return false;
        }
    }
}

