/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.util.mohandler.subrack;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackProdTypeMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoFactoryMgr;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.replaceconfigsupportmos.SubrackInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.SubrackDataContainer;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.subrack.SubrackMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeData;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeInformation;
import se.ericsson.cello.upgradepackage.util.mohandler.subrackprodtype.SubrackProdTypeInformations;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class SubrackMO_Handler
implements SubrackMO_HandlerInterface {
    public static final String EMPTY_STRING = "";

    public SubrackMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
    }

    public SubrackMoSU_Access getSubrackMo(SlotMoSU_Access slotMoSU_Access) {
        return (SubrackMoSU_Access)slotMoSU_Access.getParent();
    }

    public int getSMN(SlotMoSU_Access slotMoSU_Access) throws SubrackMO_HandlerException {
        try {
            return this.getSubrackMo(slotMoSU_Access).getSwitchModuleNumber(null);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSMN(SlotMoSU_Access aSlotMo)", "Throwable caught.", throwable);
            throw new SubrackMO_HandlerException(throwable.toString());
        }
    }

    public Collection getMatchingSubrackMos(Collection collection, SubrackProdTypeInformation subrackProdTypeInformation) throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMatchingSubrackMos(Collection anAllSubrackMos, SubrackProdTypeInformation aSubrackProdTypeInformation)", "anAllSubrackMos: " + collection + "\n\taSubrackProdTypeInformation: " + subrackProdTypeInformation);
        }
        try {
            Iterator iterator = collection.iterator();
            SubrackMoSU_Access subrackMoSU_Access = null;
            HashSet<SubrackInformation> hashSet = new HashSet<SubrackInformation>();
            while (iterator.hasNext()) {
                subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                if (!subrackProdTypeInformation.getSPT_Mo().equals(subrackMoSU_Access.getSubrackProdTypeRef(null))) continue;
                hashSet.add(new SubrackInformation(subrackMoSU_Access, subrackProdTypeInformation));
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getMatchingSubrackMos(SubrackProdTypeInformation aSubrackProdTypeInformation)", "RETURNS - theMatchingSubrackMos: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "clearSubrackProdTypesReferencedBySubrack(Collection aSubrackProdTypeInformations)", "Throwable caught.", throwable);
            throw new SubrackMO_HandlerException(throwable.toString());
        }
    }

    public Collection clearSubrackProdTypesReferencedBySubrack(SubrackProdTypeInformations subrackProdTypeInformations) throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "clearAllSubrackProdTypesReferencedBySubrack(SubrackProdTypeInformations aSubrackProdTypeInformations)", "aSubrackProdTypeInformations: " + subrackProdTypeInformations);
        }
        Control control = null;
        try {
            Iterator iterator = subrackProdTypeInformations.getSubrackProdTypeInformationsIterator();
            Collection collection = null;
            HashSet hashSet = new HashSet();
            SubrackProdTypeInformation subrackProdTypeInformation = null;
            Collection collection2 = this.getAllSubrackMos();
            while (iterator.hasNext()) {
                subrackProdTypeInformation = (SubrackProdTypeInformation)iterator.next();
                collection = this.getMatchingSubrackMos(collection2, subrackProdTypeInformation);
                this.clearReferenceToSubrackProdTypeMos(collection);
                hashSet.addAll(collection);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "clearAllSubrackProdTypesReferencedBySubrack(SubrackProdTypeInformations aSubrackProdTypeInformations)", "RETURNS - theAllMatchingSubrackMos: " + hashSet);
            }
            return hashSet;
        }
        catch (SubrackMO_HandlerException subrackMO_HandlerException) {
            Transaction.rollback(control);
            throw subrackMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "clearSubrackProdTypesReferencedBySubrack(Collection aSubrackProdTypeInformations)", "aSubrackProdTypeInformations: " + subrackProdTypeInformations + "\n\tThrowable caught.", throwable);
            Transaction.rollback(control);
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: clearAllSubrackProdTypesReferencedBySubrack()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public void clearReferenceToSubrackProdTypeMos(Collection collection) throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "clearReferenceToSubrackProdTypeMos(Collection anMatchingSubrackMos)", "anMatchingSubrackMos: " + collection);
        }
        Control control = null;
        try {
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            SubrackInformation subrackInformation = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                subrackInformation = (SubrackInformation)iterator.next();
                subrackInformation.getSubrackMo().setSubrackProdTypeForSwUpgrade(null, coordinator);
            }
            Transaction.commit(control);
        }
        catch (SubrackMO_HandlerException subrackMO_HandlerException) {
            Transaction.rollback(control);
            throw subrackMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "clearAllSubrackProdTypesReferencedBySubrack()", "Throwable caught.", throwable);
            Transaction.rollback(control);
            throw new SubrackMO_HandlerException(throwable.toString());
        }
    }

    public void clearAllSubrackProdTypesReferencedBySubrack() throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "clearAllSubrackProdTypesReferencedBySubrack()");
        }
        Control control = null;
        try {
            SubrackMoSU_Access subrackMoSU_Access = null;
            Collection collection = this.getAllSubrackMos();
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                subrackMoSU_Access.setSubrackProdTypeForSwUpgrade(null, coordinator);
            }
            Transaction.commit(control);
        }
        catch (SubrackMO_HandlerException subrackMO_HandlerException) {
            Transaction.rollback(control);
            throw subrackMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "clearAllSubrackProdTypesReferencedBySubrack()", "Throwable caught.", throwable);
            Transaction.rollback(control);
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: clearAllSubrackProdTypesReferencedBySubrack()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public HashMap getAdmProductNumberAndRevisionsForAllSubracks() throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAdmProductNumberAndRevisionsForAllSubracks( )");
        }
        HashMap<String, ProductNumberAndRevision> hashMap = new HashMap<String, ProductNumberAndRevision>();
        try {
            Collection collection = this.getAllSubrackMos();
            Iterator iterator = collection.iterator();
            SubrackMoSU_Access subrackMoSU_Access = null;
            while (iterator.hasNext()) {
                subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                ProductNumberAndRevision productNumberAndRevision = new ProductNumberAndRevision(subrackMoSU_Access.getAdministrativeProductNumber(null), subrackMoSU_Access.getAdministrativeProductRevision(null));
                hashMap.put(subrackMoSU_Access.getLocalDistinguishedName(), productNumberAndRevision);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getSubrackMoDataForAllSubrackMos( )", "RETURNS - theMapOfAdmprodDataForAllSubrackMos: " + hashMap);
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSubrackMoDataForAllSubrackMos( )", "Throwable caught.", throwable);
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getSubrackMoDataForAllSubrackMos( )" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private boolean isMRBS_Subrack(MoIterator moIterator) throws MoAccessException {
        boolean bl = false;
        SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
        while (moIterator.hasMoreElements()) {
            int n;
            SlotMoSU_Access slotMoSU_Access;
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof SlotMoSU_Access) || !slotMO_HandlerInterface.isSU_VersionSupported("SU_3", slotMoSU_Access = (SlotMoSU_Access)managedObject) || (n = slotMoSU_Access.getIntegratedHardware(null)) != 1) continue;
            bl = true;
        }
        return bl;
    }

    public Collection getSubrackMoDataForAllSubrackMos() throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSubrackMoDataForAllSubrackMos( )");
        }
        LinkedList<SubrackMoData> linkedList = new LinkedList<SubrackMoData>();
        try {
            Collection collection = this.getAllSubrackMos();
            Iterator iterator = collection.iterator();
            SubrackMoSU_Access subrackMoSU_Access = null;
            SubrackMoData subrackMoData = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                bl = this.isMRBS_Subrack(subrackMoSU_Access.getChildren());
                subrackMoData = new SubrackMoData(subrackMoSU_Access.getOperationalProductNumber(null), subrackMoSU_Access.getOperationalProductRevision(null), subrackMoSU_Access.getAdministrativeProductNumber(null), subrackMoSU_Access.getAdministrativeProductRevision(null), subrackMoSU_Access.getLocalDistinguishedName(), subrackMoSU_Access.getSubrackProdTypeRef(null), bl);
                linkedList.add(subrackMoData);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getSubrackMoDataForAllSubrackMos( )", "RETURNS - theListOfSubrackMoDataForAllSubrackMos: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSubrackMoDataForAllSubrackMos( )", "Throwable caught.", throwable);
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getSubrackMoDataForAllSubrackMos( )" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getAllSubrackProdTypesReferencedBySubrack() throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllSubrackProdTypesReferencedBySubrack ()");
        }
        try {
            SubrackMoSU_Access subrackMoSU_Access = null;
            Collection collection = this.getAllSubrackMos();
            Iterator iterator = collection.iterator();
            LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
            while (iterator.hasNext()) {
                subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                if (subrackMoSU_Access.getSubrackProdTypeRef(null) == null) continue;
                linkedList.add(subrackMoSU_Access.getSubrackProdTypeRef(null));
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getAllSubrackProdTypesReferencedBySubrack ()", "RETURNS - theReferencedSubrackProdTypeMos: " + linkedList);
            }
            return linkedList;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAllSubrackProdTypesReferencedBySubrack()", "Throwable caught.", throwable);
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getAllSubrackProdTypesReferencedBySubrack()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public boolean updateSubrackWithSubrackProdTypeData() throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateSubrackWithSubrackProdTypeData ()");
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            Collection collection = this.getAllSubrackMos();
            SubrackMoSU_Access subrackMoSU_Access = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                subrackMoSU_Access.updateSubrackProdTypeInfoSU(coordinator);
            }
            Transaction.commit(control);
            return true;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateSubrackWithSubrackProdTypeData()", "\n\tThrowable caught.\n\tThrowable data: " + throwable);
            Transaction.rollback(control);
            return false;
        }
    }

    private boolean isMRBS_Subrack(SubrackMoSU_Access subrackMoSU_Access) throws MoAccessException {
        boolean bl = false;
        SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
        MoIterator moIterator = subrackMoSU_Access.getChildren();
        while (moIterator.hasMoreElements()) {
            int n;
            SlotMoSU_Access slotMoSU_Access;
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof SlotMoSU_Access) || !slotMO_HandlerInterface.isSU_VersionSupported("SU_3", slotMoSU_Access = (SlotMoSU_Access)managedObject) || (n = slotMoSU_Access.getIntegratedHardware(null)) != 1) continue;
            bl = true;
        }
        return bl;
    }

    public void setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection collection, HashMap hashMap) throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData, HashMap anAdmProductNumberAndRevisionsForAllSubracks)", "\n\taSubrackProdTypeMosData: " + collection + "\n\tanAdmProductNumberAndRevisionsForAllSubracks: " + hashMap);
        }
        Control control = null;
        try {
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            SubrackMoSU_Access subrackMoSU_Access = null;
            Collection collection2 = this.getAllSubrackMos();
            Iterator iterator = collection2.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            SubrackProdTypeData subrackProdTypeData = null;
            String string = null;
            String string2 = null;
            while (iterator.hasNext()) {
                ProductNumberAndRevision productNumberAndRevision2;
                subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                if (this.isMRBS_Subrack(subrackMoSU_Access)) {
                    productNumberAndRevision2 = (ProductNumberAndRevision)hashMap.get(subrackMoSU_Access.getLocalDistinguishedName());
                    if (productNumberAndRevision2 != null) {
                        string = productNumberAndRevision2.productNumber;
                        string2 = productNumberAndRevision2.revision;
                    } else {
                        Trace.info(this.getClass(), "setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData, HashMap anAdmProductNumberAndRevisionsForAllSubracks)", "No administrative product data found for the subrack (setting adm prod no and rev to empty strings).\n\ttheSubrackMO: " + subrackMoSU_Access);
                        string = EMPTY_STRING;
                        string2 = EMPTY_STRING;
                    }
                } else {
                    string = subrackMoSU_Access.getOperationalProductNumber(null);
                    string2 = subrackMoSU_Access.getOperationalProductRevision(null);
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData)", "\n\ttheSubrackProductNumber: " + string + "\n\ttheSubrackRevision: " + string2);
                    }
                    if (string == null || string.equals(EMPTY_STRING) || string2 == null || string2.equals(EMPTY_STRING)) {
                        productNumberAndRevision2 = (ProductNumberAndRevision)hashMap.get(subrackMoSU_Access.getLocalDistinguishedName());
                        if (productNumberAndRevision2 != null) {
                            string = productNumberAndRevision2.productNumber;
                            string2 = productNumberAndRevision2.revision;
                        } else {
                            Trace.info(this.getClass(), "setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData, HashMap anAdmProductNumberAndRevisionsForAllSubracks)", "No administrative product data found for the subrack (setting adm prod no and rev to empty strings).\n\ttheSubrackMO: " + subrackMoSU_Access);
                            string = EMPTY_STRING;
                            string2 = EMPTY_STRING;
                        }
                        Trace.info(this.getClass(), "setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData, HashMap anAdmProductNumberAndRevisionsForAllSubracks)", "No operational product number and/or revision is available in resource layer (OSA) i.e. the\n\tadministrative product number and revision for the subrack will be used.\n\tThe Subrack MO: " + subrackMoSU_Access + "\n\tThe adm product no: '" + string + "'" + "\n\tThe adm product revision: '" + string2 + "'");
                    }
                }
                productNumberAndRevision = new ProductNumberAndRevision(string, string2);
                subrackProdTypeData = this.getMatchingSubrackProdTypeData(productNumberAndRevision, collection);
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData)", "\n\tBefore setting srpt relation to: " + subrackProdTypeData.subrackProdTypeMO);
                }
                subrackMoSU_Access.setSubrackProdTypeForSwUpgrade(subrackProdTypeData.subrackProdTypeMO, coordinator);
                if (!Trace.valid(this.getClass(), 20)) continue;
                Trace.debug(this.getClass(), 20, "setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData)", "\n\taSubrackProdTypeMosData: " + collection);
            }
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData)", "\n\taSubrackProdTypeMosData: " + collection + "\n\tThrowable caught.", throwable);
            Transaction.rollback(control);
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: setRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection aSubrackProdTypeMosData)" + "\n\taSubrackProdTypeMosData: " + collection + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public void setBackRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection collection, SubrackProdTypeInformations subrackProdTypeInformations) throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setBackRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection anAllAffectedSubrackInformations, SubrackProdTypeInformations aSubrackProdTypeInformations)", "anAllAffectedSubrackInformations: " + collection + "\n\taSubrackProdTypeInformations: " + subrackProdTypeInformations);
        }
        Control control = null;
        try {
            control = Transaction.create();
            Coordinator coordinator = Transaction.getCoordinator(control);
            SubrackInformation subrackInformation = null;
            Iterator iterator = collection.iterator();
            String string = null;
            String string2 = null;
            while (iterator.hasNext()) {
                SubrackProdTypeInformation subrackProdTypeInformation;
                subrackInformation = (SubrackInformation)iterator.next();
                if (this.isMRBS_Subrack(subrackInformation.getSubrackMo())) {
                    string = subrackInformation.getSubrackProdTypeInformation().getProductNumber();
                    string2 = subrackInformation.getSubrackProdTypeInformation().getProductRevision();
                    if (string == null || string2 == null) {
                        Trace.info(this.getClass(), "setBackRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection anAllAffectedSubrackInformations, SubrackProdTypeInformations aSubrackProdTypeInformations)", "No administrative product data found for the subrack (setting adm prod no and rev to empty strings).\n\ttheSubrackInformation: " + subrackInformation);
                        string = EMPTY_STRING;
                        string2 = EMPTY_STRING;
                    }
                } else {
                    string = subrackInformation.getSubrackMo().getOperationalProductNumber(null);
                    string2 = subrackInformation.getSubrackMo().getOperationalProductRevision(null);
                    if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "setBackRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection anAllAffectedSubrackInformations, SubrackProdTypeInformations aSubrackProdTypeInformations)", "\n\ttheSubrackProductNumber: " + string + "\n\ttheSubrackRevision: " + string2);
                    }
                    if (string == null || string.equals(EMPTY_STRING) || string2 == null || string2.equals(EMPTY_STRING)) {
                        string = subrackInformation.getSubrackProdTypeInformation().getProductNumber();
                        string2 = subrackInformation.getSubrackProdTypeInformation().getProductRevision();
                        if (string == null || string2 == null) {
                            Trace.info(this.getClass(), "setBackRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection anAllAffectedSubrackInformations, SubrackProdTypeInformations aSubrackProdTypeInformations)", "No administrative product data found for the subrack (setting adm prod no and rev to empty strings).\n\ttheSubrackInformation: " + subrackInformation);
                            string = EMPTY_STRING;
                            string2 = EMPTY_STRING;
                        }
                        Trace.info(this.getClass(), "setBackRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection anAllAffectedSubrackInformations, SubrackProdTypeInformations aSubrackProdTypeInformations)", "No operational product number and/or revision is available in resource layer (OSA) i.e. the\n\tadministrative product number and revision for the subrack will be used.\n\tThe adm product no: '" + string + "'" + "\n\tThe adm product revision: '" + string2 + "'");
                    }
                }
                if ((subrackProdTypeInformation = this.getMatchingSubrackProdTypeInformation(string = StringHandler.removeWhiteSpaces(string).toUpperCase(), string2 = StringHandler.removeWhiteSpaces(string2).toUpperCase(), subrackProdTypeInformations)) != null) {
                    subrackInformation.getSubrackMo().setSubrackProdTypeForSwUpgrade(subrackProdTypeInformation.getSPT_Mo(), coordinator);
                    continue;
                }
                Trace.error(this.getClass(), "setBackRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection anAllAffectedSubrackInformations, SubrackProdTypeInformations aSubrackProdTypeInformations)", "anAllAffectedSubrackInformations: " + collection + "\n\taSubrackProdTypeInformations: " + subrackProdTypeInformations + "\n\tFailed to connect a SubrackProdType Mo to the Subrack Mo.");
                throw new SubrackMO_HandlerException("Failed to connect a SubrackProdType Mo to the Subrack Mo.");
            }
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setBackRelationsBetweenSubrackMosAndSubrackProdTypeMos(Collection anAllAffectedSubrackInformations, SubrackProdTypeInformations aSubrackProdTypeInformations)", "anAllAffectedSubrackInformations: " + collection + "\n\taSubrackProdTypeInformations: " + subrackProdTypeInformations + "\n\tThrowable caught.", throwable);
            Transaction.rollback(control);
            throw new SubrackMO_HandlerException(throwable.toString());
        }
    }

    private SubrackProdTypeInformation getMatchingSubrackProdTypeInformation(String string, String string2, SubrackProdTypeInformations subrackProdTypeInformations) throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMatchingSubrackProdTypeInformation (String aProductNoOfSubrack, String aProductRevOfSubrack, SubrackProdTypeInformations aSubrackProdTypeInformations)", "aProductNoOfSubrack: " + string + "\n\taProductRevOfSubrack: " + string2 + "\n\taSubrackProdTypeInformations: " + subrackProdTypeInformations);
        }
        try {
            SubrackProdTypeInformation subrackProdTypeInformation = subrackProdTypeInformations.getSubrackProdTypeInformation(string, string2);
            if (subrackProdTypeInformation != null) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getMatchingSubrackProdTypeInformation (String aProductNoOfSubrack, String aProductRevOfSubrack, SubrackProdTypeInformations aSubrackProdTypeInformations)", "Matches specific revision.\n\tRETURNS - theSubrackProdTypeInformation: " + subrackProdTypeInformation);
                }
                return subrackProdTypeInformation;
            }
            subrackProdTypeInformation = subrackProdTypeInformations.getSubrackProdTypeInformation(string, ProductNumberAndRevision.getShortProductRevision(string2));
            if (subrackProdTypeInformation != null) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getMatchingSubrackProdTypeInformation (String aProductNoOfSubrack, String aProductRevOfSubrack, SubrackProdTypeInformations aSubrackProdTypeInformations)", "Matches short revision.\n\tRETURNS - theSubrackProdTypeInformation: " + subrackProdTypeInformation);
                }
                return subrackProdTypeInformation;
            }
            subrackProdTypeInformation = subrackProdTypeInformations.getSubrackProdTypeInformation(string, "*");
            if (subrackProdTypeInformation != null) {
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getMatchingSubrackProdTypeInformation (String aProductNoOfSubrack, String aProductRevOfSubrack, SubrackProdTypeInformations aSubrackProdTypeInformations)", "Matches wildcard revision.\n\tRETURNS - theSubrackProdTypeInformation: " + subrackProdTypeInformation);
                }
                return subrackProdTypeInformation;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getMatchingSubrackProdTypeInformation (String aProductNoOfSubrack, String aProductRevOfSubrack, SubrackProdTypeInformations aSubrackProdTypeInformations)", "No matching SubrackProdType found.\n\tRETURNS - theSubrackProdTypeInformation: null");
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getMatchingSubrackProdTypeInformation (String aProductNoOfSubrack, String aProductRevOfSubrack, SubrackProdTypeInformations aSubrackProdTypeInformations)", "aProductNoOfSubrack: " + string + "\n\taProductRevOfSubrack: " + string2 + "\n\taSubrackProdTypeInformations: " + subrackProdTypeInformations + "\n\tThrowable caught.", throwable);
            throw new SubrackMO_HandlerException(throwable.toString());
        }
    }

    private SubrackProdTypeData getMatchingSubrackProdTypeData(ProductNumberAndRevision productNumberAndRevision, Collection collection) throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getMatchingSubrackProdTypeData (ProductNumberAndRevision aProductNumberAndRevisionOfSubrack, Collection aSubrackProdTypeMosData)", "aProductNumberAndRevisionOfSubrack: " + productNumberAndRevision + "\n\taSubrackProdTypeMosData: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            SubrackProdTypeData subrackProdTypeData = null;
            while (iterator.hasNext()) {
                subrackProdTypeData = (SubrackProdTypeData)iterator.next();
                if (!productNumberAndRevision.equals(subrackProdTypeData.productNumberAndRevision)) continue;
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getMatchingSubrackProdTypeData (ProductNumberAndRevision aProductNumberAndRevisionOfSubrack, Collection aSubrackProdTypeMosData)", "Matches specific revision.\n\tRETURNS - theSubrackProdTypeData: " + subrackProdTypeData);
                }
                return subrackProdTypeData;
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                subrackProdTypeData = (SubrackProdTypeData)iterator.next();
                if (!productNumberAndRevision.equalsShortRevision(subrackProdTypeData.productNumberAndRevision.productNumber, subrackProdTypeData.productNumberAndRevision.revision)) continue;
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getMatchingSubrackProdTypeData (ProductNumberAndRevision aProductNumberAndRevisionOfSubrack, Collection aSubrackProdTypeMosData)", "Matches short revision.\n\tRETURNS - theSubrackProdTypeData: " + subrackProdTypeData);
                }
                return subrackProdTypeData;
            }
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                subrackProdTypeData = (SubrackProdTypeData)iterator.next();
                if (!productNumberAndRevision.equalsWildcardRevision(subrackProdTypeData.productNumberAndRevision.productNumber, subrackProdTypeData.productNumberAndRevision.revision)) continue;
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getMatchingSubrackProdTypeData (ProductNumberAndRevision aProductNumberAndRevisionOfSubrack, Collection aSubrackProdTypeMosData)", "Matches short revision.\n\tRETURNS - theSubrackProdTypeData: " + subrackProdTypeData);
                }
                return subrackProdTypeData;
            }
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getMatchingSubrackProdTypeData (ProductNumberAndRevision aProductNumberAndRevisionOfSubrack, Collection aSubrackProdTypeMosData)" + "\n\tNo SubrackProdTypeMo was found that matches the Subrack MO (aborting the upgrade)." + "\n\taProductNumberAndRevisionOfSubrack: " + productNumberAndRevision + "\n\taSubrackProdTypeMosData: " + collection);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getMatchingSubrackProdTypeData (ProductNumberAndRevision aProductNumberAndRevisionOfSubrack, Collection aSubrackProdTypeMosData)", "aProductNumberAndRevisionOfSubrack: " + productNumberAndRevision + "\n\taSubrackProdTypeMosData: " + collection + "\n\tThrowable caught.", throwable);
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getMatchingSubrackProdTypeData (ProductNumberAndRevision aProductNumberAndRevisionOfSubrack, Collection aSubrackProdTypeMosData)" + "\n\taProductNumberAndRevisionOfSubrack: " + productNumberAndRevision + "\n\taSubrackProdTypeMosData: " + collection + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public Collection getAllSubrackDataContainers() throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllSubrackDataContainers ()");
        }
        LinkedList<SubrackDataContainer> linkedList = new LinkedList<SubrackDataContainer>();
        Collection collection = this.getAllSubrackMos();
        Iterator iterator = collection.iterator();
        SubrackMoSU_Access subrackMoSU_Access = null;
        try {
            while (iterator.hasNext()) {
                subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                Integer n = this.getIntegratedHardwareValueFromSlots(subrackMoSU_Access.getChildren());
                linkedList.add(new SubrackDataContainer(subrackMoSU_Access, n));
            }
        }
        catch (MoAccessException moAccessException) {
            Trace.warning(this.getClass(), "getAllSubrackDataContainers()", "Exception caught when trying to fetch fanConfiguration from SubrackProdType MO.\n\texception: " + (Object)((Object)moAccessException));
        }
        return linkedList;
    }

    private Integer getIntegratedHardwareValueFromSlots(MoIterator moIterator) throws MoAccessException {
        MoIterator moIterator2 = moIterator;
        int n = 0;
        SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
        while (moIterator2.hasMoreElements()) {
            SlotMoSU_Access slotMoSU_Access;
            ManagedObject managedObject = moIterator2.nextMo();
            if (!(managedObject instanceof SlotMoSU_Access) || !slotMO_HandlerInterface.isSU_VersionSupported("SU_3", slotMoSU_Access = (SlotMoSU_Access)managedObject)) continue;
            n = slotMoSU_Access.getIntegratedHardware(null);
            if (slotMoSU_Access.getIntegratedHardware(null) != 1) continue;
            return new Integer(n);
        }
        return new Integer(n);
    }

    public Collection getAllSubrackMos() throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllSubrackMos ()");
        }
        try {
            SubrackMoSU_Access subrackMoSU_Access = null;
            MoIterator moIterator = MoRepository.instance().lookupType("Subrack");
            LinkedList<SubrackMoSU_Access> linkedList = new LinkedList<SubrackMoSU_Access>();
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    subrackMoSU_Access = (SubrackMoSU_Access)moIterator.nextMo();
                    linkedList.add(subrackMoSU_Access);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getAllSubrackMos ()", "RETURNS - theSubrackMOs: " + linkedList);
            }
            return linkedList;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getAllSubrackMos ()", "The Subrack MO(s) are not of type SubrackMoSU_Access2\n\tRETURNS - theSubrackMOs: []");
            }
            return new LinkedList();
        }
        catch (ClassCastException classCastException) {
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getAllSubrackMos ()", "The Subrack MO(s) are not of type SubrackMoSU_Access2 (class cast...)\n\tRETURNS - theSubrackMOs: []");
            }
            return new LinkedList();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAllSubrackMos()", "Throwable caught.", throwable);
            throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: getAllSubrackMos()" + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    public boolean existSubrackWithFanConfigurationCax() throws SubrackMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "existSubrackWithFanConfigurationCax()");
        }
        boolean bl = false;
        if (SU_AccessVersionHandler.getInstance().isSupported("SU_1", (Object)MoFactoryMgr.instance().lookup("Subrack")) && SU_AccessVersionHandler.getInstance().isSupported("SU_3", (Object)MoFactoryMgr.instance().lookup("SubrackProdType"))) {
            try {
                SubrackMoSU_Access subrackMoSU_Access = null;
                Iterator iterator = this.getAllSubrackMos().iterator();
                while (iterator.hasNext()) {
                    subrackMoSU_Access = (SubrackMoSU_Access)iterator.next();
                    SubrackProdTypeMoSU_Access subrackProdTypeMoSU_Access = (SubrackProdTypeMoSU_Access)subrackMoSU_Access.getSubrackProdTypeRef(null);
                    int n = subrackProdTypeMoSU_Access != null ? subrackProdTypeMoSU_Access.getFanConfiguration(null) : subrackMoSU_Access.getFanConfigurationFromFro(null);
                    if (n != 5) continue;
                    bl = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "existSubrackWithFanConfigurationCax()", "Throwable caught when checking fanConfiguration is CAX for any Subracks.", throwable);
                throw new SubrackMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tMethod: existSubrackWithFanConfigurationCax()" + "\n\tThrowable caught when checking fanConfiguration of Subracks." + "\n\tThrowable data: " + throwable);
            }
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "existSubrackWithFanConfigurationCax()", "Returning - theExistSubrackWithFanConfigurationCax: " + bl);
        }
        return bl;
    }
}

