/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.managedelement.suaccess.SU_ConditionalException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.signedsw.SignedSoftwareUtils;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumbersAndRevisions;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequencesProxyInterface;
import se.ericsson.cello.sudom.proxy.verifysequence.VerifySequenceProxyInterface;
import se.ericsson.cello.sudom.proxy.verifyupdatesequence.VerifyUpdateSequencesProxyInterface;
import se.ericsson.cello.sudom.proxy.verifyupgradesequence.VerifyUpgradeSequencesProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.handler.FromVersionExtendedInformation;
import se.ericsson.cello.upgradepackage.util.handler.FromVersionHandler;
import se.ericsson.cello.upgradepackage.util.handler.LoadModuleProgramInformation;
import se.ericsson.cello.upgradepackage.util.handler.SignedSoftwareInformationForPIUs;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.ssw.CrlAndCertificateToStateHandler;

public class CalculateJAUEs {
    private String myLogInfoFromState = "Java Aues-FromState";
    private String myLogInfoToState = "Java Aues-ToState";

    private Collection calculateJavaAuesToState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string, Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateJavaAuesToState( OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCase: " + string + "\n\taSSW_PIUs: " + collection);
        }
        LinkedList<SignedSoftwareInformationForPIUs> linkedList = new LinkedList<SignedSoftwareInformationForPIUs>();
        try {
            Collection collection2 = null;
            ProductNumbersAndRevisions productNumbersAndRevisions = this.calculateUpgradeSequencesToState(optimizedDocumentObjectProxyInterface, string);
            if (!productNumbersAndRevisions.isEmpty()) {
                JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
                SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
                PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = jvmMO_HandlerInterface.getJVM_PIUs();
                collection2 = this.getLoadModuleProgramInformations(optimizedDocumentObjectProxyInterface, productNumbersAndRevisions);
                if ((plugInUnitMoSU_AccessArray = SignedSoftwareUtils.contains(collection, plugInUnitMoSU_AccessArray)).length > 0) {
                    SlotMoSU_Access[] slotMoSU_AccessArray = slotMO_HandlerInterface.getSlotMos(plugInUnitMoSU_AccessArray);
                    for (int i = 0; i < slotMoSU_AccessArray.length; ++i) {
                        linkedList.add(new SignedSoftwareInformationForPIUs(slotMoSU_AccessArray[i].getSubrackMo(null).getSwitchModuleNumber(null), slotMoSU_AccessArray[i].getAsciPortNumber(null), collection2));
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList;
    }

    private Collection getLoadModuleProgramInformations(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ProductNumbersAndRevisions productNumbersAndRevisions) {
        LoadModulesProxyInterface loadModulesProxyInterface = optimizedDocumentObjectProxyInterface.getLoadModulesProxyInterface();
        LinkedList<LoadModuleProgramInformation> linkedList = new LinkedList<LoadModuleProgramInformation>();
        Enumeration enumeration = productNumbersAndRevisions.getElements().elements();
        ProductNumberAndRevision productNumberAndRevision = null;
        LoadModuleProxyInterface loadModuleProxyInterface = null;
        while (enumeration.hasMoreElements()) {
            productNumberAndRevision = (ProductNumberAndRevision)enumeration.nextElement();
            loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision.getProductNumber(), productNumberAndRevision.getRevision());
            linkedList.add(new LoadModuleProgramInformation(loadModuleProxyInterface.getDeviceLoaderInformation(), loadModuleProxyInterface.getDeviceLoaderName(), loadModuleProxyInterface.getLoaderName(), productNumberAndRevision.productNumber, productNumberAndRevision.revision, SignedSoftwareUtils.theTag0, loadModuleProxyInterface.getOseProgramLoadClass(), SignedSoftwareUtils.getDestinationFilePaths(optimizedDocumentObjectProxyInterface, loadModuleProxyInterface, productNumberAndRevision.productNumber, productNumberAndRevision.revision)));
        }
        return linkedList;
    }

    private ProductNumbersAndRevisions calculateUpgradeSequencesFromState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateUpgradeSequencesFromState( OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCase: " + string);
        }
        try {
            UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = optimizedDocumentObjectProxyInterface.getUpgradeSequencesProxyInterface();
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            return upgradeSequencesProxyInterface.getJavaAUEsFromState(string, SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess), SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_4", (Object)osaSwInstallProxyAccess));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "calculateUpgradeSequencesFromState( OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase)", "Throwable caught", throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public Collection collectToState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string, Collection collection, String string2) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectToState(  OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface , String aCase)", "aCase: " + string + "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\tanUCF_Path: " + string2);
        }
        Collection collection2 = this.calculateJavaAuesToState(optimizedDocumentObjectProxyInterface, string, collection);
        OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
        try {
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_5", (Object)osaSwInstallProxyAccess)) {
                ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
                VerifyUpgradeSequencesProxyInterface verifyUpgradeSequencesProxyInterface = optimizedDocumentObjectProxyInterface.getVerifyUpgradeSequencesProxyInterface();
                VerifyUpdateSequencesProxyInterface verifyUpdateSequencesProxyInterface = optimizedDocumentObjectProxyInterface.getVerifyUpdateSequencesProxyInterface();
                productNumbersAndRevisions.addElements(verifyUpgradeSequencesProxyInterface.getJavaAUEsFromState(string));
                productNumbersAndRevisions.addElements(verifyUpdateSequencesProxyInterface.getJavaAUEsFromState(string));
                CrlAndCertificateToStateHandler crlAndCertificateToStateHandler = new CrlAndCertificateToStateHandler(string2, optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getNumber(), optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getRevision(), string);
                collection2 = SignedSoftwareUtils.add(collection2, this.calculateJAuesWithApnSmn(optimizedDocumentObjectProxyInterface, productNumbersAndRevisions, collection, crlAndCertificateToStateHandler));
            }
        }
        catch (SU_ConditionalException sU_ConditionalException) {
            sU_ConditionalException.printStackTrace();
        }
        SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoToState, optimizedDocumentObjectProxyInterface, collection2);
        return collection2;
    }

    public ProductNumbersAndRevisions calculateUpgradeSequencesToState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ValidSequencesInformation validSequencesInformation) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateUpgradeSequencesToState (OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation);
        }
        ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
        try {
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                productNumbersAndRevisions = this.calculateUpgradeSequencesToState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                productNumbersAndRevisions.addElements(this.calculateUpgradeSequencesToState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase));
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectToState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
        return productNumbersAndRevisions;
    }

    private ProductNumbersAndRevisions calculateUpgradeSequencesToState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateUpgradeSequencesToState( OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase)", "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCase: " + string);
        }
        try {
            UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = optimizedDocumentObjectProxyInterface.getUpgradeSequencesProxyInterface();
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            return upgradeSequencesProxyInterface.getJavaAUEsToState(string, SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_3", (Object)osaSwInstallProxyAccess), SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_4", (Object)osaSwInstallProxyAccess));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "calculateUpgradeSequencesToState( OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface , String aCase)", "Throwable caught", throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private Collection calculateJAuesWithApnSmn(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ProductNumbersAndRevisions productNumbersAndRevisions, Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateJAuesWithApnSmn(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface ,ProductNumbersAndRevisions aProductNumbersAndRevisions)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\taSSW_PIUs: " + collection);
        }
        LinkedList<SignedSoftwareInformationForPIUs> linkedList = new LinkedList<SignedSoftwareInformationForPIUs>();
        try {
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = jvmMO_HandlerInterface.getJVM_PIUs();
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            plugInUnitMoSU_AccessArray = SignedSoftwareUtils.contains(collection, plugInUnitMoSU_AccessArray);
            Collection collection2 = null;
            if (plugInUnitMoSU_AccessArray.length > 0) {
                SlotMoSU_Access[] slotMoSU_AccessArray = slotMO_HandlerInterface.getSlotMos(plugInUnitMoSU_AccessArray);
                Collection collection3 = null;
                collection2 = this.getLoadModuleProgramInformations(optimizedDocumentObjectProxyInterface, productNumbersAndRevisions);
                SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs = null;
                for (int i = 0; i < slotMoSU_AccessArray.length; ++i) {
                    SlotMoSU_Access slotMoSU_Access = slotMoSU_AccessArray[i];
                    PlugInUnitMoSU_Access plugInUnitMoSU_Access = pIU_MO_HandlerInterface.getPIU_MO(slotMoSU_Access);
                    collection3 = SignedSoftwareUtils.getCRL_AndCertificateLoadModuleProgramInformations(plugInUnitMoSU_Access);
                    if (!collection3.isEmpty()) {
                        collection3.addAll(collection2);
                        signedSoftwareInformationForPIUs = new SignedSoftwareInformationForPIUs(slotMoSU_AccessArray[i].getSubrackMo(null).getSwitchModuleNumber(null), slotMoSU_AccessArray[i].getAsciPortNumber(null), collection3);
                    } else {
                        signedSoftwareInformationForPIUs = new SignedSoftwareInformationForPIUs(slotMoSU_AccessArray[i].getSubrackMo(null).getSwitchModuleNumber(null), slotMoSU_AccessArray[i].getAsciPortNumber(null), collection2);
                    }
                    linkedList.add(signedSoftwareInformationForPIUs);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList;
    }

    public Collection collectToState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ValidSequencesInformation validSequencesInformation, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectToState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\taSSW_PIUs: " + collection);
        }
        try {
            Collection collection2 = new LinkedList();
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                collection2 = this.calculateJavaAuesToState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase, collection);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                collection2 = SignedSoftwareUtils.add(collection2, this.calculateJavaAuesToState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase, collection));
            }
            if (!validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade) && !validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                Trace.log1(this.getClass(), "collectToState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor not possible to collect the programs that are valid in TO state (returns an empty list).\n\taValidSequencesInformation: " + validSequencesInformation);
            }
            if (collection2.isEmpty()) {
                return new HashSet();
            }
            SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoToState, optimizedDocumentObjectProxyInterface, collection2);
            return collection2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectToState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public Collection collectToState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, int n, ValidSequencesInformation validSequencesInformation, Collection collection, String string) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectToState(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, int aSU_LogicCompatibilityIndex, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taSU_LogicCompatibilityIndex: " + n + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\taSSW_PIUs: " + collection + "\n\tanUCF_Path" + string);
        }
        try {
            FromVersionExtendedInformation fromVersionExtendedInformation;
            VerifySequenceProxyInterface verifySequenceProxyInterface;
            Collection collection2 = new LinkedList();
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                collection2 = this.calculateJavaAuesToState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase, collection);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                collection2 = SignedSoftwareUtils.add(collection2, this.calculateJavaAuesToState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase, collection));
            }
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
            FromVersionHandler fromVersionHandler = new FromVersionHandler();
            String string2 = optimizedDocumentObjectProxyInterface.getUP_CompatibilityIndexProxyInterface().getIndex();
            if (string2 == null) {
                string2 = "";
            }
            if ((verifySequenceProxyInterface = optimizedDocumentObjectProxyInterface.getVerifySequenceProxyInterface(fromVersionExtendedInformation = fromVersionHandler.getExtendedFromVersion(optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getNumber(), optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getRevision(), string2, optimizedDocumentObjectProxyInterface.isDeltaUP(), n, optimizedDocumentObjectProxyInterface), optimizedDocumentObjectProxyInterface.isDeltaUP())) != null) {
                productNumbersAndRevisions.addElements(verifySequenceProxyInterface.getJavaAUEsFromState());
            }
            CrlAndCertificateToStateHandler crlAndCertificateToStateHandler = new CrlAndCertificateToStateHandler(string, optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getNumber(), optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getRevision(), validSequencesInformation);
            collection2 = SignedSoftwareUtils.add(collection2, this.calculateJAuesWithApnSmn(optimizedDocumentObjectProxyInterface, productNumbersAndRevisions, collection, crlAndCertificateToStateHandler));
            if (!validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade) && !validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade) && Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectToState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "No variant of upgrade is supported and therefor not possible to collect the programs that are valid in TO state (returns an empty list).\n\taValidSequencesInformation: " + validSequencesInformation);
            }
            if (collection2.isEmpty()) {
                return new HashSet();
            }
            SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoToState, optimizedDocumentObjectProxyInterface, collection2);
            return collection2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectToState(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, int aSU_LogicCompatibilityIndex, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private Collection calculateJAuesWithApnSmn(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ProductNumbersAndRevisions productNumbersAndRevisions, Collection collection, CrlAndCertificateToStateHandler crlAndCertificateToStateHandler) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "calculateJAuesWithApnSmn(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface ,ProductNumbersAndRevisions aProductNumbersAndRevisions)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taProductNumbersAndRevisions: " + productNumbersAndRevisions + "\n\taSSW_PIUs: " + collection + "\n\taCrlAndCertificateToStateHandler: " + crlAndCertificateToStateHandler);
        }
        LinkedList<SignedSoftwareInformationForPIUs> linkedList = new LinkedList<SignedSoftwareInformationForPIUs>();
        try {
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = jvmMO_HandlerInterface.getJVM_PIUs();
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            plugInUnitMoSU_AccessArray = SignedSoftwareUtils.contains(collection, plugInUnitMoSU_AccessArray);
            Collection collection2 = null;
            if (plugInUnitMoSU_AccessArray.length > 0) {
                SlotMoSU_Access[] slotMoSU_AccessArray = slotMO_HandlerInterface.getSlotMos(plugInUnitMoSU_AccessArray);
                SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs = null;
                collection2 = this.getLoadModuleProgramInformations(optimizedDocumentObjectProxyInterface, productNumbersAndRevisions);
                SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs2 = null;
                for (int i = 0; i < slotMoSU_AccessArray.length; ++i) {
                    SlotMoSU_Access slotMoSU_Access = slotMoSU_AccessArray[i];
                    PlugInUnitMoSU_Access plugInUnitMoSU_Access = pIU_MO_HandlerInterface.getPIU_MO(slotMoSU_Access);
                    signedSoftwareInformationForPIUs = crlAndCertificateToStateHandler.getCrlAndCertificatesForToStateJAues((GenericUpgradeablePlugInUnit)plugInUnitMoSU_Access);
                    if (signedSoftwareInformationForPIUs != null) {
                        signedSoftwareInformationForPIUs.getSignedProgramInformationsForPIU().addAll(collection2);
                        signedSoftwareInformationForPIUs2 = signedSoftwareInformationForPIUs;
                    } else {
                        signedSoftwareInformationForPIUs2 = new SignedSoftwareInformationForPIUs(slotMoSU_AccessArray[i].getSubrackMo(null).getSwitchModuleNumber(null), slotMoSU_AccessArray[i].getAsciPortNumber(null), collection2);
                    }
                    linkedList.add(signedSoftwareInformationForPIUs2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return linkedList;
    }

    public Collection collectFromState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, int n, ValidSequencesInformation validSequencesInformation, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectFromState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\taSSW_PIUs: " + collection);
        }
        try {
            FromVersionExtendedInformation fromVersionExtendedInformation;
            VerifySequenceProxyInterface verifySequenceProxyInterface;
            Collection collection2 = null;
            ProductNumbersAndRevisions productNumbersAndRevisions = new ProductNumbersAndRevisions();
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                productNumbersAndRevisions = this.calculateUpgradeSequencesFromState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase);
            }
            if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                productNumbersAndRevisions.addElements(this.calculateUpgradeSequencesFromState(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase));
            }
            FromVersionHandler fromVersionHandler = new FromVersionHandler();
            String string = optimizedDocumentObjectProxyInterface.getUP_CompatibilityIndexProxyInterface().getIndex();
            if (string == null) {
                string = "";
            }
            if ((verifySequenceProxyInterface = optimizedDocumentObjectProxyInterface.getVerifySequenceProxyInterface(fromVersionExtendedInformation = fromVersionHandler.getExtendedFromVersion(optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getNumberRaw(), optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getRevisionRaw(), string, optimizedDocumentObjectProxyInterface.isDeltaUP(), n, optimizedDocumentObjectProxyInterface), optimizedDocumentObjectProxyInterface.isDeltaUP())) != null) {
                productNumbersAndRevisions.addElements(verifySequenceProxyInterface.getJavaAUEsFromState());
            }
            if ((collection2 = this.calculateJAuesWithApnSmn(optimizedDocumentObjectProxyInterface, productNumbersAndRevisions, collection)).isEmpty()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collectFromState(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, int aSU_LogicCompatibilityIndex, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "No variant of upgrade is supported and therefor not possible to collect the programs that are valid in TO state (returns an empty list).\n\taValidSequencesInformation: " + validSequencesInformation);
                }
                return new HashSet();
            }
            SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoFromState, optimizedDocumentObjectProxyInterface, collection2);
            return collection2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectFromState(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public Collection collectFromState(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectFromState(  OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface , String aCase)", "aCase: " + string + "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface);
        }
        Collection collection2 = null;
        ProductNumbersAndRevisions productNumbersAndRevisions = null;
        VerifyUpgradeSequencesProxyInterface verifyUpgradeSequencesProxyInterface = optimizedDocumentObjectProxyInterface.getVerifyUpgradeSequencesProxyInterface();
        VerifyUpdateSequencesProxyInterface verifyUpdateSequencesProxyInterface = optimizedDocumentObjectProxyInterface.getVerifyUpdateSequencesProxyInterface();
        productNumbersAndRevisions = this.calculateUpgradeSequencesFromState(optimizedDocumentObjectProxyInterface, string);
        productNumbersAndRevisions.addElements(verifyUpgradeSequencesProxyInterface.getJavaAUEsFromState(string));
        productNumbersAndRevisions.addElements(verifyUpdateSequencesProxyInterface.getJavaAUEsFromState(string));
        collection2 = this.calculateJAuesWithApnSmn(optimizedDocumentObjectProxyInterface, productNumbersAndRevisions, collection);
        if (Trace.valid(this.getClass(), 40)) {
            SignedSoftwareUtils.logCollectedPrograms(this.getClass(), this.myLogInfoFromState, optimizedDocumentObjectProxyInterface, collection2);
        }
        return collection2;
    }
}

