/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackMoSU_Access;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.TypeOfUpgrade;
import se.ericsson.cello.su.signedsw.SignedSoftwareUtils;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extsuif.proxy.exceptions.SequenceInformationException;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_OseProgramLoadClassValue;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypeProxyInterface;
import se.ericsson.cello.sudom.proxy.piutype.PiuTypesProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleProgramInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.verify.TagAndLoadModuleRefInformation;
import se.ericsson.cello.swmanagement.suaccess.SwAllocationMoSU_Access;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelper;
import se.ericsson.cello.upgradepackage.upgrade.SwAllocationHelperException;
import se.ericsson.cello.upgradepackage.util.handler.SignedSoftwareInformationForPIUs;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piutype.PiuTypeMoData;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.VerifyRequestException;
import se.ericsson.cello.upgradepackage.verify.ssw.SignedSoftwareInformationForPIU;
import se.ericsson.cello.upgradepackage.verify.ssw.SignedSoftwareInformationForPIU_Interface;

public class CalculateProgramsForToState {
    private static final String SEPARATOR = "; ";

    public Collection collect(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ValidSequencesInformation validSequencesInformation, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collect(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation + "\n\taSSW_PIUs: " + collection);
        }
        try {
            Collection collection2 = null;
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                collection2 = this.collect(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase, collection);
            } else if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                collection2 = this.collect(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase, collection);
            } else if (validSequencesInformation.isSupported(TypeOfUpgrade.Update)) {
                collection2 = this.collect(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Update).getFirstSequenceInformation().currentCase, collection);
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "No variant of upgrade is supported and therefor not possible to collect the programs that are valid in TO state (returns an empty list).\n\taValidSequencesInformation: " + validSequencesInformation);
                }
                collection2 = new HashSet();
            }
            if (Trace.valid(this.getClass(), 40)) {
                this.logCollectedPrograms(optimizedDocumentObjectProxyInterface, collection2);
            }
            return collection2;
        }
        catch (SequenceInformationException sequenceInformationException) {
            throw new VerifyRequestException(sequenceInformationException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, Collection aSSW_PIUs)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public Collection collectCrlAndCertificates(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, ValidSequencesInformation validSequencesInformation) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectCrlAndCertificates(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation);
        }
        try {
            HashSet hashSet = null;
            if (validSequencesInformation.isSupported(TypeOfUpgrade.RebootNodeUpgrade)) {
                hashSet = this.collectCrlAndCertificates(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.RebootNodeUpgrade).getFirstSequenceInformation().currentCase);
            } else if (validSequencesInformation.isSupported(TypeOfUpgrade.Upgrade)) {
                hashSet = this.collectCrlAndCertificates(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Upgrade).getFirstSequenceInformation().currentCase);
            } else if (validSequencesInformation.isSupported(TypeOfUpgrade.Update)) {
                hashSet = this.collectCrlAndCertificates(optimizedDocumentObjectProxyInterface, validSequencesInformation.getSupportedSequenceInformation((TypeOfUpgrade)TypeOfUpgrade.Update).getFirstSequenceInformation().currentCase);
            } else {
                Trace.log1(this.getClass(), "collectCrlAndCertificates(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, ValidSequencesInformation aValidSequencesInformation, Collection aSSW_PIUs)", "No variant of upgrade is supported and therefor not possible to collect the programs that are valid in TO state (returns an empty list).\n\taValidSequencesInformation: " + validSequencesInformation);
                hashSet = new HashSet();
            }
            if (Trace.valid(this.getClass(), 40)) {
                this.logCollectedPrograms(optimizedDocumentObjectProxyInterface, hashSet);
            }
            return hashSet;
        }
        catch (SequenceInformationException sequenceInformationException) {
            throw new VerifyRequestException(sequenceInformationException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectCrlAndCertificates(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, Collection aSSW_PIUs)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taValidSequencesInformation: " + validSequencesInformation, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public Collection collect(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string, Collection collection) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collect(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, String aCurrentCase, Collection aSSW_PIUs)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCurrentCase: " + string + "\n\taSSW_PIUs: " + collection);
        }
        try {
            RepertoiresProxyInterface repertoiresProxyInterface = optimizedDocumentObjectProxyInterface.getRepertoiresProxyInterface();
            PiuTypeMoData piuTypeMoData = null;
            UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
            Collection collection2 = upgradeablePIU_HandlerInterface.getUpgradeablePlugInUnits();
            Iterator iterator = collection2.iterator();
            Collection collection3 = null;
            Collection collection4 = new LinkedList();
            SlotMoSU_Access slotMoSU_Access = null;
            while (iterator.hasNext()) {
                Object object;
                TagAndLoadModuleRefInformation tagAndLoadModuleRefInformation;
                ProductNumberAndRevisionInterface productNumberAndRevisionInterface;
                piuTypeMoData = (PiuTypeMoData)iterator.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, Collection aSSW_PIUs)", "theGenericUpgradeablePlugInUnitData: " + piuTypeMoData.plugInUnit + "\n\tProduct number of PiuType: " + piuTypeMoData.productNumber + "\n\tProduct revision of PiuType: " + piuTypeMoData.productRevision);
                }
                if (piuTypeMoData.plugInUnit instanceof PlugInUnitMoSU_Access) {
                    if (!collection.contains(piuTypeMoData.plugInUnit)) continue;
                    collection3 = this.collectConnectedRepertoireNames(piuTypeMoData.plugInUnit, string, optimizedDocumentObjectProxyInterface);
                    productNumberAndRevisionInterface = this.getSupportedPiuType(optimizedDocumentObjectProxyInterface, piuTypeMoData);
                    if (productNumberAndRevisionInterface != null) {
                        tagAndLoadModuleRefInformation = repertoiresProxyInterface.getLoadModuleRefsConnectedToPiuTypeOpt(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision(), collection3);
                        tagAndLoadModuleRefInformation.handleLoadModuleRefInfosWithoutLoaderName(optimizedDocumentObjectProxyInterface);
                        tagAndLoadModuleRefInformation.setGenericUpgradeablePlugInUnit(piuTypeMoData.plugInUnit);
                        slotMoSU_Access = (SlotMoSU_Access)((PlugInUnitMoSU_Access)piuTypeMoData.plugInUnit).getParent();
                        tagAndLoadModuleRefInformation.setSlotMo(slotMoSU_Access);
                        object = new SignedSoftwareInformationForPIU(((SubrackMoSU_Access)slotMoSU_Access.getParent()).getSwitchModuleNumber(null), slotMoSU_Access.getAsciPortNumber(null), tagAndLoadModuleRefInformation, optimizedDocumentObjectProxyInterface);
                        collection4 = SignedSoftwareUtils.add((SignedSoftwareInformationForPIU_Interface)object, collection4);
                        continue;
                    }
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, Collection aSSW_PIUs)", "A configured PIU is not supported in the UP and hence no SSW validation will be performed for that one\n\ttheGenericUpgradeablePlugInUnitData: " + piuTypeMoData);
                    continue;
                }
                if (!upgradeablePIU_HandlerInterface.isInstanceOfSSW_UpgradeablePlugInUnit(piuTypeMoData.plugInUnit) || !collection.contains(piuTypeMoData.plugInUnit)) continue;
                collection3 = this.collectConnectedRepertoireNames(piuTypeMoData.plugInUnit, string, optimizedDocumentObjectProxyInterface);
                productNumberAndRevisionInterface = this.getSupportedPiuType(optimizedDocumentObjectProxyInterface, piuTypeMoData);
                if (productNumberAndRevisionInterface != null) {
                    tagAndLoadModuleRefInformation = repertoiresProxyInterface.getLoadModuleRefsConnectedToPiuTypeOpt(productNumberAndRevisionInterface.getProductNumber(), productNumberAndRevisionInterface.getRevision(), collection3);
                    tagAndLoadModuleRefInformation.handleLoadModuleRefInfosWithoutLoaderName(optimizedDocumentObjectProxyInterface);
                    tagAndLoadModuleRefInformation.setGenericUpgradeablePlugInUnit(piuTypeMoData.plugInUnit);
                    object = ServiceFinder.getManagedElementMO_HandlerInterface();
                    PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = object.getFtcMos();
                    SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
                    plugInUnitMoSU_AccessArray = SignedSoftwareUtils.contains(collection, plugInUnitMoSU_AccessArray);
                    SlotMoSU_Access[] slotMoSU_AccessArray = slotMO_HandlerInterface.getSlotMos(plugInUnitMoSU_AccessArray);
                    for (int i = 0; i < slotMoSU_AccessArray.length; ++i) {
                        SignedSoftwareInformationForPIU signedSoftwareInformationForPIU = new SignedSoftwareInformationForPIU(slotMoSU_AccessArray[i].getSubrackMo(null).getSwitchModuleNumber(null), slotMoSU_AccessArray[i].getAsciPortNumber(null), tagAndLoadModuleRefInformation, optimizedDocumentObjectProxyInterface);
                        collection4 = SignedSoftwareUtils.add(signedSoftwareInformationForPIU, collection4);
                    }
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, Collection aSSW_PIUs)", "A configured PIU is not supported in the UP and hence no SSW validation will be performed for that one\n\ttheGenericUpgradeablePlugInUnitData: " + piuTypeMoData);
            }
            if (Trace.valid(this.getClass(), 40)) {
                SignedSoftwareUtils.logCollectedPrograms(this.getClass(), optimizedDocumentObjectProxyInterface, collection4);
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, Collection aSSW_PIUs)", "RETURNS - theSignedSoftwareInformations: " + collection4);
            }
            return collection4;
        }
        catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
            throw new VerifyRequestException(upgradeablePIU_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collect(String aCase, OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCurrentCase: " + string, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    public Collection collectCrlAndCertificates(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, String string) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectCrlAndCertificates(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, String aCurrentCase, Collection aSSW_PIUs)", "\n\taOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taCurrentCase: " + string);
        }
        Collection collection = this.getSignedUpgradeablePIUs();
        Iterator iterator = this.collect(optimizedDocumentObjectProxyInterface, string, collection).iterator();
        LinkedList<SignedSoftwareInformationForPIUs> linkedList = new LinkedList<SignedSoftwareInformationForPIUs>();
        SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs = null;
        while (iterator.hasNext()) {
            SignedSoftwareInformationForPIU signedSoftwareInformationForPIU = (SignedSoftwareInformationForPIU)iterator.next();
            Collection collection2 = signedSoftwareInformationForPIU.getSignedProgramInformationsForPIU();
            Iterator iterator2 = collection2.iterator();
            LoadModuleProgramInterface loadModuleProgramInterface = null;
            String string2 = null;
            LinkedList<LoadModuleProgramInterface> linkedList2 = new LinkedList<LoadModuleProgramInterface>();
            while (iterator2.hasNext()) {
                loadModuleProgramInterface = (LoadModuleProgramInterface)iterator2.next();
                string2 = loadModuleProgramInterface.getLoadClass();
                if (string2 != null && !string2.equals("")) {
                    if (string2.equalsIgnoreCase(MoDataLM_OseProgramLoadClassValue.CrlCertificate)) continue;
                    linkedList2.add(loadModuleProgramInterface);
                    continue;
                }
                linkedList2.add(loadModuleProgramInterface);
            }
            collection2.removeAll(linkedList2);
            if (collection2.size() <= 0) continue;
            signedSoftwareInformationForPIUs = new SignedSoftwareInformationForPIUs(signedSoftwareInformationForPIU.getSMN(), signedSoftwareInformationForPIU.getAPN(), collection2);
            linkedList.add(signedSoftwareInformationForPIUs);
        }
        if (Trace.valid(this.getClass(), 40)) {
            this.logCollectedPrograms(optimizedDocumentObjectProxyInterface, linkedList);
        }
        return linkedList;
    }

    private ProductNumberAndRevisionInterface getSupportedPiuType(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, PiuTypeMoData piuTypeMoData) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSupportedPiuType(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, PiuTypeMoData aGenericUpgradeablePlugInUnitData)", "aOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taGenericUpgradeablePlugInUnitData: " + piuTypeMoData);
        }
        try {
            Object object;
            PiuTypesProxyInterface piuTypesProxyInterface = optimizedDocumentObjectProxyInterface.getPiuTypesProxyInterface();
            ProductNumberAndRevision productNumberAndRevision = new ProductNumberAndRevision(piuTypeMoData.productNumber, piuTypeMoData.productRevision);
            PiuTypeProxyInterface piuTypeProxyInterface = piuTypesProxyInterface.getPiuTypeProxyInterface(productNumberAndRevision, true);
            if (piuTypeProxyInterface == null && piuTypeMoData.productRevision.equals("*") && (object = ServiceFinder.getUpgradeablePIU_HandlerInterface().getOriginRevision(piuTypeMoData.plugInUnit)) != null) {
                piuTypeProxyInterface = piuTypesProxyInterface.getPiuTypeProxyInterface(new ProductNumberAndRevision(piuTypeMoData.productNumber, (String)object), true);
            }
            object = null;
            if (piuTypeProxyInterface != null) {
                object = new ProductNumberAndRevision(piuTypeProxyInterface.getProductNumber(), piuTypeProxyInterface.getProductRevision());
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "getSupportedPiuType(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, PiuTypeMoData aGenericUpgradeablePlugInUnitData)", "RETURNS - thePiuTypeProdNoAndRevToBeUsed: " + object);
            }
            return object;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSupportedPiuType(OptimizedDocumentObjectProxyInterface aOptimizedDocumentObjectProxyInterface, PiuTypeMoData aGenericUpgradeablePlugInUnitData)", "aOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface + "\n\taGenericUpgradeablePlugInUnitData: " + piuTypeMoData, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private Collection collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit, String string, OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface) throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCase, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCase: " + string + "\n\tanOptimizedDocumentObjectProxyInterface: " + optimizedDocumentObjectProxyInterface);
        }
        try {
            Object object;
            SwAllocationMoSU_Access swAllocationMoSU_Access = (SwAllocationMoSU_Access)genericUpgradeablePlugInUnit.getSwAllocation(null);
            AbstractCollection abstractCollection = null;
            if (swAllocationMoSU_Access != null) {
                object = new SwAllocationHelper();
                abstractCollection = ((SwAllocationHelper)object).getConnectedRepertoirNames(swAllocationMoSU_Access);
            } else {
                abstractCollection = new HashSet();
            }
            object = optimizedDocumentObjectProxyInterface.getRepertoireNamesToBeUsed(abstractCollection, string);
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, String aCase, OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface)", "RETURNS - theRepertoirNamesToBeUsed: " + object);
            }
            return object;
        }
        catch (SwAllocationHelperException swAllocationHelperException) {
            throw new VerifyRequestException(swAllocationHelperException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectConnectedRepertoireNames(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit, Collection aSSW_PIUs)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\taCase: " + string, throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }

    private void logCollectedPrograms(OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface, Collection collection) {
        String string = "UP Product number: " + optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getNumber() + SEPARATOR + optimizedDocumentObjectProxyInterface.getProductDataProxyInterface().getRevision();
        String string2 = null;
        SignedSoftwareInformationForPIU_Interface signedSoftwareInformationForPIU_Interface = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            signedSoftwareInformationForPIU_Interface = (SignedSoftwareInformationForPIU_Interface)iterator.next();
            string2 = "SMN: " + signedSoftwareInformationForPIU_Interface.getSMN() + SEPARATOR + "APN: " + signedSoftwareInformationForPIU_Interface.getAPN();
            if (!Trace.valid(this.getClass(), 40)) continue;
            Trace.debug("logCollectedPrograms(OptimizedDocumentObjectProxyInterface anOptimizedDocumentObjectProxyInterface, Collection aSignedSoftwareInformationForPIU_Interfaces)", string + SEPARATOR + "thePIU_LMs: " + string2 + SEPARATOR + "Number of LMs: " + signedSoftwareInformationForPIU_Interface.getSignedProgramInformationsForPIU().size());
        }
    }

    private Collection getSignedUpgradeablePIUs() throws VerifyRequestException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSignedUpgradeablePIUs()");
        }
        UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
        try {
            Collection collection = upgradeablePIU_HandlerInterface.getSignedUpgradeablePlugInUnits();
            if (SignedSoftwareUtils.hasSSW_UpgradeablePlugInUnit(collection)) {
                ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
                PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = managedElementMO_HandlerInterface.getFtcMos();
                if ((plugInUnitMoSU_AccessArray = SignedSoftwareUtils.contains(collection, plugInUnitMoSU_AccessArray)).length == 0) {
                    collection = SignedSoftwareUtils.removeAllSSW_UpgradeablePlugInUnit(collection);
                }
            }
            return collection;
        }
        catch (Exception exception) {
            throw new VerifyRequestException(exception.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getSignedUpgradeablePIUs()", "getSignedUpgradeablePIUs()", throwable);
            throw new VerifyRequestException(throwable.toString());
        }
    }
}

