/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify.ssw;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.su.extsuif.upgradepackage.main.exception.UpgradeException;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.SswInstallCertResultInformation;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageHandlerException;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.repertoire.LoadModuleProgramInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.handler.SignedSoftwareInformationForPIUs;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.jvm.JvmMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.CalculateProgramsForToState;
import se.ericsson.cello.upgradepackage.verify.ssw.CrlAndCertificateLM_InfoContainer;

public class CrlAndCertificateToStateHandler {
    private String myUpgradePackageUCF_Path = null;
    private String myUpgradePackageDocumentNumber = null;
    private String myUpgradePackageDocumentRevision = null;
    private String myCase = null;
    private Collection myAllCaseValues = new Vector(1);
    private Collection myAllSignedSoftwareInformationForPIUs = null;
    private ValidSequencesInformation myValidSequencesInformation = null;
    private static final String REPLICATED_PARTITION = "/d/";

    public CrlAndCertificateToStateHandler(String string, String string2, String string3, String string4) {
        this.myUpgradePackageUCF_Path = string;
        this.myUpgradePackageDocumentNumber = string2;
        this.myUpgradePackageDocumentRevision = string3;
        this.myCase = string4;
    }

    public CrlAndCertificateToStateHandler(String string, String string2, String string3, ValidSequencesInformation validSequencesInformation) {
        this.myUpgradePackageUCF_Path = string;
        this.myUpgradePackageDocumentNumber = string2;
        this.myUpgradePackageDocumentRevision = string3;
        this.myValidSequencesInformation = validSequencesInformation;
    }

    public CrlAndCertificateToStateHandler(String string, String string2, String string3, Collection collection) {
        this.myUpgradePackageUCF_Path = string;
        this.myUpgradePackageDocumentNumber = string2;
        this.myUpgradePackageDocumentRevision = string3;
        this.myAllCaseValues = collection;
    }

    public void loadJVMCrlAndCertForToState() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadJVMCrlAndCertForToState()");
        }
        try {
            JvmMO_HandlerInterface jvmMO_HandlerInterface = ServiceFinder.getJvmMO_HandlerInterface();
            PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = jvmMO_HandlerInterface.getJVM_PIUs();
            if (plugInUnitMoSU_AccessArray.length > 0) {
                for (int i = 0; i < plugInUnitMoSU_AccessArray.length; ++i) {
                    this.loadCrlAndCertForToState((GenericUpgradeablePlugInUnit)plugInUnitMoSU_AccessArray[i]);
                }
            }
        }
        catch (JvmMO_HandlerException jvmMO_HandlerException) {
            Trace.error(this.getClass(), "loadJVMCrlAndCertForToState()", "Failed to get the JVM PIUs, exception caught.", (Throwable)((Object)jvmMO_HandlerException));
        }
    }

    public void loadCrlAndCertForToState(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadCrlAndCertForToState(GenericUpgradeablePlugInUnit aPiuMo)", "aPiuMo: " + genericUpgradeablePlugInUnit);
        }
        if (this.myAllSignedSoftwareInformationForPIUs == null) {
            this.myAllSignedSoftwareInformationForPIUs = this.getAllCrlAndCertificatesForToState();
        }
        CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer = null;
        Collection collection = this.getCrlAndCertificatesForToState(genericUpgradeablePlugInUnit);
        Iterator iterator = collection.iterator();
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadCrlAndCertForToState(GenericUpgradeablePlugInUnit aPiuMo)", "theCrlAndCertificatesForToState: " + collection);
        }
        if (!collection.isEmpty()) {
            if (!this.isLoadOfToStateCrlAndCertSupported()) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.log1(this.getClass(), "loadJVMCrlAndCertForToState(GenericUpgradeablePlugInUnit aPiuMo)", "Loading of to state certificates and crls is not supported in this version. aPiuMo: " + genericUpgradeablePlugInUnit + "\n\tNote however that there are certificates/CRLs that should have been loaded: " + collection);
                }
                return;
            }
        } else if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadCrlAndCertForToState(GenericUpgradeablePlugInUnit aPiuMo)", "No Certificates or CRLs needs to be loaded");
        }
        while (iterator.hasNext()) {
            crlAndCertificateLM_InfoContainer = (CrlAndCertificateLM_InfoContainer)iterator.next();
            if (!this.isCrlAndCertAlreadyLoaded(crlAndCertificateLM_InfoContainer)) {
                if (!this.loadCrlAndCertificate(crlAndCertificateLM_InfoContainer) || !Trace.valid(this.getClass(), 40)) continue;
                this.logLoadedCertInfo("Loaded to state certs for piu: " + genericUpgradeablePlugInUnit + ".", crlAndCertificateLM_InfoContainer);
                continue;
            }
            if (!Trace.valid(this.getClass(), 40)) continue;
            this.logLoadedCertInfo("Did not load to state certs for piu: " + genericUpgradeablePlugInUnit + ". Already loaded.", crlAndCertificateLM_InfoContainer);
        }
    }

    private boolean isLoadOfToStateCrlAndCertSupported() {
        boolean bl = false;
        OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
        try {
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_5", (Object)osaSwInstallProxyAccess)) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "isLoadOfToStateCrlAndCertSupported()", "Failed to look up the version of Osa Sw Install function (assuming not supported)");
        }
        return bl;
    }

    private void logLoadedCertInfo(String string, CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) {
        String string2 = "";
        Iterator iterator = crlAndCertificateLM_InfoContainer.getFilePaths().iterator();
        while (iterator.hasNext()) {
            if (!string2.equals("")) {
                string2 = string2 + ";";
            }
            string2 = string2 + iterator.next();
        }
        Trace.log1(this.getClass(), "logLoadedCertInfo(String aStartString)", string + " SMN: " + crlAndCertificateLM_InfoContainer.getSMN() + " APN: " + crlAndCertificateLM_InfoContainer.getAPN() + " ClassPaths: " + string2);
    }

    private Collection getCrlAndCertificatesForToState(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCrlAndCertificatesForToState(GenericUpgradeablePlugInUnit aPiuMo)", "aPiuMo: " + genericUpgradeablePlugInUnit);
        }
        Vector vector = new Vector(1);
        try {
            SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs = null;
            Iterator iterator = this.myAllSignedSoftwareInformationForPIUs.iterator();
            while (iterator.hasNext()) {
                signedSoftwareInformationForPIUs = (SignedSoftwareInformationForPIUs)iterator.next();
                if (this.isCrlAndCertForPiuInToState(signedSoftwareInformationForPIUs, genericUpgradeablePlugInUnit)) {
                    vector.addAll(this.createCrlAndCertificateLM_InfoContainers(signedSoftwareInformationForPIUs));
                    break;
                }
                signedSoftwareInformationForPIUs = null;
            }
        }
        catch (UpgradeException upgradeException) {
            Trace.error(this.getClass(), "getCrlAndCertificatesForToState(GenericUpgradeablePlugInUnit aPiuMo)", "Failed to get Crls and ceritificates for PIU, exception caught\n\taPiuMo: " + genericUpgradeablePlugInUnit, (Throwable)((Object)upgradeException));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getCrlAndCertificatesForToState(GenericUpgradeablePlugInUnit aPiuMo)", "Returning - theCrlAndCertificateLM_InfoContainers: " + vector);
        }
        return vector;
    }

    public SignedSoftwareInformationForPIUs getCrlAndCertificatesForToStateJAues(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCrlAndCertificatesForToStateJAues(GenericUpgradeablePlugInUnit aPiuMo)", "aPiuMo: " + genericUpgradeablePlugInUnit);
        }
        SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs = null;
        try {
            if (this.myAllSignedSoftwareInformationForPIUs == null) {
                this.myAllSignedSoftwareInformationForPIUs = this.getAllCrlAndCertificatesForToState();
            }
            Iterator iterator = this.myAllSignedSoftwareInformationForPIUs.iterator();
            while (iterator.hasNext() && !this.isCrlAndCertForPiuInToState(signedSoftwareInformationForPIUs = (SignedSoftwareInformationForPIUs)iterator.next(), genericUpgradeablePlugInUnit)) {
                signedSoftwareInformationForPIUs = null;
            }
        }
        catch (UpgradeException upgradeException) {
            Trace.error(this.getClass(), "getCrlAndCertificatesForToState(GenericUpgradeablePlugInUnit aPiuMo)", "Failed to get Crls and ceritificates for PIU, exception caught\n\taPiuMo: " + genericUpgradeablePlugInUnit, (Throwable)((Object)upgradeException));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getCrlAndCertificatesForToStateJAues(GenericUpgradeablePlugInUnit aPiuMo)", "Returning - theSignedSoftwareInformationForPIUs: " + signedSoftwareInformationForPIUs);
        }
        return signedSoftwareInformationForPIUs;
    }

    private boolean isCrlAndCertAlreadyLoaded(CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isCrlAndCertAlreadyLoaded(CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "aCrlAndCertificateLM_InfoContainer: " + crlAndCertificateLM_InfoContainer);
        }
        boolean bl = false;
        try {
            bl = UpgradeDB_StorageUtil.isLoadedCertInfoExisting(crlAndCertificateLM_InfoContainer);
        }
        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
            Trace.error(this.getClass(), "isCrlAndCertAlreadyLoaded(CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "Failed to check if Crls and ceritificates for PIU already has been loaded, exception caught. Assuming that is has not been loaded.", (Throwable)((Object)upgradeDB_StorageHandlerException));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "isCrlAndCertAlreadyLoaded(CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "Returning - theIsCrlAndCertAlreadyLoaded: " + bl);
        }
        return bl;
    }

    private boolean isCrlAndCertForPiuInToState(SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs, GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) throws UpgradeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isCrlAndCertForPiuInToState(SignedSoftwareInformationForPIUs aSignedSoftwareInformationForPIUs, GenericUpgradeablePlugInUnit aPlugInUnit)", "aSignedSoftwareInformationForPIUs: " + signedSoftwareInformationForPIUs + "aPlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        boolean bl = false;
        try {
            if (genericUpgradeablePlugInUnit instanceof PlugInUnitMoSU_Access) {
                SlotMoSU_Access slotMoSU_Access = (SlotMoSU_Access)((PlugInUnitMoSU_Access)genericUpgradeablePlugInUnit).getParent();
                if (this.isSmnApnEqual(signedSoftwareInformationForPIUs, slotMoSU_Access)) {
                    bl = true;
                }
            } else {
                UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
                if (upgradeablePIU_HandlerInterface.isInstanceOfSSW_UpgradeablePlugInUnit(genericUpgradeablePlugInUnit)) {
                    ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
                    PlugInUnitMoSU_Access[] plugInUnitMoSU_AccessArray = managedElementMO_HandlerInterface.getFtcMos();
                    SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
                    SlotMoSU_Access[] slotMoSU_AccessArray = slotMO_HandlerInterface.getSlotMos(plugInUnitMoSU_AccessArray);
                    for (int i = 0; i < slotMoSU_AccessArray.length; ++i) {
                        if (!this.isSmnApnEqual(signedSoftwareInformationForPIUs, slotMoSU_AccessArray[i])) continue;
                        bl = true;
                    }
                } else if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "isCrlAndCertForPiuInToState(SignedSoftwareInformationForPIUs aSignedSoftwareInformationForPIUs, GenericUpgradeablePlugInUnit aPlugInUnit)", "PIU not SSW UpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
                }
            }
        }
        catch (UpgradeException upgradeException) {
            throw upgradeException;
        }
        catch (Throwable throwable) {
            throw new UpgradeException("Class name: " + this.getClass().getName() + "\n\tisCrlAndCertForPiuInToState(SignedSoftwareInformationForPIUs aSignedSoftwareInformationForPIUs, GenericUpgradeablePlugInUnit aPlugInUnit)" + "\n\tThrowable caught." + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "isCrlAndCertForPiuInToState(SignedSoftwareInformationForPIUs aSignedSoftwareInformationForPIUs, GenericUpgradeablePlugInUnit aPlugInUnit)", "Returning - theIsCrlAndCertForPiuInToState: " + bl);
        }
        return bl;
    }

    private boolean isSmnApnEqual(SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs, SlotMoSU_Access slotMoSU_Access) throws UpgradeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isSmnApnEqual(SignedSoftwareInformationForPIUs aSignedSoftwareInformationForPIUs, SlotMoSU_Access aSlotMo)", "aSignedSoftwareInformationForPIUs: " + signedSoftwareInformationForPIUs + "\n\taSlotMo: " + slotMoSU_Access);
        }
        boolean bl = false;
        try {
            if (slotMoSU_Access.getSubrackMo(null).getSwitchModuleNumber(null) == signedSoftwareInformationForPIUs.getSMN() && slotMoSU_Access.getAsciPortNumber(null) == signedSoftwareInformationForPIUs.getAPN()) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            throw new UpgradeException("Class name: " + this.getClass().getName() + "\n\tMethod: isSmnApnEqual(SignedSoftwareInformationForPIUs aSignedSoftwareInformationForPIUs, SlotMoSU_Access aSlotMo)" + "\n\taSignedSoftwareInformationForPIUs: " + signedSoftwareInformationForPIUs + "\n\taSlotMo: " + slotMoSU_Access + "\n\tThrowable caught." + throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "isSmnApnEqual(SignedSoftwareInformationForPIUs aSignedSoftwareInformationForPIUs, SlotMoSU_Access aSlotMo)", "Returning - theSmnApnEqual: " + bl);
        }
        return bl;
    }

    private Collection getAllCrlAndCertificatesForToState() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllCrlAndCertificatesForToState()");
        }
        Collection collection = new Vector(1);
        OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = null;
        try {
            optimizedDocumentObjectProxyInterface = this.parseUCF();
            CalculateProgramsForToState calculateProgramsForToState = new CalculateProgramsForToState();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getCrlAndCertificatesForToState()", "myCase: " + this.myCase + "\n\tmyAllCaseValues " + this.myAllCaseValues + "\n\tmyValidSequencesInformation: " + this.myValidSequencesInformation);
            }
            if (this.myCase != null) {
                collection = calculateProgramsForToState.collectCrlAndCertificates(optimizedDocumentObjectProxyInterface, this.myCase);
            } else if (this.myAllCaseValues.size() != 0) {
                Iterator iterator = this.myAllCaseValues.iterator();
                String string = null;
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    collection.addAll(calculateProgramsForToState.collectCrlAndCertificates(optimizedDocumentObjectProxyInterface, string));
                }
            } else {
                collection = calculateProgramsForToState.collectCrlAndCertificates(optimizedDocumentObjectProxyInterface, this.myValidSequencesInformation);
            }
            this.logTotalCrlCertInfoToState(collection);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "getAllCrlAndCertificatesForToState()", "Failed to load all Crl and Certificated for TO state, Throwable caught, \n\tThis might cause the upgrade to fail.\n\tThrowable: " + throwable);
        }
        return collection;
    }

    public Collection installRequiredCrlAndCertLMs() {
        Collection collection = new LinkedList();
        if (this.myAllSignedSoftwareInformationForPIUs == null) {
            this.myAllSignedSoftwareInformationForPIUs = this.getAllCrlAndCertificatesForToState();
        }
        Iterator iterator = this.myAllSignedSoftwareInformationForPIUs.iterator();
        SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs = null;
        while (iterator.hasNext()) {
            signedSoftwareInformationForPIUs = (SignedSoftwareInformationForPIUs)iterator.next();
            collection = this.addAllLmsThatMustBeInstalled(collection, signedSoftwareInformationForPIUs.getSignedProgramInformationsForPIU());
        }
        return collection;
    }

    private Collection addAllLmsThatMustBeInstalled(Collection collection, Collection collection2) {
        Iterator iterator = collection2.iterator();
        LoadModuleProgramInterface loadModuleProgramInterface = null;
        ProductNumberAndRevision productNumberAndRevision = null;
        while (iterator.hasNext()) {
            loadModuleProgramInterface = (LoadModuleProgramInterface)iterator.next();
            productNumberAndRevision = new ProductNumberAndRevision(loadModuleProgramInterface.getProductNumber(), loadModuleProgramInterface.getRevision());
            if (collection.contains(productNumberAndRevision)) continue;
            collection.add(productNumberAndRevision);
        }
        return collection;
    }

    private OptimizedDocumentObjectProxyInterface parseUCF() throws UpgradeException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "parseUCF()");
        }
        try {
            String[] stringArray = new String[]{"Repertoire", "ExplicitReplacement", "PiuType", "LoadModule"};
            return UCF_ParserFacade.parseMainElementsOptimizedInterface(this.myUpgradePackageDocumentNumber, this.myUpgradePackageDocumentRevision, this.myUpgradePackageUCF_Path, stringArray, false);
        }
        catch (Throwable throwable) {
            throw new UpgradeException("Class name: " + this.getClass().getName() + "\n\tparseUCF()" + "\n\tThrowable caught," + "\n\tmyUpgradePackageUCF_Path: " + this.myUpgradePackageUCF_Path + "\n\tmyUpgradePackageDocumentNumber: " + this.myUpgradePackageDocumentNumber + "\n\tmyUpgradePackageDocumentRevision: " + this.myUpgradePackageDocumentRevision + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private void logTotalCrlCertInfoToState(Collection collection) {
        SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs = null;
        Iterator iterator = collection.iterator();
        if (Trace.valid(this.getClass(), 40)) {
            Trace.log1(this.getClass(), "logTotalCrlCertInfoToState(Collection aCrlsAndCertsInfoForToState)", "CertCrl for TO state to be loaded  " + collection);
        }
        while (iterator.hasNext()) {
            signedSoftwareInformationForPIUs = (SignedSoftwareInformationForPIUs)iterator.next();
            LoadModuleProgramInterface loadModuleProgramInterface = null;
            Iterator iterator2 = signedSoftwareInformationForPIUs.getSignedProgramInformationsForPIU().iterator();
            while (iterator2.hasNext()) {
                loadModuleProgramInterface = (LoadModuleProgramInterface)iterator2.next();
                if (!Trace.valid(this.getClass(), 40)) continue;
                Trace.log1(this.getClass(), "logTotalCrlCertInfoToState(Collection aCrlsAndCertsInfoForToState)", "CertCrl for TO state to be loaded - SMN: " + signedSoftwareInformationForPIUs.getSMN() + ", APN: " + signedSoftwareInformationForPIUs.getAPN() + ", LM prodno: " + loadModuleProgramInterface.getProductNumber() + ", LM prodrev: " + loadModuleProgramInterface.getRevision());
            }
        }
    }

    private Collection createCrlAndCertificateLM_InfoContainers(SignedSoftwareInformationForPIUs signedSoftwareInformationForPIUs) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createCrlAndCertificateLM_InfoContainers(SignedSoftwareInformationForPIUs aSignedSoftwareInformationForPIUs)", "aSignedSoftwareInformationForPIUs: " + signedSoftwareInformationForPIUs);
        }
        Vector<CrlAndCertificateLM_InfoContainer> vector = new Vector<CrlAndCertificateLM_InfoContainer>(1);
        LoadModuleProgramInterface loadModuleProgramInterface = null;
        Vector vector2 = new Vector(1);
        Iterator iterator = signedSoftwareInformationForPIUs.getSignedProgramInformationsForPIU().iterator();
        while (iterator.hasNext()) {
            loadModuleProgramInterface = (LoadModuleProgramInterface)iterator.next();
            vector2.addAll(this.ensureReplicatedPaths(loadModuleProgramInterface.getDestinationFilePaths()));
        }
        CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer = new CrlAndCertificateLM_InfoContainer(signedSoftwareInformationForPIUs.getSMN(), signedSoftwareInformationForPIUs.getAPN(), vector2);
        vector.add(crlAndCertificateLM_InfoContainer);
        return vector;
    }

    private boolean loadCrlAndCertificate(CrlAndCertificateLM_InfoContainer crlAndCertificateLM_InfoContainer) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "loadCrlAndCertificate(CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "aCrlAndCertificateLM_InfoContainer: " + crlAndCertificateLM_InfoContainer);
        }
        boolean bl = false;
        OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
        try {
            SswInstallCertResultInformation sswInstallCertResultInformation = osaSwInstallProxyAccess.sendOsaSswInstallCertReq(crlAndCertificateLM_InfoContainer.getSMN() + crlAndCertificateLM_InfoContainer.getAPN(), crlAndCertificateLM_InfoContainer.getSMN(), crlAndCertificateLM_InfoContainer.getAPN(), crlAndCertificateLM_InfoContainer.getFilePaths());
            if (sswInstallCertResultInformation.result == 0) {
                UpgradeDB_StorageUtil.saveLoadedCertInfo(crlAndCertificateLM_InfoContainer);
                bl = true;
            } else {
                Trace.error(this.getClass(), "loadCrlAndCertificate(CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "Failed to load certificates for TO state in PIU with SMN: " + crlAndCertificateLM_InfoContainer.getSMN() + " APN: " + crlAndCertificateLM_InfoContainer.getAPN() + "\n\tError result received from resource layer." + "\n\tError information: " + sswInstallCertResultInformation.errorInformation);
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "loadCrlAndCertificate(CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "It is NOT possible to load the below Crl and Certificate:\n\tSMN: " + crlAndCertificateLM_InfoContainer.getSMN() + "\n\tAPN: " + crlAndCertificateLM_InfoContainer.getAPN() + "\n\tCrlAndCertificateLM_Paths: " + crlAndCertificateLM_InfoContainer.getFilePaths(), froNotAccessibleException);
        }
        catch (UpgradeDB_StorageHandlerException upgradeDB_StorageHandlerException) {
            Trace.error(this.getClass(), "loadCrlAndCertificate(CrlAndCertificateLM_InfoContainer aCrlAndCertificateLM_InfoContainer)", "Failed to store information about the loaded cert in database:\n\tSMN: " + crlAndCertificateLM_InfoContainer.getSMN() + "\n\tAPN: " + crlAndCertificateLM_InfoContainer.getAPN() + "\n\tCrlAndCertificateLM_Paths: " + crlAndCertificateLM_InfoContainer.getFilePaths(), (Throwable)((Object)upgradeDB_StorageHandlerException));
        }
        return bl;
    }

    private Collection ensureReplicatedPaths(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ensureReplicatedPaths(Collection aPaths)", "aPaths: " + collection);
        }
        Iterator iterator = collection.iterator();
        String string = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.startsWith("/c/")) {
                string = REPLICATED_PARTITION + string.substring("/c/".length(), string.length());
            }
            linkedList.add(string);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "ensureReplicatedPaths(Collection aPaths)", "RETURNS theReplicatedPaths: " + linkedList);
        }
        return linkedList;
    }
}

