/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.nex.ConfigurationI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.StateMoParams;
import se.ericsson.cello.nex.gui.NodeStateIcon;
import se.ericsson.cello.nex.toolservices.ToolServicesI;

public class NodeStateUpdater {
    private final boolean DISABLE_EMAS_JAR_DOWNLOAD = Boolean.getBoolean("DISABLE_EMAS_JAR_DOWNLOAD");
    private ToolServicesI myToolService;
    private StateMoParams[] myStateMoParams = null;
    private Timer moSearchingTimer;
    private Runnable moSearchingRunner;
    private TimerTask searchTask;
    private Map<String, NodeStateIcon> cachedIcons = null;
    private Map<String, ImageIcon> cachedIconImages = null;
    private Map<String, NodeStateIcon> cachedDefaultIcons = null;
    private NodeStateIcon[] nodeStateIcons;
    private final String rootMoLdn = "ManagedElement=1";
    private Mo rootMo = null;
    private boolean showWarning = true;
    private final int pollperiod = 20000;

    public NodeStateUpdater() {
    }

    public NodeStateUpdater(ToolServicesI toolService) {
        NexLog.logger().finer("NodeStateUpdater constructor.");
        this.myToolService = toolService;
        ConfigurationI config = this.myToolService.getConfiguration();
        this.myStateMoParams = config.getStateMoParams();
        this.cachedIcons = new HashMap<String, NodeStateIcon>();
        this.cachedIconImages = new HashMap<String, ImageIcon>();
        if (this.myStateMoParams != null && this.myStateMoParams.length > 0) {
            this.nodeStateIcons = new NodeStateIcon[this.myStateMoParams.length];
            this.makeDefaultIcons();
            this.startTimer();
        }
        NexLog.logger().finer("Exiting NodeStateUpdater constructor.");
    }

    private void makeDefaultIcons() {
        NexLog.logger().entering(this.getClass().getName(), "makeDefaultIcons()");
        if (this.myStateMoParams == null) {
            NexLog.logger().finer("myStateMoParmas was null. Returning here.");
            return;
        }
        int n = this.myStateMoParams.length;
        this.cachedDefaultIcons = null;
        this.cachedDefaultIcons = new HashMap<String, NodeStateIcon>();
        NodeStateIcon icon = null;
        String iconFileName = null;
        String tooltip = "";
        for (int i = 0; i < n; ++i) {
            iconFileName = this.myStateMoParams[i].getIcon();
            tooltip = this.myStateMoParams[i].getToolTip();
            icon = new NodeStateIcon(new ImageIcon(), tooltip);
            this.cachedDefaultIcons.put(iconFileName, icon);
            this.nodeStateIcons[i] = icon;
        }
        NexLog.logger().exiting(this.getClass().getName(), "makeDefaultIcons()");
    }

    private Mo[] searchForMos(String moClass, String searchQuery) {
        NexLog.logger().finest("searchForMos(String moClass, String searchQuery), moClass is " + moClass + "searchQuery is: " + searchQuery);
        if (null == this.myToolService || !this.myToolService.isNodeServicesStarted()) {
            NexLog.logger().finest("searchForMos returning null. ToolService not initialized.");
            return null;
        }
        Mo[] mos = null;
        try {
            this.rootMo = this.myToolService.getNodeServices().getNode().getCmService().getMo("ManagedElement=1");
            mos = this.rootMo.getChildren(moClass, searchQuery, Scope.ALL_LEVELS, null);
        }
        catch (Exception e) {
            mos = null;
            String reason = "Can not get children mos of the type: " + moClass + "   \n" + e.getMessage();
            NexLog.logger().warning(reason);
        }
        NexLog.logger().finest("searchForMos(String moClass, String searchQuery), returning: " + mos);
        return mos;
    }

    private synchronized NodeStateIcon getCurrentIcon(StateMoParams moParams) {
        if (NexLog.logger().isLoggable(Level.FINEST)) {
            NexLog.logger().entering(this.getClass().getName(), "getCurrentIcon(StateMoParams moParams)", moParams);
        }
        String iconFileName = moParams.getIcon();
        NodeStateIcon iconOnState = null;
        NodeStateIcon icon = null;
        Mo[] mos = this.searchForMos(moParams.getMoClass(), moParams.getDisplayCondition());
        boolean displayConditionCurrentlySatisfied = false;
        displayConditionCurrentlySatisfied = mos != null && mos.length > 0;
        if (displayConditionCurrentlySatisfied) {
            iconOnState = this.cachedIcons.get(iconFileName);
            if (null == iconOnState) {
                iconOnState = this.makeNodeStateIconForStateMo(moParams);
                this.cachedIcons.put(iconFileName, iconOnState);
            }
            icon = iconOnState;
        } else {
            icon = this.cachedDefaultIcons.get(iconFileName);
        }
        if (NexLog.logger().isLoggable(Level.FINEST)) {
            NexLog.logger().exiting(this.getClass().getName(), "getCurrentIcon(StateMoParams moParams)", icon);
        }
        return icon;
    }

    private NodeStateIcon makeNodeStateIconForStateMo(StateMoParams moParams) {
        NexLog.logger().entering(this.getClass().getName(), "makeNodeStateIconForStateMo(StateMoParams moParams)", moParams);
        NodeStateIcon icon = null;
        String iconFileName = moParams.getIcon();
        String tooltip = moParams.getToolTip();
        String iconJarFileName = moParams.getIconJarFile();
        ImageIcon imageIcon = null;
        try {
            imageIcon = this.cachedIconImages.get(iconFileName);
            if (imageIcon == null) {
                imageIcon = new ImageIcon(this.myToolService.getFileInJarAsByteArray(iconFileName, iconJarFileName));
                this.cachedIconImages.put(iconFileName, imageIcon);
            }
        }
        catch (Exception e) {
            String reason = "Can not read the icon file: " + iconFileName + "\n in the jar file: " + iconJarFileName + "\n " + e.getMessage();
            NexLog.logger().log(Level.WARNING, reason);
        }
        icon = new NodeStateIcon(imageIcon, tooltip);
        NexLog.logger().exiting(this.getClass().getName(), "makeNodeStateIconForStateMo(StateMoParams moParams)", icon);
        return icon;
    }

    private void refreshAllCurrentIcons() {
        if (NexLog.logger().isLoggable(Level.FINEST)) {
            NexLog.logger().entering(this.getClass().getName(), "refreshAllCurrentIcons()");
        }
        if (this.myStateMoParams == null || this.myStateMoParams.length == 0 || this.myToolService == null || !this.myToolService.isNodeServicesStarted()) {
            String reason = "No stateMoParams or tool service is not ready.";
            if (this.showWarning) {
                this.showWarning = false;
                NexLog.logger().log(Level.WARNING, reason);
            }
            return;
        }
        NodeStateIcon icon = null;
        StateMoParams p = null;
        for (int i = 0; i < this.myStateMoParams.length; ++i) {
            p = this.myStateMoParams[i];
            this.nodeStateIcons[i] = icon = this.getCurrentIcon(p);
        }
        if (NexLog.logger().isLoggable(Level.FINEST)) {
            NexLog.logger().exiting(this.getClass().getName(), "refreshAllCurrentIcons()");
        }
    }

    private void startTimer() {
        NexLog.logger().entering(this.getClass().getName(), "startTimer()");
        this.searchTask = new TimerTask(){

            public void run() {
                NodeStateUpdater.this.refreshAllCurrentIcons();
            }
        };
        this.moSearchingRunner = new Runnable(){

            public void run() {
                NodeStateUpdater.this.moSearchingTimer = new Timer();
                NodeStateUpdater.this.moSearchingTimer.schedule(NodeStateUpdater.this.searchTask, 6000L, 20000L);
            }
        };
        new Thread(this.moSearchingRunner, "moSearchingTimer for display condition").start();
        NexLog.logger().exiting(this.getClass().getName(), "startTimer()");
    }

    public void destroy() {
        NexLog.logger().entering(this.getClass().getName(), "destroy()");
        if (null != this.moSearchingTimer) {
            this.moSearchingTimer.cancel();
            NexLog.logger().log(Level.FINER, "Destroyed: moSearchingTimer");
            this.moSearchingTimer = null;
        }
        this.cachedIcons = null;
        this.cachedDefaultIcons = null;
        this.nodeStateIcons = null;
        NexLog.logger().exiting(this.getClass().getName(), "destroy()");
    }

    public NodeStateIcon[] getNodeStateIcons() {
        return this.nodeStateIcons;
    }
}

