/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.ericsson.cello.nex.ConfigurationI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.Gui;
import se.ericsson.cello.nex.gui.XmlFileFilter;
import se.ericsson.cello.nex.toolservices.StartFailureException;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.ViewInfo;
import se.ericsson.cello.nex.viewservices.ViewServicesI;

public class ViewSelectionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8578674040569057987L;
    private static final String TOP_FOLDER_TITLE = "Available Views";
    private static final String PRE_FOLDER_TITLE = "Predefined Views";
    private static final String USER_FOLDER_TITLE = "User-Defined Views";
    private static final String IMPORT_FOLDER_TITLE = "Imported Views";
    private static final String HELP_DOC_TITLE = "Element Manager";
    private static final String HELP_DOC_SECTION = "handlingViews";
    private static final String CPI_VIEWI_DOC_TITLE = "Specifying User-Defined Views";
    private JButton myCloseButton;
    private JButton mySelectButton;
    private JButton myImportButton;
    private JButton myHelpButton;
    private JButton myRemoveButton;
    private JTextArea myDescriptionArea;
    private JTextField myRootMOTypeTextField;
    private JTextField myFileTextField;
    private JTree myTreeOfViews;
    private DefaultMutableTreeNode myTopNode;
    private DefaultMutableTreeNode myPreDefNode;
    private DefaultMutableTreeNode myUserDefNode;
    private DefaultMutableTreeNode myImportedNode;
    private ViewServicesI myViewServices;
    private ToolServicesI myToolServices;
    private TreeSelectionListener mySelectionListener;
    private Gui myOwner;
    private ViewInfo myViewInfo;
    private ConfigurationI myConfig;
    private boolean closeAtOpen;
    private boolean predefsInitiatedInViewInfo;
    private boolean userdefsInitiatedInViewInfo;
    private boolean importedInitiatedInViewInfo;

    public ViewSelectionDialog(Gui owner, String title, ViewServicesI viewServices, String selectView, ToolServicesI toolServices, ConfigurationI config, boolean closeOnOpenView) {
        super((Frame)owner.getFrame(), title);
        NexLog.logger().info("view selection dialog constructor, view is: " + selectView);
        this.closeAtOpen = closeOnOpenView;
        this.myOwner = owner;
        this.myViewServices = viewServices;
        this.myToolServices = toolServices;
        this.myViewInfo = viewServices.getViewInfo();
        this.myConfig = config;
        this.init(selectView);
    }

    public void selectView(String viewname) {
        this.selectViewInTree(viewname);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.myCloseButton)) {
            this.setVisible(false);
            this.destroy();
        } else if (arg0.getSource().equals(this.mySelectButton)) {
            final String viewname = this.myTreeOfViews.getSelectionPath().getLastPathComponent().toString();
            final ViewServicesI viewServices = this.myViewServices;
            Runnable runner = new Runnable(){

                public void run() {
                    if (viewServices != null) {
                        viewServices.startView(viewname, "");
                    }
                }
            };
            new Thread(null, runner, "SelectButton starts view " + viewname).start();
            if (this.closeAtOpen) {
                this.setVisible(false);
                this.destroy();
            }
        } else if (arg0.getSource().equals(this.myImportButton)) {
            NexLog.logger().log(Level.FINE, " Open action");
            JFileChooser fileChooser = null != this.myOwner.lastOpenViewDir ? new JFileChooser(this.myOwner.lastOpenViewDir) : new JFileChooser();
            XmlFileFilter filter = new XmlFileFilter();
            fileChooser.setFileFilter(filter);
            fileChooser.setMultiSelectionEnabled(true);
            int returnVal = fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                NexLog.logger().log(Level.FINE, " Import file " + fileChooser.getSelectedFile().getName());
                this.myOwner.lastOpenViewDir = fileChooser.getSelectedFile().getParentFile();
                File[] fileArr = fileChooser.getSelectedFiles();
                for (int i = 0; i < fileArr.length; ++i) {
                    this.myViewServices.importView(fileArr[i]);
                }
                this.importedInitiatedInViewInfo = false;
                this.refreshImportedViews();
            }
        } else if (arg0.getSource().equals(this.myRemoveButton)) {
            TreePath selectedPath = this.myTreeOfViews.getSelectionPath();
            String viewName = selectedPath.getLastPathComponent().toString();
            this.myViewServices.removeImportedView(viewName);
            this.myViewInfo.fillInImportedViews();
            this.refreshImportedViews();
        } else if (arg0.getSource().equals(this.myHelpButton)) {
            this.displayHelp();
        }
    }

    private void refreshImportedViews() {
        this.myTreeOfViews.collapsePath(new TreePath(this.myImportedNode.getPath()));
        this.myImportedNode.removeAllChildren();
        this.myTreeOfViews.revalidate();
        this.fillInImported();
        DefaultTreeModel model = (DefaultTreeModel)this.myTreeOfViews.getModel();
        model.nodeStructureChanged(this.myImportedNode);
        this.myTreeOfViews.expandPath(new TreePath(this.myImportedNode.getPath()));
    }

    private void init(String selectedViewName) {
        this.myTopNode = new DefaultMutableTreeNode(TOP_FOLDER_TITLE);
        this.myPreDefNode = new DefaultMutableTreeNode(PRE_FOLDER_TITLE);
        this.myPreDefNode.setAllowsChildren(true);
        this.myUserDefNode = new DefaultMutableTreeNode(USER_FOLDER_TITLE);
        this.myUserDefNode.setAllowsChildren(true);
        this.myImportedNode = new DefaultMutableTreeNode(IMPORT_FOLDER_TITLE);
        this.myImportedNode.setAllowsChildren(true);
        this.fillInPreDefs();
        this.fillInUserDefs();
        this.fillInImported();
        this.myTopNode.add(this.myPreDefNode);
        this.myTopNode.add(this.myUserDefNode);
        this.myTopNode.add(this.myImportedNode);
        this.myTreeOfViews = new JTree(this.myTopNode);
        this.myTreeOfViews.setCellRenderer(new TreeOfViewsCellRenderer());
        this.myDescriptionArea = new JTextArea();
        this.myDescriptionArea.setLineWrap(true);
        this.myDescriptionArea.setWrapStyleWord(true);
        this.myDescriptionArea.setEditable(false);
        this.myDescriptionArea.setOpaque(false);
        this.myDescriptionArea.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.myDescriptionArea.setName("txtViewDescription");
        JScrollPane listScrollPane = new JScrollPane(this.myTreeOfViews);
        JPanel descPanel = new JPanel(new BorderLayout());
        this.myFileTextField = new JTextField();
        this.myFileTextField.setEditable(false);
        JScrollPane descScrollPane = new JScrollPane(this.myDescriptionArea);
        descScrollPane.setHorizontalScrollBarPolicy(31);
        listScrollPane.setMinimumSize(new Dimension(280, 400));
        descScrollPane.setMinimumSize(new Dimension(400, 400));
        listScrollPane.setPreferredSize(new Dimension(280, 400));
        descScrollPane.setPreferredSize(new Dimension(400, 400));
        this.myRootMOTypeTextField = new JTextField();
        JPanel rootMOTypePanel = new JPanel(new BorderLayout());
        rootMOTypePanel.add((Component)new JLabel("  Required top MO class: "), "West");
        rootMOTypePanel.add((Component)this.myRootMOTypeTextField, "Center");
        JPanel descriptionHeaderPanel = new JPanel(new BorderLayout(10, 5));
        descriptionHeaderPanel.add((Component)new JLabel("View Description", 0), "Center");
        rootMOTypePanel.add("South", descriptionHeaderPanel);
        this.myRootMOTypeTextField.setEditable(false);
        this.myRootMOTypeTextField.setName("txtRootMOType");
        descPanel.add((Component)rootMOTypePanel, "North");
        descPanel.add((Component)descScrollPane, "Center");
        descPanel.add((Component)this.myFileTextField, "South");
        JSplitPane splitPane = new JSplitPane(1, listScrollPane, descPanel);
        splitPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
        selModel.setSelectionMode(1);
        this.myTreeOfViews.setSelectionModel(selModel);
        this.mySelectionListener = new TreeOfViewsSelectionListener();
        this.myTreeOfViews.addTreeSelectionListener(this.mySelectionListener);
        this.myCloseButton = new JButton("Close");
        this.myCloseButton.setMnemonic('c');
        this.myCloseButton.setToolTipText("Close this window");
        this.mySelectButton = new JButton("Open View");
        this.mySelectButton.setMnemonic('o');
        String openToolTip = this.closeAtOpen ? "Open selected view and close this window" : "Open selected view";
        this.mySelectButton.setToolTipText(openToolTip);
        this.myImportButton = new JButton("Import View File...");
        this.myImportButton.setMnemonic('i');
        this.myImportButton.setToolTipText("Import view XML file from the file system");
        this.myRemoveButton = new JButton("Remove Imported View");
        this.myRemoveButton.setMnemonic('r');
        this.myRemoveButton.setToolTipText("Remove selected imported view");
        this.myRemoveButton.setEnabled(false);
        this.myHelpButton = new JButton("Help");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.mySelectButton);
        buttonPanel.add(this.myImportButton);
        buttonPanel.add(this.myRemoveButton);
        buttonPanel.add(this.myCloseButton);
        buttonPanel.add(this.myHelpButton);
        this.myCloseButton.addActionListener(this);
        this.mySelectButton.addActionListener(this);
        this.myImportButton.addActionListener(this);
        this.myRemoveButton.addActionListener(this);
        this.myHelpButton.addActionListener(this);
        this.myCloseButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "");
        this.myCloseButton.getActionMap().put("", new AbstractAction(){
            private static final long serialVersionUID = 8034053819186763053L;

            public void actionPerformed(ActionEvent event) {
                ViewSelectionDialog.this.setVisible(false);
                ViewSelectionDialog.this.destroy();
            }
        });
        this.myHelpButton.getInputMap(2).put(KeyStroke.getKeyStroke(112, 0), "");
        this.myHelpButton.getActionMap().put("", new AbstractAction(){
            private static final long serialVersionUID = -297313304928575747L;

            public void actionPerformed(ActionEvent ae) {
                ViewSelectionDialog.this.displayHelp();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        for (int i = 0; i < this.myTreeOfViews.getRowCount(); ++i) {
            this.myTreeOfViews.expandRow(i);
        }
        this.selectViewInTree(selectedViewName);
        this.pack();
    }

    private void selectViewInTree(String viewname) {
        if (viewname != null && viewname.length() > 0) {
            DefaultMutableTreeNode node = null;
            boolean found = false;
            Enumeration<TreeNode> folderEnum = this.myTopNode.children();
            block0: while (folderEnum.hasMoreElements() && !found) {
                node = (DefaultMutableTreeNode)folderEnum.nextElement();
                Enumeration<TreeNode> viewEnum = node.children();
                while (viewEnum.hasMoreElements()) {
                    node = (DefaultMutableTreeNode)viewEnum.nextElement();
                    if (!node.toString().equals(viewname)) continue;
                    found = true;
                    continue block0;
                }
            }
            if (found) {
                TreePath selectNodeTreePath = new TreePath(node.getPath());
                this.myTreeOfViews.scrollPathToVisible(selectNodeTreePath);
                this.myTreeOfViews.addSelectionPath(selectNodeTreePath);
            }
        }
    }

    private void fillInPreDefs() {
        this.myPreDefNode.add(new DefaultMutableTreeNode("Containment (MOM based)"));
        Collection<String> preDefs = this.myViewServices.getPreDefViewNames();
        for (String viewName : preDefs) {
            this.myPreDefNode.add(new DefaultMutableTreeNode(viewName));
        }
    }

    private void fillInUserDefs() {
        Collection<String> userDefs = this.myViewServices.getUserDefViewNames();
        NexLog.logger().fine("userDefs size is " + userDefs.size());
        for (String viewName : userDefs) {
            NexLog.logger().fine("filling in user-defined view named " + viewName);
            this.myUserDefNode.add(new DefaultMutableTreeNode(viewName));
        }
    }

    private void fillInImported() {
        Collection<String> imps = this.myViewServices.getImportedViewNames();
        for (String viewName : imps) {
            this.myImportedNode.add(new DefaultMutableTreeNode(viewName));
        }
    }

    private void destroy() {
        this.myTreeOfViews.removeTreeSelectionListener(this.mySelectionListener);
        this.myCloseButton.removeActionListener(this);
        this.mySelectButton.removeActionListener(this);
        this.myImportButton.removeActionListener(this);
        this.myRemoveButton.removeActionListener(this);
        this.myHelpButton.removeActionListener(this);
        this.myTreeOfViews = null;
        this.mySelectionListener = null;
        this.myCloseButton = null;
        this.mySelectButton = null;
        this.myImportButton = null;
        this.myRemoveButton = null;
        this.myDescriptionArea = null;
        this.myRootMOTypeTextField = null;
        this.myTopNode = null;
        this.myPreDefNode = null;
        this.myUserDefNode = null;
        this.myImportedNode = null;
        this.myViewServices = null;
        this.dispose();
    }

    private void displayHelp() {
        Properties props = new Properties();
        props.setProperty("DOC_TITLE", HELP_DOC_TITLE);
        props.setProperty("SECTION_TAG", HELP_DOC_SECTION);
        try {
            this.myToolServices.startHelpTool(props);
        }
        catch (StartFailureException e) {
            NexLog.logger().log(Level.WARNING, "Can not start Help Service from View Description Dialog.\n" + NexLog.stackToString(e));
        }
    }

    private void disableRemoveImported() {
        this.myRemoveButton.setEnabled(false);
        this.myFileTextField.setForeground(this.myRootMOTypeTextField.getForeground());
        this.myFileTextField.setText("");
    }

    private static class TreeOfViewsCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 7115614567516974523L;

        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean is_selected, boolean is_expanded, boolean is_leaf, int row, boolean focus) {
            if (obj.toString().equals(ViewSelectionDialog.TOP_FOLDER_TITLE) || obj.toString().equals(ViewSelectionDialog.PRE_FOLDER_TITLE) || obj.toString().equals(ViewSelectionDialog.USER_FOLDER_TITLE) || obj.toString().equals(ViewSelectionDialog.IMPORT_FOLDER_TITLE)) {
                this.setLeafIcon(super.getDefaultClosedIcon());
                this.setClosedIcon(super.getDefaultClosedIcon());
                this.setOpenIcon(super.getDefaultOpenIcon());
            } else {
                this.setLeafIcon(super.getDefaultLeafIcon());
            }
            super.getTreeCellRendererComponent(tree, obj, is_selected, is_expanded, is_leaf, row, focus);
            return this;
        }
    }

    private final class TreeOfViewsSelectionListener
    implements TreeSelectionListener,
    Serializable {
        private static final long serialVersionUID = 2001400954118069438L;

        private TreeOfViewsSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent arg0) {
            TreePath tp = ViewSelectionDialog.this.myTreeOfViews.getSelectionPath();
            if (null == tp) {
                ViewSelectionDialog.this.myRootMOTypeTextField.setText("");
                ViewSelectionDialog.this.myDescriptionArea.setText("");
                ViewSelectionDialog.this.disableRemoveImported();
                return;
            }
            String viewName = ViewSelectionDialog.this.myTreeOfViews.getSelectionPath().getLastPathComponent().toString();
            TreePath parentPath = ViewSelectionDialog.this.myTreeOfViews.getSelectionPath().getParentPath();
            if (null == parentPath) {
                ViewSelectionDialog.this.myDescriptionArea.setText("");
                ViewSelectionDialog.this.myRootMOTypeTextField.setText("");
                ViewSelectionDialog.this.disableRemoveImported();
                return;
            }
            String folderName = ViewSelectionDialog.this.myTreeOfViews.getSelectionPath().getParentPath().getLastPathComponent().toString();
            if (folderName.equals(ViewSelectionDialog.TOP_FOLDER_TITLE)) {
                ViewSelectionDialog.this.myRootMOTypeTextField.setText("");
                if (viewName.equals(ViewSelectionDialog.PRE_FOLDER_TITLE)) {
                    ViewSelectionDialog.this.myDescriptionArea.setText("This folder contains views that are predefined for this Network Element.");
                } else if (viewName.equals(ViewSelectionDialog.USER_FOLDER_TITLE)) {
                    ViewSelectionDialog.this.myDescriptionArea.setText("This folder contains views from the user's directory " + ViewSelectionDialog.this.myViewServices.getUserDefDirectory() + "\n\nFor more information on how to specify a view, see the User Guide \"" + ViewSelectionDialog.CPI_VIEWI_DOC_TITLE + "\".");
                } else if (viewName.equals(ViewSelectionDialog.IMPORT_FOLDER_TITLE)) {
                    String text = "This folder contains views that have been imported. ";
                    String brask = "Views are only imported temporarily, during the current session of the " + ViewSelectionDialog.this.myConfig.getManagerName() + ".";
                    if (ViewSelectionDialog.this.myConfig.shouldStoreImportedViewPaths()) {
                        ViewSelectionDialog.this.myDescriptionArea.setText(text);
                    } else {
                        ViewSelectionDialog.this.myDescriptionArea.setText(text + brask);
                    }
                }
                ViewSelectionDialog.this.disableRemoveImported();
                return;
            }
            if (folderName.equals(ViewSelectionDialog.PRE_FOLDER_TITLE) && !ViewSelectionDialog.this.predefsInitiatedInViewInfo) {
                ViewSelectionDialog.this.myViewInfo.fillInPreDefViews();
                ViewSelectionDialog.this.predefsInitiatedInViewInfo = true;
            } else if (folderName.equals(ViewSelectionDialog.USER_FOLDER_TITLE) && !ViewSelectionDialog.this.userdefsInitiatedInViewInfo) {
                ViewSelectionDialog.this.myViewInfo.fillInUserDefViews();
                ViewSelectionDialog.this.userdefsInitiatedInViewInfo = true;
            } else if (folderName.equals(ViewSelectionDialog.IMPORT_FOLDER_TITLE) && !ViewSelectionDialog.this.importedInitiatedInViewInfo) {
                ViewSelectionDialog.this.myViewInfo.fillInImportedViews();
                ViewSelectionDialog.this.importedInitiatedInViewInfo = true;
            }
            String topNames = ViewSelectionDialog.this.myViewInfo.getTopMoClasses(viewName).toString();
            topNames = topNames.replace('[', ' ');
            topNames = topNames.replace(']', ',');
            if (topNames.endsWith(",")) {
                topNames = topNames.substring(0, topNames.length() - 1);
            }
            ViewSelectionDialog.this.myRootMOTypeTextField.setText(topNames);
            ViewSelectionDialog.this.myDescriptionArea.setText(ViewSelectionDialog.this.myViewInfo.getDescription(viewName));
            if (parentPath.toString().indexOf(ViewSelectionDialog.IMPORT_FOLDER_TITLE) > -1) {
                ViewSelectionDialog.this.myRemoveButton.setEnabled(true);
                File file = ViewSelectionDialog.this.myViewServices.getFileForImportedView(viewName);
                if (file.exists()) {
                    ViewSelectionDialog.this.myFileTextField.setForeground(ViewSelectionDialog.this.myRootMOTypeTextField.getForeground());
                    ViewSelectionDialog.this.myFileTextField.setText("File: " + file);
                } else {
                    ViewSelectionDialog.this.myFileTextField.setForeground(Color.RED);
                    ViewSelectionDialog.this.myFileTextField.setText("The file to import was not found: " + file);
                }
            } else {
                ViewSelectionDialog.this.disableRemoveImported();
            }
            ViewSelectionDialog.this.myDescriptionArea.setCaretPosition(0);
        }
    }
}

