/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.nex.gui.view;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import se.ericsson.cello.nex.MessengerI;
import se.ericsson.cello.nex.NexLog;
import se.ericsson.cello.nex.gui.treetable.TreeTableModelAdapter;
import se.ericsson.cello.nex.gui.view.ExpanderGUI;
import se.ericsson.cello.nex.gui.view.MoTreeTableModel;
import se.ericsson.cello.nex.gui.view.NexTreeNode;
import se.ericsson.cello.nex.gui.view.workers.ModelCallback;
import se.ericsson.cello.nex.toolservices.ToolServicesI;
import se.ericsson.cello.nex.viewservices.ViewServicesI;
import se.ericsson.cello.nex.viewservices.model.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodePopupManager {
    public static final String COPY_LDN = "Copy LDN";
    public static final String MO_PROPERTIES = "Properties";
    public static final String GOTO = "Open In";
    public static final String REFRESH = "Refresh";
    public static final String EXPAND_BELOW = "Expand Below";
    public static final String DELETE = "Delete";
    private static final String REFRESH_TOOLTIP = "Refresh own table attributes, add new immediate children, and remove deleted ones.";
    private static final String ACTION_COPY_LDN = "ACTION_COPY_LDN";
    private static final String ACTION_PROPERTIES = "ACTION_PROPERTIES";
    private static final String ACTION_REFRESH = "ACTION_REFRESH";
    private static final String ACTION_GOTO = "ACTION_GOTO";
    private static final String ACTION_EXPAND = "ACTION_EXPAND";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private JMenuItem copyLdnItem = null;
    private JMenuItem propertiesItem = null;
    private JMenuItem refreshItem = null;
    private JMenuItem commandItem = null;
    private JMenuItem expandItem = null;
    private JMenuItem deleteItem = null;
    private JMenu gotoMenu = null;
    private Vector<JMenuItem> storedItems = new Vector();
    private PopupListener popupListener = null;
    private ToolServicesI toolServices;
    private MessengerI messenger;
    private MoTreeTableModel model;
    private TreeTableModelAdapter modelAdapter;
    private boolean refreshOngoing;
    private ExpanderGUI gui;
    private JTable table;
    private ViewServicesI viewServices;
    private NexTreeNode currentNode;

    public NodePopupManager(ToolServicesI toolserv, MessengerI messageDeliverer, MoTreeTableModel tablemodel, TreeTableModelAdapter aModelAdapter, ExpanderGUI view, JTable aTable, ViewServicesI aViewServices) {
        this.toolServices = toolserv;
        this.messenger = messageDeliverer;
        this.model = tablemodel;
        this.modelAdapter = aModelAdapter;
        this.gui = view;
        this.table = aTable;
        this.viewServices = aViewServices;
    }

    public void addCopyLdnMenu(JPopupMenu popup) {
        this.copyLdnItem = new JMenuItem(COPY_LDN);
        popup.add(this.copyLdnItem);
        this.copyLdnItem.setActionCommand(ACTION_COPY_LDN);
        this.copyLdnItem.addActionListener(new NodePopupListener());
    }

    public void addMoPropertiesMenu(JPopupMenu popup) {
        this.propertiesItem = new JMenuItem(MO_PROPERTIES);
        popup.add(this.propertiesItem);
        this.propertiesItem.setActionCommand(ACTION_PROPERTIES);
        this.propertiesItem.addActionListener(new NodePopupListener());
    }

    public void addRefreshMenu(JPopupMenu popup) {
        this.refreshItem = new JMenuItem(REFRESH);
        popup.add(this.refreshItem);
        this.refreshItem.setToolTipText(REFRESH_TOOLTIP);
        this.refreshItem.setActionCommand(ACTION_REFRESH);
        this.refreshItem.addActionListener(new NodePopupListener());
    }

    public void addGotoMenu(JPopupMenu popup, Collection<String> hypertools) {
        if (hypertools.isEmpty()) {
            return;
        }
        this.gotoMenu = new JMenu(GOTO);
        popup.add(this.gotoMenu);
        for (String hypertoolName : hypertools) {
            JMenuItem tmpMenuItem = new JMenuItem(hypertoolName);
            tmpMenuItem.setActionCommand(ACTION_GOTO);
            tmpMenuItem.addActionListener(new NodePopupListener());
            this.gotoMenu.add(tmpMenuItem);
        }
    }

    public void addTaskMenu(JPopupMenu popup, Task task) {
        this.commandItem = new JMenuItem(task);
        popup.add(this.commandItem);
        this.storedItems.add(this.commandItem);
    }

    public void addExpandMenu(JPopupMenu popup) {
        this.expandItem = new JMenuItem(EXPAND_BELOW);
        popup.add(this.expandItem);
        this.expandItem.setActionCommand(ACTION_EXPAND);
        this.expandItem.addActionListener(new NodePopupListener());
    }

    public void addMoDeleteMenu(JPopupMenu popup) {
        this.deleteItem = new JMenuItem(DELETE);
        popup.add(this.deleteItem);
        this.deleteItem.setActionCommand(ACTION_DELETE);
        this.deleteItem.addActionListener(new NodePopupListener());
    }

    public void setRefreshOngoing(boolean b) {
        this.refreshOngoing = b;
    }

    public MouseListener getPopupListener(JPopupMenu popupMenu) {
        if (this.popupListener == null) {
            this.popupListener = new PopupListener(popupMenu);
        }
        return this.popupListener;
    }

    private NexTreeNode getNodeAtEventPoint(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        return (NexTreeNode)this.modelAdapter.nodeForRow(row);
    }

    private class NodePopupListener
    implements ActionListener {
        private NodePopupListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals(NodePopupManager.ACTION_COPY_LDN)) {
                this.copyLdn();
            } else if (actionCommand.equals(NodePopupManager.ACTION_PROPERTIES)) {
                this.openProperties();
            } else if (actionCommand.equals(NodePopupManager.ACTION_REFRESH)) {
                this.refresh();
            } else if (actionCommand.equals(NodePopupManager.ACTION_GOTO)) {
                this.gotoAction(e);
            } else if (actionCommand.equals(NodePopupManager.ACTION_EXPAND)) {
                NexLog.logger().fine("Expand pressed");
                NodePopupManager.this.gui.expandAllBelow(NodePopupManager.this.currentNode);
            } else if (actionCommand.equals(NodePopupManager.ACTION_DELETE)) {
                this.deleteMo();
            }
        }

        private void deleteMo() {
            NexLog.logger().fine("Delete pressed");
            if (NodePopupManager.this.currentNode != null) {
                NodePopupManager.this.viewServices.deleteMos(NodePopupManager.this.currentNode.getLongName());
            } else {
                NexLog.logger().fine("No MO is selected");
            }
        }

        private void gotoAction(ActionEvent e) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if (NodePopupManager.this.currentNode == null) {
                NexLog.logger().info("No MO row.");
            } else {
                Properties props = NodePopupManager.this.toolServices.getConfiguration().getSupersedingProperties();
                props.put("LDNs", NodePopupManager.this.currentNode.getViewElement().getLdn());
                try {
                    NodePopupManager.this.toolServices.startHyperTool(menuItem.getText(), props);
                }
                catch (Exception ex) {
                    NexLog.logger().warning("Was not able to launch the tool ." + menuItem.getText() + "\n" + ex.getMessage());
                    NodePopupManager.this.messenger.setMessage("Failed to start the tool " + menuItem.getText(), ex, false);
                }
            }
        }

        private void refresh() {
            NexLog.logger().finer("Refresh pressed");
            if (null != NodePopupManager.this.currentNode) {
                ModelCallback<NexTreeNode> callBackForGuiUpdate = new ModelCallback<NexTreeNode>(){

                    @Override
                    public void run(NexTreeNode node, boolean cancelled) {
                        NodePopupManager.this.modelAdapter.fireTableDataChanged();
                        NodePopupManager.this.gui.expandToNode(node);
                    }
                };
                NodePopupManager.this.model.asynchronousRefreshNode(NodePopupManager.this.currentNode, callBackForGuiUpdate);
            }
        }

        private void openProperties() {
            if (null == NodePopupManager.this.currentNode) {
                NexLog.logger().info("Not an MO node.");
            } else {
                Properties props = NodePopupManager.this.toolServices.getConfiguration().getSupersedingProperties();
                props.put("LDNs", NodePopupManager.this.currentNode.getLongName());
                try {
                    NodePopupManager.this.toolServices.startMoPropsTool(props);
                }
                catch (Exception ex) {
                    NexLog.logger().warning("Was not able to launch MO Properties tool.\n" + ex.getMessage());
                    NodePopupManager.this.messenger.setMessage("Failed to start MO Properties", ex, false);
                }
            }
        }

        private void copyLdn() {
            try {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (NodePopupManager.this.currentNode == null) {
                    NexLog.logger().info("No MO row.");
                } else {
                    StringSelection contents = new StringSelection(NodePopupManager.this.currentNode.getLongName());
                    cb.setContents(contents, null);
                }
            }
            catch (Exception x) {
                NexLog.logger().warning("NodePopupManager: Cannot access clipboard\n" + x);
            }
        }
    }

    public class PopupListener
    extends MouseAdapter {
        private JPopupMenu popupMenu = null;

        public PopupListener(JPopupMenu popupMenu) {
            this.popupMenu = popupMenu;
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void removeActionItems() {
            for (int i = 0; i < NodePopupManager.this.storedItems.size(); ++i) {
                this.popupMenu.remove((JMenuItem)NodePopupManager.this.storedItems.elementAt(i));
            }
            NodePopupManager.this.storedItems.clear();
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                NodePopupManager.this.currentNode = NodePopupManager.this.getNodeAtEventPoint(e);
                if (NodePopupManager.this.currentNode != null) {
                    if (NodePopupManager.this.currentNode.isFolder()) {
                        this.popupMenu.setLabel("");
                        if (null != NodePopupManager.this.propertiesItem) {
                            NodePopupManager.this.propertiesItem.setText(NodePopupManager.MO_PROPERTIES);
                            NodePopupManager.this.propertiesItem.setEnabled(false);
                        }
                        if (null != NodePopupManager.this.copyLdnItem) {
                            NodePopupManager.this.copyLdnItem.setEnabled(false);
                        }
                        if (null != NodePopupManager.this.gotoMenu) {
                            NodePopupManager.this.gotoMenu.setEnabled(false);
                        }
                        if (null != NodePopupManager.this.deleteItem) {
                            NodePopupManager.this.deleteItem.setEnabled(false);
                        }
                    } else {
                        this.popupMenu.setLabel(NodePopupManager.this.currentNode.getName());
                        if (null != NodePopupManager.this.propertiesItem) {
                            NodePopupManager.this.propertiesItem.setText("Properties of " + NodePopupManager.this.currentNode.getName());
                            NodePopupManager.this.propertiesItem.setEnabled(true);
                        }
                        if (null != NodePopupManager.this.copyLdnItem) {
                            NodePopupManager.this.copyLdnItem.setEnabled(true);
                        }
                        if (null != NodePopupManager.this.gotoMenu) {
                            NodePopupManager.this.gotoMenu.setEnabled(true);
                        }
                        if (null != NodePopupManager.this.deleteItem) {
                            NodePopupManager.this.deleteItem.setEnabled(true);
                        }
                    }
                    this.getTaskItems(NodePopupManager.this.currentNode);
                    if (null != NodePopupManager.this.refreshItem) {
                        NodePopupManager.this.refreshItem.setEnabled(!NodePopupManager.this.refreshOngoing);
                    }
                    if (null != NodePopupManager.this.expandItem) {
                        NodePopupManager.this.expandItem.setEnabled(!NodePopupManager.this.refreshOngoing);
                    }
                    this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        private void getTaskItems(NexTreeNode node) {
            this.removeActionItems();
            Collection<Task> taskV = node.getViewElement().getTasks();
            if (taskV == null) {
                return;
            }
            for (Task task : taskV) {
                NexLog.logger().fine("NodePopupmanager setting LDNs to task: " + node.getViewElement().getLdn() + "   " + task.getName());
                task.putValue("LDNs", node.getViewElement().getLdn());
                NodePopupManager.this.addTaskMenu(this.popupMenu, task);
            }
        }
    }
}

