/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class AlgorithmParametersIV
extends AlgorithmParametersSpi {
    private byte[] iv;
    private boolean initialized = false;
    static /* synthetic */ Class class$0;

    protected byte[] engineGetEncoded(String format) throws IOException {
        if (!this.initialized) {
            throw new IOException();
        }
        if (format == null || format.equals("ASN.1")) {
            return ASN1Encoder.getEncoding((Object)this.iv);
        }
        if (format.equals("RAW")) {
            return this.iv;
        }
        throw new IOException(Msg.getString("JCP000"));
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.crypto.spec.IvParameterSpec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (paramSpec != clazz) {
            throw new InvalidParameterSpecException();
        }
        return new IvParameterSpec(this.iv, 0, this.iv.length);
    }

    private void validateIV(byte[] iv) throws IOException {
        if (iv == null || iv.length == 0) {
            throw new IOException();
        }
    }

    protected void engineInit(byte[] params, String format) throws IOException {
        if (format == null || format.equals("ASN.1")) {
            this.iv = (byte[])ASN1Decoder.getDecoded((byte[])params);
            this.validateIV(this.iv);
            this.initialized = true;
            return;
        }
        if (format.equals("RAW")) {
            this.iv = params;
            this.validateIV(this.iv);
            this.initialized = true;
            return;
        }
        throw new IOException(Msg.getString("JCP000"));
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException(Msg.getString("JCP001"));
        }
        IvParameterSpec ivParms = (IvParameterSpec)paramSpec;
        try {
            this.engineInit(ivParms.getIV(), "RAW");
        }
        catch (IOException e) {
            throw new InvalidParameterSpecException(e.getMessage());
        }
        this.initialized = true;
    }

    protected String engineToString() {
        return "IV Parameters";
    }

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    protected void engineInit(byte[] params) throws IOException {
        this.engineInit(params, "ASN.1");
    }
}

