/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.CipherSpiJ9;
import com.ibm.j9.jce.provider.Msg;
import com.ibm.j9.jce.provider.Util;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class BlockCipherSpi
extends CipherSpiJ9 {
    private static final int SUPPORTED_MODE_NAME_LEN = 3;
    private static final int BYTE_SIZE_BITS = 8;
    protected int blockSizeBytes = this.getDefaultBlockSizeInBytes();
    protected byte[] initializationVector = null;
    protected byte[] workingIV = null;
    private byte[] unprocessedBuffer = new byte[0];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        super.engineSetMode(mode);
        try {
            if (mode.length() > 3) {
                String blockSizeStr = mode.substring(4);
                int blockSize = Integer.parseInt(blockSizeStr);
                if (!this.isValidBlockSize(blockSize / 8)) throw new NoSuchAlgorithmException(Msg.getString("JCP008", mode));
                this.blockSizeBytes = blockSize / 8;
                return;
            } else {
                this.blockSizeBytes = this.getDefaultBlockSizeInBytes();
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NoSuchAlgorithmException(Msg.getString("JCP008", mode));
        }
    }

    protected int engineGetBlockSize() {
        return this.blockSizeBytes;
    }

    protected int engineGetOutputSize(int inputLength) {
        this.validateState();
        int bytesToProcess = this.unprocessedBuffer.length + inputLength;
        int blocks = (bytesToProcess - 1) / this.blockSizeBytes + 1;
        switch (this.operationMode) {
            case 1: 
            case 3: {
                if (this.paddingMode != 2 && bytesToProcess % this.blockSizeBytes == 0) {
                    return (blocks + 1) * this.blockSizeBytes;
                }
                return blocks * this.blockSizeBytes;
            }
            case 2: 
            case 4: {
                return blocks * this.blockSizeBytes;
            }
        }
        throw new InternalError();
    }

    protected byte[] engineGetIV() {
        if (this.initializationVector == null) {
            return null;
        }
        byte[] result = new byte[this.blockSizeBytes];
        System.arraycopy(this.initializationVector, 0, result, 0, this.blockSizeBytes);
        return result;
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.getParameters();
    }

    protected void engineInit(int opMode, Key key, SecureRandom random) throws InvalidKeyException {
        if (opMode == 2 && this.feedbackMode != 1) {
            throw new InvalidKeyException("Decrypting in non ECB mode requires an IV for initialization");
        }
        this.initForOperation(opMode, key, random);
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opMode == 2 && params == null && this.feedbackMode != 1) {
            throw new InvalidAlgorithmParameterException("Decrypting in non ECB mode requires an IV for initialization");
        }
        if (params != null) {
            if (!(params instanceof IvParameterSpec)) {
                throw new InvalidAlgorithmParameterException();
            }
            byte[] iv = ((IvParameterSpec)params).getIV();
            if (iv != null && iv.length != this.blockSizeBytes) {
                throw new InvalidAlgorithmParameterException();
            }
            this.setInitializationVector(iv);
        }
        this.initForOperation(opMode, key, random);
    }

    protected void engineInit(int opMode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opMode == 2 && params == null && this.feedbackMode != 1) {
            throw new InvalidAlgorithmParameterException("Decrypting in non ECB mode requires an IV for initialization");
        }
        if (params != null) {
            byte[] iv = null;
            try {
                iv = (byte[])ASN1Decoder.getDecoded((byte[])params.getEncoded());
            }
            catch (IOException iOException) {
                throw new InvalidAlgorithmParameterException(Msg.getString("JCP000"));
            }
            if (iv == null || iv.length != this.blockSizeBytes) {
                throw new InvalidAlgorithmParameterException(Msg.getString("JCP011"));
            }
            this.setInitializationVector(iv);
        }
        this.initForOperation(opMode, key, random);
    }

    protected byte[] engineUpdate(byte[] input, int start, int inputLen) {
        this.validateState();
        if (inputLen < 0) {
            throw new IllegalArgumentException();
        }
        byte[] output = new byte[this.engineGetOutputSize(inputLen)];
        int bytesProcessed = 0;
        try {
            bytesProcessed = this.engineUpdate(input, start, inputLen, output, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new InternalError();
        }
        if (bytesProcessed == 0) {
            return null;
        }
        if (bytesProcessed < output.length) {
            byte[] buffer = new byte[bytesProcessed];
            System.arraycopy(output, 0, buffer, 0, bytesProcessed);
            return buffer;
        }
        return output;
    }

    protected int engineUpdate(byte[] input, int start, int inputLen, byte[] output, int outputStart) throws ShortBufferException {
        this.validateState();
        if (input == null && start != 0 && inputLen != 0) {
            throw new IllegalArgumentException();
        }
        if (start < 0 || inputLen < 0 || output == null || outputStart < 0) {
            throw new IllegalArgumentException();
        }
        int totalInputLen = this.unprocessedBuffer.length + inputLen;
        int outputSizeBlocks = totalInputLen / this.blockSizeBytes;
        int remainderLen = totalInputLen % this.blockSizeBytes;
        if (this.operationMode == 2 && this.paddingMode != 2 && remainderLen == 0) {
            if (outputSizeBlocks > 0) {
                --outputSizeBlocks;
            }
            remainderLen += this.blockSizeBytes;
        }
        if (outputSizeBlocks == 0) {
            if (inputLen > 0) {
                byte[] newUnprocessedBuffer = new byte[this.unprocessedBuffer.length + inputLen];
                System.arraycopy(this.unprocessedBuffer, 0, newUnprocessedBuffer, 0, this.unprocessedBuffer.length);
                System.arraycopy(input, start, newUnprocessedBuffer, this.unprocessedBuffer.length, inputLen);
                this.unprocessedBuffer = newUnprocessedBuffer;
            }
            return outputSizeBlocks;
        }
        if (output.length - outputStart < outputSizeBlocks * this.blockSizeBytes) {
            throw new ShortBufferException();
        }
        int inputIndex = start;
        int outputIndex = outputStart;
        int cl3OpMode = this.operationMode == 1 ? 0 : 1;
        byte[] inputBuffer = new byte[outputSizeBlocks * this.blockSizeBytes];
        System.arraycopy(this.unprocessedBuffer, 0, inputBuffer, 0, this.unprocessedBuffer.length);
        System.arraycopy(input, start, inputBuffer, this.unprocessedBuffer.length, inputBuffer.length - this.unprocessedBuffer.length);
        int newStart = inputBuffer.length - this.unprocessedBuffer.length + start;
        this.unprocessedBuffer = new byte[remainderLen];
        System.arraycopy(input, newStart, this.unprocessedBuffer, 0, remainderLen);
        if (this.feedbackMode == 2) {
            this.updateCFB(this.cipherKey, cl3OpMode, this.workingIV, 0, inputBuffer, 0, output, outputIndex, inputBuffer.length);
        } else {
            this.update(this.cipherKey, cl3OpMode, this.workingIV, 0, inputBuffer, 0, output, outputIndex, inputBuffer.length);
        }
        inputIndex += inputBuffer.length;
        outputIndex += inputBuffer.length;
        return inputBuffer.length;
    }

    private void updateCFB(Key k, int opMode, byte[] iv, int ivOff, byte[] input, int inputOffset, byte[] output, int outputOffset, int length) {
        int i = 0;
        while (i < length / this.blockSizeBytes) {
            if (i == 0) {
                this.update(k, 0, null, 0, iv, ivOff, output, outputOffset, this.blockSizeBytes);
            } else if (opMode == 0) {
                this.update(k, 0, null, 0, output, outputOffset + (i - 1) * this.blockSizeBytes, output, outputOffset + i * this.blockSizeBytes, this.blockSizeBytes);
            } else {
                this.update(k, 0, null, 0, input, inputOffset + (i - 1) * this.blockSizeBytes, output, outputOffset + i * this.blockSizeBytes, this.blockSizeBytes);
            }
            this.xor(input, inputOffset + i * this.blockSizeBytes, output, outputOffset + i * this.blockSizeBytes);
            if (i == length / this.blockSizeBytes - 1) {
                if (opMode == 0) {
                    System.arraycopy(output, outputOffset + i * this.blockSizeBytes, this.workingIV, 0, this.blockSizeBytes);
                } else {
                    System.arraycopy(input, inputOffset + i * this.blockSizeBytes, this.workingIV, 0, this.blockSizeBytes);
                }
            }
            ++i;
        }
    }

    private void xor(byte[] input, int inputOffset, byte[] output, int outputOffset) {
        int i = 0;
        while (i < this.blockSizeBytes) {
            output[outputOffset + i] = (byte)(input[inputOffset + i] ^ output[outputOffset + i]);
            ++i;
        }
    }

    protected byte[] engineDoFinal(byte[] input, int start, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        this.validateState();
        if (inputLen < 0) {
            throw new IllegalArgumentException();
        }
        byte[] output = new byte[this.engineGetOutputSize(inputLen)];
        int bytesProcessed = 0;
        try {
            bytesProcessed = this.engineDoFinal(input, start, inputLen, output, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new InternalError();
        }
        if (bytesProcessed == 0) {
            return null;
        }
        if (bytesProcessed < output.length) {
            byte[] buffer = new byte[bytesProcessed];
            System.arraycopy(output, 0, buffer, 0, bytesProcessed);
            return buffer;
        }
        return output;
    }

    protected int engineDoFinal(byte[] input, int start, int inputLen, byte[] output, int outputStart) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.validateState();
        if (input == null && start != 0 && inputLen != 0) {
            throw new IllegalArgumentException();
        }
        if (start < 0 || inputLen < 0 || output == null || outputStart < 0) {
            throw new IllegalArgumentException();
        }
        if (this.operationMode != 2 ? output.length - outputStart < this.engineGetOutputSize(inputLen) : output.length - outputStart < this.engineGetOutputSize(inputLen) - this.engineGetBlockSize()) {
            throw new ShortBufferException();
        }
        int totalInputLen = this.unprocessedBuffer.length + inputLen;
        int remainderLen = totalInputLen % this.blockSizeBytes;
        if (this.feedbackMode != 2 && this.operationMode == 2 && remainderLen != 0) {
            throw new IllegalBlockSizeException();
        }
        if (this.feedbackMode != 2 && this.operationMode == 1 && this.paddingMode == 2 && remainderLen != 0) {
            throw new IllegalBlockSizeException();
        }
        int bytesWritten = this.engineUpdate(input, start, inputLen, output, outputStart);
        int outputLastChunkStart = outputStart + bytesWritten;
        switch (this.operationMode) {
            case 1: {
                return this.finalEncrypt(output, bytesWritten, outputLastChunkStart);
            }
            case 2: {
                return this.finalDecrypt(output, bytesWritten, outputLastChunkStart);
            }
        }
        throw new InternalError();
    }

    private int finalEncrypt(byte[] output, int bytesWritten, int outputLastChunkStart) {
        byte[] paddedData = this.getPaddedBlock(this.paddingMode, this.unprocessedBuffer);
        if (paddedData.length == 0) {
            return bytesWritten;
        }
        if (this.feedbackMode == 2) {
            byte[] newPaddedData;
            if (paddedData.length < this.blockSizeBytes) {
                newPaddedData = new byte[this.blockSizeBytes];
                System.arraycopy(paddedData, 0, newPaddedData, 0, paddedData.length);
            } else {
                newPaddedData = paddedData;
            }
            this.updateCFB(this.cipherKey, 0, this.workingIV, 0, newPaddedData, 0, output, outputLastChunkStart, newPaddedData.length);
        } else {
            this.update(this.cipherKey, 0, this.workingIV, 0, paddedData, 0, output, outputLastChunkStart, paddedData.length);
        }
        this.reset();
        return bytesWritten + paddedData.length;
    }

    private int finalDecrypt(byte[] output, int bytesWritten, int outputLastChunkStart) throws BadPaddingException, ShortBufferException {
        if (this.unprocessedBuffer.length == 0) {
            return bytesWritten;
        }
        byte[] temp = new byte[this.blockSizeBytes];
        if (this.feedbackMode == 2) {
            byte[] data;
            if (this.unprocessedBuffer.length < this.blockSizeBytes) {
                data = new byte[this.blockSizeBytes];
                System.arraycopy(this.unprocessedBuffer, 0, data, 0, this.unprocessedBuffer.length);
            } else {
                data = this.unprocessedBuffer;
            }
            this.updateCFB(this.cipherKey, 0, this.workingIV, 0, data, 0, temp, 0, data.length);
        } else {
            this.update(this.cipherKey, 1, this.workingIV, 0, this.unprocessedBuffer, 0, temp, 0, this.unprocessedBuffer.length);
        }
        byte[] unPadded = this.getUnpaddedBlock(this.paddingMode, temp, this.unprocessedBuffer.length);
        if (output.length - outputLastChunkStart < unPadded.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(unPadded, 0, output, outputLastChunkStart, unPadded.length);
        this.reset();
        return bytesWritten + unPadded.length;
    }

    private byte[] getPaddedBlock(int paddingMode, byte[] unpaddedData) {
        switch (paddingMode) {
            case 1: {
                return Util.padPKCS5(unpaddedData, 0, unpaddedData.length, this.blockSizeBytes);
            }
            case 0: {
                return Util.padSSL(unpaddedData, 0, unpaddedData.length, this.blockSizeBytes);
            }
            case 2: {
                return unpaddedData;
            }
        }
        throw new IllegalArgumentException(Msg.getString("JCP009", paddingMode));
    }

    private byte[] getUnpaddedBlock(int paddingMode, byte[] paddedData, int cfbLength) throws BadPaddingException {
        byte[] unpaddedBlock = null;
        try {
            switch (paddingMode) {
                case 1: {
                    unpaddedBlock = Util.unpadPKCS5(paddedData, this.blockSizeBytes);
                    break;
                }
                case 0: {
                    unpaddedBlock = Util.unpadSSL(paddedData, this.blockSizeBytes);
                    break;
                }
                case 2: {
                    if (this.feedbackMode == 2) {
                        unpaddedBlock = new byte[cfbLength];
                        System.arraycopy(paddedData, 0, unpaddedBlock, 0, cfbLength);
                    } else {
                        unpaddedBlock = paddedData;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Msg.getString("JCP009", paddingMode));
                }
            }
        }
        catch (IOException iOException) {
            throw new BadPaddingException();
        }
        return unpaddedBlock;
    }

    public void reset() {
        if (this.feedbackMode != 1) {
            if (this.initializationVector == null) {
                byte[] iv = new byte[this.blockSizeBytes];
                this.randomSource.nextBytes(iv);
                this.setInitializationVector(iv);
            } else {
                System.arraycopy(this.initializationVector, 0, this.workingIV, 0, this.initializationVector.length);
            }
        }
        this.unprocessedBuffer = new byte[0];
        this.algorithmSpecificReset();
    }

    protected void setInitializationVector(byte[] iv) {
        if (iv == null) {
            this.initializationVector = null;
            this.workingIV = null;
        } else {
            this.initializationVector = new byte[this.blockSizeBytes];
            System.arraycopy(iv, 0, this.initializationVector, 0, this.blockSizeBytes);
            this.workingIV = new byte[this.blockSizeBytes];
            System.arraycopy(iv, 0, this.workingIV, 0, this.blockSizeBytes);
        }
    }

    protected AlgorithmParameters getParameters() {
        AlgorithmParameters ap;
        if (this.initializationVector == null) {
            return null;
        }
        try {
            ap = AlgorithmParameters.getInstance(this.getAlgorithmName(), this.getProviderID());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return null;
        }
        try {
            ap.init(ASN1Encoder.getEncoding((Object)this.initializationVector));
        }
        catch (IOException iOException) {
            return null;
        }
        return ap;
    }

    protected abstract void update(Key var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9);

    protected Key validateKey(Key key, int opMode) throws InvalidKeyException {
        byte[] keyBytes = key.getEncoded();
        if (key.getFormat() != "RAW" || keyBytes == null) {
            throw new InvalidKeyException(Msg.getString("K0360"));
        }
        if (!this.validateKeyLength(keyBytes.length)) {
            throw new InvalidKeyException(Msg.getString("K0351"));
        }
        if (key instanceof SecretKeySpec) {
            try {
                SecretKeyFactory factory = SecretKeyFactory.getInstance(this.getAlgorithmName());
                return factory.generateSecret((KeySpec)((Object)key));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException(Msg.getString("K03b5", this.getAlgorithmName()));
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidKeyException(e.getMessage());
            }
        }
        if (!this.validateKeyType(key)) {
            throw new InvalidKeyException(key.getClass().getName());
        }
        return key;
    }

    protected abstract boolean validateKeyLength(int var1);

    protected abstract boolean validateKeyType(Key var1);

    protected abstract void algorithmSpecificReset();

    protected abstract int getDefaultBlockSizeInBytes();

    protected abstract boolean isValidBlockSize(int var1);

    protected abstract String getAlgorithmName();

    protected abstract String getProviderID();

    protected int getModeID(String mode) {
        if (mode.equalsIgnoreCase("CBC")) {
            return 0;
        }
        if (mode.equalsIgnoreCase("ECB")) {
            return 1;
        }
        if (mode.equalsIgnoreCase("CFB")) {
            return 2;
        }
        return -1;
    }
}

