/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import com.ibm.oti.security.provider.KeyStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class EncryptedKeyStore
extends KeyStore {
    protected int getKeyStoreMagic() {
        return 777;
    }

    protected int getKeyStoreVersion() {
        return 1;
    }

    protected int getKeyStoreOldVeresion() {
        return 0;
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object entry = this.database.get(alias);
        if (entry == null) {
            return null;
        }
        if (entry instanceof EncryptedKeyStoreKey) {
            try {
                return ((EncryptedKeyStoreKey)entry).decryptKey(password);
            }
            catch (KeyStoreException keyStoreException) {
                throw new UnrecoverableKeyException();
            }
        }
        return null;
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        KeyStore.KeyStoreEntry entry = (KeyStore.KeyStoreEntry)this.database.get(alias);
        if (entry != null && entry instanceof KeyStore.KeyStoreKey) {
            throw new KeyStoreException(Msg.getString("K0185"));
        }
        this.database.put(alias, new KeyStore.KeyStoreCertificate(cert));
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        EncryptedKeyStoreKey entry = new EncryptedKeyStoreKey(key, password, chain);
        this.database.put(alias, entry);
    }

    public static class EncryptedKeyStoreKey
    extends KeyStore.KeyStoreKey
    implements Serializable {
        byte[] salt;
        int iterationCount;

        public EncryptedKeyStoreKey(Key key, char[] password, Certificate[] certChain) throws KeyStoreException {
            try {
                this.salt = EncryptedKeyStoreKey.getSalt();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new KeyStoreException("Algorithm not found");
            }
            this.iterationCount = 1024;
            this.key = EncryptedKeyStoreKey.encryptKey(key, password, this.salt, this.iterationCount);
            this.chain = certChain;
        }

        private static byte[] getSalt() throws NoSuchAlgorithmException {
            byte[] salt = new byte[8];
            SecureRandom.getInstance("SHA1PRNG").nextBytes(salt);
            return salt;
        }

        private static byte[] encode(Object entry) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(entry);
            oos.close();
            return os.toByteArray();
        }

        private Key decode(byte[] data) throws IOException, ClassNotFoundException {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object obj = ois.readObject();
            ois.close();
            if (obj instanceof Key) {
                return (Key)obj;
            }
            throw new IOException();
        }

        private static byte[] encryptKey(Key key, char[] password, byte[] salt, int iterationCount) throws KeyStoreException {
            try {
                byte[] encodedKey = EncryptedKeyStoreKey.encode(key);
                PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterationCount);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5andTripleDES");
                SecretKey secretKey = keyFactory.generateSecret(keySpec);
                Cipher cipher = Cipher.getInstance("PBEWithMD5andTripleDES/CBC/PKCS5Padding");
                cipher.init(1, secretKey);
                return cipher.doFinal(encodedKey);
            }
            catch (InvalidKeyException e) {
                throw new KeyStoreException("Could not encrypt key: " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException("Could not encrypt key: " + e.getMessage());
            }
            catch (InvalidKeySpecException e) {
                throw new KeyStoreException("Could not encrypt key: " + e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                throw new KeyStoreException("Could not encrypt key: " + e.getMessage());
            }
            catch (IllegalStateException e) {
                throw new KeyStoreException("Could not encrypt key: " + e.getMessage());
            }
            catch (IllegalBlockSizeException e) {
                throw new KeyStoreException("Could not encrypt key: " + e.getMessage());
            }
            catch (BadPaddingException e) {
                throw new KeyStoreException("Could not encrypt key: " + e.getMessage());
            }
            catch (IOException e) {
                throw new KeyStoreException("Could not encrypt key: " + e.getMessage());
            }
        }

        private Key decryptKey(char[] password) throws KeyStoreException {
            try {
                PBEKeySpec keySpec = new PBEKeySpec(password, this.salt, this.iterationCount);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBEWithMD5andTripleDES");
                SecretKey secretKey = keyFactory.generateSecret(keySpec);
                Cipher cipher = Cipher.getInstance("PBEWithMD5andTripleDES/CBC/PKCS5Padding");
                cipher.init(2, secretKey);
                byte[] decryptedEncoding = cipher.doFinal((byte[])this.key);
                return this.decode(decryptedEncoding);
            }
            catch (InvalidKeyException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
            catch (InvalidKeySpecException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
            catch (IllegalStateException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
            catch (IllegalBlockSizeException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
            catch (BadPaddingException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
            catch (IOException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new KeyStoreException("Could not decrypt key: " + e.getMessage());
            }
        }
    }
}

