/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.ArrayList;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.ipsec.IkePeerMoGen;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.ipsec.StructIkeSaImpl;
import se.ericsson.cello.ipsec.StructIpSecCertInfoImpl;
import se.ericsson.cello.ipsec.StructPeerIdentityImpl;
import se.ericsson.cello.ipsec.StructPreSharedKeyImpl;
import se.ericsson.cello.ipsec.mom.EnumOwnIdType;
import se.ericsson.cello.ipsec.mom.StructIpSecCertInfo;
import se.ericsson.cello.mao.DomainNameFormatException;
import se.ericsson.cello.mao.DomainNameValidation;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpAddressValidation;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class IkePeerMoImpl
extends IkePeerMoGen
implements LogContentInspector {
    private Struct newPeerIdentity;
    private boolean isDomainName = false;
    private static final String INSTALL_PRE_SHARED_KEY = "installPreSharedKey";

    public IkePeerMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "IkePeer");
    }

    public IkePeerMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "IkePeer");
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        if (setRequestContext.isIncludedInRequest("peerIdentity")) {
            setRequestContext.replaceParameter(this.froProxy, (Parameter)StructPeerIdentityImpl.toStructParameter(this.newPeerIdentity, "IkePeer", "peerIdentity"));
        }
        int n = ((IpSecMo)this.getParent()).getFroId(coordinator);
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipSecFroId", n));
        setRequestContext.addParameter(this.froProxy, (Parameter)new StringParameter("ikePeerMoId", this.getFullDistinguishedName()));
    }

    protected Object handleGetPeerCertificate(GetRequestContext getRequestContext) throws MoAccessException {
        Object object = getRequestContext.getParameter("peerCertificate");
        object = object == null ? new StructImpl(StructIpSecCertInfo.ELEMENT_NAMES, StructIpSecCertInfo.ELEMENT_DEFAULTVALUES) : StructIpSecCertInfoImpl.toStruct((StructParameter)object);
        return object;
    }

    protected void handleSetPeerCertificate(Struct struct, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected Object handleGetSecurityAssociations(GetRequestContext getRequestContext) throws MoAccessException {
        Struct[] structArray = getRequestContext.getParameter("securityAssociations");
        structArray = structArray == null ? new Struct[]{} : StructIkeSaImpl.toStructArray((ArrayParameter)structArray);
        return structArray;
    }

    protected void handleSetSecurityAssociations(Struct[] structArray, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        if (setRequestContext.isIncludedInRequest("peerIdentity")) {
            setRequestContext.replaceParameter(this.froProxy, (Parameter)StructPeerIdentityImpl.toStructParameter(this.newPeerIdentity, "IkePeer", "peerIdentity"));
        }
    }

    protected void validatePeerIdentity(Struct struct, SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        String string = (String)setRequestContext.getAttributeFromRequest("peerIpAddress");
        if (string == null) {
            string = this.getPeerIpAddress(coordinator);
        }
        if (struct != null) {
            this.checkPeerIpAddress(string);
            this.checkPeerIdentity(struct, string);
        }
    }

    protected void validatePeerIpAddress(String string, SetRequestContext setRequestContext) throws MoAccessException {
        this.checkPeerIpAddress(string);
    }

    protected void validateOwnIdentity(Struct struct, SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        String string = (String)setRequestContext.getAttributeFromRequest("peerIpAddress");
        if (string == null) {
            string = this.getPeerIpAddress(coordinator);
        }
        if (struct != null) {
            this.checkPeerIpAddress(string);
            this.checkOwnIdentity(struct, string);
        }
    }

    public void actionInstallPreSharedKey(Struct struct, Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = StructPreSharedKeyImpl.toStructParameter(struct, "IkePeer", "installPreSharedKey_preSharedKey");
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(structParameter);
        this.froProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 101, arrayList);
    }

    private Struct checkPeerIdentity(Struct struct, String string) throws MoAccessException {
        String string2;
        String string3;
        int n;
        if (struct.size() != 3) {
            throw new ValueOutOfRangeException("peerIdentity has wrong number of elements.", "IkePeer");
        }
        try {
            n = (Integer)struct.getValue("idType");
            string3 = (String)struct.getValue("ipv4Address");
            string2 = (String)struct.getValue("idFqdn");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ValueOutOfRangeException("PeerIdentity is inconsistent, attribute is missing " + noSuchFieldException.toString(), "IkePeer");
        }
        catch (MoAccessException moAccessException) {
            throw moAccessException;
        }
        if (n > 3) {
            throw new ValueOutOfRangeException("idType is set to " + n + " , value is not OK", "IkePeer");
        }
        if (n == 2 && string2.length() == 0) {
            throw new ValueOutOfRangeException("IdType is set to FQDN, then idFqdn must not be empty", "IkePeer");
        }
        if (n == 0 && (string2.length() == 0 || string3.length() == 0)) {
            throw new ValueOutOfRangeException("IdType is set to ANY, then Fqdn and/or IpAdd should not be empty", "IkePeer");
        }
        if (string2.length() != 0) {
            if (string2.length() > 127) {
                throw new ValueOutOfRangeException("idFqdn must not exceed 127 characters", "IkePeer");
            }
            char c = '.';
            char c2 = '-';
            for (int i = 0; i < string2.length(); ++i) {
                if (Character.isLetterOrDigit(string2.charAt(i)) || string2.charAt(i) == c || string2.charAt(i) == c2) continue;
                throw new ValueOutOfRangeException("FQDN is not a qualified domain name", "IkePeer");
            }
        }
        if (n == 1 && string3.length() == 0) {
            if (this.isDomainName || Ipv6AddressValidation.isIpv6((String)string)) {
                throw new IllegalAttributeValueException("If idType specifies an IPv4 address and the value of peerIpAddress is a domain name or Ipv6Address, field IpAddress must not be empty.", "IkePeer");
            }
            this.newPeerIdentity = this.getNewPeerIdentity(string, struct);
            return this.newPeerIdentity;
        }
        if (!string3.equals("")) {
            Ipv4AddressValidation.validateIpv4((String)string3);
        }
        this.newPeerIdentity = this.getNewPeerIdentity(string3, struct);
        return this.newPeerIdentity;
    }

    private Struct getNewPeerIdentity(String string, Struct struct) throws MoAccessException {
        String[] stringArray = new String[]{"idFqdn", "idType", "ipv4Address"};
        Object[] objectArray = new Object[]{struct.getValue("idFqdn"), struct.getValue("idType"), string};
        StructImpl structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }

    private Struct checkOwnIdentity(Struct struct, String string) throws MoAccessException {
        String string2;
        String string3;
        int n;
        if (struct.size() != 3) {
            throw new ValueOutOfRangeException("ownIdType has wrong number of elements.", "IkePeer");
        }
        try {
            n = (Integer)struct.getValue("ownIdType");
            string3 = (String)struct.getValue("ipv4Address");
            string2 = (String)struct.getValue("idFqdn");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ValueOutOfRangeException("OwnIdentity is inconsistent, attribute is missing " + noSuchFieldException.toString(), "IkePeer");
        }
        catch (MoAccessException moAccessException) {
            throw moAccessException;
        }
        int n2 = EnumOwnIdType.VALUES_ARRAY.length - 1;
        if (n > n2) {
            throw new ValueOutOfRangeException("ownIdType is set to " + n + " , value is not OK", "IkePeer");
        }
        if (string2.length() != 0) {
            if (string2.length() > 127) {
                throw new ValueOutOfRangeException("idFqdn must not exceed 127 characters", "IkePeer");
            }
            char c = '.';
            for (int i = 0; i < string2.length(); ++i) {
                if (Character.isLetterOrDigit(string2.charAt(i)) || string2.charAt(i) == c) continue;
                throw new ValueOutOfRangeException("FQDN is not a qualified domain name", "IkePeer");
            }
        }
        if (string3.length() != 0) {
            new IpAddress(string3);
        }
        return struct;
    }

    private void checkPeerIpAddress(String string) throws MoAccessException {
        this.isDomainName = false;
        try {
            IpAddressValidation.validate((String)string);
        }
        catch (IpFormatException ipFormatException) {
            try {
                DomainNameValidation.validateForFQDN((String)string);
            }
            catch (DomainNameFormatException domainNameFormatException) {
                throw new ValueOutOfRangeException(string, "IkePeer", "Invalid format of Ipv4 or Ipv6 Address and domain name");
            }
            this.isDomainName = true;
        }
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            if (string.equalsIgnoreCase(INSTALL_PRE_SHARED_KEY)) {
                return this.blankPreSharedKeyValue(objectArray);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + runtimeException));
            return null;
        }
    }

    private Object[] blankPreSharedKeyValue(Object[] objectArray) {
        try {
            Struct struct = (Struct)objectArray[0];
            String[] stringArray = new String[]{"encoding", "preSharedKey"};
            Object[] objectArray2 = new Object[]{struct.getValue("encoding"), "*****"};
            StructImpl structImpl = new StructImpl(stringArray, objectArray2);
            objectArray[0] = structImpl;
            return objectArray;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + (Object)((Object)moAccessException)));
            return null;
        }
    }
}

