/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipsec.IpSecAccountInfo;
import se.ericsson.cello.ipsec.IpSecCertSpec;
import se.ericsson.cello.ipsec.IpSecEnrollmentData;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.ipsec.StructHelper;
import se.ericsson.cello.ipsec.ipi_ipsecmi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumActivationVals;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class IpSecMoImpl
extends CelloMao
implements IpSecMo,
LogContentInspector {
    private MoData data;
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    private static final TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)new ipi_ipsecmi());
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;
    public static final long IPSEC_VC_DEFAULT = 0L;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpSec", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkCardinality((String)"IpSec", (int)1);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpSec", (int)128, (int)0);
        String string3 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"autoUpdateCertEnrollmentServer", (AttrList)attrList, (boolean)false, (String)"", (String)"IpSec", (int)255, (int)0);
        if (!string3.equals("")) {
            IpSecEnrollmentData.checkEnrollmentServerURL(string3, "autoUpdateCertEnrollmentServer");
        }
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"certExpirWarnTime", (AttrList)attrList, (boolean)false, (int)90, (int)2, (int)365, (String)"IpSec");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"featureState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"IpSec");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpSec");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter("certExpirWarnTime", n));
        arrayList.add(new SignedIntParameter("featureState", n2));
        arrayList.add(new StringParameter("autoUpdateCertEnrollmentServer", string3));
        arrayList.add(new UnsignedIntParameter("vendorCredentials", 0L));
        return new IpSecMoImpl(managedObject, string, string2, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    private IpSecMoImpl(ManagedObject managedObject, String string, String string2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "IpSec", string, coordinator);
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "IpSec");
        this.data.setRevision(8000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpSecMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "IpSec");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = null;
        map = this.getFroParameters(map, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("certEnrollErrorMsg")) {
                if (map.get("certEnrollErrorMsg") != null) {
                    signedIntParameter = (SignedIntParameter)map.get("certEnrollErrorMsg");
                    arrayList.add(signedIntParameter.getValue());
                    continue;
                }
                arrayList.add("");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("certEnrollState")) {
                if (map.get("certEnrollState") != null) {
                    signedIntParameter = (SignedIntParameter)map.get("certEnrollState");
                    arrayList.add(new Integer(signedIntParameter.getValue()));
                    continue;
                }
                arrayList.add(new Integer(99));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("certExpirWarnTime")) {
                signedIntParameter = (SignedIntParameter)map.get("certExpirWarnTime");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("featureState")) {
                signedIntParameter = (SignedIntParameter)map.get("featureState");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("installedTrustedCertificates")) {
                if (map.get("installedTrustedCertificates") != null) {
                    arrayList.add(StructHelper.convertCertListParam2Struct((ArrayParameter)map.get("installedTrustedCertificates")));
                    continue;
                }
                arrayList.add(new Struct[0]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("certificate")) {
                if (map.get("ipSecCertInfo") != null) {
                    arrayList.add(StructHelper.convertCertInfo2Struct((StructParameter)map.get("ipSecCertInfo")));
                    continue;
                }
                signedIntParameter = new SignedIntParameter[]{"", "", "", "", "", "", ""};
                arrayList.add(new StructImpl(IpSecMo.CERT_INFO_ELEMENT_NAMES, (Object[])signedIntParameter));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("IpSecId")) {
                arrayList.add(super.getNamingAttributeValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("licenseState")) {
                if (map.get("licenseState") != null) {
                    signedIntParameter = (SignedIntParameter)map.get("licenseState");
                    arrayList.add(new Integer(signedIntParameter.getValue()));
                    continue;
                }
                arrayList.add(new Integer(99));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trustedCertInstallState")) {
                if (map.get("trustedCertInstallState") != null) {
                    signedIntParameter = (SignedIntParameter)map.get("trustedCertInstallState");
                    arrayList.add(new Integer(signedIntParameter.getValue()));
                    continue;
                }
                arrayList.add(new Integer(99));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trustedCertInstallErrorMsg")) {
                if (map.get("trustedCertInstallErrorMsg") != null) {
                    signedIntParameter = (StringParameter)map.get("trustedCertInstallErrorMsg");
                    arrayList.add(signedIntParameter.getValue());
                    continue;
                }
                arrayList.add("");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("autoUpdateCertEnrollmentServer")) {
                if (map.get("autoUpdateCertEnrollmentServer") != null) {
                    signedIntParameter = (StringParameter)map.get("autoUpdateCertEnrollmentServer");
                    arrayList.add(signedIntParameter.getValue());
                    continue;
                }
                arrayList.add("");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                arrayList.add(((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpSec");
        }
        return arrayList.toArray();
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.setAttributes(new String[]{string}, new Object[]{object}, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpSecMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpSec");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpSec", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("certExpirWarnTime")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpSecMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("certExpirWarnTime", "IpSec");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"certExpirWarnTime", (int)n, (int)2, (int)365, (String)"IpSec");
                arrayList.add(new SignedIntParameter("certExpirWarnTime", n));
                this.sendNotification("certExpirWarnTime", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("featureState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpSecMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("featureState", "IpSec");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkEnumAttribute((String)"featureState", (int)n, (int[])EnumActivationVals.VALUES_ARRAY, (String)"IpSec");
                arrayList.add(new SignedIntParameter("featureState", n));
                this.sendNotification("featureState", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("autoUpdateCertEnrollmentServer")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpSecMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("autoUpdateCertEnrollmentServer", "IpSec");
                }
                if (!objectArray[i].toString().equals("")) {
                    IpSecEnrollmentData.checkEnrollmentServerURL(objectArray[i].toString(), "autoUpdateCertEnrollmentServer");
                }
                String string = (String)objectArray[i];
                MoAttributeValidator.checkStringWithLength((String)string, (String)"autoUpdateCertEnrollmentServer", (String)"IpSec", (int)255, (int)0);
                arrayList.add(new StringParameter("autoUpdateCertEnrollmentServer", string));
                this.sendNotification("autoUpdateCertEnrollmentServer", string, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpSec");
        }
        if (!arrayList.isEmpty()) {
            this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public String getTrustedCertInstallErrorMsg(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("trustedCertInstallErrorMsg", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public long getVendorCredentials(Coordinator coordinator) throws MoAccessException {
        UnsignedIntParameter unsignedIntParameter = (UnsignedIntParameter)this.genericProxyInstance.getAttribute(coordinator, this.getFroId(coordinator), "vendorCredentials");
        return unsignedIntParameter.getValue();
    }

    public String getCertEnrollErrorMsg(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("certEnrollErrorMsg", coordinator);
    }

    public int getCertEnrollState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("certEnrollState", coordinator);
    }

    public int getCertExpirWarnTime(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("certExpirWarnTime", coordinator);
    }

    public void setCertExpirWarnTime(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("certExpirWarnTime", new Integer(n), coordinator);
    }

    public void setVendorCredentials(long l, Coordinator coordinator) throws MoAccessException {
        if (l < 0L || l > 1L) {
            throw new ValueOutOfRangeException("vendorCredentials", "IpSec");
        }
        UnsignedIntParameter unsignedIntParameter = new UnsignedIntParameter("vendorCredentials", l);
        this.genericProxyInstance.setAttribute(coordinator, this.getFroId(coordinator), (Parameter)unsignedIntParameter);
    }

    public Struct[] getInstalledTrustedCertificates(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("installedTrustedCertificates", coordinator);
    }

    public Struct getCertificate(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("certificate", coordinator);
    }

    public int getTrustedCertInstallState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("trustedCertInstallState", coordinator);
    }

    public int getFeatureState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("featureState", coordinator);
    }

    public void setFeatureState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("featureState", new Integer(n), coordinator);
    }

    public int getLicenseState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("licenseState", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public void actionInitCertEnrollment(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        IpSecEnrollmentData ipSecEnrollmentData = new IpSecEnrollmentData(struct);
        StructParameter structParameter = new StructParameter("ipSecEnrollmentData");
        structParameter.add((Parameter)new StringParameter("caFingerPrint", ipSecEnrollmentData.getCaFingerPrint(), 127));
        structParameter.add((Parameter)new StringParameter("challengePassword", ipSecEnrollmentData.getChallengePassword(), 23));
        structParameter.add((Parameter)new StringParameter("distinguishedName", ipSecEnrollmentData.getDistinguishedName(), 127));
        structParameter.add((Parameter)new SignedIntParameter("enrollmentMode", ipSecEnrollmentData.getEnrollmentMode()));
        structParameter.add((Parameter)new StringParameter("enrollmentServerURL", ipSecEnrollmentData.getEnrollmentServerURL(), 255));
        structParameter.add((Parameter)new SignedIntParameter("keyLength", ipSecEnrollmentData.getKeyLength()));
        structParameter.add((Parameter)new StringParameter("subjectAltName", ipSecEnrollmentData.getSubjectAltName(), 255));
        structParameter.add((Parameter)new SignedIntParameter("subjectAltNameType", ipSecEnrollmentData.getSubjectAltNameType()));
        structParameter.add((Parameter)new StringParameter("certificateAuthorityDn", ipSecEnrollmentData.getCertificateAuthorityDn(), 511));
        arrayList.add(structParameter);
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 103, arrayList);
    }

    public void actionCancelCertEnrollment(Coordinator coordinator) throws MoAccessException {
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 101, null);
    }

    public void actionInstallTrustedCertificates(Struct[] structArray, Struct[] structArray2, Coordinator coordinator) throws MoAccessException {
        Object object;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (structArray.length == 0) {
            throw new ValueOutOfRangeException("certSpecList", "IpSec");
        }
        ArrayParameter arrayParameter = new ArrayParameter("certSpecList");
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        for (int i = 0; i < structArray.length; ++i) {
            IpSecCertSpec ipSecCertSpec = new IpSecCertSpec(structArray[i]);
            object = new StructParameter("certSpec");
            object.add((Parameter)new StringParameter("fileName", ipSecCertSpec.getFileName(), 255));
            object.add((Parameter)new StringParameter("fingerprint", ipSecCertSpec.getFingerprint(), 127));
            object.add((Parameter)new StringParameter("serialNumber", ipSecCertSpec.getSerialNumber(), 39));
            arrayParameter.add((Parameter)object);
        }
        arrayList.add(arrayParameter);
        if (structArray2.length == 0) {
            throw new ValueOutOfRangeException("accountInfoList", "IpSec");
        }
        ArrayParameter arrayParameter2 = new ArrayParameter("accountInfoList");
        for (int i = 0; i < structArray2.length; ++i) {
            object = new IpSecAccountInfo(structArray2[i]);
            StructParameter structParameter = new StructParameter("ipSecAccountInfo");
            structParameter.add((Parameter)new StringParameter("password", ((IpSecAccountInfo)object).getPassword(), 21));
            structParameter.add((Parameter)new StringParameter("remoteHost", ((IpSecAccountInfo)object).getRemoteHost(), 255));
            structParameter.add((Parameter)new StringParameter("userID", ((IpSecAccountInfo)object).getUserID(), 21));
            arrayParameter2.add((Parameter)structParameter);
        }
        arrayList.add(arrayParameter2);
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 104, arrayList);
    }

    public void actionCancelInstallTrustedCertificates(Coordinator coordinator) throws MoAccessException {
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 102, null);
    }

    public void actionRemoveTrustedCert(String string, String string2, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (string.length() < 1 || string.length() > 40) {
            throw new ValueOutOfRangeException("serialNumber", "IpSec");
        }
        if (string2.length() < 1 || string2.length() > 128) {
            throw new ValueOutOfRangeException("issuer", "IpSec");
        }
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        arrayList.add(new StringParameter("serialNumber", string, 40));
        arrayList.add(new StringParameter("issuer", string2, 128));
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 105, arrayList);
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(DICTIONARY);
            Set set = map.entrySet();
            Iterator iterator = set.iterator();
            Map.Entry entry = null;
            while (iterator.hasNext()) {
                SignedIntParameter signedIntParameter;
                entry = iterator.next();
                if (entry.getKey().equals("certEnrollErrorMsg")) {
                    signedIntParameter = (SignedIntParameter)entry.getValue();
                    if (signedIntParameter == null) continue;
                    this.sendNotification("certEnrollErrorMsg", signedIntParameter.getValue(), null);
                    continue;
                }
                if (entry.getKey().equals("certEnrollState")) {
                    signedIntParameter = (SignedIntParameter)entry.getValue();
                    if (signedIntParameter == null) continue;
                    this.sendNotification("certEnrollState", new Integer(signedIntParameter.getValue()), null);
                    continue;
                }
                if (entry.getKey().equals("certificate")) {
                    signedIntParameter = StructHelper.convertCertInfo2Struct((StructParameter)entry.getValue());
                    if (signedIntParameter == null) continue;
                    this.sendNotification("certificate", signedIntParameter, null);
                    continue;
                }
                if (entry.getKey().equals("installedTrustedCertificates")) {
                    signedIntParameter = StructHelper.convertCertListParam2Struct((ArrayParameter)entry.getValue());
                    if (signedIntParameter == null) continue;
                    this.sendNotification("installedTrustedCertificates", signedIntParameter, null);
                    continue;
                }
                if (entry.getKey().equals("licenseState")) {
                    signedIntParameter = (SignedIntParameter)entry.getValue();
                    if (signedIntParameter == null) continue;
                    this.sendNotification("licenseState", new Integer(signedIntParameter.getValue()), null);
                    continue;
                }
                if (entry.getKey().equals("trustedCertInstallErrorMsg")) {
                    signedIntParameter = (StringParameter)entry.getValue();
                    if (signedIntParameter == null) continue;
                    this.sendNotification("trustedCertInstallErrorMsg", signedIntParameter.getValue(), null);
                    continue;
                }
                if (entry.getKey().equals("trustedCertInstallState")) {
                    signedIntParameter = (SignedIntParameter)entry.getValue();
                    if (signedIntParameter == null) continue;
                    this.sendNotification("trustedCertInstallState", new Integer(signedIntParameter.getValue()), null);
                    continue;
                }
                MessageLog.info(this.getClass(), (String)("CERT_ENROLL_ERROR_MSG " + map.get("certEnrollErrorMsg") + "CERT_ENROLL_STATE " + map.get("certEnrollState") + "CERTIFICATE " + map.get("certificate") + "LICENSE_STATE " + map.get("licenseState") + "TRUSTED_CERT_INSTALL_ERROR_MSG " + map.get("trustedCertInstallErrorMsg") + "TRUSTED_CERT_INSTALL_STATE " + map.get("trustedCertInstallState") + "Unknown attribute in parameterChanged() " + entry));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag  not in property file");
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    private Map getFroParameters(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            if (string.equalsIgnoreCase("installTrustedCertificates")) {
                return this.blankAccountInfoPw(objectArray, 1);
            }
            if (string.equalsIgnoreCase("initCertEnrollment")) {
                return this.blankEnrollmentDataPw(objectArray);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + runtimeException));
            return null;
        }
    }

    private Object[] blankEnrollmentDataPw(Object[] objectArray) {
        try {
            Struct struct = (Struct)objectArray[0];
            String[] stringArray = struct.getNames();
            Object[] objectArray2 = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                objectArray2[i] = stringArray[i].equals("challengePassword") ? "*****" : struct.getValue(stringArray[i]);
            }
            StructImpl structImpl = new StructImpl(stringArray, objectArray2);
            objectArray[0] = structImpl;
            return objectArray;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + (Object)((Object)moAccessException)));
            return null;
        }
    }

    private Object[] blankAccountInfoPw(Object[] objectArray, int n) {
        try {
            Struct[] structArray = (Struct[])objectArray[n];
            Struct[] structArray2 = new Struct[structArray.length];
            String[] stringArray = new String[]{"password", "remoteHost", "userID"};
            for (int i = 0; i < structArray2.length; ++i) {
                Object[] objectArray2 = new Object[]{"*****", structArray[i].getValue("remoteHost"), structArray[i].getValue("userID")};
                structArray2[i] = new StructImpl(stringArray, objectArray2);
            }
            objectArray[n] = structArray2;
            return objectArray;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + (Object)((Object)moAccessException)));
            return null;
        }
    }

    public String getAutoUpdateCertEnrollmentServer(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("autoUpdateCertEnrollmentServer", coordinator);
    }

    public void setAutoUpdateCertEnrollmentServer(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("autoUpdateCertEnrollmentServer", string, coordinator);
    }

    public String getType() {
        return "IpSec";
    }
}

